/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CascadeType;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.annotations.spi.AttributeMarker;
import org.hibernate.models.spi.ModelsContext;

public class ManyToOneJpaAnnotation
implements ManyToOne,
AttributeMarker,
AttributeMarker.Fetchable,
AttributeMarker.Cascadeable,
AttributeMarker.Optionalable {
    private Class<?> targetEntity;
    private CascadeType[] cascade;
    private FetchType fetch;
    private boolean optional;

    public ManyToOneJpaAnnotation(ModelsContext modelContext) {
        this.targetEntity = Void.TYPE;
        this.cascade = new CascadeType[0];
        this.fetch = FetchType.EAGER;
        this.optional = true;
    }

    public ManyToOneJpaAnnotation(ManyToOne annotation, ModelsContext modelContext) {
        this.targetEntity = annotation.targetEntity();
        this.cascade = annotation.cascade();
        this.fetch = annotation.fetch();
        this.optional = annotation.optional();
    }

    public ManyToOneJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.targetEntity = (Class)attributeValues.get("targetEntity");
        this.cascade = (CascadeType[])attributeValues.get("cascade");
        this.fetch = (FetchType)((Object)attributeValues.get("fetch"));
        this.optional = (Boolean)attributeValues.get("optional");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ManyToOne.class;
    }

    @Override
    public Class<?> targetEntity() {
        return this.targetEntity;
    }

    public void targetEntity(Class<?> value) {
        this.targetEntity = value;
    }

    @Override
    public CascadeType[] cascade() {
        return this.cascade;
    }

    @Override
    public void cascade(CascadeType[] value) {
        this.cascade = value;
    }

    @Override
    public FetchType fetch() {
        return this.fetch;
    }

    @Override
    public void fetch(FetchType value) {
        this.fetch = value;
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    @Override
    public void optional(boolean value) {
        this.optional = value;
    }
}

