/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.SqlResultSetMapping;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.ModelsContext;

public class SQLSelectAnnotation
implements SQLSelect {
    private String sql;
    private SqlResultSetMapping resultSetMapping;
    private String[] querySpaces;

    public SQLSelectAnnotation(ModelsContext modelContext) {
        this.resultSetMapping = JpaAnnotations.SQL_RESULT_SET_MAPPING.createUsage(modelContext);
        this.querySpaces = new String[0];
    }

    public SQLSelectAnnotation(SQLSelect annotation, ModelsContext modelContext) {
        this.sql = annotation.sql();
        this.resultSetMapping = (SqlResultSetMapping)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.SQL_SELECT, "resultSetMapping", modelContext);
        this.querySpaces = annotation.querySpaces();
    }

    public SQLSelectAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.sql = (String)attributeValues.get("sql");
        this.resultSetMapping = (SqlResultSetMapping)attributeValues.get("resultSetMapping");
        this.querySpaces = (String[])attributeValues.get("querySpaces");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return SQLSelect.class;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    public void sql(String value) {
        this.sql = value;
    }

    @Override
    public SqlResultSetMapping resultSetMapping() {
        return this.resultSetMapping;
    }

    public void resultSetMapping(SqlResultSetMapping value) {
        this.resultSetMapping = value;
    }

    @Override
    public String[] querySpaces() {
        return this.querySpaces;
    }

    public void querySpaces(String[] value) {
        this.querySpaces = value;
    }
}

