/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CheckConstraint;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.spi.CommonTableDetails;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.ModelsContext;

public class TableJpaAnnotation
implements Table,
CommonTableDetails {
    private String name;
    private String catalog;
    private String schema;
    private UniqueConstraint[] uniqueConstraints;
    private Index[] indexes;
    private CheckConstraint[] check;
    private String comment;
    private String options;

    public TableJpaAnnotation(ModelsContext modelContext) {
        this.name = "";
        this.catalog = "";
        this.schema = "";
        this.uniqueConstraints = new UniqueConstraint[0];
        this.indexes = new Index[0];
        this.check = new CheckConstraint[0];
        this.comment = "";
        this.options = "";
    }

    public TableJpaAnnotation(Table annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.uniqueConstraints = (UniqueConstraint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.TABLE, "uniqueConstraints", modelContext);
        this.indexes = (Index[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.TABLE, "indexes", modelContext);
        this.check = (CheckConstraint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.TABLE, "check", modelContext);
        this.comment = annotation.comment();
        this.options = annotation.options();
    }

    public TableJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.catalog = (String)attributeValues.get("catalog");
        this.schema = (String)attributeValues.get("schema");
        this.uniqueConstraints = (UniqueConstraint[])attributeValues.get("uniqueConstraints");
        this.indexes = (Index[])attributeValues.get("indexes");
        this.check = (CheckConstraint[])attributeValues.get("check");
        this.comment = (String)attributeValues.get("comment");
        this.options = (String)attributeValues.get("options");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Table.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String value) {
        this.name = value;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public void catalog(String value) {
        this.catalog = value;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public void schema(String value) {
        this.schema = value;
    }

    @Override
    public UniqueConstraint[] uniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public void uniqueConstraints(UniqueConstraint[] value) {
        this.uniqueConstraints = value;
    }

    @Override
    public Index[] indexes() {
        return this.indexes;
    }

    @Override
    public void indexes(Index[] value) {
        this.indexes = value;
    }

    @Override
    public CheckConstraint[] check() {
        return this.check;
    }

    public void check(CheckConstraint[] value) {
        this.check = value;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public void comment(String value) {
        this.comment = value;
    }

    @Override
    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }

    public void apply(JaxbTableImpl jaxbTable, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyOptionalString(jaxbTable.getName(), this::name);
        XmlAnnotationHelper.applyCatalog(jaxbTable, this, xmlDocumentContext);
        XmlAnnotationHelper.applySchema(jaxbTable, this, xmlDocumentContext);
        XmlAnnotationHelper.applyOptionalString(jaxbTable.getComment(), this::comment);
        XmlAnnotationHelper.applyOptionalString(jaxbTable.getOptions(), this::options);
        this.check(XmlAnnotationHelper.collectCheckConstraints(jaxbTable.getCheckConstraints(), xmlDocumentContext));
        this.indexes(XmlAnnotationHelper.collectIndexes(jaxbTable.getIndexes(), xmlDocumentContext));
        this.uniqueConstraints(XmlAnnotationHelper.collectUniqueConstraints(jaxbTable.getUniqueConstraints(), xmlDocumentContext));
    }
}

