/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToOneImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.OneToOneJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PropertyRefAnnotation;
import org.hibernate.boot.models.annotations.internal.TargetXmlAnnotation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class OneToOneAttributeProcessing {
    public static MutableMemberDetails processOneToOneAttribute(JaxbOneToOneImpl jaxbOneToOne, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbOneToOne.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbOneToOne.getName(), accessType, declarer);
        OneToOneJpaAnnotation oneToOneAnn = OneToOneAttributeProcessing.applyOneToOne(memberDetails, accessType, jaxbOneToOne, xmlDocumentContext);
        OneToOneAttributeProcessing.applyMappedBy(memberDetails, jaxbOneToOne, oneToOneAnn, xmlDocumentContext);
        OneToOneAttributeProcessing.applyTarget(memberDetails, jaxbOneToOne, oneToOneAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbOneToOne.getCascade(), memberDetails, xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbOneToOne.getJoinTable(), memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyJoinColumnsOrFormulas(jaxbOneToOne.getJoinColumnOrJoinFormula(), memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyPrimaryKeyJoinColumns(jaxbOneToOne.getPrimaryKeyJoinColumn(), memberDetails, xmlDocumentContext);
        if (jaxbOneToOne.getPropertyRef() != null) {
            PropertyRefAnnotation propertyRefUsage = (PropertyRefAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.PROPERTY_REF, xmlDocumentContext.getModelBuildingContext());
            propertyRefUsage.value(jaxbOneToOne.getPropertyRef().getName());
        }
        if (jaxbOneToOne.isId() == Boolean.TRUE) {
            memberDetails.applyAnnotationUsage(JpaAnnotations.ID, xmlDocumentContext.getModelBuildingContext());
        }
        CommonAttributeProcessing.applyMapsId(jaxbOneToOne.getMapsId(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    private static OneToOneJpaAnnotation applyOneToOne(MutableMemberDetails memberDetails, AccessType accessType, JaxbOneToOneImpl jaxbOneToOne, XmlDocumentContext xmlDocumentContext) {
        OneToOneJpaAnnotation annotation = (OneToOneJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.ONE_TO_ONE, xmlDocumentContext.getModelBuildingContext());
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbOneToOne, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyFetching(jaxbOneToOne, memberDetails, annotation, xmlDocumentContext);
        CommonAttributeProcessing.applyOptionality(jaxbOneToOne, annotation, xmlDocumentContext);
        CommonAttributeProcessing.applyOptimisticLock(jaxbOneToOne, memberDetails, xmlDocumentContext);
        if (jaxbOneToOne.isOrphanRemoval() != null) {
            annotation.orphanRemoval(jaxbOneToOne.isOrphanRemoval());
        }
        return annotation;
    }

    private static void applyMappedBy(MutableMemberDetails memberDetails, JaxbOneToOneImpl jaxbOneToOne, OneToOneJpaAnnotation oneToOneAnn, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbOneToOne.getMappedBy())) {
            oneToOneAnn.mappedBy(jaxbOneToOne.getMappedBy());
        }
    }

    private static void applyTarget(MutableMemberDetails memberDetails, JaxbOneToOneImpl jaxbOneToOne, OneToOneJpaAnnotation oneToOneAnn, XmlDocumentContext xmlDocumentContext) {
        String targetEntityName = jaxbOneToOne.getTargetEntity();
        if (StringHelper.isEmpty(targetEntityName)) {
            return;
        }
        TargetXmlAnnotation annotation = (TargetXmlAnnotation)memberDetails.applyAnnotationUsage(XmlAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
        annotation.value(xmlDocumentContext.resolveClassName(targetEntityName));
    }
}

