/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.query.NamedQueryDefinition;

public abstract class AbstractNamedQueryDefinition<R>
implements NamedQueryDefinition<R> {
    private final String name;
    private final @Nullable Class<R> resultType;
    private final Boolean cacheable;
    private final String cacheRegion;
    private final CacheMode cacheMode;
    private final FlushMode flushMode;
    private final Boolean readOnly;
    private final LockOptions lockOptions;
    private final Integer timeout;
    private final Integer fetchSize;
    private final String comment;
    private final Map<String, Object> hints;
    private final String location;

    public AbstractNamedQueryDefinition(String name, @Nullable Class<R> resultType, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints, String location) {
        this.name = name;
        this.resultType = resultType;
        this.cacheable = cacheable;
        this.cacheRegion = cacheRegion;
        this.cacheMode = cacheMode;
        this.flushMode = flushMode;
        this.readOnly = readOnly;
        this.lockOptions = lockOptions;
        this.timeout = timeout;
        this.fetchSize = fetchSize;
        this.comment = comment;
        this.hints = hints == null ? new HashMap<String, Object>() : new HashMap<String, Object>(hints);
        this.location = location;
    }

    @Override
    public String getRegistrationName() {
        return this.name;
    }

    @Override
    public @Nullable String getLocation() {
        return this.location;
    }

    @Override
    public @Nullable Class<R> getResultType() {
        return this.resultType;
    }

    public Boolean getCacheable() {
        return this.cacheable;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Map<String, Object> getHints() {
        return this.hints;
    }
}

