/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.cache", description="Logging related to the second-level cache")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90001001, max=90002000)
public interface SecondLevelCacheLogger
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.cache";
    public static final SecondLevelCacheLogger L2CACHE_LOGGER = Logger.getMessageLogger(MethodHandles.lookup(), SecondLevelCacheLogger.class, "org.hibernate.orm.cache");
    public static final int NAMESPACE = 90001000;

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempt to start an already-started RegionFactory, probably because a SessionFactory was not closed. Using previously created RegionFactory.", id=90001001)
    public void attemptToStartAlreadyStartedCacheProvider();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempt to stop an already-stopped JCacheRegionFactory.", id=90001002)
    public void attemptToStopAlreadyStoppedCacheProvider();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Read-only caching was requested for mutable entity [%s]", id=90001003)
    public void readOnlyCachingMutableEntity(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Read-only caching was requested for entity [%s] with mutable natural id", id=90001004)
    public void readOnlyCachingMutableNaturalId(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="A soft-locked cache entry in region [%s] with key [%s] was expired by the underlying cache. If this happens regularly, consider increasing the cache timeouts and/or capacity limits.", id=90001005)
    public void softLockedCacheExpired(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Missing cache region [%1$s] was created with provider-specific default policies. Explicitly configure the region and its policies, or disable this warning by setting '%2$s' to '%3$s'.", id=90001006)
    public void missingCacheCreated(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Using legacy cache name [%2$s] because configuration could not be found for cache [%1$s]. Update configuration to rename cache [%2$s] to [%1$s].", id=90001007)
    public void usingLegacyCacheName(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cache region [%1$s] has the access type '%2$s' which is not supported by [%3$s]. Ensure cache implementation supports JTA transactions.", id=90001008)
    public void nonStandardSupportForAccessType(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Caching query results in region '%s' with timestamp %s", id=90001009)
    public void cachingQueryResults(String var1, long var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Checking cached query results in region '%s'", id=90001010)
    public void checkingCachedQueryResults(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Query results were not found in cache", id=90001011)
    public void queryResultsNotFound();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Cached query results were stale", id=90001012)
    public void cachedQueryResultsStale();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Returning cached query results", id=90001014)
    public void returningCachedQueryResults();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Evicting entity second-level cache: %s", id=90001015)
    public void evictingEntityCache(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Evicting entity second-level cache: %s", id=90001016)
    public void evictingEntityCacheByRole(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Evicting natural id cache: %s", id=90001017)
    public void evictingNaturalIdCache(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Evicting collection second-level cache: %s", id=90001018)
    public void evictingCollectionCache(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Evicting collection second-level cache: %s", id=90001019)
    public void evictingCollectionCacheByRole(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Auto-evicting collection from second-level cache: %s (since 'hibernate.cache.auto_evict_collection_cache' is enabled)", id=90001025)
    public void autoEvictingCollectionCache(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Auto-evicting collection from second-level cache: %s (since 'hibernate.cache.auto_evict_collection_cache' is enabled)", id=90001026)
    public void autoEvictingCollectionCacheByRole(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Evicting query cache region: %s", id=90001020)
    public void evictingQueryCacheRegion(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Evicting cache of all query regions", id=90001021)
    public void evictingAllQueryRegions();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Pre-invalidating space [%s], timestamp: %s", id=90001022)
    public void preInvalidatingSpace(String var1, Long var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Invalidating space [%s], timestamp: %s", id=90001023)
    public void invalidatingSpace(String var1, Long var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="[%s] last update timestamp: %s, result set timestamp: %s", id=90001024)
    public void lastUpdateTimestampForSpace(String var1, Long var2, Long var3);
}

