/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.OptimisticLockHelper;
import org.hibernate.persister.entity.EntityPersister;

public class PessimisticForceIncrementLockingStrategy
implements LockingStrategy {
    private final EntityPersister lockable;
    private final LockMode lockMode;

    public PessimisticForceIncrementLockingStrategy(EntityPersister lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        if (lockMode.lessThan(LockMode.PESSIMISTIC_READ)) {
            throw new HibernateException("[" + String.valueOf(lockMode) + "] not valid for [" + lockable.getEntityName() + "]");
        }
    }

    @Override
    public void lock(Object id, Object version, Object object, int timeout, SharedSessionContractImplementor session) {
        if (!this.lockable.isVersioned()) {
            throw new HibernateException("[" + String.valueOf(this.lockMode) + "] not supported for non-versioned entities [" + this.lockable.getEntityName() + "]");
        }
        EntityEntry entry = session.getPersistenceContextInternal().getEntry(object);
        OptimisticLockHelper.forceVersionIncrement(object, entry, session);
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }
}

