/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.lang.invoke.MethodHandles;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.jdbc", description="Logging related to JDBC interactions")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=100001, max=100500)
public interface JdbcLogging
extends BasicLogger {
    public static final String NAME = "org.hibernate.orm.jdbc";
    public static final Logger JDBC_LOGGER = Logger.getLogger("org.hibernate.orm.jdbc");
    public static final JdbcLogging JDBC_MESSAGE_LOGGER = Logger.getMessageLogger(MethodHandles.lookup(), JdbcLogging.class, "org.hibernate.orm.jdbc");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=100001, value="JDBC driver did not return the expected number of row counts (%s) - expected %s, but received %s")
    public void unexpectedRowCounts(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Created JdbcCoordinator @%s", id=100002)
    public void createdJdbcCoordinator(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Closing JdbcCoordinator @%s", id=100003)
    public void closingJdbcCoordinator(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Statement execution complete (connection release mode %s) in JdbcCoordinator @%s", id=100004)
    public void statementExecutionComplete(ConnectionReleaseMode var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Transaction after begin in JdbcCoordinator @%s", id=100005)
    public void transactionAfterBegin(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Transaction before completion in JdbcCoordinator @%s", id=100006)
    public void transactionBeforeCompletion(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Transaction after %s completion in JdbcCoordinator @%s", id=100007)
    public void transactionAfterCompletion(String var1, int var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Closing unreleased batch in JdbcCoordinator @%s", id=100008)
    public void closingUnreleasedBatch(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Closing logical connection @%s", id=100009)
    public void closingLogicalConnection(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Closed logical connection @%s", id=100010)
    public void logicalConnectionClosed(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Skipping aggressive release of JDBC connection @%s from 'afterStatement' due to held resources", id=100011)
    public void skipConnectionReleaseAfterStatementDueToResources(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Initiating release of JDBC connection @%s from 'afterStatement'", id=100012)
    public void initiatingConnectionReleaseAfterStatement(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Initiating release of JDBC connection @%s from 'beforeTransactionCompletion'", id=100013)
    public void initiatingConnectionReleaseBeforeTransactionCompletion(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Initiating release of JDBC connection @%s from 'afterTransaction'", id=100014)
    public void initiatingConnectionReleaseAfterTransaction(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error before releasing JDBC connection @%s", id=100015)
    public void errorBeforeReleasingJdbcConnection(int var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=100016, value="'hibernate.connection.provider_disables_autocommit' was enabled. This setting should only be enabled when JDBC Connections obtained by Hibernate from the ConnectionProvider have auto-commit disabled. Enabling this setting when connections have auto-commit enabled leads to execution of SQL operations outside of any JDBC transaction.")
    public void connectionProviderDisablesAutoCommitEnabled();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Database:\n\tname: %s\n\tversion: %s\n\tmajor: %s\n\tminor: %s", id=100017)
    public void logDatabaseInfo(String var1, String var2, int var3, int var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Driver:\n\tname: %s\n\tversion: %s\n\tmajor: %s\n\tminor: %s\n\tJDBC version: %s.%s", id=100018)
    public void logDriverInfo(String var1, String var2, int var3, int var4, int var5, int var6);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to release isolated connection", id=100020)
    public void unableToReleaseIsolatedConnection(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Unable to release connection", id=100021)
    public void unableToReleaseConnection(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to roll back isolated connection on exception ", id=100022)
    public void unableToRollBackIsolatedConnection(@Cause Exception var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Unable to reset connection back to auto-commit enabled", id=100040)
    public void unableToResetAutoCommitEnabled(@Cause Exception var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Unable to reset connection back to auto-commit disabled", id=100041)
    public void unableToResetAutoCommitDisabled(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Using default JDBC fetch size: %s", id=100122)
    public void usingFetchSize(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Low default JDBC fetch size: %s (consider setting 'hibernate.jdbc.fetch_size')", id=100123)
    public void warnLowFetchSize(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="JDBC fetch size: %s", id=100124)
    public void fetchSize(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Low JDBC fetch size: %s (consider setting 'hibernate.jdbc.fetch_size')", id=100125)
    public void lowFetchSize(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Setting JDBC fetch size: %s", id=100126)
    public void settingFetchSize(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Setting JDBC query timeout: %s", id=100127)
    public void settingQueryTimeout(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Called joinTransaction() on a non-JTA EntityManager (ignoring)", id=100030)
    public void callingJoinTransactionOnNonJtaEntityManager();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Current timestamp retrieved from database: %s (nanos=%s, time=%s)", id=100031)
    public void currentTimestampRetrievedFromDatabase(Object var1, int var2, long var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Sequence value retrieved from database: %s", id=100032)
    public void sequenceValueRetrievedFromDatabase(Number var1);
}

