/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jndi.internal;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingListener;
import org.hibernate.engine.jndi.JndiException;
import org.hibernate.engine.jndi.JndiNameException;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.NullnessUtil;
import org.jboss.logging.Logger;

final class JndiServiceImpl
implements JndiService {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(MethodHandles.lookup(), CoreMessageLogger.class, JndiServiceImpl.class.getName());
    private final Hashtable<String, Object> initialContextSettings;

    public JndiServiceImpl(Map<?, ?> configurationValues) {
        this.initialContextSettings = JndiServiceImpl.extractJndiProperties(configurationValues);
    }

    private static Hashtable<String, Object> extractJndiProperties(Map<?, ?> configurationValues) {
        Hashtable<String, Object> jndiProperties = new Hashtable<String, Object>();
        for (Map.Entry<?, ?> entry : configurationValues.entrySet()) {
            Object obj = entry.getKey();
            if (!(obj instanceof String)) continue;
            String propertyName = (String)obj;
            Object propertyValue = entry.getValue();
            if (!propertyName.startsWith("hibernate.jndi")) continue;
            if ("hibernate.jndi.class".equals(propertyName)) {
                if (propertyValue == null) continue;
                jndiProperties.put("java.naming.factory.initial", propertyValue);
                continue;
            }
            if ("hibernate.jndi.url".equals(propertyName)) {
                if (propertyValue == null) continue;
                jndiProperties.put("java.naming.provider.url", propertyValue);
                continue;
            }
            String passThruPropertyName = propertyName.substring("hibernate.jndi".length() + 1);
            jndiProperties.put(passThruPropertyName, NullnessUtil.castNonNull(propertyValue));
        }
        return jndiProperties;
    }

    @Override
    public Object locate(String jndiName) {
        InitialContext initialContext = this.buildInitialContext();
        Name name = this.parseName(jndiName, initialContext);
        try {
            Object object = initialContext.lookup(name);
            return object;
        }
        catch (NamingException e) {
            throw new JndiException("Unable to lookup JNDI name [" + jndiName + "]", e);
        }
        finally {
            this.cleanUp(initialContext);
        }
    }

    private InitialContext buildInitialContext() {
        try {
            return this.initialContextSettings.size() == 0 ? new InitialContext() : new InitialContext(this.initialContextSettings);
        }
        catch (NamingException e) {
            throw new JndiException("Unable to open InitialContext", e);
        }
    }

    private Name parseName(String jndiName, Context context) {
        try {
            URI uri = new URI(jndiName);
            String scheme = uri.getScheme();
            if (scheme != null && !JndiServiceImpl.allowedScheme(scheme)) {
                throw new JndiException("JNDI lookups for scheme '" + scheme + "' are not allowed");
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        try {
            return context.getNameParser("").parse(jndiName);
        }
        catch (InvalidNameException e) {
            throw new JndiNameException("JNDI name [" + jndiName + "] was not valid", e);
        }
        catch (NamingException e) {
            throw new JndiException("Error parsing JNDI name [" + jndiName + "]", e);
        }
    }

    private static boolean allowedScheme(String scheme) {
        switch (scheme) {
            case "java": 
            case "osgi": {
                return true;
            }
        }
        return false;
    }

    private void cleanUp(InitialContext initialContext) {
        try {
            initialContext.close();
        }
        catch (NamingException e) {
            LOG.unableToCloseInitialContext(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String jndiName, Object value) {
        InitialContext initialContext = this.buildInitialContext();
        Name name = this.parseName(jndiName, initialContext);
        try {
            this.bind(name, value, initialContext);
        }
        finally {
            this.cleanUp(initialContext);
        }
    }

    private void bind(Name name, Object value, Context context) {
        try {
            LOG.tracef("Binding: %s", (Object)name);
            context.rebind(name, value);
        }
        catch (Exception initialException) {
            if (name.size() == 1) {
                throw new JndiException("Error performing bind [" + String.valueOf(name) + "]", initialException);
            }
            Context intermediateContextBase = context;
            while (name.size() > 1) {
                String intermediateContextName = name.get(0);
                Context intermediateContext = null;
                try {
                    LOG.tracef("Intermediate lookup: %s", (Object)intermediateContextName);
                    intermediateContext = (Context)intermediateContextBase.lookup(intermediateContextName);
                }
                catch (NameNotFoundException nameNotFoundException) {
                }
                catch (NamingException e) {
                    throw new JndiException("Unanticipated error doing intermediate lookup", e);
                }
                if (intermediateContext != null) {
                    LOG.tracef("Found intermediate context: %s", (Object)intermediateContextName);
                } else {
                    LOG.tracef("Creating subcontext: %s", (Object)intermediateContextName);
                    try {
                        intermediateContext = intermediateContextBase.createSubcontext(intermediateContextName);
                    }
                    catch (NamingException e) {
                        throw new JndiException("Error creating intermediate context [" + intermediateContextName + "]", e);
                    }
                }
                intermediateContextBase = intermediateContext;
                name = name.getSuffix(1);
            }
            LOG.tracef("Binding: %s", (Object)name);
            try {
                intermediateContextBase.rebind(name, value);
            }
            catch (NamingException e) {
                throw new JndiException("Error performing intermediate bind [" + String.valueOf(name) + "]", e);
            }
        }
        LOG.tracef("Bound name: %s", (Object)name);
    }

    @Override
    public void unbind(String jndiName) {
        InitialContext initialContext = this.buildInitialContext();
        Name name = this.parseName(jndiName, initialContext);
        try {
            initialContext.unbind(name);
        }
        catch (Exception e) {
            throw new JndiException("Error performing unbind [" + String.valueOf(name) + "]", e);
        }
        finally {
            this.cleanUp(initialContext);
        }
    }

    @Override
    public void addListener(String jndiName, NamespaceChangeListener listener) {
        InitialContext initialContext = this.buildInitialContext();
        Name name = this.parseName(jndiName, initialContext);
        try {
            ((EventContext)((Object)initialContext)).addNamingListener(name, 0, (NamingListener)listener);
        }
        catch (Exception e) {
            throw new JndiException("Unable to bind listener to namespace [" + String.valueOf(name) + "]", e);
        }
        finally {
            this.cleanUp(initialContext);
        }
    }
}

