/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public final class CollectionEntry
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(CollectionEntry.class);
    private @Nullable Serializable snapshot;
    private @Nullable String role;
    private transient @Nullable CollectionPersister loadedPersister;
    private @Nullable Object loadedKey;
    private transient boolean reached;
    private transient boolean processed;
    private transient boolean doupdate;
    private transient boolean doremove;
    private transient boolean dorecreate;
    private transient boolean ignore;
    private transient @Nullable CollectionPersister currentPersister;
    private transient @Nullable Object currentKey;
    private boolean fromMerge;

    public CollectionEntry(CollectionPersister persister, PersistentCollection<?> collection) {
        this.ignore = false;
        collection.clearDirty();
        this.snapshot = persister.isMutable() ? collection.getSnapshot(persister) : null;
        this.role = persister.getRole();
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
    }

    public CollectionEntry(PersistentCollection<?> collection, CollectionPersister loadedPersister, Object loadedKey, boolean ignore) {
        this.ignore = ignore;
        this.loadedKey = loadedKey;
        this.loadedPersister = loadedPersister;
        this.role = loadedPersister == null ? null : loadedPersister.getRole();
        collection.setSnapshot(loadedKey, this.role, null);
    }

    public CollectionEntry(CollectionPersister loadedPersister, Object loadedKey) {
        this.ignore = false;
        this.loadedKey = loadedKey;
        this.loadedPersister = loadedPersister;
        this.role = loadedPersister == null ? null : loadedPersister.getRole();
    }

    public CollectionEntry(PersistentCollection<?> collection, SessionFactoryImplementor factory) {
        this.ignore = false;
        this.loadedKey = collection.getKey();
        this.role = collection.getRole();
        this.loadedPersister = factory.getMappingMetamodel().getCollectionDescriptor(NullnessUtil.castNonNull(this.role));
        this.snapshot = collection.getStoredSnapshot();
    }

    private CollectionEntry(@Nullable String role, Serializable snapshot, Object loadedKey, @Nullable SessionFactoryImplementor factory) {
        this.role = role;
        this.snapshot = snapshot;
        this.loadedKey = loadedKey;
        if (role != null) {
            this.afterDeserialize(factory);
        }
    }

    private void dirty(PersistentCollection<?> collection) throws HibernateException {
        boolean forceDirty;
        CollectionPersister loadedPersister = this.getLoadedPersister();
        boolean bl = forceDirty = collection.wasInitialized() && !collection.isDirty() && loadedPersister != null && loadedPersister.isMutable() && (collection.isDirectlyAccessible() || loadedPersister.getElementType().isMutable()) && !collection.equalsSnapshot(loadedPersister);
        if (forceDirty) {
            collection.dirty();
        }
    }

    public void preFlush(PersistentCollection<?> collection) throws HibernateException {
        boolean nonMutableChange;
        if (this.loadedKey == null && collection.getKey() != null) {
            this.loadedKey = collection.getKey();
        }
        CollectionPersister loadedPersister = this.getLoadedPersister();
        boolean bl = nonMutableChange = collection.isDirty() && loadedPersister != null && !loadedPersister.isMutable();
        if (nonMutableChange) {
            throw new HibernateException("changed an immutable collection instance: " + MessageHelper.collectionInfoString(NullnessUtil.castNonNull(loadedPersister).getRole(), this.getLoadedKey()));
        }
        this.dirty(collection);
        if (LOG.isTraceEnabled() && collection.isDirty() && loadedPersister != null) {
            LOG.trace("Collection dirty: " + MessageHelper.collectionInfoString(loadedPersister.getRole(), this.getLoadedKey()));
        }
        this.setReached(false);
        this.setProcessed(false);
        this.setDoupdate(false);
        this.setDoremove(false);
        this.setDorecreate(false);
    }

    public void postInitialize(PersistentCollection<?> collection, SharedSessionContractImplementor session) throws HibernateException {
        CollectionPersister loadedPersister = this.getLoadedPersister();
        this.snapshot = loadedPersister != null && loadedPersister.isMutable() ? collection.getSnapshot(loadedPersister) : null;
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
        if (loadedPersister != null && session.getLoadQueryInfluencers().effectivelyBatchLoadable(loadedPersister)) {
            session.getPersistenceContextInternal().getBatchFetchQueue().removeBatchLoadableCollection(this);
        }
    }

    public void postFlush(PersistentCollection<?> collection) throws HibernateException {
        if (this.isIgnore()) {
            this.ignore = false;
        } else if (!this.isProcessed()) {
            throw new HibernateException("Collection '" + collection.getRole() + "' was not processed by flush (this is likely due to unsafe use of the session, for example, current use in multiple threads, or updates during entity lifecycle callbacks)");
        }
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
    }

    public void afterAction(PersistentCollection<?> collection) {
        boolean resnapshot;
        this.loadedKey = this.getCurrentKey();
        this.setLoadedPersister(this.getCurrentPersister());
        boolean bl = resnapshot = collection.wasInitialized() && (this.isDoremove() || this.isDorecreate() || this.isDoupdate());
        if (resnapshot) {
            this.snapshot = this.loadedPersister != null && this.loadedPersister.isMutable() ? collection.getSnapshot(NullnessUtil.castNonNull(this.loadedPersister)) : null;
        }
        collection.postAction();
    }

    public @Nullable Object getKey() {
        return this.getLoadedKey();
    }

    public @Nullable String getRole() {
        return this.role;
    }

    public @Nullable Serializable getSnapshot() {
        return this.snapshot;
    }

    public void resetStoredSnapshot(PersistentCollection<?> collection, Serializable storedSnapshot) {
        LOG.tracef("Reset storedSnapshot to %s for %s", (Object)storedSnapshot, (Object)this);
        if (!this.fromMerge) {
            this.snapshot = storedSnapshot;
            collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
            this.fromMerge = true;
        }
    }

    private void setLoadedPersister(@Nullable CollectionPersister persister) {
        this.loadedPersister = persister;
        this.setRole(persister == null ? null : persister.getRole());
    }

    void afterDeserialize(@Nullable SessionFactoryImplementor factory) {
        this.loadedPersister = factory == null ? null : factory.getMappingMetamodel().getCollectionDescriptor(NullnessUtil.castNonNull(this.role));
    }

    public boolean wasDereferenced() {
        return this.getLoadedKey() == null;
    }

    public boolean isReached() {
        return this.reached;
    }

    public void setReached(boolean reached) {
        this.reached = reached;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isDoupdate() {
        return this.doupdate;
    }

    public void setDoupdate(boolean doupdate) {
        this.doupdate = doupdate;
    }

    public boolean isDoremove() {
        return this.doremove;
    }

    public void setDoremove(boolean doremove) {
        this.doremove = doremove;
    }

    public boolean isDorecreate() {
        return this.dorecreate;
    }

    public void setDorecreate(boolean dorecreate) {
        this.dorecreate = dorecreate;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public @Nullable CollectionPersister getCurrentPersister() {
        return this.currentPersister;
    }

    public void setCurrentPersister(@Nullable CollectionPersister currentPersister) {
        this.currentPersister = currentPersister;
    }

    public @Nullable Object getCurrentKey() {
        return this.currentKey;
    }

    public void setCurrentKey(@Nullable Object currentKey) {
        this.currentKey = currentKey;
    }

    public @Nullable CollectionPersister getLoadedPersister() {
        return this.loadedPersister;
    }

    public @Nullable Object getLoadedKey() {
        return this.loadedKey;
    }

    public void setRole(@Nullable String role) {
        this.role = role;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("CollectionEntry").append(MessageHelper.collectionInfoString(this.role, this.loadedKey));
        CollectionPersister persister = this.currentPersister;
        if (persister != null) {
            result.append("->").append(MessageHelper.collectionInfoString(persister.getRole(), this.currentKey));
        }
        return result.toString();
    }

    public Collection<?> getOrphans(String entityName, PersistentCollection<?> collection) throws HibernateException {
        if (this.snapshot == null) {
            throw new AssertionFailure("no collection snapshot for orphan delete");
        }
        return collection.getOrphans(this.snapshot, entityName);
    }

    public boolean isSnapshotEmpty(PersistentCollection<?> collection) {
        CollectionPersister loadedPersister = this.getLoadedPersister();
        Serializable snapshot = this.getSnapshot();
        return !(!collection.wasInitialized() || loadedPersister != null && !loadedPersister.isMutable() || snapshot != null && !collection.isSnapshotEmpty(snapshot));
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.role);
        oos.writeObject(this.snapshot);
        oos.writeObject(this.loadedKey);
    }

    public static CollectionEntry deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        return new CollectionEntry((String)ois.readObject(), (Serializable)ois.readObject(), ois.readObject(), (SessionFactoryImplementor)(session == null ? null : session.getFactory()));
    }
}

