/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.jboss.logging.Logger;

public class EffectiveEntityGraph
implements AppliedGraph,
Serializable {
    private static final Logger log = Logger.getLogger(EffectiveEntityGraph.class);
    private final boolean allowOverwrite;
    private @Nullable GraphSemantic semantic;
    private @Nullable RootGraphImplementor<?> graph;

    @Incubating
    public EffectiveEntityGraph() {
        this(false);
    }

    @Incubating
    public EffectiveEntityGraph(boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    @Override
    public @Nullable GraphSemantic getSemantic() {
        return this.semantic;
    }

    @Override
    public @Nullable RootGraphImplementor<?> getGraph() {
        return this.graph;
    }

    public void applyGraph(RootGraphImplementor<?> graph, @Nullable GraphSemantic semantic) {
        if (semantic == null) {
            throw new IllegalArgumentException("Graph semantic cannot be null");
        }
        this.verifyWriteability();
        log.tracef("Setting effective graph state [%s] : %s", (Object)semantic.name(), (Object)graph);
        this.semantic = semantic;
        this.graph = graph;
    }

    private void verifyWriteability() {
        if (!this.allowOverwrite && this.semantic != null) {
            throw new IllegalStateException("Cannot overwrite existing state, should clear previous state first");
        }
    }

    public void applyConfiguredGraph(@Nullable Map<String, ?> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        RootGraphImplementor fetchHint = (RootGraphImplementor)properties.get(GraphSemantic.FETCH.getJpaHintName());
        RootGraphImplementor loadHint = (RootGraphImplementor)properties.get(GraphSemantic.LOAD.getJpaHintName());
        if (fetchHint == null) {
            fetchHint = (RootGraphImplementor)properties.get(GraphSemantic.FETCH.getJakartaHintName());
        }
        if (loadHint == null) {
            loadHint = (RootGraphImplementor)properties.get(GraphSemantic.LOAD.getJakartaHintName());
        }
        if (fetchHint != null) {
            if (loadHint != null) {
                throw new IllegalArgumentException("Passed properties contained both a LOAD and a FETCH graph which is illegal - only one should be passed");
            }
            this.applyGraph(fetchHint, GraphSemantic.FETCH);
        } else if (loadHint != null) {
            this.applyGraph(loadHint, GraphSemantic.LOAD);
        }
    }

    public void clear() {
        this.semantic = null;
        this.graph = null;
    }
}

