/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import jakarta.persistence.ConnectionConsumer;
import jakarta.persistence.ConnectionFunction;
import jakarta.persistence.criteria.CriteriaSelect;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryImplementor;

public interface SessionImplementor
extends Session,
SharedSessionContractImplementor {
    @Override
    default public SessionImplementor getSession() {
        return this;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory();

    public <T> QueryImplementor<T> createQuery(CriteriaSelect<T> var1);

    public ActionQueue getActionQueue();

    @Override
    public Object instantiate(EntityPersister var1, Object var2) throws HibernateException;

    public void forceFlush(EntityEntry var1) throws HibernateException;

    public void forceFlush(EntityKey var1) throws HibernateException;

    @Override
    default public <C> void runWithConnection(ConnectionConsumer<C> action) {
        this.doWork(connection -> {
            try {
                action.accept(connection);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    default public <C, T> T callWithConnection(ConnectionFunction<C, T> function) {
        return (T)this.doReturningWork(connection -> {
            try {
                return function.apply(connection);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

