/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.integrator.internal;

import java.util.LinkedHashSet;
import org.hibernate.boot.beanvalidation.BeanValidationIntegrator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cache.internal.CollectionCacheInvalidator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.jboss.logging.Logger;

public class IntegratorServiceImpl
implements IntegratorService {
    private static final Logger LOG = Logger.getLogger(IntegratorServiceImpl.class.getName());
    private final LinkedHashSet<Integrator> integrators = new LinkedHashSet();

    private IntegratorServiceImpl() {
    }

    public static IntegratorServiceImpl create(LinkedHashSet<Integrator> providedIntegrators, ClassLoaderService classLoaderService) {
        IntegratorServiceImpl instance = new IntegratorServiceImpl();
        instance.addIntegrator(new BeanValidationIntegrator());
        instance.addIntegrator(new CollectionCacheInvalidator());
        for (Integrator integrator : providedIntegrators) {
            instance.addIntegrator(integrator);
        }
        for (Integrator integrator : classLoaderService.loadJavaServices(Integrator.class)) {
            instance.addIntegrator(integrator);
        }
        return instance;
    }

    private void addIntegrator(Integrator integrator) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Adding Integrator [%s]", (Object)integrator.getClass().getName());
        }
        this.integrators.add(integrator);
    }

    @Override
    public Iterable<Integrator> getIntegrators() {
        return this.integrators;
    }
}

