/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.spi;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.PersistenceUnitTransactionType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.stream.StreamSource;
import org.hibernate.boot.archive.internal.ArchiveHelper;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.configuration.spi.JaxbPersistenceImpl;
import org.hibernate.boot.jaxb.internal.ConfigurationBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.internal.TcclLookupPrecedence;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.PersistenceUnitTransactionTypeHelper;

public final class PersistenceXmlParser {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(PersistenceXmlParser.class);
    private final Map<?, ?> integration;
    private final ClassLoaderService classLoaderService;

    public static PersistenceXmlParser create() {
        return new PersistenceXmlParser(Map.of(), null, null);
    }

    public static PersistenceXmlParser create(Map<?, ?> integration) {
        return new PersistenceXmlParser(integration, null, null);
    }

    public static PersistenceXmlParser create(Map<?, ?> integration, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService) {
        return new PersistenceXmlParser(integration, providedClassLoader, providedClassLoaderService);
    }

    private PersistenceXmlParser(Map<?, ?> integration, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService) {
        this.integration = integration;
        if (providedClassLoaderService != null) {
            this.classLoaderService = providedClassLoaderService;
        } else {
            Collection classLoaders;
            ArrayList<ClassLoader> providedClassLoaders = new ArrayList<ClassLoader>();
            if (providedClassLoader != null) {
                providedClassLoaders.add(providedClassLoader);
            }
            if ((classLoaders = (Collection)integration.get("hibernate.classLoaders")) != null) {
                providedClassLoaders.addAll(classLoaders);
            }
            this.classLoaderService = new ClassLoaderServiceImpl(providedClassLoaders, TcclLookupPrecedence.from(integration, TcclLookupPrecedence.AFTER));
        }
    }

    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    public Map<String, PersistenceUnitDescriptor> parse(List<URL> persistenceXmlUrls) {
        HashMap<String, PersistenceUnitDescriptor> persistenceUnits = new HashMap<String, PersistenceUnitDescriptor>();
        this.parsePersistenceXml(persistenceUnits, persistenceXmlUrls, PersistenceUnitTransactionType.RESOURCE_LOCAL);
        return persistenceUnits;
    }

    public Map<String, PersistenceUnitDescriptor> parse(List<URL> persistenceXmlUrls, PersistenceUnitTransactionType transactionType) {
        HashMap<String, PersistenceUnitDescriptor> persistenceUnits = new HashMap<String, PersistenceUnitDescriptor>();
        this.parsePersistenceXml(persistenceUnits, persistenceXmlUrls, transactionType);
        return persistenceUnits;
    }

    private void parsePersistenceXml(Map<String, PersistenceUnitDescriptor> persistenceUnits, List<URL> xmlUrls, PersistenceUnitTransactionType defaultTransactionType) {
        for (URL xmlUrl : xmlUrls) {
            this.parsePersistenceXml(persistenceUnits, xmlUrl, defaultTransactionType);
        }
    }

    private void parsePersistenceXml(Map<String, PersistenceUnitDescriptor> persistenceUnits, URL xmlUrl, PersistenceUnitTransactionType defaultTransactionType) {
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to parse persistence.xml file : %s", (Object)xmlUrl.toExternalForm());
        }
        URL persistenceUnitRootUrl = ArchiveHelper.getJarURLFromURLEntry(xmlUrl, "/META-INF/persistence.xml");
        JaxbPersistenceImpl jaxbPersistence = this.loadUrlWithJaxb(xmlUrl);
        List<JaxbPersistenceImpl.JaxbPersistenceUnitImpl> jaxbPersistenceUnits = jaxbPersistence.getPersistenceUnit();
        for (int i = 0; i < jaxbPersistenceUnits.size(); ++i) {
            JaxbPersistenceImpl.JaxbPersistenceUnitImpl jaxbPersistenceUnit = jaxbPersistenceUnits.get(i);
            if (persistenceUnits.containsKey(jaxbPersistenceUnit.getName())) {
                log.duplicatedPersistenceUnitName(jaxbPersistenceUnit.getName());
                continue;
            }
            ParsedPersistenceXmlDescriptor persistenceUnitDescriptor = new ParsedPersistenceXmlDescriptor(persistenceUnitRootUrl);
            this.bindPersistenceUnit(jaxbPersistenceUnit, persistenceUnitDescriptor);
            this.applyIntegrationOverrides(this.integration, defaultTransactionType, persistenceUnitDescriptor);
            persistenceUnits.put(persistenceUnitDescriptor.getName(), persistenceUnitDescriptor);
        }
    }

    private void bindPersistenceUnit(JaxbPersistenceImpl.JaxbPersistenceUnitImpl jaxbPersistenceUnit, ParsedPersistenceXmlDescriptor persistenceUnitDescriptor) {
        String name = jaxbPersistenceUnit.getName();
        if (StringHelper.isNotEmpty(name)) {
            log.tracef("Persistence unit name from persistence.xml : %s", (Object)name);
            persistenceUnitDescriptor.setName(name);
        }
        PersistenceXmlParser.setTransactionType(jaxbPersistenceUnit, persistenceUnitDescriptor);
        persistenceUnitDescriptor.setProviderClassName(jaxbPersistenceUnit.getProvider());
        persistenceUnitDescriptor.setNonJtaDataSource(jaxbPersistenceUnit.getNonJtaDataSource());
        persistenceUnitDescriptor.setJtaDataSource(jaxbPersistenceUnit.getJtaDataSource());
        persistenceUnitDescriptor.setSharedCacheMode(jaxbPersistenceUnit.getSharedCacheMode());
        persistenceUnitDescriptor.setValidationMode(jaxbPersistenceUnit.getValidationMode());
        persistenceUnitDescriptor.setExcludeUnlistedClasses(this.handleBoolean(jaxbPersistenceUnit.isExcludeUnlistedClasses()));
        persistenceUnitDescriptor.addClasses(jaxbPersistenceUnit.getClasses());
        persistenceUnitDescriptor.addMappingFiles(jaxbPersistenceUnit.getMappingFiles());
        persistenceUnitDescriptor.addJarFileUrls(jaxbPersistenceUnit.getJarFiles());
        JaxbPersistenceImpl.JaxbPersistenceUnitImpl.JaxbPropertiesImpl propertyContainer = jaxbPersistenceUnit.getPropertyContainer();
        if (propertyContainer != null) {
            for (JaxbPersistenceImpl.JaxbPersistenceUnitImpl.JaxbPropertiesImpl.JaxbPropertyImpl property : propertyContainer.getProperties()) {
                persistenceUnitDescriptor.getProperties().put(property.getName(), property.getValue());
            }
        }
    }

    private static void setTransactionType(JaxbPersistenceImpl.JaxbPersistenceUnitImpl jaxbPersistenceUnit, ParsedPersistenceXmlDescriptor persistenceUnitDescriptor) {
        jakarta.persistence.spi.PersistenceUnitTransactionType transactionType = jaxbPersistenceUnit.getTransactionType();
        if (transactionType != null) {
            persistenceUnitDescriptor.setTransactionType(PersistenceUnitTransactionTypeHelper.toNewForm(transactionType));
        }
    }

    private boolean handleBoolean(Boolean incoming) {
        if (incoming != null) {
            return incoming;
        }
        return false;
    }

    private void applyIntegrationOverrides(Map<?, ?> integration, PersistenceUnitTransactionType defaultTransactionType, ParsedPersistenceXmlDescriptor persistenceUnitDescriptor) {
        if (integration.containsKey("jakarta.persistence.provider")) {
            persistenceUnitDescriptor.setProviderClassName((String)integration.get("jakarta.persistence.provider"));
        } else if (integration.containsKey("javax.persistence.provider")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.provider", "jakarta.persistence.provider");
            persistenceUnitDescriptor.setProviderClassName((String)integration.get("javax.persistence.provider"));
        }
        if (integration.containsKey("javax.persistence.transactionType")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.transactionType", "jakarta.persistence.transactionType");
            transactionType = (String)integration.get("javax.persistence.transactionType");
            persistenceUnitDescriptor.setTransactionType(PersistenceXmlParser.parseTransactionType(transactionType));
        } else if (integration.containsKey("jakarta.persistence.transactionType")) {
            transactionType = (String)integration.get("jakarta.persistence.transactionType");
            persistenceUnitDescriptor.setTransactionType(PersistenceXmlParser.parseTransactionType(transactionType));
        }
        if (integration.containsKey("javax.persistence.jtaDataSource")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jtaDataSource", "jakarta.persistence.jtaDataSource");
            persistenceUnitDescriptor.setJtaDataSource(integration.get("javax.persistence.jtaDataSource"));
        } else if (integration.containsKey("jakarta.persistence.jtaDataSource")) {
            persistenceUnitDescriptor.setJtaDataSource(integration.get("jakarta.persistence.jtaDataSource"));
        }
        if (integration.containsKey("javax.persistence.nonJtaDataSource")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.nonJtaDataSource", "jakarta.persistence.nonJtaDataSource");
            persistenceUnitDescriptor.setNonJtaDataSource(integration.get("javax.persistence.nonJtaDataSource"));
        } else if (integration.containsKey("jakarta.persistence.nonJtaDataSource")) {
            persistenceUnitDescriptor.setNonJtaDataSource(integration.get("jakarta.persistence.nonJtaDataSource"));
        }
        this.applyTransactionTypeOverride(persistenceUnitDescriptor, defaultTransactionType);
        Properties properties = persistenceUnitDescriptor.getProperties();
        ConfigurationHelper.overrideProperties(properties, integration);
    }

    private void applyTransactionTypeOverride(ParsedPersistenceXmlDescriptor persistenceUnitDescriptor, PersistenceUnitTransactionType defaultTransactionType) {
        if (persistenceUnitDescriptor.getPersistenceUnitTransactionType() == null) {
            if (persistenceUnitDescriptor.getJtaDataSource() != null) {
                persistenceUnitDescriptor.setTransactionType(PersistenceUnitTransactionType.JTA);
            } else if (persistenceUnitDescriptor.getNonJtaDataSource() != null) {
                persistenceUnitDescriptor.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
            } else {
                persistenceUnitDescriptor.setTransactionType(defaultTransactionType);
            }
        }
    }

    private static PersistenceUnitTransactionType parseTransactionType(String value) {
        if (StringHelper.isEmpty(value)) {
            return null;
        }
        if (PersistenceUnitTransactionType.JTA.name().equalsIgnoreCase(value)) {
            return PersistenceUnitTransactionType.JTA;
        }
        if (PersistenceUnitTransactionType.RESOURCE_LOCAL.name().equalsIgnoreCase(value)) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        throw new PersistenceException("Unknown persistence unit transaction type : " + value);
    }

    private JaxbPersistenceImpl loadUrlWithJaxb(URL xmlUrl) {
        JaxbPersistenceImpl jaxbPersistenceImpl;
        block11: {
            String resourceName = xmlUrl.toExternalForm();
            URLConnection conn = xmlUrl.openConnection();
            conn.setUseCaches(false);
            InputStream inputStream = conn.getInputStream();
            try {
                StreamSource inputSource = new StreamSource(inputStream);
                ConfigurationBinder configurationBinder = new ConfigurationBinder(this.classLoaderService);
                Binding binding = configurationBinder.bind(inputSource, new Origin(SourceType.URL, resourceName));
                jaxbPersistenceImpl = (JaxbPersistenceImpl)binding.getRoot();
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Unable to obtain input stream from [" + resourceName + "]", e);
                    }
                }
                catch (IOException e) {
                    throw new PersistenceException("Unable to access [" + resourceName + "]", e);
                }
            }
            inputStream.close();
        }
        return jaxbPersistenceImpl;
    }
}

