/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceUnitTransactionType;

public class PersistenceUnitTransactionTypeHelper {
    private PersistenceUnitTransactionTypeHelper() {
    }

    public static jakarta.persistence.PersistenceUnitTransactionType interpretTransactionType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof jakarta.persistence.PersistenceUnitTransactionType) {
            jakarta.persistence.PersistenceUnitTransactionType transactionType = (jakarta.persistence.PersistenceUnitTransactionType)((Object)value);
            return transactionType;
        }
        String stringValue = value.toString().trim();
        if (stringValue.isEmpty()) {
            return null;
        }
        if (jakarta.persistence.PersistenceUnitTransactionType.JTA.name().equalsIgnoreCase(stringValue)) {
            return jakarta.persistence.PersistenceUnitTransactionType.JTA;
        }
        if (jakarta.persistence.PersistenceUnitTransactionType.RESOURCE_LOCAL.name().equalsIgnoreCase(stringValue)) {
            return jakarta.persistence.PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        throw new PersistenceException("Unknown TransactionType: '" + stringValue + "'");
    }

    public static PersistenceUnitTransactionType toDeprecatedForm(jakarta.persistence.PersistenceUnitTransactionType type) {
        PersistenceUnitTransactionType persistenceUnitTransactionType;
        if (type == null) {
            persistenceUnitTransactionType = null;
        } else {
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case JTA: {
                    persistenceUnitTransactionType = PersistenceUnitTransactionType.JTA;
                    break;
                }
                case RESOURCE_LOCAL: {
                    persistenceUnitTransactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
                }
            }
        }
        return persistenceUnitTransactionType;
    }

    public static jakarta.persistence.PersistenceUnitTransactionType toNewForm(PersistenceUnitTransactionType type) {
        jakarta.persistence.PersistenceUnitTransactionType persistenceUnitTransactionType;
        if (type == null) {
            persistenceUnitTransactionType = null;
        } else {
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case JTA: {
                    persistenceUnitTransactionType = jakarta.persistence.PersistenceUnitTransactionType.JTA;
                    break;
                }
                case RESOURCE_LOCAL: {
                    persistenceUnitTransactionType = jakarta.persistence.PersistenceUnitTransactionType.RESOURCE_LOCAL;
                }
            }
        }
        return persistenceUnitTransactionType;
    }
}

