/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderStandardImpl;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderSupport;
import org.hibernate.loader.ast.spi.EntityBatchLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractEntityBatchLoader<T>
extends SingleIdEntityLoaderSupport<T>
implements EntityBatchLoader<T> {
    private final SingleIdEntityLoaderStandardImpl<T> singleIdLoader;

    public AbstractEntityBatchLoader(EntityMappingType entityDescriptor, LoadQueryInfluencers influencers) {
        super(entityDescriptor, influencers.getSessionFactory());
        this.singleIdLoader = new SingleIdEntityLoaderStandardImpl(entityDescriptor, influencers);
    }

    protected abstract void initializeEntities(Object[] var1, Object var2, Object var3, LockOptions var4, Boolean var5, SharedSessionContractImplementor var6);

    protected abstract Object[] resolveIdsToInitialize(Object var1, SharedSessionContractImplementor var2);

    @Override
    public final T load(Object id, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.trace("Batch fetching entity: " + MessageHelper.infoString(this.getLoadable(), id));
        }
        Object[] ids = this.resolveIdsToInitialize(id, session);
        return this.load(id, ids, MultiKeyLoadHelper.hasSingleId(ids), entityInstance, lockOptions, readOnly, session);
    }

    @Override
    public T load(Object id, Object entityInstance, LockOptions lockOptions, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.trace("Batch fetching entity: " + MessageHelper.infoString(this.getLoadable(), id));
        }
        Object[] ids = this.resolveIdsToInitialize(id, session);
        boolean hasSingleId = MultiKeyLoadHelper.hasSingleId(ids);
        T entity = this.load(id, ids, hasSingleId, entityInstance, lockOptions, null, session);
        if (hasSingleId) {
            return entity;
        }
        if (Hibernate.isInitialized(entity)) {
            return entity;
        }
        return null;
    }

    private T load(Object id, Object[] ids, boolean hasSingleId, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (hasSingleId || lockOptions.getLockMode() != LockMode.NONE) {
            return this.singleIdLoader.load(id, entityInstance, lockOptions, readOnly, session);
        }
        this.initializeEntities(ids, id, entityInstance, lockOptions, readOnly, session);
        EntityKey entityKey = session.generateEntityKey(id, this.getLoadable().getEntityPersister());
        return (T)session.getPersistenceContext().getEntity(entityKey);
    }
}

