/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoadOptions;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;

public abstract class AbstractMultiNaturalIdLoader<E>
implements MultiNaturalIdLoader<E> {
    private final EntityMappingType entityDescriptor;

    public AbstractMultiNaturalIdLoader(EntityMappingType entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
    }

    @Override
    public <K> List<E> multiLoad(K[] naturalIds, MultiNaturalIdLoadOptions options, SharedSessionContractImplementor session) {
        assert (naturalIds != null);
        if (naturalIds.length == 0) {
            return Collections.emptyList();
        }
        return options.isOrderReturnEnabled() ? this.performOrderedMultiLoad(naturalIds, options, session) : this.performUnorderedMultiLoad(naturalIds, options, session);
    }

    private <K> List<E> performUnorderedMultiLoad(K[] naturalIds, MultiNaturalIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("Unordered batch load starting: " + this.getEntityDescriptor().getEntityName(), new Object[0]);
        }
        return this.unorderedMultiLoad(naturalIds, loadOptions, session);
    }

    private static LockOptions lockOptions(MultiNaturalIdLoadOptions loadOptions) {
        LockOptions lockOptions = loadOptions.getLockOptions();
        return lockOptions == null ? new LockOptions() : lockOptions;
    }

    private <K> List<E> unorderedMultiLoad(K[] naturalIds, MultiNaturalIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        ArrayList results = CollectionHelper.arrayList(naturalIds.length);
        LockOptions lockOptions = AbstractMultiNaturalIdLoader.lockOptions(loadOptions);
        Object[] unresolvedIds = this.checkPersistenceContextForCachedResults(naturalIds, loadOptions, session, lockOptions, results::add);
        if (!CollectionHelper.isEmpty(unresolvedIds)) {
            results.addAll(this.loadEntitiesWithUnresolvedIds(unresolvedIds, loadOptions, lockOptions, session));
        }
        return results;
    }

    protected abstract List<E> loadEntitiesWithUnresolvedIds(Object[] var1, MultiNaturalIdLoadOptions var2, LockOptions var3, SharedSessionContractImplementor var4);

    private <K> List<E> performOrderedMultiLoad(K[] naturalIds, MultiNaturalIdLoadOptions options, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.trace("Ordered MultiLoad starting: " + this.getEntityDescriptor().getEntityName());
        }
        return this.orderedMultiLoad(naturalIds, options, session);
    }

    private <K> List<E> orderedMultiLoad(K[] naturalIds, MultiNaturalIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        LockOptions lockOptions = AbstractMultiNaturalIdLoader.lockOptions(loadOptions);
        Object[] unresolvedIds = this.checkPersistenceContextForCachedResults(naturalIds, loadOptions, session, lockOptions, result -> {});
        if (!CollectionHelper.isEmpty(unresolvedIds)) {
            this.loadEntitiesWithUnresolvedIds(unresolvedIds, loadOptions, lockOptions, session);
        }
        return this.sortResults(naturalIds, loadOptions, session);
    }

    private <K> List<E> sortResults(K[] naturalIds, MultiNaturalIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        PersistenceContext context = session.getPersistenceContextInternal();
        ArrayList results = CollectionHelper.arrayList(naturalIds.length);
        for (K naturalId : naturalIds) {
            Object entity = this.entityForNaturalId(context, naturalId);
            Object result = entity == null || !loadOptions.isReturnOfDeletedEntitiesEnabled() && context.getEntry(entity).getStatus().isDeletedOrGone() ? null : context.proxyFor(entity);
            results.add(result);
        }
        return results;
    }

    private <K> Object entityForNaturalId(PersistenceContext context, K naturalId) {
        EntityMappingType descriptor = this.getEntityDescriptor();
        Object id = context.getNaturalIdResolutions().findCachedIdByNaturalId(naturalId, descriptor);
        return id == null ? null : context.getEntity(new EntityKey(id, descriptor.getEntityPersister()));
    }

    private <K> Object[] checkPersistenceContextForCachedResults(K[] naturalIds, MultiNaturalIdLoadOptions loadOptions, SharedSessionContractImplementor session, LockOptions lockOptions, Consumer<E> results) {
        ArrayList unresolvedIds = CollectionHelper.arrayList(naturalIds.length);
        PersistenceContext context = session.getPersistenceContextInternal();
        NaturalIdMapping naturalIdMapping = this.getEntityDescriptor().getNaturalIdMapping();
        for (K naturalId : naturalIds) {
            Object entity = this.entityForNaturalId(context, naturalIdMapping.normalizeInput(naturalId));
            if (entity != null) {
                EntityEntry entry = context.getEntry(entity);
                if (!loadOptions.isReturnOfDeletedEntitiesEnabled() && entry.getStatus().isDeletedOrGone()) continue;
                LoaderHelper.upgradeLock(entity, entry, lockOptions, session);
                Object result = context.proxyFor(entity);
                results.accept(result);
                continue;
            }
            unresolvedIds.add(naturalId);
        }
        return unresolvedIds.toArray();
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.getEntityDescriptor();
    }

    protected final EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }
}

