/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractSqmPathSource<J>
implements SqmPathSource<J> {
    private final String localPathName;
    protected final SqmPathSource<J> pathModel;
    private final SqmDomainType<J> domainType;
    private final Bindable.BindableType jpaBindableType;

    public AbstractSqmPathSource(String localPathName, SqmPathSource<J> pathModel, DomainType<J> domainType, Bindable.BindableType jpaBindableType) {
        this.localPathName = localPathName;
        this.pathModel = pathModel == null ? this : pathModel;
        this.domainType = (SqmDomainType)domainType;
        this.jpaBindableType = jpaBindableType;
    }

    @Override
    public Class<J> getBindableJavaType() {
        return this.domainType.getJavaType();
    }

    @Override
    public String getPathName() {
        return this.localPathName;
    }

    @Override
    public SqmDomainType<J> getPathType() {
        return this.domainType;
    }

    @Override
    public Bindable.BindableType getBindableType() {
        return this.jpaBindableType;
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.domainType.getExpressibleJavaType();
    }
}

