/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.sql.exec.internal.JdbcCallFunctionReturnImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.spi.JdbcCallFunctionReturn;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindableType;
import org.hibernate.type.OutputableType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class FunctionReturnImpl<T>
implements FunctionReturnImplementor<T> {
    private final ProcedureCallImplementor<T> procedureCall;
    private final int sqlTypeCode;
    private OutputableType<T> ormType;

    public FunctionReturnImpl(ProcedureCallImplementor<T> procedureCall, int sqlTypeCode) {
        this.procedureCall = procedureCall;
        this.sqlTypeCode = sqlTypeCode;
    }

    public FunctionReturnImpl(ProcedureCallImplementor<T> procedureCall, OutputableType<T> ormType) {
        this.procedureCall = procedureCall;
        this.sqlTypeCode = ormType.getJdbcType().getDefaultSqlTypeCode();
        this.ormType = ormType;
    }

    @Override
    public JdbcCallFunctionReturn toJdbcFunctionReturn(SharedSessionContractImplementor persistenceContext) {
        if (this.getJdbcTypeCode() == 2012) {
            return new JdbcCallFunctionReturnImpl.RefCurserJdbcCallFunctionReturnImpl(new JdbcCallRefCursorExtractorImpl(1));
        }
        return new JdbcCallFunctionReturnImpl.RegularJdbcCallFunctionReturnImpl(this.getOrmType(persistenceContext), new JdbcCallParameterExtractorImpl<T>(this.procedureCall.getProcedureName(), null, 1, this.getOrmType(persistenceContext)));
    }

    private OutputableType<T> getOrmType(SharedSessionContractImplementor persistenceContext) {
        if (this.ormType != null) {
            return this.ormType;
        }
        TypeConfiguration typeConfiguration = persistenceContext.getFactory().getTypeConfiguration();
        JavaType javaType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(this.getJdbcTypeCode()).getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration);
        BasicType basicType = typeConfiguration.standardBasicTypeForJavaType(javaType.getJavaTypeClass());
        return basicType;
    }

    @Override
    public int getJdbcTypeCode() {
        return this.sqlTypeCode;
    }

    @Override
    public BindableType<T> getHibernateType() {
        return this.ormType;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Integer getPosition() {
        return 1;
    }

    @Override
    public ParameterMode getMode() {
        return ParameterMode.OUT;
    }

    @Override
    public Class<T> getParameterType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disallowMultiValuedBinding() {
    }

    @Override
    public void applyAnticipatedType(BindableType<?> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean allowsMultiValuedBinding() {
        return false;
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        return session -> this.ormType != null ? new FunctionReturnImpl<T>(this.procedureCall, this.ormType) : new FunctionReturnImpl<T>(this.procedureCall, this.sqlTypeCode);
    }
}

