/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Nulls;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hibernate.AssertionFailure;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.dialect.function.SqlColumn;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.grammars.hql.HqlParserBaseVisitor;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.internal.util.QuotingHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PathSource;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPath;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EntitySqmPathSource;
import org.hibernate.query.ParameterLabelException;
import org.hibernate.query.PathException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SortDirection;
import org.hibernate.query.SyntaxException;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.common.FrameExclusion;
import org.hibernate.query.common.FrameKind;
import org.hibernate.query.common.FrameMode;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.criteria.JpaConflictClause;
import org.hibernate.query.criteria.JpaConflictUpdateAction;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaCteCriteriaAttribute;
import org.hibernate.query.criteria.JpaCteCriteriaType;
import org.hibernate.query.criteria.JpaFrom;
import org.hibernate.query.criteria.JpaJoin;
import org.hibernate.query.criteria.JpaJsonExistsNode;
import org.hibernate.query.criteria.JpaJsonQueryNode;
import org.hibernate.query.criteria.JpaJsonTableColumnsNode;
import org.hibernate.query.criteria.JpaJsonTableFunction;
import org.hibernate.query.criteria.JpaJsonValueNode;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaSearchOrder;
import org.hibernate.query.criteria.JpaXmlTableColumnNode;
import org.hibernate.query.criteria.JpaXmlTableFunction;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.internal.DomainPathPart;
import org.hibernate.query.hql.internal.QualifiedJoinPathConsumer;
import org.hibernate.query.hql.internal.QualifiedJoinPredicatePathConsumer;
import org.hibernate.query.hql.internal.SqmTreeCreationHelper;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.LiteralNumberFormatException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.TerminalPathException;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.UnknownEntityException;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.internal.ParameterCollector;
import org.hibernate.query.sqm.internal.SqmCreationProcessingStateImpl;
import org.hibernate.query.sqm.internal.SqmDmlCreationProcessingState;
import org.hibernate.query.sqm.internal.SqmQueryPartCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.spi.ParameterDeclarationContext;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmCteRoot;
import org.hibernate.query.sqm.tree.domain.SqmDerivedRoot;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmElementAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmEntityDomainType;
import org.hibernate.query.sqm.tree.domain.SqmFkExpression;
import org.hibernate.query.sqm.tree.domain.SqmFunctionRoot;
import org.hibernate.query.sqm.tree.domain.SqmIndexAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.expression.AbstractSqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmAnyDiscriminatorValue;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmHqlNumericLiteral;
import org.hibernate.query.sqm.tree.expression.SqmJsonExistsExpression;
import org.hibernate.query.sqm.tree.expression.SqmJsonNullBehavior;
import org.hibernate.query.sqm.tree.expression.SqmJsonObjectAggUniqueKeysBehavior;
import org.hibernate.query.sqm.tree.expression.SqmJsonQueryExpression;
import org.hibernate.query.sqm.tree.expression.SqmJsonTableFunction;
import org.hibernate.query.sqm.tree.expression.SqmJsonValueExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedExpression;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmOver;
import org.hibernate.query.sqm.tree.expression.SqmOverflow;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmSetReturningFunction;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.expression.SqmXmlElementExpression;
import org.hibernate.query.sqm.tree.expression.SqmXmlTableFunction;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmCteJoin;
import org.hibernate.query.sqm.tree.from.SqmDerivedJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmFunctionJoin;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmConflictClause;
import org.hibernate.query.sqm.tree.insert.SqmConflictUpdateAction;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmTruthnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmAliasedNode;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteSearchClauseKind;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SemanticQueryBuilder<R>
extends HqlParserBaseVisitor<Object>
implements SqmCreationState {
    private static final Logger log = Logger.getLogger(SemanticQueryBuilder.class);
    private static final Set<String> JPA_STANDARD_FUNCTIONS = Set.of("avg", "max", "min", "sum", "count", "length", "locate", "abs", "sqrt", "mod", "size", "index", "current_date", "current_time", "current_timestamp", "concat", "substring", "trim", "lower", "upper", "coalesce", "nullif", "left", "right", "replace");
    private static final BasicTypeImpl<Object> OBJECT_BASIC_TYPE = new BasicTypeImpl<Object>(new UnknownBasicJavaType<Object>(Object.class), ObjectJdbcType.INSTANCE);
    private final Class<R> expectedResultType;
    private final String expectedResultTypeName;
    private final String expectedResultTypeShortName;
    private final String expectedResultEntity;
    private final SqmCreationOptions creationOptions;
    private final SqmCreationContext creationContext;
    private final String query;
    private final Stack<DotIdentifierConsumer> dotIdentifierConsumerStack;
    private final Stack<ParameterDeclarationContext> parameterDeclarationContextStack = new StandardStack<ParameterDeclarationContext>();
    private final Stack<SqmCreationProcessingState> processingStateStack = new StandardStack<SqmCreationProcessingState>();
    private final BasicType<Integer> integerDomainType;
    private final JavaType<List<?>> listJavaType;
    private final JavaType<Map<?, ?>> mapJavaType;
    private ParameterCollector parameterCollector;
    private ParameterStyle parameterStyle;
    private Map<Object, AbstractSqmParameter<?>> parameters;
    private boolean isExtractingJdbcTemporalType;
    private JpaCteCriteria<?> currentPotentialRecursiveCte;

    public static <R> SqmStatement<R> buildSemanticModel(HqlParser.StatementContext hqlParseTree, Class<R> expectedResultType, SqmCreationOptions creationOptions, SqmCreationContext creationContext, String query) {
        return new SemanticQueryBuilder<R>(expectedResultType, creationOptions, creationContext, query).visitStatement(hqlParseTree);
    }

    public SemanticQueryBuilder(Class<R> expectedResultType, SqmCreationOptions creationOptions, SqmCreationContext creationContext, String query) {
        this(expectedResultType, expectedResultType == null ? null : expectedResultType.getTypeName(), expectedResultType == null ? null : expectedResultType.getSimpleName(), null, creationOptions, creationContext, query);
    }

    public SemanticQueryBuilder(String expectedResultTypeName, String expectedResultTypeShortName, String expectedResultEntity, SqmCreationOptions creationOptions, SqmCreationContext creationContext, String query) {
        this(null, expectedResultTypeName, expectedResultTypeShortName, expectedResultEntity, creationOptions, creationContext, query);
    }

    public SemanticQueryBuilder(String expectedResultTypeName, String expectedResultTypeShortName, Class<R> expectedResultType, SqmCreationOptions creationOptions, SqmCreationContext creationContext, String query) {
        this(expectedResultType, expectedResultTypeName, expectedResultTypeShortName, null, creationOptions, creationContext, query);
    }

    private SemanticQueryBuilder(Class<R> expectedResultType, String expectedResultTypeName, String expectedResultTypeShortName, String expectedResultEntity, SqmCreationOptions creationOptions, SqmCreationContext creationContext, String query) {
        this.expectedResultType = expectedResultType;
        this.expectedResultTypeName = expectedResultTypeName;
        this.expectedResultTypeShortName = expectedResultTypeShortName;
        this.expectedResultEntity = expectedResultEntity;
        this.creationOptions = creationOptions;
        this.creationContext = creationContext;
        this.query = query;
        this.dotIdentifierConsumerStack = new StandardStack<BasicDotIdentifierConsumer>(new BasicDotIdentifierConsumer(this));
        this.parameterStyle = creationOptions.useStrictJpaCompliance() ? ParameterStyle.UNKNOWN : ParameterStyle.MIXED;
        TypeConfiguration typeConfiguration = creationContext.getTypeConfiguration();
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        this.integerDomainType = typeConfiguration.standardBasicTypeForJavaType(Integer.class);
        this.listJavaType = javaTypeRegistry.resolveDescriptor((Type)((Object)List.class));
        this.mapJavaType = javaTypeRegistry.resolveDescriptor((Type)((Object)Map.class));
    }

    @Override
    public SqmCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqmCreationOptions getCreationOptions() {
        return this.creationOptions;
    }

    @Override
    public Stack<SqmCreationProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    private NodeBuilder nodeBuilder() {
        return this.creationContext.getNodeBuilder();
    }

    private QueryEngine queryEngine() {
        return this.creationContext.getQueryEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmStatement<R> visitStatement(HqlParser.StatementContext ctx) {
        this.parameterDeclarationContextStack.push(() -> false);
        try {
            ParseTree parseTree = ctx.getChild(0);
            if (parseTree instanceof HqlParser.SelectStatementContext) {
                HqlParser.SelectStatementContext selectStatementContext = (HqlParser.SelectStatementContext)parseTree;
                Object selectStatement = this.visitSelectStatement(selectStatementContext);
                ((SqmQueryPart)((AbstractSqmSelectQuery)selectStatement).getQueryPart()).validateQueryStructureAndFetchOwners();
                Object object = selectStatement;
                return object;
            }
            if (parseTree instanceof HqlParser.InsertStatementContext) {
                HqlParser.InsertStatementContext insertStatementContext = (HqlParser.InsertStatementContext)parseTree;
                Object object = this.visitInsertStatement(insertStatementContext);
                return object;
            }
            if (parseTree instanceof HqlParser.UpdateStatementContext) {
                HqlParser.UpdateStatementContext updateStatementContext = (HqlParser.UpdateStatementContext)parseTree;
                Object object = this.visitUpdateStatement(updateStatementContext);
                return object;
            }
            if (parseTree instanceof HqlParser.DeleteStatementContext) {
                HqlParser.DeleteStatementContext deleteStatementContext = (HqlParser.DeleteStatementContext)parseTree;
                Object object = this.visitDeleteStatement(deleteStatementContext);
                return object;
            }
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
        throw new ParsingException("Unexpected statement type [not INSERT, UPDATE, DELETE or SELECT] : " + ctx.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSelectStatement<R> visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        SqmSelectStatement selectStatement;
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        this.parameterCollector = selectStatement = new SqmSelectStatement(this.nodeBuilder());
        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
        try {
            queryExpressionContext.accept(this);
        }
        finally {
            this.processingStateStack.pop();
        }
        return selectStatement;
    }

    @Override
    public SqmRoot<R> visitTargetEntity(HqlParser.TargetEntityContext dmlTargetContext) {
        return new SqmRoot(this.visitEntityName(dmlTargetContext.entityName()), this.extractAlias(dmlTargetContext.variable()), false, this.nodeBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmInsertStatement<R> visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        SqmInsertValuesStatement insertStatement;
        HqlParser.TargetEntityContext dmlTargetContext = ctx.targetEntity();
        HqlParser.TargetFieldsContext targetFieldsSpecContext = ctx.targetFields();
        Object root = this.visitTargetEntity(dmlTargetContext);
        if (((SqmRoot)root).getModel() instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Target type '" + ((SqmRoot)root).getModel().getHibernateEntityName() + "' in 'insert' statement is not an entity", this.query);
        }
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        if (queryExpressionContext != null) {
            SqmInsertSelectStatement insertStatement2;
            this.parameterCollector = insertStatement2 = new SqmInsertSelectStatement(root, this.nodeBuilder());
            SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement2, this);
            this.processingStateStack.push(processingState);
            try {
                SqmCreationProcessingStateImpl stateFieldsProcessingState = new SqmCreationProcessingStateImpl(insertStatement2, this);
                stateFieldsProcessingState.getPathRegistry().register((SqmPath<?>)root);
                this.processingStateStack.push(stateFieldsProcessingState);
                try {
                    for (HqlParser.SimplePathContext stateFieldCtx : targetFieldsSpecContext.simplePath()) {
                        SqmPath stateField = (SqmPath)this.visitSimplePath(stateFieldCtx);
                        insertStatement2.addInsertTargetStateField(stateField);
                    }
                }
                finally {
                    this.processingStateStack.pop();
                }
                queryExpressionContext.accept(this);
                insertStatement2.onConflict((JpaConflictClause)this.visitConflictClause(ctx.conflictClause()));
                insertStatement2.validate(this.query);
                SqmInsertSelectStatement sqmInsertSelectStatement = insertStatement2;
                return sqmInsertSelectStatement;
            }
            finally {
                this.processingStateStack.pop();
            }
        }
        this.parameterCollector = insertStatement = new SqmInsertValuesStatement(root, this.nodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register((SqmPath<?>)root);
        try {
            for (HqlParser.SimplePathContext stateFieldCtx : targetFieldsSpecContext.simplePath()) {
                SqmPath stateField = (SqmPath)this.visitSimplePath(stateFieldCtx);
                insertStatement.addInsertTargetStateField(stateField);
            }
            ArrayList<SqmValues> valuesList = new ArrayList<SqmValues>();
            HqlParser.ValuesListContext valuesListContext = ctx.valuesList();
            for (int i = 1; i < valuesListContext.getChildCount(); i += 2) {
                ParseTree values = valuesListContext.getChild(i);
                ArrayList valuesExpressions = new ArrayList();
                Iterator<SqmPath<?>> iterator = insertStatement.getInsertionTargetPaths().iterator();
                for (int j = 1; j < values.getChildCount(); j += 2) {
                    HqlParser.ExpressionContext expressionContext;
                    Set<String> possibleEnumTypes;
                    ParseTree parseTree;
                    SqmPath<?> targetPath = iterator.next();
                    String targetPathJavaType = targetPath.getJavaTypeName();
                    boolean isEnum = targetPath.isEnum();
                    ParseTree valuesContext = values.getChild(j);
                    SqmExpression<?> value = isEnum && (parseTree = valuesContext.getChild(0)) instanceof HqlParser.ExpressionContext && (possibleEnumTypes = this.getPossibleEnumTypes(expressionContext = (HqlParser.ExpressionContext)parseTree)) != null ? this.resolveEnumShorthandLiteral(expressionContext, this.getPossibleEnumValue(expressionContext), targetPathJavaType, possibleEnumTypes) : (SqmExpression<?>)valuesContext.accept(this);
                    valuesExpressions.add(value);
                }
                valuesList.add(new SqmValues(valuesExpressions));
            }
            insertStatement.values(valuesList);
            insertStatement.onConflict((JpaConflictClause)this.visitConflictClause(ctx.conflictClause()));
            insertStatement.validate(this.query);
            SqmInsertValuesStatement sqmInsertValuesStatement = insertStatement;
            return sqmInsertValuesStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    @Override
    public SqmConflictClause<R> visitConflictClause(HqlParser.ConflictClauseContext ctx) {
        HqlParser.ConflictActionContext conflictActionContext;
        HqlParser.SetClauseContext setClauseContext;
        if (ctx == null) {
            return null;
        }
        SqmCreationProcessingState processingState = this.processingStateStack.getCurrent();
        SqmInsertStatement statement = (SqmInsertStatement)processingState.getProcessingQuery();
        SqmConflictClause conflictClause = new SqmConflictClause(statement);
        HqlParser.ConflictTargetContext conflictTargetContext = ctx.conflictTarget();
        if (conflictTargetContext != null) {
            HqlParser.IdentifierContext identifierCtx = conflictTargetContext.identifier();
            if (identifierCtx != null) {
                conflictClause.conflictOnConstraint(this.visitIdentifier(identifierCtx));
            } else {
                ArrayList constraintAttributes = new ArrayList();
                for (HqlParser.SimplePathContext pathContext : conflictTargetContext.simplePath()) {
                    constraintAttributes.add(this.consumeDomainPath(pathContext));
                }
                conflictClause.conflictOnConstraintPaths((List)constraintAttributes);
            }
        }
        if ((setClauseContext = (conflictActionContext = ctx.conflictAction()).setClause()) != null) {
            processingState.getPathRegistry().registerByAliasOnly((SqmFrom<?, ?>)((Object)conflictClause.getExcludedRoot()));
            JpaConflictUpdateAction updateAction = conflictClause.onConflictDoUpdate();
            for (HqlParser.AssignmentContext assignmentContext : setClauseContext.assignment()) {
                ((SqmConflictUpdateAction)updateAction).addAssignment((SqmAssignment<?>)this.visitAssignment(assignmentContext));
            }
            ((SqmConflictUpdateAction)updateAction).where((Expression)this.visitWhereClause(conflictActionContext.whereClause()));
        }
        return conflictClause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmUpdateStatement<R> visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        SqmUpdateStatement updateStatement;
        this.parameterCollector = updateStatement = new SqmUpdateStatement(this.nodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(updateStatement, this);
        this.processingStateStack.push(processingState);
        try {
            updateStatement.versioned(ctx.VERSIONED() != null);
            updateStatement.setTarget(this.visitEntityWithJoins(ctx.entityWithJoins()));
            HqlParser.SetClauseContext setClauseCtx = ctx.setClause();
            for (ParseTree subCtx : setClauseCtx.children) {
                if (!(subCtx instanceof HqlParser.AssignmentContext)) continue;
                HqlParser.AssignmentContext assignmentContext = (HqlParser.AssignmentContext)subCtx;
                updateStatement.applyAssignment(this.visitAssignment(assignmentContext));
            }
            HqlParser.WhereClauseContext whereClauseContext = ctx.whereClause();
            if (whereClauseContext != null) {
                updateStatement.applyPredicate(this.visitWhereClause(whereClauseContext));
            }
            updateStatement.validate(this.query);
            SqmUpdateStatement sqmUpdateStatement = updateStatement;
            return sqmUpdateStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    @Override
    public SqmAssignment<?> visitAssignment(HqlParser.AssignmentContext ctx) {
        HqlParser.ExpressionContext expressionContext;
        Set<String> possibleEnumValues;
        ParseTree parseTree;
        SqmPath<?> targetPath = this.consumeDomainPath(ctx.simplePath());
        String targetPathJavaType = targetPath.getJavaTypeName();
        boolean isEnum = targetPath.isEnum();
        HqlParser.ExpressionOrPredicateContext rightSide = ctx.expressionOrPredicate();
        SqmExpression<?> value = isEnum && (parseTree = rightSide.getChild(0)) instanceof HqlParser.ExpressionContext && (possibleEnumValues = this.getPossibleEnumTypes(expressionContext = (HqlParser.ExpressionContext)parseTree)) != null ? this.resolveEnumShorthandLiteral(expressionContext, this.getPossibleEnumValue(expressionContext), targetPathJavaType, possibleEnumValues) : (SqmExpression<?>)rightSide.accept(this);
        return new SqmAssignment(targetPath, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmDeleteStatement<R> visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        SqmDeleteStatement deleteStatement;
        this.parameterCollector = deleteStatement = new SqmDeleteStatement(this.nodeBuilder());
        SqmDmlCreationProcessingState sqmDeleteCreationState = new SqmDmlCreationProcessingState(deleteStatement, this);
        this.processingStateStack.push(sqmDeleteCreationState);
        try {
            deleteStatement.setTarget(this.visitEntityWithJoins(ctx.entityWithJoins()));
            HqlParser.WhereClauseContext whereClauseContext = ctx.whereClause();
            if (whereClauseContext != null) {
                deleteStatement.applyPredicate(this.visitWhereClause(whereClauseContext));
            }
            SqmDeleteStatement sqmDeleteStatement = deleteStatement;
            return sqmDeleteStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    @Override
    public Object visitWithClause(HqlParser.WithClauseContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.CTES);
        }
        List children = ctx.children;
        for (int i = 1; i < children.size(); i += 2) {
            this.visitCte((HqlParser.CteContext)children.get(i));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCte(HqlParser.CteContext ctx) {
        SqmSelectStatement<Object> sqmSelectStatement;
        SqmCteContainer cteContainer = (SqmCteContainer)((Object)this.processingStateStack.getCurrent().getProcessingQuery());
        String name = this.visitIdentifier(ctx.identifier());
        TerminalNode thirdChild = (TerminalNode)ctx.getChild(2);
        CteMaterialization materialization = switch (thirdChild.getSymbol().getType()) {
            case 169 -> CteMaterialization.NOT_MATERIALIZED;
            case 151 -> CteMaterialization.MATERIALIZED;
            default -> null;
        };
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        if (cteContainer instanceof SqmSubQuery) {
            SqmSubQuery subQuery = (SqmSubQuery)cteContainer;
            sqmSelectStatement = new SqmSubQuery((SqmQuery<?>)((Object)subQuery.getParent()), this.nodeBuilder());
        } else {
            sqmSelectStatement = new SqmSelectStatement(this.nodeBuilder());
        }
        SqmSelectStatement<Object> cte = sqmSelectStatement;
        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), cte, this));
        JpaCteCriteria<?> oldCte = this.currentPotentialRecursiveCte;
        try {
            HqlParser.SetQueryGroupContext setContext;
            this.currentPotentialRecursiveCte = null;
            if (queryExpressionContext instanceof HqlParser.SetQueryGroupContext && (setContext = (HqlParser.SetQueryGroupContext)queryExpressionContext).getChildCount() < 5 && this.handleRecursive(ctx, setContext, cteContainer, name, cte, materialization)) {
                Object var10_10 = null;
                return var10_10;
            }
            queryExpressionContext.accept(this);
            JpaCteCriteria cteDefinition = cteContainer.with(name, cte);
            if (materialization != null) {
                cteDefinition.setMaterialization(materialization);
            }
        }
        finally {
            this.processingStateStack.pop();
            this.currentPotentialRecursiveCte = oldCte;
        }
        return null;
    }

    private boolean handleRecursive(HqlParser.CteContext cteContext, HqlParser.SetQueryGroupContext setContext, SqmCteContainer cteContainer, String name, SqmSelectQuery<Object> cte, CteMaterialization materialization) {
        SetOperator setOperator = (SetOperator)((Object)setContext.setOperator(0).accept(this));
        switch (setOperator) {
            case UNION: 
            case UNION_ALL: {
                HqlParser.SearchClauseContext searchClauseContext;
                HqlParser.CycleClauseContext cycleClauseContext;
                HqlParser.OrderedQueryContext nonRecursiveQueryContext = setContext.orderedQuery(0);
                HqlParser.OrderedQueryContext recursiveQueryContext = setContext.orderedQuery(1);
                nonRecursiveQueryContext.accept(this);
                SqmSelectStatement recursivePart = new SqmSelectStatement(this.nodeBuilder());
                this.processingStateStack.pop();
                this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), recursivePart, this));
                JpaCteCriteria<Object> cteDefinition = setOperator == SetOperator.UNION ? cteContainer.withRecursiveUnionDistinct(name, cte, cteCriteria -> {
                    this.currentPotentialRecursiveCte = cteCriteria;
                    recursiveQueryContext.accept(this);
                    return recursivePart;
                }) : cteContainer.withRecursiveUnionAll(name, cte, cteCriteria -> {
                    this.currentPotentialRecursiveCte = cteCriteria;
                    recursiveQueryContext.accept(this);
                    return recursivePart;
                });
                if (materialization != null) {
                    cteDefinition.setMaterialization(materialization);
                }
                if ((cycleClauseContext = cteContext.cycleClause()) != null) {
                    this.applyCycleClause(cteDefinition, cycleClauseContext);
                }
                if ((searchClauseContext = cteContext.searchClause()) != null) {
                    this.applySearchClause(cteDefinition, searchClauseContext);
                }
                return true;
            }
        }
        return false;
    }

    private void applyCycleClause(JpaCteCriteria<?> cteDefinition, HqlParser.CycleClauseContext ctx) {
        Boolean noCycleValue;
        Boolean cycleValue;
        HqlParser.CteAttributesContext attributesContext = ctx.cteAttributes();
        String cycleMarkAttributeName = this.visitIdentifier(ctx.identifier(0));
        ArrayList<JpaCteCriteriaAttribute> cycleAttributes = new ArrayList<JpaCteCriteriaAttribute>(attributesContext.getChildCount() + 1 >> 1);
        List<HqlParser.IdentifierContext> identifiers = attributesContext.identifier();
        JpaCteCriteriaType<?> type = cteDefinition.getType();
        for (int i = 0; i < identifiers.size(); ++i) {
            String attributeName = this.visitIdentifier(identifiers.get(i));
            JpaCteCriteriaAttribute attribute = type.getAttribute(attributeName);
            if (attribute == null) {
                throw new SemanticException(String.format("Cycle attribute '%s' not found in the CTE %s", attributeName, cteDefinition.getName()), this.query);
            }
            cycleAttributes.add(attribute);
        }
        if (ctx.TO() != null && ctx.DEFAULT() != null) {
            SqmLiteral cycleLiteral = (SqmLiteral)this.visitLiteral(ctx.literal(0));
            SqmLiteral noCycleLiteral = (SqmLiteral)this.visitLiteral(ctx.literal(1));
            cycleValue = cycleLiteral.getLiteralValue();
            noCycleValue = noCycleLiteral.getLiteralValue();
        } else {
            cycleValue = Boolean.TRUE;
            noCycleValue = Boolean.FALSE;
        }
        String cyclePathAttributeName = ctx.USING() != null ? this.visitIdentifier(ctx.identifier(1)) : null;
        cteDefinition.cycleUsing(cycleMarkAttributeName, cyclePathAttributeName, cycleValue, noCycleValue, cycleAttributes);
    }

    private void applySearchClause(JpaCteCriteria<?> cteDefinition, HqlParser.SearchClauseContext ctx) {
        String searchAttributeName = this.visitIdentifier(ctx.identifier());
        HqlParser.SearchSpecificationsContext searchCtx = ctx.searchSpecifications();
        ArrayList<JpaSearchOrder> searchOrders = new ArrayList<JpaSearchOrder>(searchCtx.getChildCount() + 1 >> 1);
        List<HqlParser.SearchSpecificationContext> searchSpecifications = searchCtx.searchSpecification();
        JpaCteCriteriaType<?> type = cteDefinition.getType();
        for (int i = 0; i < searchSpecifications.size(); ++i) {
            HqlParser.SearchSpecificationContext specCtx = searchSpecifications.get(i);
            String attributeName = this.visitIdentifier(specCtx.identifier());
            JpaCteCriteriaAttribute attribute = type.getAttribute(attributeName);
            if (attribute == null) {
                throw new SemanticException(String.format("Search attribute '%s' not found in the CTE %s", attributeName, cteDefinition.getName()), this.query);
            }
            SortDirection sortOrder = SortDirection.ASCENDING;
            Nulls nullPrecedence = Nulls.NONE;
            int index = 1;
            if (index < specCtx.getChildCount()) {
                Token symbol;
                if (specCtx.getChild(index) instanceof HqlParser.SortDirectionContext) {
                    HqlParser.SortDirectionContext sortCtx = specCtx.sortDirection();
                    symbol = ((TerminalNode)sortCtx.getChild(0)).getSymbol();
                    sortOrder = switch (symbol.getType()) {
                        case 53 -> SortDirection.ASCENDING;
                        case 83 -> SortDirection.DESCENDING;
                        default -> throw new UnsupportedOperationException("Unrecognized sort ordering: " + sortCtx.getText());
                    };
                    ++index;
                }
                if (index < specCtx.getChildCount()) {
                    HqlParser.NullsPrecedenceContext nullsPrecedenceContext = specCtx.nullsPrecedence();
                    symbol = ((TerminalNode)nullsPrecedenceContext.getChild(1)).getSymbol();
                    nullPrecedence = switch (symbol.getType()) {
                        case 102 -> Nulls.FIRST;
                        case 138 -> Nulls.LAST;
                        default -> throw new UnsupportedOperationException("Unrecognized null precedence: " + nullsPrecedenceContext.getText());
                    };
                }
            }
            searchOrders.add(this.nodeBuilder().search(attribute, sortOrder, nullPrecedence));
        }
        cteDefinition.search(SemanticQueryBuilder.getCteSearchClauseKind(ctx), searchAttributeName, searchOrders);
    }

    private static CteSearchClauseKind getCteSearchClauseKind(HqlParser.SearchClauseContext ctx) {
        return ctx.BREADTH() != null ? CteSearchClauseKind.BREADTH_FIRST : CteSearchClauseKind.DEPTH_FIRST;
    }

    @Override
    public SqmQueryPart<?> visitSimpleQueryGroup(HqlParser.SimpleQueryGroupContext ctx) {
        HqlParser.WithClauseContext withClauseContext = ctx.withClause();
        if (withClauseContext != null) {
            withClauseContext.accept(this);
        }
        return (SqmQueryPart)ctx.orderedQuery().accept(this);
    }

    @Override
    public SqmQueryPart<?> visitQueryOrderExpression(HqlParser.QueryOrderExpressionContext ctx) {
        SqmQuerySpec<?> sqmQuerySpec = this.currentQuerySpec();
        SqmFromClause fromClause = this.buildInferredFromClause(null);
        sqmQuerySpec.setFromClause(fromClause);
        sqmQuerySpec.setSelectClause(this.buildInferredSelectClause(fromClause));
        this.visitOrderBy(sqmQuerySpec, ctx.orderByClause());
        this.visitLimitOffset(sqmQuerySpec, ctx.limitOffset());
        return sqmQuerySpec;
    }

    @Override
    public SqmQueryPart<?> visitQuerySpecExpression(HqlParser.QuerySpecExpressionContext ctx) {
        Object queryPart = this.visitQuery(ctx.query());
        this.visitOrderBy((SqmQueryPart<?>)queryPart, ctx.orderByClause());
        this.visitLimitOffset((SqmQueryPart<?>)queryPart, ctx.limitOffset());
        return queryPart;
    }

    @Override
    public SqmQueryPart<?> visitNestedQueryExpression(HqlParser.NestedQueryExpressionContext ctx) {
        SqmQueryPart queryPart = (SqmQueryPart)ctx.queryExpression().accept(this);
        SqmCreationProcessingState firstProcessingState = this.processingStateStack.pop();
        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), firstProcessingState.getProcessingQuery(), this));
        this.visitOrderBy(queryPart, ctx.orderByClause());
        this.visitLimitOffset(queryPart, ctx.limitOffset());
        return queryPart;
    }

    @Override
    public SqmQueryGroup<?> visitSetQueryGroup(HqlParser.SetQueryGroupContext ctx) {
        SqmQueryGroup sqmQueryGroup;
        SqmQueryPart firstQueryPart;
        HqlParser.WithClauseContext withClauseContext = ctx.withClause();
        if (withClauseContext != null) {
            withClauseContext.accept(this);
        }
        if ((firstQueryPart = (SqmQueryPart)ctx.orderedQuery(0).accept(this)) instanceof SqmQueryGroup) {
            SqmQueryGroup sqmQueryGroup2 = (SqmQueryGroup)firstQueryPart;
            sqmQueryGroup = sqmQueryGroup2;
        } else {
            sqmQueryGroup = new SqmQueryGroup(firstQueryPart);
        }
        SqmQueryGroup queryGroup = sqmQueryGroup;
        this.setCurrentQueryPart(queryGroup);
        List<HqlParser.OrderedQueryContext> orderedQueryContexts = ctx.orderedQuery();
        List<HqlParser.SetOperatorContext> setOperatorContexts = ctx.setOperator();
        SqmCreationProcessingState firstProcessingState = this.processingStateStack.pop();
        for (int i = 0; i < setOperatorContexts.size(); ++i) {
            queryGroup = this.getSqmQueryGroup(this.visitSetOperator(setOperatorContexts.get(i)), orderedQueryContexts.get(i + 1), queryGroup, setOperatorContexts.size(), firstProcessingState, i);
        }
        this.processingStateStack.push(firstProcessingState);
        return queryGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> SqmQueryGroup<X> getSqmQueryGroup(SetOperator operator, HqlParser.OrderedQueryContext simpleQueryCtx, SqmQueryGroup<X> queryGroup, int size, SqmCreationProcessingState firstProcessingState, int i) {
        block9: {
            List queryParts;
            this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), firstProcessingState.getProcessingQuery(), this));
            SetOperator setOperator = queryGroup.getSetOperator();
            if (setOperator == null || setOperator == operator) {
                queryGroup.setSetOperator(operator);
                queryParts = queryGroup.queryParts();
            } else {
                queryParts = new ArrayList<SqmQueryPart<X>>(size - (i >> 1));
                queryParts.add(queryGroup);
                queryGroup = new SqmQueryGroup(this.nodeBuilder(), operator, queryParts);
                this.setCurrentQueryPart(queryGroup);
            }
            try {
                if (simpleQueryCtx instanceof HqlParser.QuerySpecExpressionContext) {
                    HqlParser.QuerySpecExpressionContext querySpecContext = (HqlParser.QuerySpecExpressionContext)simpleQueryCtx;
                    SqmQuerySpec querySpec = new SqmQuerySpec(this.nodeBuilder());
                    queryParts.add(querySpec);
                    this.visitQuerySpecExpression(querySpecContext);
                    break block9;
                }
                if (!(simpleQueryCtx instanceof HqlParser.NestedQueryExpressionContext)) break block9;
                HqlParser.NestedQueryExpressionContext nestedQueryContext = (HqlParser.NestedQueryExpressionContext)simpleQueryCtx;
                try {
                    SqmSelectStatement selectStatement = new SqmSelectStatement(this.nodeBuilder());
                    this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
                    Object queryPart = this.visitNestedQueryExpression(nestedQueryContext);
                    queryParts.add(queryPart);
                }
                finally {
                    this.processingStateStack.pop();
                }
            }
            finally {
                this.processingStateStack.pop();
            }
        }
        return queryGroup;
    }

    @Override
    public SetOperator visitSetOperator(HqlParser.SetOperatorContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        boolean all = ctx.getChildCount() == 2;
        return switch (token.getType()) {
            case 225 -> {
                if (all) {
                    yield SetOperator.UNION_ALL;
                }
                yield SetOperator.UNION;
            }
            case 122 -> {
                if (all) {
                    yield SetOperator.INTERSECT_ALL;
                }
                yield SetOperator.INTERSECT;
            }
            case 96 -> {
                if (all) {
                    yield SetOperator.EXCEPT_ALL;
                }
                yield SetOperator.EXCEPT;
            }
            default -> throw new ParsingException("Unrecognized set operator: " + token.getText());
        };
    }

    protected void visitLimitOffset(SqmQueryPart<?> sqmQueryPart, HqlParser.LimitOffsetContext ctx) {
        if (ctx != null) {
            HqlParser.LimitClauseContext limitClauseContext = ctx.limitClause();
            HqlParser.OffsetClauseContext offsetClauseContext = ctx.offsetClause();
            HqlParser.FetchClauseContext fetchClauseContext = ctx.fetchClause();
            if (limitClauseContext != null || offsetClauseContext != null || fetchClauseContext != null) {
                if (this.getCreationOptions().useStrictJpaCompliance()) {
                    throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.LIMIT_OFFSET_CLAUSE);
                }
                if (this.processingStateStack.depth() > 1 && sqmQueryPart.getOrderByClause() == null) {
                    throw new SemanticException("A 'limit', 'offset', or 'fetch' clause requires an 'order by' clause when used in a subquery", this.query);
                }
                this.setOffsetFetchLimit(sqmQueryPart, limitClauseContext, offsetClauseContext, fetchClauseContext);
            }
        }
    }

    protected void visitOrderBy(SqmQueryPart<?> sqmQueryPart, HqlParser.OrderByClauseContext ctx) {
        if (ctx != null) {
            if (this.creationOptions.useStrictJpaCompliance() && this.processingStateStack.depth() > 1) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SUBQUERY_ORDER_BY);
            }
            sqmQueryPart.setOrderByClause(this.visitOrderByClause(ctx));
        }
    }

    private void setOffsetFetchLimit(SqmQueryPart<?> sqmQueryPart, HqlParser.LimitClauseContext limitClauseContext, HqlParser.OffsetClauseContext offsetClauseContext, HqlParser.FetchClauseContext fetchClauseContext) {
        sqmQueryPart.setOffsetExpression((SqmExpression<Number>)this.visitOffsetClause(offsetClauseContext));
        if (limitClauseContext == null) {
            sqmQueryPart.setFetchExpression((SqmExpression<Number>)this.visitFetchClause(fetchClauseContext), this.visitFetchClauseType(fetchClauseContext));
        } else if (fetchClauseContext == null) {
            sqmQueryPart.setFetchExpression((SqmExpression<Number>)this.visitLimitClause(limitClauseContext));
        } else {
            throw new SemanticException("The 'limit' and 'fetch' clauses may not be used together", this.query);
        }
    }

    @Override
    public SqmQuerySpec<?> visitQuery(HqlParser.QueryContext ctx) {
        SqmQuerySpec<?> sqmQuerySpec = this.currentQuerySpec();
        HqlParser.FromClauseContext fromClauseContext = ctx.fromClause();
        HqlParser.WhereClauseContext whereClauseContext = ctx.whereClause();
        HqlParser.GroupByClauseContext groupByClauseContext = ctx.groupByClause();
        HqlParser.HavingClauseContext havingClauseContext = ctx.havingClause();
        HqlParser.SelectClauseContext selectClauseContext = ctx.selectClause();
        if (havingClauseContext != null && groupByClauseContext == null) {
            throw new SemanticException("Query has 'having' but no 'group by'", this.query);
        }
        SqmFromClause fromClause = fromClauseContext == null ? this.buildInferredFromClause(selectClauseContext) : this.visitFromClause(fromClauseContext);
        sqmQuerySpec.setFromClause(fromClause);
        SqmSelectClause selectClause = selectClauseContext == null ? this.buildInferredSelectClause(fromClause) : this.visitSelectClause(selectClauseContext);
        sqmQuerySpec.setSelectClause(selectClause);
        SqmWhereClause whereClause = new SqmWhereClause(this.nodeBuilder());
        if (whereClauseContext != null) {
            whereClause.setPredicate((SqmPredicate)whereClauseContext.accept(this));
        }
        sqmQuerySpec.setWhereClause(whereClause);
        if (groupByClauseContext != null) {
            sqmQuerySpec.setGroupByClauseExpressions((List<SqmExpression<?>>)this.visitGroupByClause(groupByClauseContext));
        }
        if (havingClauseContext != null) {
            sqmQuerySpec.setHavingClausePredicate(this.visitHavingClause(havingClauseContext));
        }
        return sqmQuerySpec;
    }

    private SqmFromClause buildInferredFromClause(HqlParser.SelectClauseContext selectClauseContext) {
        if (selectClauseContext != null || this.processingStateStack.depth() > 1) {
            return new SqmFromClause();
        }
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered implicit 'from' clause, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.IMPLICIT_FROM);
        }
        SqmFromClause fromClause = new SqmFromClause();
        EntityDomainType<R> entityDescriptor = this.getResultEntity();
        if (entityDescriptor != null) {
            SqmRoot<R> sqmRoot = new SqmRoot<R>(entityDescriptor, "_0", false, this.nodeBuilder());
            this.processingStateStack.getCurrent().getPathRegistry().register(sqmRoot);
            fromClause.addRoot(sqmRoot);
        }
        return fromClause;
    }

    private EntityDomainType<R> getResultEntity() {
        JpaMetamodel jpaMetamodel = this.creationContext.getJpaMetamodel();
        if (this.expectedResultEntity != null) {
            EntityDomainType<?> entityDescriptor = jpaMetamodel.findEntityType(this.expectedResultEntity);
            if (entityDescriptor == null) {
                throw new SemanticException("Query has no 'from' clause, and the result type '" + this.expectedResultEntity + "' is not an entity type", this.query);
            }
            return entityDescriptor;
        }
        if (this.expectedResultType != null) {
            EntityDomainType<R> entityDescriptor = jpaMetamodel.findEntityType(this.expectedResultType);
            if (entityDescriptor == null) {
                throw new SemanticException("Query has no 'from' clause, and the result type '" + this.expectedResultTypeShortName + "' is not an entity type", this.query);
            }
            return entityDescriptor;
        }
        return null;
    }

    protected SqmSelectClause buildInferredSelectClause(SqmFromClause fromClause) {
        SqmSelectClause selectClause;
        SqmRoot<?> sqmRoot2;
        SqmSelectClause selectClause2;
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered implicit 'select' clause, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.IMPLICIT_SELECT);
        }
        if (fromClause.getNumberOfRoots() == 0) {
            throw new SemanticException("query has no 'select' clause, and no root entities (every selection query must have an explicit 'select', an explicit 'from', or an explicit entity result type)", this.query);
        }
        NodeBuilder nodeBuilder = this.nodeBuilder();
        for (SqmRoot<?> sqmRoot3 : fromClause.getRoots()) {
            if (!"this".equals(sqmRoot3.getExplicitAlias())) continue;
            SqmSelectClause selectClause3 = new SqmSelectClause(false, 1, nodeBuilder);
            selectClause3.addSelection(new SqmSelection(sqmRoot3, "this", nodeBuilder));
            return selectClause3;
        }
        if (this.expectedResultType == null) {
            if (this.processingStateStack.getCurrent().getProcessingQuery() instanceof SqmSubQuery) {
                selectClause2 = new SqmSelectClause(false, nodeBuilder);
                fromClause.visitRoots(sqmRoot -> {
                    selectClause2.addSelection(new SqmSelection(sqmRoot, sqmRoot.getAlias(), nodeBuilder));
                    this.applyJoinsToInferredSelectClause((SqmFrom<?, ?>)sqmRoot, selectClause2);
                });
                return selectClause2;
            }
            if (fromClause.getNumberOfRoots() == 1) {
                sqmRoot2 = fromClause.getRoots().get(0);
                if (sqmRoot2.hasImplicitlySelectableJoin()) {
                    throw new SemanticException("Query has no 'select' clause, and joins, but no result type was given (pass an explicit result type to 'createQuery()')", this.query);
                }
                selectClause = new SqmSelectClause(false, 1, nodeBuilder);
                selectClause.addSelection(new SqmSelection(sqmRoot2, sqmRoot2.getAlias(), nodeBuilder));
                return selectClause;
            }
            throw new SemanticException("Query has no 'select' clause, and multiple root entities, but no result type was given (pass an explicit result type to 'createQuery()')", this.query);
        }
        if (this.creationContext.getJpaMetamodel().findEntityType(this.expectedResultType) != null) {
            if (fromClause.getNumberOfRoots() > 1) {
                throw new SemanticException("Query has no 'select' clause, and multiple root entities, but query result type is an entity class (specify an explicit 'select' list, or a different result type, for example, 'Object[].class')", this.query);
            }
            sqmRoot2 = fromClause.getRoots().get(0);
            if (sqmRoot2 instanceof SqmCteRoot) {
                throw new SemanticException("Query has no 'select' clause, and the 'from' clause refers to a CTE, but query result type is an entity class (specify an explicit 'select' list)", this.query);
            }
            selectClause = new SqmSelectClause(false, 1, nodeBuilder);
            selectClause.addSelection(new SqmSelection(sqmRoot2, sqmRoot2.getAlias(), nodeBuilder));
            return selectClause;
        }
        selectClause2 = new SqmSelectClause(false, nodeBuilder);
        fromClause.visitRoots(sqmRoot -> {
            selectClause2.addSelection(new SqmSelection(sqmRoot, sqmRoot.getAlias(), nodeBuilder));
            this.applyJoinsToInferredSelectClause((SqmFrom<?, ?>)sqmRoot, selectClause2);
        });
        return selectClause2;
    }

    private void applyJoinsToInferredSelectClause(SqmFrom<?, ?> sqm, SqmSelectClause selectClause) {
        sqm.visitSqmJoins(sqmJoin -> {
            if (sqmJoin.isImplicitlySelectable()) {
                selectClause.addSelection(new SqmSelection(sqmJoin, sqmJoin.getAlias(), this.nodeBuilder()));
                this.applyJoinsToInferredSelectClause((SqmFrom<?, ?>)sqmJoin, selectClause);
            }
        });
    }

    @Override
    public SqmSelectClause visitSelectClause(HqlParser.SelectClauseContext ctx) {
        SqmSelectClause selectClause = new SqmSelectClause(ctx.DISTINCT() != null, this.nodeBuilder());
        HqlParser.SelectionListContext selectionListContext = ctx.selectionList();
        for (HqlParser.SelectionContext selectionContext : selectionListContext.selection()) {
            selectClause.addSelection((SqmSelection<?>)this.visitSelection(selectionContext));
        }
        return selectClause;
    }

    @Override
    public SqmSelection<?> visitSelection(HqlParser.SelectionContext ctx) {
        SqmSelectableNode<?> selectableNode = this.visitSelectableNode(ctx);
        String resultIdentifier = SqmTreeCreationHelper.extractJpaCompliantAlias(ctx.variable(), this);
        SqmSelection selection = new SqmSelection(selectableNode, resultIdentifier, this.nodeBuilder());
        if (!(selectableNode instanceof SqmDynamicInstantiation)) {
            this.processingStateStack.getCurrent().getPathRegistry().register(selection);
        }
        return selection;
    }

    private SqmSelectableNode<?> visitSelectableNode(HqlParser.SelectionContext ctx) {
        ParseTree subCtx = ctx.selectExpression().getChild(0);
        if (subCtx instanceof HqlParser.ExpressionOrPredicateContext) {
            SqmPath sqmPath;
            SqmExpression sqmExpression = (SqmExpression)subCtx.accept(this);
            if (sqmExpression instanceof SqmPath && (sqmPath = (SqmPath)sqmExpression).getReferencedPathSource() instanceof PluralPersistentAttribute) {
                if (this.creationOptions.useStrictJpaCompliance()) {
                    SqmTreeCreationLogger.LOGGER.debugf("Raw selection of plural attribute not supported by JPA. Use 'value(%s)' or 'key(%s)' to indicate what part of the collection to select", (Object)sqmPath.getAlias(), (Object)sqmPath.getAlias());
                }
                SemanticPathPart elementPath = sqmPath.resolvePathPart(CollectionPart.Nature.ELEMENT.getName(), true, this);
                this.processingStateStack.getCurrent().getPathRegistry().register((SqmPath<?>)elementPath);
                return elementPath;
            }
            return sqmExpression;
        }
        return (SqmSelectableNode)subCtx.accept(this);
    }

    @Override
    public SqmDynamicInstantiation<?> visitInstantiation(HqlParser.InstantiationContext ctx) {
        Object dynamicInstantiation = this.visitInstantiationTarget(ctx.instantiationTarget());
        for (HqlParser.InstantiationArgumentContext arg : ctx.instantiationArguments().instantiationArgument()) {
            ((SqmDynamicInstantiation)dynamicInstantiation).addArgument((SqmDynamicInstantiationArgument<?>)this.visitInstantiationArgument(arg));
        }
        if (!((SqmDynamicInstantiation)dynamicInstantiation).checkInstantiation(this.creationContext.getTypeConfiguration())) {
            String typeName = dynamicInstantiation.getJavaType().getSimpleName();
            if (((SqmDynamicInstantiation)dynamicInstantiation).isFullyAliased()) {
                throw new SemanticException("Missing constructor or attributes for injection into type '" + typeName + "'", this.query);
            }
            throw new SemanticException("Missing constructor for type '" + typeName + "'", this.query);
        }
        return dynamicInstantiation;
    }

    @Override
    public SqmDynamicInstantiation<?> visitInstantiationTarget(HqlParser.InstantiationTargetContext ctx) {
        if (ctx.MAP() != null) {
            return SqmDynamicInstantiation.forMapInstantiation(this.mapJavaType, this.nodeBuilder());
        }
        if (ctx.LIST() != null) {
            return SqmDynamicInstantiation.forListInstantiation(this.listJavaType, this.nodeBuilder());
        }
        HqlParser.SimplePathContext simplePath = ctx.simplePath();
        if (simplePath == null) {
            throw new SyntaxException("Missing instantiation target type");
        }
        String className = this.instantiationClassName(simplePath);
        try {
            return SqmDynamicInstantiation.forClassInstantiation(this.resolveInstantiationTargetType(className), this.nodeBuilder());
        }
        catch (ClassLoadingException e) {
            throw new SemanticException("Could not resolve class '" + className + "' named for instantiation", this.query);
        }
    }

    private String instantiationClassName(HqlParser.SimplePathContext ctx) {
        String name = ctx.getText();
        return this.expectedResultTypeName != null && this.expectedResultTypeShortName.equals(name) ? this.expectedResultTypeName : name;
    }

    private JavaType<?> resolveInstantiationTargetType(String className) {
        String qualifiedName = this.creationContext.getJpaMetamodel().qualifyImportableName(className);
        Class<?> targetJavaType = this.creationContext.classForName(qualifiedName);
        return this.creationContext.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(targetJavaType);
    }

    @Override
    public SqmDynamicInstantiationArgument<?> visitInstantiationArgument(HqlParser.InstantiationArgumentContext ctx) {
        HqlParser.VariableContext variable = ctx.variable();
        String alias = variable == null ? null : this.extractAlias(variable);
        SqmSelectableNode argExpression = (SqmSelectableNode)ctx.instantiationArgumentExpression().accept(this);
        SqmDynamicInstantiationArgument argument = new SqmDynamicInstantiationArgument(argExpression, alias, this.nodeBuilder());
        if (!(argExpression instanceof SqmDynamicInstantiation)) {
            this.processingStateStack.getCurrent().getPathRegistry().register(argument);
        }
        return argument;
    }

    @Override
    public SqmPath<?> visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        String alias = ctx.getChild(2).getText();
        Object sqmFromByAlias = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias, true);
        if (sqmFromByAlias == null) {
            throw new SemanticException("Could not resolve alias '" + alias + "' in selection [" + ctx.getText() + "]", this.query);
        }
        return sqmFromByAlias;
    }

    @Override
    public List<SqmExpression<?>> visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        List<HqlParser.GroupByExpressionContext> groupByExpressionContexts = ctx.groupByExpression();
        int size = groupByExpressionContexts.size();
        ArrayList expressions = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            expressions.add((SqmExpression)groupByExpressionContexts.get(i).accept(this));
        }
        return expressions;
    }

    private SqmExpression<?> resolveOrderByOrGroupByExpression(ParseTree child, boolean definedCollate, boolean allowPositionalOrAliases) {
        JpaQueryPart<Object> queryPart;
        NodeBuilder nodeBuilder = this.nodeBuilder();
        SqmCreationProcessingState processingState = this.processingStateStack.getCurrent();
        SqmQuery<?> processingQuery = processingState.getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            SqmInsertSelectStatement insertSelectStatement = (SqmInsertSelectStatement)processingQuery;
            queryPart = insertSelectStatement.getSelectQueryPart();
        } else if (processingQuery instanceof SqmSelectQuery) {
            SqmSelectQuery selectQuery = (SqmSelectQuery)processingQuery;
            queryPart = selectQuery.getQueryPart();
        } else {
            queryPart = null;
        }
        if (child instanceof TerminalNode) {
            List<SqmSelection<?>> selections;
            if (definedCollate) {
                throw new SyntaxException("'collate' is not allowed for position based 'order by' or 'group by' items");
            }
            if (!allowPositionalOrAliases) {
                throw new SyntaxException("Position based 'order by' is not allowed in 'over' or 'within group' clauses");
            }
            int position = Integer.parseInt(child.getText());
            SqmAliasedNode<Object> nodeByPosition = queryPart instanceof SqmQueryGroup ? (position <= (selections = ((SqmQueryPart)queryPart).getFirstQuerySpec().getSelectClause().getSelections()).size() ? (SqmAliasedNode)selections.get(position - 1) : null) : processingState.getPathRegistry().findAliasedNodeByPosition(position);
            if (nodeByPosition == null) {
                throw new SemanticException("Numeric literal '" + position + "' used in 'group by' does not match a registered select item", this.query);
            }
            return new SqmAliasedNodeRef(position, nodeBuilder.resolveExpressible(this.integerDomainType), nodeBuilder);
        }
        if (child instanceof HqlParser.IdentifierContext) {
            HqlParser.IdentifierContext identifierContext = (HqlParser.IdentifierContext)child;
            String identifierText = this.visitIdentifier(identifierContext);
            if (queryPart instanceof SqmQueryGroup) {
                SqmPath found = null;
                int sqmPosition = 0;
                List<SqmSelection<?>> selections = ((SqmQueryPart)queryPart).getFirstQuerySpec().getSelectClause().getSelections();
                for (int i = 0; i < selections.size(); ++i) {
                    SqmPath path;
                    SqmSelection<?> sqmSelection = selections.get(i);
                    if (identifierText.equals(sqmSelection.getAlias())) {
                        return new SqmAliasedNodeRef(i + 1, nodeBuilder.getIntegerType(), nodeBuilder);
                    }
                    SqmSelectableNode<?> selectableNode = sqmSelection.getSelectableNode();
                    if (selectableNode instanceof SqmFrom) {
                        SqmFrom fromElement = (SqmFrom)selectableNode;
                        if (fromElement.getReferencedPathSource().findSubPathSource(identifierText) == null) continue;
                        if (sqmPosition != 0) {
                            throw new IllegalStateException("Multiple from elements expose unqualified attribute: " + identifierText);
                        }
                        found = fromElement;
                        sqmPosition = i + 1;
                        continue;
                    }
                    if (!(selectableNode instanceof SqmPath) || !identifierText.equals((path = (SqmPath)selectableNode).getReferencedPathSource().getPathName())) continue;
                    if (sqmPosition != 0) {
                        throw new IllegalStateException("Multiple from elements expose unqualified attribute: " + identifierText);
                    }
                    sqmPosition = i + 1;
                }
                if (found != null) {
                    return new SqmAliasedNodeRef(sqmPosition, found.get(identifierText).getNavigablePath(), nodeBuilder.getIntegerType(), nodeBuilder);
                }
                if (sqmPosition != 0) {
                    return new SqmAliasedNodeRef(sqmPosition, nodeBuilder.getIntegerType(), nodeBuilder);
                }
            } else {
                Integer correspondingPosition;
                Integer n = correspondingPosition = allowPositionalOrAliases ? processingState.getPathRegistry().findAliasedNodePosition(identifierText) : null;
                if (correspondingPosition != null) {
                    if (definedCollate) {
                        throw new SyntaxException("'collate' is not allowed for alias-based 'order by' or 'group by' items");
                    }
                    return new SqmAliasedNodeRef(correspondingPosition, nodeBuilder.resolveExpressible(this.integerDomainType), nodeBuilder);
                }
                Object sqmFrom = processingState.getPathRegistry().findFromByAlias(identifierText, true);
                if (sqmFrom != null) {
                    if (definedCollate) {
                        throw new SyntaxException("'collate' is not allowed for alias-based 'order by' or 'group by' items");
                    }
                    return sqmFrom;
                }
                DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
                dotIdentifierConsumer.consumeIdentifier(identifierText, true, true);
                return (SqmExpression)((Object)dotIdentifierConsumer.getConsumedPart());
            }
        }
        return (SqmExpression)child.accept(this);
    }

    @Override
    public SqmExpression<?> visitGroupByExpression(HqlParser.GroupByExpressionContext ctx) {
        return this.resolveOrderByOrGroupByExpression(ctx.getChild(0), ctx.getChildCount() > 1, true);
    }

    @Override
    public SqmPredicate visitHavingClause(HqlParser.HavingClauseContext ctx) {
        return (SqmPredicate)ctx.getChild(1).accept(this);
    }

    @Override
    public SqmOrderByClause visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        return this.visitOrderByClause(ctx, true);
    }

    private SqmOrderByClause visitOrderByClause(HqlParser.OrderByClauseContext ctx, boolean allowPositionalOrAliases) {
        List<HqlParser.SortSpecificationContext> sortSpecificationContexts = ctx.sortSpecification();
        int size = sortSpecificationContexts.size();
        SqmOrderByClause orderByClause = new SqmOrderByClause(size);
        for (int i = 0; i < size; ++i) {
            orderByClause.addSortSpecification(this.visitSortSpecification(sortSpecificationContexts.get(i), allowPositionalOrAliases));
        }
        return orderByClause;
    }

    @Override
    public SqmSortSpecification visitSortSpecification(HqlParser.SortSpecificationContext ctx) {
        return this.visitSortSpecification(ctx, true);
    }

    private SqmSortSpecification visitSortSpecification(HqlParser.SortSpecificationContext ctx, boolean allowPositionalOrAliases) {
        SqmExpression<?> sortExpression = this.visitSortExpression(ctx.sortExpression(), allowPositionalOrAliases);
        if (sortExpression == null) {
            throw new SemanticException("Could not resolve sort expression: '" + ctx.sortExpression().getText() + "'", this.query);
        }
        if (sortExpression instanceof SqmLiteral || sortExpression instanceof SqmParameter) {
            HqlLogging.QUERY_LOGGER.debugf("Questionable sorting by constant value: %s", (Object)sortExpression);
        }
        return new SqmSortSpecification(sortExpression, SemanticQueryBuilder.sortOrder(ctx), SemanticQueryBuilder.nullPrecedence(ctx));
    }

    private static SortDirection sortOrder(HqlParser.SortSpecificationContext ctx) {
        return ctx.sortDirection() == null || ctx.sortDirection().DESC() == null ? SortDirection.ASCENDING : SortDirection.DESCENDING;
    }

    private static Nulls nullPrecedence(HqlParser.SortSpecificationContext ctx) {
        if (ctx.nullsPrecedence() == null) {
            return Nulls.NONE;
        }
        if (ctx.nullsPrecedence().FIRST() != null) {
            return Nulls.FIRST;
        }
        if (ctx.nullsPrecedence().LAST() != null) {
            return Nulls.LAST;
        }
        throw new ParsingException("Unrecognized null precedence");
    }

    @Override
    public SqmExpression<?> visitSortExpression(HqlParser.SortExpressionContext ctx) {
        return this.visitSortExpression(ctx, true);
    }

    public SqmExpression<?> visitSortExpression(HqlParser.SortExpressionContext ctx, boolean allowPositionalOrAliases) {
        return this.resolveOrderByOrGroupByExpression(ctx.getChild(0), ctx.getChildCount() > 1, allowPositionalOrAliases);
    }

    private SqmQuerySpec<?> currentQuerySpec() {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            SqmInsertSelectStatement insertSelectStatement = (SqmInsertSelectStatement)processingQuery;
            return insertSelectStatement.getSelectQueryPart().getLastQuerySpec();
        }
        if (processingQuery instanceof SqmSelectQuery) {
            SqmSelectQuery selectQuery = (SqmSelectQuery)processingQuery;
            return ((SqmQueryPart)selectQuery.getQueryPart()).getLastQuerySpec();
        }
        throw new AssertionFailure("Unrecognized SqmQuery type");
    }

    private <X> void setCurrentQueryPart(SqmQueryPart<X> queryPart) {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            SqmInsertSelectStatement insertSelectStatement = (SqmInsertSelectStatement)processingQuery;
            insertSelectStatement.setSelectQueryPart(queryPart);
        } else if (processingQuery instanceof AbstractSqmSelectQuery) {
            AbstractSqmSelectQuery selectQuery = (AbstractSqmSelectQuery)processingQuery;
            selectQuery.setQueryPart(queryPart);
        } else {
            throw new AssertionFailure("Unrecognized SqmQuery type");
        }
    }

    @Override
    public SqmExpression<?> visitLimitClause(HqlParser.LimitClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.parameterOrIntegerLiteral().accept(this);
    }

    @Override
    public SqmExpression<?> visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.parameterOrIntegerLiteral().accept(this);
    }

    @Override
    public SqmExpression<?> visitFetchClause(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        HqlParser.FetchCountOrPercentContext fetchCountOrPercent = ctx.fetchCountOrPercent();
        if (fetchCountOrPercent.PERCENT() == null) {
            return (SqmExpression)fetchCountOrPercent.parameterOrIntegerLiteral().accept(this);
        }
        return (SqmExpression)fetchCountOrPercent.parameterOrNumberLiteral().accept(this);
    }

    private FetchClauseType visitFetchClauseType(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return FetchClauseType.ROWS_ONLY;
        }
        if (ctx.fetchCountOrPercent().PERCENT() == null) {
            return ctx.TIES() == null ? FetchClauseType.ROWS_ONLY : FetchClauseType.ROWS_WITH_TIES;
        }
        return ctx.TIES() == null ? FetchClauseType.PERCENT_ONLY : FetchClauseType.PERCENT_WITH_TIES;
    }

    @Override
    public Object visitSyntacticPathExpression(HqlParser.SyntacticPathExpressionContext ctx) {
        Object object;
        SemanticPathPart part = this.visitSyntacticDomainPath(ctx.syntacticDomainPath());
        if (ctx.getChildCount() == 2) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(part, this){

                @Override
                protected void reset() {
                }
            });
            try {
                part = (SemanticPathPart)ctx.pathContinuation().simplePath().accept(this);
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        if (part instanceof DomainPathPart) {
            DomainPathPart domainPathPart = (DomainPathPart)part;
            object = domainPathPart.getSqmExpression();
        } else {
            object = part;
        }
        return object;
    }

    @Override
    public Object visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx) {
        Object object;
        SemanticPathPart part = this.visitGeneralPathFragment(ctx.generalPathFragment());
        if (part instanceof DomainPathPart) {
            DomainPathPart domainPathPart = (DomainPathPart)part;
            object = domainPathPart.getSqmExpression();
        } else {
            object = part;
        }
        return object;
    }

    @Override
    public SqmExpression<?> visitFunctionExpression(HqlParser.FunctionExpressionContext ctx) {
        return (SqmExpression)ctx.function().accept(this);
    }

    @Override
    public SqmExpression<?> visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        return (SqmExpression)ctx.parameter().accept(this);
    }

    @Override
    public SqmExpression<?> visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.FLOAT_LITERAL() != null) {
            return this.floatLiteral(ctx.FLOAT_LITERAL().getText());
        }
        if (ctx.DOUBLE_LITERAL() != null) {
            return this.doubleLiteral(ctx.DOUBLE_LITERAL().getText());
        }
        if (ctx.parameter() != null) {
            return (SqmExpression)ctx.parameter().accept(this);
        }
        ParseTree parseTree = ctx.getChild(0);
        if (parseTree instanceof TerminalNode) {
            TerminalNode firstChild = (TerminalNode)parseTree;
            return switch (firstChild.getSymbol().getType()) {
                case 3 -> this.integerLiteral(ctx.getChild(0).getText());
                case 5 -> this.floatLiteral(ctx.getChild(0).getText());
                case 6 -> this.doubleLiteral(ctx.getChild(0).getText());
                default -> throw new UnsupportedOperationException("Unsupported literal: " + ctx.getChild(0).getText());
            };
        }
        return (SqmExpression)ctx.getChild(0).accept(this);
    }

    public String getEntityName(HqlParser.EntityNameContext parserEntityName) {
        StringBuilder sb = new StringBuilder();
        int end = parserEntityName.getChildCount();
        sb.append(this.visitIdentifier((HqlParser.IdentifierContext)parserEntityName.getChild(0)));
        for (int i = 2; i < end; i += 2) {
            sb.append('.');
            sb.append(this.visitIdentifier((HqlParser.IdentifierContext)parserEntityName.getChild(i)));
        }
        return sb.toString();
    }

    @Override
    public String visitIdentifier(HqlParser.IdentifierContext ctx) {
        ParseTree child = ctx.getChild(0);
        return child instanceof TerminalNode ? child.getText() : this.visitNakedIdentifier((HqlParser.NakedIdentifierContext)child);
    }

    @Override
    public String visitNakedIdentifier(HqlParser.NakedIdentifierContext ctx) {
        TerminalNode node = (TerminalNode)ctx.getChild(0);
        String text = node.getText();
        return node.getSymbol().getType() == 253 ? QuotingHelper.unquoteIdentifier(text) : text;
    }

    @Override
    public EntityDomainType<?> visitEntityName(HqlParser.EntityNameContext parserEntityName) {
        String entityName = this.getEntityName(parserEntityName);
        EntityDomainType entityReference = this.getJpaMetamodel().getHqlEntityReference(entityName);
        if (entityReference == null) {
            throw new UnknownEntityException("Could not resolve target entity '" + entityName + "'", entityName);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(entityName, entityReference);
        if (entityReference instanceof SqmPolymorphicRootDescriptor && this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered the use of a non entity name [" + entityName + "], but strict JPQL compliance was requested which doesn't allow this", StrictJpaComplianceViolation.Type.NON_ENTITY_NAME);
        }
        return entityReference;
    }

    @Override
    public SqmFromClause visitFromClause(HqlParser.FromClauseContext parserFromClause) {
        List<HqlParser.EntityWithJoinsContext> roots = parserFromClause.entityWithJoins();
        SqmFromClause fromClause = new SqmFromClause(roots.size());
        this.currentQuerySpec().setFromClause(fromClause);
        if (this.creationOptions.useStrictJpaCompliance() && roots.size() > 1) {
            Object sqmRoot = this.visitEntityWithJoins(roots.get(0));
            fromClause.addRoot((SqmRoot<?>)sqmRoot);
            for (int i = 1; i < roots.size(); ++i) {
                HqlParser.EntityWithJoinsContext secondaryRoot = roots.get(i);
                SqmTreeCreationHelper.handleRootAsCrossJoin(secondaryRoot, sqmRoot, this);
            }
        } else {
            for (HqlParser.EntityWithJoinsContext root : roots) {
                Object sqmRoot = this.visitEntityWithJoins(root);
                if (sqmRoot instanceof SqmCorrelation) continue;
                fromClause.addRoot((SqmRoot<?>)sqmRoot);
            }
        }
        return fromClause;
    }

    @Override
    public SqmRoot<?> visitEntityWithJoins(HqlParser.EntityWithJoinsContext parserSpace) {
        SqmRoot sqmRoot = (SqmRoot)parserSpace.fromRoot().accept(this);
        int size = parserSpace.getChildCount();
        for (int i = 1; i < size; ++i) {
            ParseTree parseTree = parserSpace.getChild(i);
            if (parseTree instanceof HqlParser.CrossJoinContext) {
                HqlParser.CrossJoinContext crossJoinContext = (HqlParser.CrossJoinContext)parseTree;
                this.consumeCrossJoin(crossJoinContext, sqmRoot);
                continue;
            }
            if (parseTree instanceof HqlParser.JoinContext) {
                HqlParser.JoinContext joinContext = (HqlParser.JoinContext)parseTree;
                this.consumeJoin(joinContext, sqmRoot);
                continue;
            }
            if (!(parseTree instanceof HqlParser.JpaCollectionJoinContext)) continue;
            HqlParser.JpaCollectionJoinContext jpaCollectionJoinContext = (HqlParser.JpaCollectionJoinContext)parseTree;
            this.consumeJpaCollectionJoin(jpaCollectionJoinContext, sqmRoot);
        }
        return sqmRoot;
    }

    @Override
    public SqmRoot<?> visitRootEntity(HqlParser.RootEntityContext ctx) {
        HqlParser.EntityNameContext entityNameContext = ctx.entityName();
        String name = this.getEntityName(entityNameContext);
        EntityDomainType entityDescriptor = this.creationContext.getJpaMetamodel().getHqlEntityReference(name);
        String alias = this.extractAlias(ctx.variable());
        SqmCreationProcessingState processingState = this.processingStateStack.getCurrent();
        SqmPathRegistry pathRegistry = processingState.getPathRegistry();
        if (entityDescriptor == null) {
            return this.resolveRootEntity(entityNameContext, name, alias, processingState, pathRegistry);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(name, entityDescriptor);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered unmapped polymorphic reference [" + entityDescriptor.getHibernateEntityName() + "], but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.UNMAPPED_POLYMORPHISM);
            }
            if (this.processingStateStack.depth() > 1) {
                throw new SemanticException("Implicitly-polymorphic domain path in subquery '" + entityDescriptor.getName() + "'", this.query);
            }
        }
        SqmRoot sqmRoot = new SqmRoot(entityDescriptor, alias, true, this.nodeBuilder());
        pathRegistry.register(sqmRoot);
        return sqmRoot;
    }

    private SqmRoot<?> resolveRootEntity(HqlParser.EntityNameContext entityNameContext, String name, String alias, SqmCreationProcessingState processingState, SqmPathRegistry pathRegistry) {
        List entityNameParseTreeChildren = entityNameContext.children;
        int size = entityNameParseTreeChildren.size();
        if (this.processingStateStack.depth() > 1 && size > 2) {
            String parentAlias = ((ParseTree)entityNameParseTreeChildren.get(0)).getText();
            AbstractSqmFrom correlation = (AbstractSqmFrom)processingState.getPathRegistry().findFromByAlias(parentAlias, true);
            if (correlation instanceof SqmCorrelation) {
                SqmCorrelation sqmCorrelation = (SqmCorrelation)((Object)correlation);
                QualifiedJoinPathConsumer dotIdentifierConsumer = new QualifiedJoinPathConsumer(correlation, SqmJoinType.INNER, false, alias, (SqmCreationState)this);
                int lastIdx = size - 1;
                for (int i = 2; i != lastIdx; i += 2) {
                    dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(i)).getText(), false, false);
                }
                dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(lastIdx)).getText(), false, true);
                return sqmCorrelation.getCorrelatedRoot();
            }
            throw new SemanticException("Could not resolve entity or correlation path '" + name + "'", this.query);
        }
        SqmCteStatement<?> cteStatement = this.findCteStatement(name);
        if (cteStatement != null) {
            SqmCteRoot root = new SqmCteRoot(cteStatement, alias);
            pathRegistry.register(root);
            return root;
        }
        throw new UnknownEntityException("Could not resolve root entity '" + name + "'", name);
    }

    @Override
    public SqmCteStatement<?> findCteStatement(String name) {
        if (this.currentPotentialRecursiveCte != null && name.equals(this.currentPotentialRecursiveCte.getName())) {
            return (SqmCteStatement)this.currentPotentialRecursiveCte;
        }
        return this.processingStateStack.findCurrentFirstWithParameter(name, SemanticQueryBuilder::matchCteStatement);
    }

    private static SqmCteStatement<?> matchCteStatement(SqmCreationProcessingState state, String n) {
        SqmCteStatement<?> sqmCteStatement;
        SqmQuery<?> sqmQuery = state.getProcessingQuery();
        if (sqmQuery instanceof SqmCteContainer) {
            SqmCteContainer container = (SqmCteContainer)((Object)sqmQuery);
            sqmCteStatement = container.getCteStatement(n);
        } else {
            sqmCteStatement = null;
        }
        return sqmCteStatement;
    }

    @Override
    public SqmRoot<?> visitRootSubquery(HqlParser.RootSubqueryContext ctx) {
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("The JPA specification does not support subqueries in the from clause. Please disable the JPA query compliance if you want to use this feature.", StrictJpaComplianceViolation.Type.FROM_SUBQUERY);
        }
        SqmSubQuery subQuery = (SqmSubQuery)ctx.subquery().accept(this);
        String alias = this.extractAlias(ctx.variable());
        SqmDerivedRoot sqmRoot = new SqmDerivedRoot(subQuery, alias);
        this.processingStateStack.getCurrent().getPathRegistry().register(sqmRoot);
        return sqmRoot;
    }

    @Override
    public SqmRoot<?> visitRootFunction(HqlParser.RootFunctionContext ctx) {
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("The JPA specification does not support functions in the from clause. Please disable the JPA query compliance if you want to use this feature.", StrictJpaComplianceViolation.Type.FROM_FUNCTION);
        }
        SqmSetReturningFunction function = (SqmSetReturningFunction)ctx.setReturningFunction().accept(this);
        String alias = this.extractAlias(ctx.variable());
        SqmFunctionRoot sqmRoot = new SqmFunctionRoot(function, alias);
        this.processingStateStack.getCurrent().getPathRegistry().register(sqmRoot);
        return sqmRoot;
    }

    @Override
    public String visitVariable(HqlParser.VariableContext ctx) {
        return this.extractAlias(ctx);
    }

    protected String extractAlias(HqlParser.VariableContext ctx) {
        return SqmTreeCreationHelper.extractAlias(ctx, this);
    }

    @Override
    public final SqmCrossJoin<?> visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        throw new UnsupportedOperationException("Unexpected call to #visitCrossJoin, see #consumeCrossJoin");
    }

    protected <T> void consumeCrossJoin(HqlParser.CrossJoinContext parserJoin, SqmRoot<T> sqmRoot) {
        String name = this.getEntityName(parserJoin.entityName());
        EntityDomainType entityDescriptor = this.getJpaMetamodel().resolveHqlEntityReference(name);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Unmapped polymorphic reference cannot be used as a target of 'cross join'", this.query);
        }
        SqmCrossJoin join = new SqmCrossJoin((SqmEntityDomainType)entityDescriptor, this.extractAlias(parserJoin.variable()), sqmRoot);
        this.processingStateStack.getCurrent().getPathRegistry().register(join);
        sqmRoot.addSqmJoin((SqmJoin<T, ?>)join);
    }

    private JpaMetamodel getJpaMetamodel() {
        return this.getCreationContext().getJpaMetamodel();
    }

    @Override
    public final SqmJoin<?, ?> visitJoin(HqlParser.JoinContext parserJoin) {
        throw new UnsupportedOperationException("Unexpected call to #visitJoin, see #consumeJoin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <X> void consumeJoin(HqlParser.JoinContext parserJoin, SqmRoot<X> sqmRoot) {
        block12: {
            boolean fetch;
            SqmJoinType joinType = SemanticQueryBuilder.getSqmJoinType(parserJoin.joinType());
            HqlParser.JoinTargetContext qualifiedJoinTargetContext = parserJoin.joinTarget();
            String alias = this.extractAlias(SemanticQueryBuilder.getVariable(qualifiedJoinTargetContext));
            boolean bl = fetch = parserJoin.FETCH() != null;
            if (fetch && this.processingStateStack.depth() > 1) {
                throw new SemanticException("The 'from' clause of a subquery has a 'fetch'", this.query);
            }
            this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, joinType, fetch, alias, (SqmCreationState)this));
            try {
                SqmJoin<X, ?> join = this.getJoin(sqmRoot, joinType, qualifiedJoinTargetContext, alias, fetch);
                HqlParser.JoinRestrictionContext joinRestrictionContext = parserJoin.joinRestriction();
                if (join instanceof SqmEntityJoin || join instanceof SqmDerivedJoin || join instanceof SqmCteJoin) {
                    sqmRoot.addSqmJoin(join);
                } else if (join instanceof SqmAttributeJoin) {
                    SqmAttributeJoin attributeJoin = (SqmAttributeJoin)join;
                    if (this.getCreationOptions().useStrictJpaCompliance() && join.getExplicitAlias() != null && attributeJoin.isFetched()) {
                        throw new StrictJpaComplianceViolation("Encountered aliased fetch join, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.ALIASED_FETCH_JOIN);
                    }
                    if (joinRestrictionContext != null && attributeJoin.isFetched()) {
                        throw new SemanticException("Fetch join has a 'with' clause (use a filter instead)", this.query);
                    }
                }
                if (joinRestrictionContext == null) break block12;
                this.dotIdentifierConsumerStack.push(new QualifiedJoinPredicatePathConsumer(join, (SqmCreationState)this));
                try {
                    join.setJoinPredicate((SqmPredicate)joinRestrictionContext.getChild(1).accept(this));
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
    }

    private static HqlParser.VariableContext getVariable(HqlParser.JoinTargetContext joinTargetContext) {
        if (joinTargetContext instanceof HqlParser.JoinPathContext) {
            HqlParser.JoinPathContext joinPathContext = (HqlParser.JoinPathContext)joinTargetContext;
            return joinPathContext.variable();
        }
        if (joinTargetContext instanceof HqlParser.JoinSubqueryContext) {
            HqlParser.JoinSubqueryContext joinSubqueryContext = (HqlParser.JoinSubqueryContext)joinTargetContext;
            return joinSubqueryContext.variable();
        }
        if (joinTargetContext instanceof HqlParser.JoinFunctionContext) {
            HqlParser.JoinFunctionContext joinFunctionContext = (HqlParser.JoinFunctionContext)joinTargetContext;
            return joinFunctionContext.variable();
        }
        throw new ParsingException("unexpected join type");
    }

    private <X> SqmJoin<X, ?> getJoin(SqmRoot<X> sqmRoot, SqmJoinType joinType, HqlParser.JoinTargetContext joinTargetContext, String alias, boolean fetch) {
        if (joinTargetContext instanceof HqlParser.JoinPathContext) {
            HqlParser.JoinPathContext joinPathContext = (HqlParser.JoinPathContext)joinTargetContext;
            return (SqmJoin)joinPathContext.path().accept(this);
        }
        if (joinTargetContext instanceof HqlParser.JoinSubqueryContext) {
            HqlParser.JoinSubqueryContext joinSubqueryContext = (HqlParser.JoinSubqueryContext)joinTargetContext;
            if (fetch) {
                throw new SemanticException("The 'from' clause of a subquery has a 'fetch' join", this.query);
            }
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("The JPA specification does not support subqueries in the from clause. Please disable the JPA query compliance if you want to use this feature.", StrictJpaComplianceViolation.Type.FROM_SUBQUERY);
            }
            boolean lateral = joinSubqueryContext.LATERAL() != null;
            DotIdentifierConsumer identifierConsumer = this.dotIdentifierConsumerStack.pop();
            SqmSubQuery subQuery = (SqmSubQuery)joinSubqueryContext.subquery().accept(this);
            this.dotIdentifierConsumerStack.push(identifierConsumer);
            SqmDerivedJoin<X> join = new SqmDerivedJoin<X>(subQuery, alias, joinType, lateral, sqmRoot);
            this.processingStateStack.getCurrent().getPathRegistry().register(join);
            return join;
        }
        if (joinTargetContext instanceof HqlParser.JoinFunctionContext) {
            HqlParser.JoinFunctionContext joinFunctionContext = (HqlParser.JoinFunctionContext)joinTargetContext;
            if (fetch) {
                throw new SemanticException("The 'from' clause of a set returning function has a 'fetch' join", this.query);
            }
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("The JPA specification does not support functions in the from clause. Please disable the JPA query compliance if you want to use this feature.", StrictJpaComplianceViolation.Type.FROM_FUNCTION);
            }
            boolean lateral = joinFunctionContext.LATERAL() != null;
            DotIdentifierConsumer identifierConsumer = this.dotIdentifierConsumerStack.pop();
            SqmSetReturningFunction function = (SqmSetReturningFunction)joinFunctionContext.setReturningFunction().accept(this);
            this.dotIdentifierConsumerStack.push(identifierConsumer);
            SqmFunctionJoin join = new SqmFunctionJoin(function, alias, joinType, lateral, sqmRoot);
            this.processingStateStack.getCurrent().getPathRegistry().register(join);
            sqmRoot.addSqmJoin(join);
            return join;
        }
        throw new ParsingException("unexpected join type");
    }

    private static SqmJoinType getSqmJoinType(HqlParser.JoinTypeContext joinTypeContext) {
        if (joinTypeContext == null || joinTypeContext.getChildCount() == 0) {
            return SqmJoinType.INNER;
        }
        TerminalNode firstChild = (TerminalNode)joinTypeContext.getChild(0);
        return switch (firstChild.getSymbol().getType()) {
            case 107 -> SqmJoinType.FULL;
            case 198 -> SqmJoinType.RIGHT;
            case 141, 182 -> SqmJoinType.LEFT;
            default -> SqmJoinType.INNER;
        };
    }

    @Override
    public SqmJoin<?, ?> visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx, SqmRoot<?> sqmRoot) {
        String alias = this.extractAlias(ctx.variable());
        this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, SqmJoinType.INNER, false, alias, (SqmCreationState)this));
        try {
            this.consumePluralAttributeReference(ctx.path());
        }
        finally {
            this.dotIdentifierConsumerStack.pop();
        }
    }

    @Override
    public SqmPredicate visitWhereClause(HqlParser.WhereClauseContext ctx) {
        if (ctx == null || ctx.predicate() == null) {
            return null;
        }
        return (SqmPredicate)ctx.predicate().accept(this);
    }

    @Override
    public SqmGroupedPredicate visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        return new SqmGroupedPredicate((SqmPredicate)ctx.predicate().accept(this), this.nodeBuilder());
    }

    @Override
    public SqmPredicate visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        return this.junction(Predicate.BooleanOperator.AND, (SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this));
    }

    @Override
    public SqmPredicate visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        return this.junction(Predicate.BooleanOperator.OR, (SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this));
    }

    private SqmPredicate junction(Predicate.BooleanOperator operator, SqmPredicate lhs, SqmPredicate rhs) {
        SqmJunctionPredicate junction;
        if (lhs instanceof SqmJunctionPredicate && (junction = (SqmJunctionPredicate)lhs).getOperator() == operator) {
            junction.getPredicates().add(rhs);
            return junction;
        }
        if (rhs instanceof SqmJunctionPredicate && (junction = (SqmJunctionPredicate)rhs).getOperator() == operator) {
            junction.getPredicates().add(0, lhs);
            return junction;
        }
        return new SqmJunctionPredicate(operator, lhs, rhs, this.nodeBuilder());
    }

    @Override
    public SqmPredicate visitNegatedPredicate(HqlParser.NegatedPredicateContext ctx) {
        SqmPredicate predicate = (SqmPredicate)ctx.predicate().accept(this);
        if (predicate instanceof SqmNegatablePredicate) {
            SqmNegatablePredicate negatablePredicate = (SqmNegatablePredicate)predicate;
            negatablePredicate.negate();
            return predicate;
        }
        return new SqmNegatedPredicate(predicate, this.nodeBuilder());
    }

    @Override
    public SqmBetweenPredicate visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        return new SqmBetweenPredicate((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), (SqmExpression)ctx.expression(2).accept(this), ctx.NOT() != null, this.nodeBuilder());
    }

    @Override
    public SqmNullnessPredicate visitIsNullPredicate(HqlParser.IsNullPredicateContext ctx) {
        return new SqmNullnessPredicate((SqmExpression)ctx.expression().accept(this), ctx.NOT() != null, this.nodeBuilder());
    }

    @Override
    public SqmEmptinessPredicate visitIsEmptyPredicate(HqlParser.IsEmptyPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        if (expression instanceof SqmPluralValuedSimplePath) {
            SqmPluralValuedSimplePath pluralValuedSimplePath = (SqmPluralValuedSimplePath)expression;
            return new SqmEmptinessPredicate(pluralValuedSimplePath, ctx.NOT() != null, this.nodeBuilder());
        }
        throw new SemanticException("Operand of 'is empty' operator must be a plural path", this.query);
    }

    @Override
    public Object visitIsTruePredicate(HqlParser.IsTruePredicateContext ctx) {
        return new SqmTruthnessPredicate((SqmExpression)ctx.expression().accept(this), true, ctx.NOT() != null, this.nodeBuilder());
    }

    @Override
    public Object visitIsFalsePredicate(HqlParser.IsFalsePredicateContext ctx) {
        return new SqmTruthnessPredicate((SqmExpression)ctx.expression().accept(this), false, ctx.NOT() != null, this.nodeBuilder());
    }

    @Override
    public Object visitComparisonOperator(HqlParser.ComparisonOperatorContext ctx) {
        TerminalNode firstToken = (TerminalNode)ctx.getChild(0);
        return switch (firstToken.getSymbol().getType()) {
            case 16 -> ComparisonOperator.EQUAL;
            case 17 -> ComparisonOperator.NOT_EQUAL;
            case 20 -> ComparisonOperator.LESS_THAN;
            case 21 -> ComparisonOperator.LESS_THAN_OR_EQUAL;
            case 18 -> ComparisonOperator.GREATER_THAN;
            case 19 -> ComparisonOperator.GREATER_THAN_OR_EQUAL;
            default -> throw new ParsingException("Unrecognized comparison operator");
        };
    }

    @Override
    public SqmPredicate visitComparisonPredicate(HqlParser.ComparisonPredicateContext ctx) {
        ComparisonOperator comparisonOperator = (ComparisonOperator)((Object)ctx.comparisonOperator().accept(this));
        HqlParser.ExpressionContext leftExpressionContext = ctx.expression(0);
        HqlParser.ExpressionContext rightExpressionContext = ctx.expression(1);
        return this.createComparisonPredicate(comparisonOperator, leftExpressionContext, rightExpressionContext);
    }

    @Override
    public SqmPredicate visitIsDistinctFromPredicate(HqlParser.IsDistinctFromPredicateContext ctx) {
        HqlParser.ExpressionContext leftExpressionContext = ctx.expression(0);
        HqlParser.ExpressionContext rightExpressionContext = ctx.expression(1);
        ComparisonOperator comparisonOperator = ctx.NOT() == null ? ComparisonOperator.DISTINCT_FROM : ComparisonOperator.NOT_DISTINCT_FROM;
        return this.createComparisonPredicate(comparisonOperator, leftExpressionContext, rightExpressionContext);
    }

    /*
     * Enabled aggressive block sorting
     */
    private SqmComparisonPredicate createComparisonPredicate(ComparisonOperator comparisonOperator, HqlParser.ExpressionContext leftExpressionContext, HqlParser.ExpressionContext rightExpressionContext) {
        SqmExpression left;
        SqmExpression right;
        Set<String> possibleEnumTypes = this.getPossibleEnumTypes(leftExpressionContext);
        if (possibleEnumTypes != null) {
            right = (SqmExpression)rightExpressionContext.accept(this);
            left = this.resolveEnumShorthandLiteral(leftExpressionContext, this.getPossibleEnumValue(leftExpressionContext), right.getJavaTypeName(), possibleEnumTypes);
            return new SqmComparisonPredicate(left, comparisonOperator, right, this.nodeBuilder());
        }
        possibleEnumTypes = this.getPossibleEnumTypes(rightExpressionContext);
        if (possibleEnumTypes != null) {
            left = (SqmExpression)leftExpressionContext.accept(this);
            right = this.resolveEnumShorthandLiteral(rightExpressionContext, this.getPossibleEnumValue(rightExpressionContext), left.getJavaTypeName(), possibleEnumTypes);
            return new SqmComparisonPredicate(left, comparisonOperator, right, this.nodeBuilder());
        }
        SqmExpression l = (SqmExpression)leftExpressionContext.accept(this);
        SqmExpression r = (SqmExpression)rightExpressionContext.accept(this);
        if (l instanceof AnyDiscriminatorSqmPath) {
            AnyDiscriminatorSqmPath anyDiscriminatorPath = (AnyDiscriminatorSqmPath)l;
            if (r instanceof SqmLiteralEntityType) {
                left = l;
                right = this.createDiscriminatorValue(anyDiscriminatorPath, rightExpressionContext);
                return new SqmComparisonPredicate(left, comparisonOperator, right, this.nodeBuilder());
            }
        }
        if (r instanceof AnyDiscriminatorSqmPath) {
            AnyDiscriminatorSqmPath anyDiscriminatorPath = (AnyDiscriminatorSqmPath)r;
            if (l instanceof SqmLiteralEntityType) {
                left = this.createDiscriminatorValue(anyDiscriminatorPath, leftExpressionContext);
                right = r;
                return new SqmComparisonPredicate(left, comparisonOperator, right, this.nodeBuilder());
            }
        }
        left = l;
        right = r;
        return new SqmComparisonPredicate(left, comparisonOperator, right, this.nodeBuilder());
    }

    private <T> SqmExpression<T> createDiscriminatorValue(AnyDiscriminatorSqmPath<T> anyDiscriminatorTypeSqmPath, HqlParser.ExpressionContext valueExpressionContext) {
        SqmBindableType expressible = anyDiscriminatorTypeSqmPath.getExpressible();
        return new SqmAnyDiscriminatorValue(((AbstractSqmPathSource)((Object)expressible)).getPathName(), this.getJpaMetamodel().resolveHqlEntityReference(valueExpressionContext.getText()), ((AnyDiscriminatorSqmPathSource)expressible).getPathType(), this.nodeBuilder());
    }

    private SqmExpression<?> resolveEnumShorthandLiteral(HqlParser.ExpressionContext expressionContext, String enumValue, String enumType, Set<String> enumTypes) {
        if (enumValue != null && enumType != null && enumTypes.contains(enumType)) {
            DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(enumType, true, false);
            dotIdentifierConsumer.consumeIdentifier(enumValue, false, true);
            return (SqmExpression)((Object)this.dotIdentifierConsumerStack.getCurrent().getConsumedPart());
        }
        return (SqmExpression)expressionContext.accept(this);
    }

    private Set<String> getPossibleEnumTypes(HqlParser.ExpressionContext expressionContext) {
        if (expressionContext instanceof HqlParser.BarePrimaryExpressionContext && expressionContext.getChildCount() == 1) {
            ParseTree ctx = expressionContext.getChild(0);
            while (ctx instanceof HqlParser.PrimaryExpressionContext && ctx.getChildCount() == 1) {
                ctx = ctx.getChild(0);
            }
            if (ctx instanceof HqlParser.GeneralPathFragmentContext && ctx.getChildCount() == 1 && (ctx = ctx.getChild(0)) instanceof HqlParser.SimplePathContext) {
                return this.creationContext.getJpaMetamodel().getEnumTypesForValue(ctx.getText());
            }
        }
        return null;
    }

    private String getPossibleEnumValue(HqlParser.ExpressionContext expressionContext) {
        if (expressionContext instanceof HqlParser.BarePrimaryExpressionContext && expressionContext.getChildCount() == 1) {
            ParseTree ctx = expressionContext.getChild(0);
            while (ctx instanceof HqlParser.PrimaryExpressionContext && ctx.getChildCount() == 1) {
                ctx = ctx.getChild(0);
            }
            if (ctx instanceof HqlParser.GeneralPathFragmentContext && ctx.getChildCount() == 1 && (ctx = ctx.getChild(0)) instanceof HqlParser.SimplePathContext) {
                HqlParser.SimplePathContext simplePathContext = (HqlParser.SimplePathContext)ctx;
                int size = simplePathContext.simplePathElement().size();
                return size == 0 ? simplePathContext.getText() : simplePathContext.simplePathElement(size - 1).identifier().getText();
            }
        }
        return null;
    }

    @Override
    public SqmPredicate visitContainsPredicate(HqlParser.ContainsPredicateContext ctx) {
        boolean negated = ctx.NOT() != null;
        SqmExpression lhs = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression(1).accept(this);
        SqmBindableType lhsExpressible = lhs.getExpressible();
        if (lhsExpressible != null && !(lhsExpressible.getSqmType() instanceof BasicPluralType)) {
            throw new SemanticException("First operand for contains predicate must be a basic plural type expression, but found: " + String.valueOf(lhsExpressible.getSqmType()), this.query);
        }
        SelfRenderingSqmFunction<Boolean> contains = this.getFunctionDescriptor("array_contains").generateSqmExpression(Arrays.asList(lhs, rhs), null, this.queryEngine());
        return new SqmBooleanExpressionPredicate(contains, negated, this.nodeBuilder());
    }

    @Override
    public SqmExpression<?> visitJsonValueFunction(HqlParser.JsonValueFunctionContext ctx) {
        this.checkJsonFunctionsEnabled(ctx);
        SqmExpression jsonDocument = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression jsonPath = (SqmExpression)ctx.expression(1).accept(this);
        HqlParser.JsonValueReturningClauseContext returningClause = ctx.jsonValueReturningClause();
        SqmCastTarget castTarget = returningClause == null ? null : (SqmCastTarget)returningClause.castTarget().accept(this);
        SqmJsonValueExpression jsonValue = (SqmJsonValueExpression)this.getFunctionDescriptor("json_value").generateSqmExpression(castTarget == null ? Arrays.asList(jsonDocument, jsonPath) : Arrays.asList(jsonDocument, jsonPath, castTarget), null, this.queryEngine());
        this.visitJsonValueOnErrorOrEmptyClause(jsonValue, ctx.jsonValueOnErrorOrEmptyClause());
        HqlParser.JsonPassingClauseContext passingClause = ctx.jsonPassingClause();
        if (passingClause != null) {
            List<HqlParser.ExpressionOrPredicateContext> expressionContexts = passingClause.expressionOrPredicate();
            List<HqlParser.IdentifierContext> identifierContexts = passingClause.identifier();
            for (int i = 0; i < expressionContexts.size(); ++i) {
                jsonValue.passing(this.visitIdentifier(identifierContexts.get(i)), (Expression)((SqmExpression)expressionContexts.get(i).accept(this)));
            }
        }
        return jsonValue;
    }

    private void visitJsonValueOnErrorOrEmptyClause(JpaJsonValueNode<?> jsonValue, List<HqlParser.JsonValueOnErrorOrEmptyClauseContext> errorOrEmptyClauseContexts) {
        for (HqlParser.JsonValueOnErrorOrEmptyClauseContext subCtx : errorOrEmptyClauseContexts) {
            TerminalNode firstToken = (TerminalNode)subCtx.getChild(0);
            TerminalNode lastToken = (TerminalNode)subCtx.getChild(subCtx.getChildCount() - 1);
            if (lastToken.getSymbol().getType() == 93) {
                switch (firstToken.getSymbol().getType()) {
                    case 251: {
                        jsonValue.nullOnError();
                        break;
                    }
                    case 93: {
                        jsonValue.errorOnError();
                        break;
                    }
                    case 80: {
                        jsonValue.defaultOnError((SqmExpression)subCtx.expression().accept(this));
                    }
                }
                continue;
            }
            switch (firstToken.getSymbol().getType()) {
                case 251: {
                    jsonValue.nullOnEmpty();
                    break;
                }
                case 93: {
                    jsonValue.errorOnEmpty();
                    break;
                }
                case 80: {
                    jsonValue.defaultOnEmpty((SqmExpression)subCtx.expression().accept(this));
                }
            }
        }
    }

    @Override
    public SqmExpression<?> visitJsonQueryFunction(HqlParser.JsonQueryFunctionContext ctx) {
        this.checkJsonFunctionsEnabled(ctx);
        SqmExpression jsonDocument = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression jsonPath = (SqmExpression)ctx.expression(1).accept(this);
        SqmJsonQueryExpression jsonQuery = (SqmJsonQueryExpression)this.getFunctionDescriptor("json_query").generateSqmExpression(Arrays.asList(jsonDocument, jsonPath), null, this.queryEngine());
        SemanticQueryBuilder.visitJsonQueryWrapperClause(jsonQuery, ctx.jsonQueryWrapperClause());
        SemanticQueryBuilder.visitJsonQueryOnErrorOrEmptyClause(jsonQuery, ctx.jsonQueryOnErrorOrEmptyClause());
        HqlParser.JsonPassingClauseContext passingClause = ctx.jsonPassingClause();
        if (passingClause != null) {
            List<HqlParser.ExpressionOrPredicateContext> expressionContexts = passingClause.expressionOrPredicate();
            List<HqlParser.IdentifierContext> identifierContexts = passingClause.identifier();
            for (int i = 0; i < expressionContexts.size(); ++i) {
                jsonQuery.passing(this.visitIdentifier(identifierContexts.get(i)), (Expression)((SqmExpression)expressionContexts.get(i).accept(this)));
            }
        }
        return jsonQuery;
    }

    private static void visitJsonQueryWrapperClause(JpaJsonQueryNode jsonQuery, HqlParser.JsonQueryWrapperClauseContext wrapperClause) {
        if (wrapperClause != null) {
            TerminalNode firstToken = (TerminalNode)wrapperClause.getChild(0);
            if (firstToken.getSymbol().getType() == 234) {
                TerminalNode secondToken = (TerminalNode)wrapperClause.getChild(1);
                if (wrapperClause.getChildCount() > 2 && secondToken.getSymbol().getType() == 64) {
                    jsonQuery.withConditionalWrapper();
                } else {
                    jsonQuery.withWrapper();
                }
            } else {
                jsonQuery.withoutWrapper();
            }
        }
    }

    private static void visitJsonQueryOnErrorOrEmptyClause(JpaJsonQueryNode jsonQuery, List<HqlParser.JsonQueryOnErrorOrEmptyClauseContext> jsonQueryOnErrorOrEmptyClauseContexts) {
        for (HqlParser.JsonQueryOnErrorOrEmptyClauseContext subCtx : jsonQueryOnErrorOrEmptyClauseContexts) {
            TerminalNode secondToken;
            TerminalNode firstToken = (TerminalNode)subCtx.getChild(0);
            TerminalNode lastToken = (TerminalNode)subCtx.getChild(subCtx.getChildCount() - 1);
            if (lastToken.getSymbol().getType() == 93) {
                switch (firstToken.getSymbol().getType()) {
                    case 251: {
                        jsonQuery.nullOnError();
                        break;
                    }
                    case 93: {
                        jsonQuery.errorOnError();
                        break;
                    }
                    case 89: {
                        secondToken = (TerminalNode)subCtx.getChild(1);
                        if (secondToken.getSymbol().getType() == 172) {
                            jsonQuery.emptyObjectOnError();
                            break;
                        }
                        jsonQuery.emptyArrayOnError();
                    }
                }
                continue;
            }
            switch (firstToken.getSymbol().getType()) {
                case 251: {
                    jsonQuery.nullOnEmpty();
                    break;
                }
                case 93: {
                    jsonQuery.errorOnEmpty();
                    break;
                }
                case 89: {
                    secondToken = (TerminalNode)subCtx.getChild(1);
                    if (secondToken.getSymbol().getType() == 172) {
                        jsonQuery.emptyObjectOnEmpty();
                        break;
                    }
                    jsonQuery.emptyArrayOnEmpty();
                }
            }
        }
    }

    @Override
    public SqmExpression<?> visitJsonExistsFunction(HqlParser.JsonExistsFunctionContext ctx) {
        HqlParser.JsonPassingClauseContext passingClause;
        this.checkJsonFunctionsEnabled(ctx);
        SqmExpression jsonDocument = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression jsonPath = (SqmExpression)ctx.expression(1).accept(this);
        SqmJsonExistsExpression jsonExists = (SqmJsonExistsExpression)this.getFunctionDescriptor("json_exists").generateSqmExpression(Arrays.asList(jsonDocument, jsonPath), null, this.queryEngine());
        HqlParser.JsonExistsOnErrorClauseContext subCtx = ctx.jsonExistsOnErrorClause();
        if (subCtx != null) {
            TerminalNode firstToken = (TerminalNode)subCtx.getChild(0);
            switch (firstToken.getSymbol().getType()) {
                case 93: {
                    jsonExists.errorOnError();
                    break;
                }
                case 249: {
                    jsonExists.trueOnError();
                    break;
                }
                case 250: {
                    jsonExists.falseOnError();
                }
            }
        }
        if ((passingClause = ctx.jsonPassingClause()) != null) {
            List<HqlParser.ExpressionOrPredicateContext> expressionContexts = passingClause.expressionOrPredicate();
            List<HqlParser.IdentifierContext> identifierContexts = passingClause.identifier();
            for (int i = 0; i < expressionContexts.size(); ++i) {
                jsonExists.passing(this.visitIdentifier(identifierContexts.get(i)), (Expression)((SqmExpression)expressionContexts.get(i).accept(this)));
            }
        }
        return jsonExists;
    }

    @Override
    public SqmExpression<?> visitJsonArrayFunction(HqlParser.JsonArrayFunctionContext ctx) {
        this.checkJsonFunctionsEnabled(ctx);
        HqlParser.JsonNullClauseContext subCtx = ctx.jsonNullClause();
        List<HqlParser.ExpressionOrPredicateContext> argumentContexts = ctx.expressionOrPredicate();
        int count = argumentContexts.size();
        ArrayList<SqmTypedNode> arguments = new ArrayList<SqmTypedNode>(count + (subCtx == null ? 0 : 1));
        for (int i = 0; i < count; ++i) {
            arguments.add((SqmTypedNode)argumentContexts.get(i).accept(this));
        }
        if (subCtx != null) {
            TerminalNode firstToken = (TerminalNode)subCtx.getChild(0);
            arguments.add(firstToken.getSymbol().getType() == 47 ? SqmJsonNullBehavior.ABSENT : SqmJsonNullBehavior.NULL);
        }
        return this.getFunctionDescriptor("json_array").generateSqmExpression(arguments, null, this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitJsonObjectFunction(HqlParser.JsonObjectFunctionContext ctx) {
        List arguments;
        this.checkJsonFunctionsEnabled(ctx);
        HqlParser.JsonObjectFunctionEntriesContext entries = ctx.jsonObjectFunctionEntries();
        if (entries == null) {
            arguments = Collections.emptyList();
        } else {
            HqlParser.JsonNullClauseContext subCtx = ctx.jsonNullClause();
            List<HqlParser.ExpressionOrPredicateContext> argumentContexts = entries.expressionOrPredicate();
            int count = argumentContexts.size();
            arguments = new ArrayList(count + (subCtx == null ? 0 : 1));
            for (int i = 0; i < count; ++i) {
                arguments.add((SqmTypedNode)argumentContexts.get(i).accept(this));
            }
            if (subCtx != null) {
                TerminalNode firstToken = (TerminalNode)subCtx.getChild(0);
                arguments.add(firstToken.getSymbol().getType() == 47 ? SqmJsonNullBehavior.ABSENT : SqmJsonNullBehavior.NULL);
            }
        }
        return this.getFunctionDescriptor("json_object").generateSqmExpression(arguments, null, this.queryEngine());
    }

    @Override
    public Object visitJsonArrayAggFunction(HqlParser.JsonArrayAggFunctionContext ctx) {
        this.checkJsonFunctionsEnabled(ctx);
        HqlParser.JsonNullClauseContext jsonNullClauseContext = ctx.jsonNullClause();
        ArrayList<SqmTypedNode> arguments = new ArrayList<SqmTypedNode>(jsonNullClauseContext == null ? 1 : 2);
        arguments.add((SqmTypedNode)ctx.expressionOrPredicate().accept(this));
        if (jsonNullClauseContext != null) {
            TerminalNode firstToken = (TerminalNode)jsonNullClauseContext.getChild(0);
            arguments.add(firstToken.getSymbol().getType() == 47 ? SqmJsonNullBehavior.ABSENT : SqmJsonNullBehavior.NULL);
        }
        return this.getFunctionDescriptor("json_arrayagg").generateOrderedSetAggregateSqmExpression(arguments, this.getFilterExpression(ctx), ctx.orderByClause() == null ? null : this.visitOrderByClause(ctx.orderByClause(), false), null, this.queryEngine());
    }

    @Override
    public Object visitJsonObjectAggFunction(HqlParser.JsonObjectAggFunctionContext ctx) {
        TerminalNode firstToken;
        this.checkJsonFunctionsEnabled(ctx);
        HqlParser.JsonNullClauseContext jsonNullClauseContext = ctx.jsonNullClause();
        HqlParser.JsonUniqueKeysClauseContext jsonUniqueKeysClauseContext = ctx.jsonUniqueKeysClause();
        ArrayList<SqmTypedNode> arguments = new ArrayList<SqmTypedNode>(4);
        for (HqlParser.ExpressionOrPredicateContext subCtx : ctx.expressionOrPredicate()) {
            arguments.add((SqmTypedNode)subCtx.accept(this));
        }
        if (jsonNullClauseContext != null) {
            firstToken = (TerminalNode)jsonNullClauseContext.getChild(0);
            arguments.add(firstToken.getSymbol().getType() == 47 ? SqmJsonNullBehavior.ABSENT : SqmJsonNullBehavior.NULL);
        }
        if (jsonUniqueKeysClauseContext != null) {
            firstToken = (TerminalNode)jsonUniqueKeysClauseContext.getChild(0);
            arguments.add(firstToken.getSymbol().getType() == 234 ? SqmJsonObjectAggUniqueKeysBehavior.WITH : SqmJsonObjectAggUniqueKeysBehavior.WITHOUT);
        }
        return this.getFunctionDescriptor("json_objectagg").generateAggregateSqmExpression(arguments, this.getFilterExpression(ctx), null, this.queryEngine());
    }

    @Override
    public Object visitJsonTableFunction(HqlParser.JsonTableFunctionContext ctx) {
        JpaJsonTableFunction jsonTable;
        this.checkJsonFunctionsEnabled(ctx);
        List<HqlParser.ExpressionContext> argumentsContexts = ctx.expression();
        SqmExpression jsonDocument = (SqmExpression)argumentsContexts.get(0).accept(this);
        if (argumentsContexts.size() == 1) {
            jsonTable = this.nodeBuilder().jsonTable((Expression)jsonDocument);
        } else {
            SqmExpression jsonPath = (SqmExpression)argumentsContexts.get(1).accept(this);
            jsonTable = this.nodeBuilder().jsonTable((Expression)jsonDocument, (Expression)jsonPath);
        }
        HqlParser.JsonPassingClauseContext passingClauseContext = ctx.jsonPassingClause();
        if (passingClauseContext != null) {
            List<HqlParser.ExpressionOrPredicateContext> expressionContexts = passingClauseContext.expressionOrPredicate();
            List<HqlParser.IdentifierContext> identifierContexts = passingClauseContext.identifier();
            for (int i = 0; i < expressionContexts.size(); ++i) {
                ((SqmJsonTableFunction)jsonTable).passing(this.visitIdentifier(identifierContexts.get(i)), (SqmExpression)expressionContexts.get(i).accept(this));
            }
        }
        this.visitColumns(jsonTable, ctx.jsonTableColumnsClause().jsonTableColumns().jsonTableColumn());
        HqlParser.JsonTableErrorClauseContext errorClauseContext = ctx.jsonTableErrorClause();
        if (errorClauseContext != null) {
            if (((TerminalNode)errorClauseContext.getChild(0)).getSymbol().getType() == 93) {
                ((SqmJsonTableFunction)jsonTable).errorOnError();
            } else {
                ((SqmJsonTableFunction)jsonTable).nullOnError();
            }
        }
        return jsonTable;
    }

    private void visitColumns(JpaJsonTableColumnsNode columnsNode, List<HqlParser.JsonTableColumnContext> columnContexts) {
        for (HqlParser.JsonTableColumnContext columnContext : columnContexts) {
            TerminalNode jsonPath;
            String attributeName;
            if (columnContext instanceof HqlParser.JsonTableQueryColumnContext) {
                HqlParser.JsonTableQueryColumnContext queryContext = (HqlParser.JsonTableQueryColumnContext)columnContext;
                attributeName = this.visitIdentifier(queryContext.identifier());
                jsonPath = queryContext.STRING_LITERAL();
                JpaJsonQueryNode queryNode = jsonPath == null ? columnsNode.queryColumn(attributeName) : columnsNode.queryColumn(attributeName, QuotingHelper.unquoteStringLiteral(jsonPath.getText()));
                SemanticQueryBuilder.visitJsonQueryOnErrorOrEmptyClause(queryNode, queryContext.jsonQueryOnErrorOrEmptyClause());
                continue;
            }
            if (columnContext instanceof HqlParser.JsonTableValueColumnContext) {
                HqlParser.JsonTableValueColumnContext valueContext = (HqlParser.JsonTableValueColumnContext)columnContext;
                attributeName = this.visitIdentifier(valueContext.identifier());
                Object sqmCastTarget = this.visitCastTarget(valueContext.castTarget());
                TerminalNode jsonPath2 = valueContext.STRING_LITERAL();
                JpaJsonValueNode valueNode = jsonPath2 == null ? columnsNode.valueColumn(attributeName, sqmCastTarget) : columnsNode.valueColumn(attributeName, sqmCastTarget, QuotingHelper.unquoteStringLiteral(jsonPath2.getText()));
                this.visitJsonValueOnErrorOrEmptyClause(valueNode, valueContext.jsonValueOnErrorOrEmptyClause());
                continue;
            }
            if (columnContext instanceof HqlParser.JsonTableOrdinalityColumnContext) {
                HqlParser.JsonTableOrdinalityColumnContext ordinalityContext = (HqlParser.JsonTableOrdinalityColumnContext)columnContext;
                columnsNode.ordinalityColumn(this.visitIdentifier(ordinalityContext.identifier()));
                continue;
            }
            if (columnContext instanceof HqlParser.JsonTableExistsColumnContext) {
                JpaJsonExistsNode existsNode;
                HqlParser.JsonTableExistsColumnContext existsContext = (HqlParser.JsonTableExistsColumnContext)columnContext;
                attributeName = this.visitIdentifier(existsContext.identifier());
                jsonPath = existsContext.STRING_LITERAL();
                JpaJsonExistsNode jpaJsonExistsNode = existsNode = jsonPath == null ? columnsNode.existsColumn(attributeName) : columnsNode.existsColumn(attributeName, QuotingHelper.unquoteStringLiteral(jsonPath.getText()));
                HqlParser.JsonExistsOnErrorClauseContext errorClauseContext = existsContext.jsonExistsOnErrorClause();
                if (errorClauseContext == null) continue;
                switch (((TerminalNode)errorClauseContext.getChild(0)).getSymbol().getType()) {
                    case 93: {
                        existsNode.errorOnError();
                        break;
                    }
                    case 249: {
                        existsNode.trueOnError();
                        break;
                    }
                    case 250: {
                        existsNode.falseOnError();
                    }
                }
                continue;
            }
            HqlParser.JsonTableNestedColumnContext nestedColumnContext = (HqlParser.JsonTableNestedColumnContext)columnContext;
            this.visitColumns(columnsNode.nested(QuotingHelper.unquoteStringLiteral(nestedColumnContext.STRING_LITERAL().getText())), nestedColumnContext.jsonTableColumnsClause().jsonTableColumns().jsonTableColumn());
        }
    }

    private void checkJsonFunctionsEnabled(ParserRuleContext ctx) {
        if (!this.creationOptions.isJsonFunctionsEnabled()) {
            throw new SemanticException("Can't use function '" + ctx.children.get(0).getText() + "', because tech preview JSON functions are not enabled. To enable, set the 'hibernate.query.hql.json_functions_enabled' setting to 'true'.", this.query);
        }
    }

    @Override
    public SqmExpression<?> visitXmlelementFunction(HqlParser.XmlelementFunctionContext ctx) {
        this.checkXmlFunctionsEnabled(ctx);
        String elementName = this.visitIdentifier(ctx.identifier());
        SqmXmlElementExpression xmlelement = this.nodeBuilder().xmlelement(elementName);
        HqlParser.XmlattributesFunctionContext attributeCtx = ctx.xmlattributesFunction();
        if (attributeCtx != null) {
            List<HqlParser.ExpressionOrPredicateContext> expressions = attributeCtx.expressionOrPredicate();
            List<HqlParser.IdentifierContext> attributeNames = attributeCtx.identifier();
            for (int i = 0; i < expressions.size(); ++i) {
                xmlelement.attribute(this.visitIdentifier(attributeNames.get(i)), (Expression)expressions.get(i).accept(this));
            }
        }
        xmlelement.content(this.visitExpressions(ctx));
        return xmlelement;
    }

    @Override
    public SqmExpression<?> visitXmlforestFunction(HqlParser.XmlforestFunctionContext ctx) {
        this.checkXmlFunctionsEnabled(ctx);
        ArrayList elementExpressions = new ArrayList(ctx.getChildCount() >> 1);
        for (int i = 2; i < ctx.getChildCount(); ++i) {
            SqmPath path;
            Bindable bindable;
            ParseTree parseTree;
            ParseTree parseTree2 = ctx.getChild(i);
            if (!(parseTree2 instanceof HqlParser.ExpressionOrPredicateContext)) continue;
            HqlParser.ExpressionOrPredicateContext exprCtx = (HqlParser.ExpressionOrPredicateContext)parseTree2;
            SqmExpression expression = (SqmExpression)exprCtx.accept(this);
            if (i + 2 < ctx.getChildCount() && (parseTree = ctx.getChild(i + 2)) instanceof HqlParser.IdentifierContext) {
                HqlParser.IdentifierContext identifierContext = (HqlParser.IdentifierContext)parseTree;
                String name = this.visitIdentifier(identifierContext);
                elementExpressions.add(new SqmNamedExpression(expression, name));
                i += 2;
                continue;
            }
            if (!(expression instanceof SqmPath) || !((bindable = (path = (SqmPath)expression).getModel()) instanceof PersistentAttribute)) {
                throw new SemanticException("Can't use expression '" + exprCtx.getText() + " without explicit name in xmlforest function, because XML element names can only be derived from path expressions.", this.query);
            }
            PersistentAttribute attribute = (PersistentAttribute)((Object)bindable);
            elementExpressions.add(new SqmNamedExpression(expression, attribute.getName()));
        }
        return this.nodeBuilder().xmlforest((List)elementExpressions);
    }

    @Override
    public SqmExpression<?> visitXmlpiFunction(HqlParser.XmlpiFunctionContext ctx) {
        this.checkXmlFunctionsEnabled(ctx);
        String name = this.visitIdentifier(ctx.identifier());
        HqlParser.ExpressionContext exprCtx = ctx.expression();
        return exprCtx == null ? this.nodeBuilder().xmlpi(name) : this.nodeBuilder().xmlpi(name, (Expression)exprCtx.accept(this));
    }

    @Override
    public SqmExpression<?> visitXmlqueryFunction(HqlParser.XmlqueryFunctionContext ctx) {
        this.checkXmlFunctionsEnabled(ctx);
        SqmExpression query = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression xmlDocument = (SqmExpression)ctx.expression(1).accept(this);
        return this.nodeBuilder().xmlquery((Expression)query, (Expression)xmlDocument);
    }

    @Override
    public SqmExpression<?> visitXmlexistsFunction(HqlParser.XmlexistsFunctionContext ctx) {
        this.checkXmlFunctionsEnabled(ctx);
        SqmExpression query = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression xmlDocument = (SqmExpression)ctx.expression(1).accept(this);
        return this.nodeBuilder().xmlexists((Expression)query, (Expression)xmlDocument);
    }

    @Override
    public SqmExpression<?> visitXmlaggFunction(HqlParser.XmlaggFunctionContext ctx) {
        this.checkXmlFunctionsEnabled(ctx);
        ArrayList<SqmTypedNode> arguments = new ArrayList<SqmTypedNode>(1);
        arguments.add((SqmTypedNode)ctx.expression().accept(this));
        return this.applyOverClause(ctx.overClause(), this.getFunctionDescriptor("xmlagg").generateOrderedSetAggregateSqmExpression(arguments, this.getFilterExpression(ctx), ctx.orderByClause() == null ? null : this.visitOrderByClause(ctx.orderByClause(), false), null, this.queryEngine()));
    }

    @Override
    public Object visitXmltableFunction(HqlParser.XmltableFunctionContext ctx) {
        this.checkXmlFunctionsEnabled(ctx);
        List<HqlParser.ExpressionContext> argumentsContexts = ctx.expression();
        SqmExpression xpath = (SqmExpression)argumentsContexts.get(0).accept(this);
        SqmExpression document = (SqmExpression)argumentsContexts.get(1).accept(this);
        JpaXmlTableFunction xmlTable = this.nodeBuilder().xmlTable((Expression)xpath, (Expression)document);
        this.visitColumns((SqmXmlTableFunction<?>)xmlTable, ctx.xmltableColumnsClause().xmltableColumn());
        return xmlTable;
    }

    private void visitColumns(SqmXmlTableFunction<?> xmlTable, List<HqlParser.XmltableColumnContext> columnContexts) {
        for (HqlParser.XmltableColumnContext columnContext : columnContexts) {
            String columnName;
            if (columnContext instanceof HqlParser.XmlTableQueryColumnContext) {
                HqlParser.XmlTableQueryColumnContext queryColumnContext = (HqlParser.XmlTableQueryColumnContext)columnContext;
                columnName = this.visitIdentifier(queryColumnContext.identifier());
                TerminalNode pathNode = queryColumnContext.STRING_LITERAL();
                String xpath = pathNode == null ? null : QuotingHelper.unquoteStringLiteral(pathNode.getText());
                JpaXmlTableColumnNode<String> node = xmlTable.queryColumn(columnName, xpath);
                HqlParser.XmltableDefaultClauseContext defaultClause = queryColumnContext.xmltableDefaultClause();
                if (defaultClause == null) continue;
                node.defaultExpression((Expression)defaultClause.expression().accept(this));
                continue;
            }
            if (columnContext instanceof HqlParser.XmlTableValueColumnContext) {
                HqlParser.XmlTableValueColumnContext valueColumnContext = (HqlParser.XmlTableValueColumnContext)columnContext;
                columnName = this.visitIdentifier(valueColumnContext.identifier());
                Object castTarget = this.visitCastTarget(valueColumnContext.castTarget());
                TerminalNode pathNode = valueColumnContext.STRING_LITERAL();
                String xpath = pathNode == null ? null : QuotingHelper.unquoteStringLiteral(pathNode.getText());
                JpaXmlTableColumnNode node = xmlTable.valueColumn(columnName, castTarget, xpath);
                HqlParser.XmltableDefaultClauseContext defaultClause = valueColumnContext.xmltableDefaultClause();
                if (defaultClause == null) continue;
                node.defaultExpression((Expression)defaultClause.expression().accept(this));
                continue;
            }
            HqlParser.XmlTableOrdinalityColumnContext ordinalityColumnContext = (HqlParser.XmlTableOrdinalityColumnContext)columnContext;
            xmlTable.ordinalityColumn(this.visitIdentifier(ordinalityColumnContext.identifier()));
        }
    }

    private void checkXmlFunctionsEnabled(ParserRuleContext ctx) {
        if (!this.creationOptions.isXmlFunctionsEnabled()) {
            throw new SemanticException("Can't use function '" + ctx.children.get(0).getText() + "', because tech preview XML functions are not enabled. To enable, set the 'hibernate.query.hql.xml_functions_enabled' setting to 'true'.", this.query);
        }
    }

    @Override
    public SqmPredicate visitIncludesPredicate(HqlParser.IncludesPredicateContext ctx) {
        boolean negated = ctx.NOT() != null;
        SqmExpression lhs = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression(1).accept(this);
        SqmBindableType lhsExpressible = lhs.getExpressible();
        SqmBindableType rhsExpressible = rhs.getExpressible();
        if (lhsExpressible != null && !(lhsExpressible.getSqmType() instanceof BasicPluralType)) {
            throw new SemanticException("First operand for includes predicate must be a basic plural type expression, but found: " + String.valueOf(lhsExpressible.getSqmType()), this.query);
        }
        if (rhsExpressible != null && !(rhsExpressible.getSqmType() instanceof BasicPluralType)) {
            throw new SemanticException("Second operand for includes predicate must be a basic plural type expression, but found: " + String.valueOf(rhsExpressible.getSqmType()), this.query);
        }
        SelfRenderingSqmFunction<Boolean> contains = this.getFunctionDescriptor("array_includes").generateSqmExpression(Arrays.asList(lhs, rhs), null, this.queryEngine());
        return new SqmBooleanExpressionPredicate(contains, negated, this.nodeBuilder());
    }

    @Override
    public SqmPredicate visitIntersectsPredicate(HqlParser.IntersectsPredicateContext ctx) {
        boolean negated = ctx.NOT() != null;
        SqmExpression lhs = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression(1).accept(this);
        SqmBindableType lhsExpressible = lhs.getExpressible();
        if (lhsExpressible != null && !(lhsExpressible.getSqmType() instanceof BasicPluralType)) {
            throw new SemanticException("First operand for intersects predicate must be a basic plural type expression, but found: " + String.valueOf(lhsExpressible.getSqmType()), this.query);
        }
        SelfRenderingSqmFunction<Boolean> contains = this.getFunctionDescriptor("array_intersects").generateSqmExpression(Arrays.asList(lhs, rhs), null, this.queryEngine());
        return new SqmBooleanExpressionPredicate(contains, negated, this.nodeBuilder());
    }

    @Override
    public SqmPredicate visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        boolean caseSensitive;
        boolean negated = ctx.NOT() != null;
        boolean bl = caseSensitive = ctx.LIKE() != null;
        if (ctx.likeEscape() == null) {
            return new SqmLikePredicate((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), negated, caseSensitive, this.nodeBuilder());
        }
        return new SqmLikePredicate((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), (SqmExpression)ctx.likeEscape().accept(this), negated, caseSensitive, this.nodeBuilder());
    }

    @Override
    public Object visitLikeEscape(HqlParser.LikeEscapeContext ctx) {
        HqlParser.ParameterContext parameter = ctx.parameter();
        BasicType<Character> characterType = this.nodeBuilder().getCharacterType();
        if (parameter instanceof HqlParser.NamedParameterContext) {
            HqlParser.NamedParameterContext namedParameterContext = (HqlParser.NamedParameterContext)parameter;
            return this.visitNamedParameter(namedParameterContext, characterType);
        }
        if (parameter instanceof HqlParser.PositionalParameterContext) {
            HqlParser.PositionalParameterContext positionalParameterContext = (HqlParser.PositionalParameterContext)parameter;
            return this.visitPositionalParameter(positionalParameterContext, characterType);
        }
        TerminalNode terminalNode = (TerminalNode)ctx.getChild(1);
        String escape = QuotingHelper.unquoteStringLiteral(terminalNode.getText());
        if (escape.length() != 1) {
            throw new SemanticException("Escape character literals must have exactly a single character, but found: " + escape, this.query);
        }
        return new SqmLiteral<Character>(Character.valueOf(escape.charAt(0)), characterType, this.nodeBuilder());
    }

    @Override
    public SqmPredicate visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        boolean negated = ctx.NOT() != null;
        SqmPath<?> sqmPluralPath = this.consumeDomainPath(ctx.path());
        if (sqmPluralPath instanceof SqmPluralValuedSimplePath) {
            SqmPluralValuedSimplePath pluralValuedSimplePath = (SqmPluralValuedSimplePath)sqmPluralPath;
            return new SqmMemberOfPredicate((SqmExpression)ctx.expression().accept(this), pluralValuedSimplePath, negated, this.nodeBuilder());
        }
        throw new SemanticException("Operand of 'member of' operator must be a plural path", this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPredicate visitInPredicate(HqlParser.InPredicateContext ctx) {
        boolean negated = ctx.getChildCount() == 4;
        SqmExpression testExpression = (SqmExpression)ctx.expression().accept(this);
        HqlParser.InListContext inListContext = ctx.inList();
        if (inListContext instanceof HqlParser.ExplicitTupleInListContext) {
            HqlParser.ExplicitTupleInListContext tupleExpressionListContext = (HqlParser.ExplicitTupleInListContext)inListContext;
            int size = tupleExpressionListContext.getChildCount();
            int estimatedSize = size >> 1;
            String testExpressionJavaType = testExpression.getJavaTypeName();
            boolean isEnum = testExpression.isEnum();
            this.parameterDeclarationContextStack.push(() -> size == 3);
            try {
                ArrayList<SqmExpression> listExpressions = new ArrayList<SqmExpression>(estimatedSize);
                for (int i = 1; i < size; ++i) {
                    HqlParser.ExpressionContext expressionContext;
                    Set<String> possibleEnumTypes;
                    ParseTree parseTree = tupleExpressionListContext.getChild(i);
                    if (!(parseTree instanceof HqlParser.ExpressionOrPredicateContext)) continue;
                    ParseTree child = parseTree.getChild(0);
                    if (isEnum && child instanceof HqlParser.ExpressionContext && (possibleEnumTypes = this.getPossibleEnumTypes(expressionContext = (HqlParser.ExpressionContext)child)) != null) {
                        listExpressions.add(this.resolveEnumShorthandLiteral(expressionContext, this.getPossibleEnumValue(expressionContext), testExpressionJavaType, possibleEnumTypes));
                        continue;
                    }
                    listExpressions.add((SqmExpression)child.accept(this));
                }
                SqmInListPredicate sqmInListPredicate = new SqmInListPredicate(testExpression, listExpressions, negated, this.nodeBuilder());
                return sqmInListPredicate;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (inListContext instanceof HqlParser.ParamInListContext) {
            HqlParser.ParamInListContext tupleExpressionListContext = (HqlParser.ParamInListContext)inListContext;
            this.parameterDeclarationContextStack.push(() -> true);
            try {
                SqmInListPredicate size = new SqmInListPredicate(testExpression, Collections.singletonList(tupleExpressionListContext.parameter().accept(this)), negated, this.nodeBuilder());
                return size;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (inListContext instanceof HqlParser.SubqueryInListContext) {
            HqlParser.SubqueryInListContext subQueryOrParamInListContext = (HqlParser.SubqueryInListContext)inListContext;
            return new SqmInSubQueryPredicate(testExpression, this.visitSubquery(subQueryOrParamInListContext.subquery()), negated, this.nodeBuilder());
        }
        if (inListContext instanceof HqlParser.PersistentCollectionReferenceInListContext) {
            HqlParser.PersistentCollectionReferenceInListContext collectionReferenceInListContext = (HqlParser.PersistentCollectionReferenceInListContext)inListContext;
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
            }
            return new SqmInSubQueryPredicate(testExpression, this.createCollectionReferenceSubQuery(collectionReferenceInListContext.simplePath(), (TerminalNode)collectionReferenceInListContext.collectionQuantifier().getChild(0).getChild(0)), negated, this.nodeBuilder());
        }
        if (inListContext instanceof HqlParser.ArrayInListContext) {
            HqlParser.ArrayInListContext arrayInListContext = (HqlParser.ArrayInListContext)inListContext;
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
            }
            SqmExpression arrayExpr = (SqmExpression)arrayInListContext.expression().accept(this);
            SqmBindableType arrayExpressible = arrayExpr.getExpressible();
            if (arrayExpressible != null) {
                SqmDomainType sqmDomainType = arrayExpressible.getSqmType();
                if (!(sqmDomainType instanceof BasicPluralType)) {
                    throw new SemanticException("Right operand for in-array predicate must be a basic plural type expression, but found: " + String.valueOf(arrayExpressible.getSqmType()), this.query);
                }
                BasicPluralType pluralType = (BasicPluralType)sqmDomainType;
                testExpression.applyInferableType(pluralType.getElementType());
            }
            SelfRenderingSqmFunction<Boolean> contains = this.getFunctionDescriptor("array_contains").generateSqmExpression(Arrays.asList(arrayExpr, testExpression), null, this.queryEngine());
            return new SqmBooleanExpressionPredicate(contains, negated, this.nodeBuilder());
        }
        throw new ParsingException("Unexpected IN predicate type [" + ctx.getClass().getSimpleName() + "] : " + ctx.getText());
    }

    @Override
    public SqmPredicate visitExistsCollectionPartPredicate(HqlParser.ExistsCollectionPartPredicateContext ctx) {
        SqmSubQuery subQuery = this.createCollectionReferenceSubQuery(ctx.simplePath(), null);
        return new SqmExistsPredicate(subQuery, this.nodeBuilder());
    }

    @Override
    public SqmPredicate visitExistsPredicate(HqlParser.ExistsPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        return new SqmExistsPredicate(expression, this.nodeBuilder());
    }

    @Override
    public SqmPredicate visitBooleanExpressionPredicate(HqlParser.BooleanExpressionPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        if (SqmUtil.resolveExpressibleJavaTypeClass(expression) != Boolean.class) {
            throw new SemanticException("Non-boolean expression used in predicate context: " + ctx.getText(), this.query);
        }
        SqmExpression booleanExpression = expression;
        return new SqmBooleanExpressionPredicate(booleanExpression, this.nodeBuilder());
    }

    @Override
    public Object visitEntityTypeExpression(HqlParser.EntityTypeExpressionContext ctx) {
        HqlParser.EntityTypeReferenceContext entityTypeReferenceContext = ctx.entityTypeReference();
        HqlParser.ParameterContext parameter = entityTypeReferenceContext.parameter();
        HqlParser.PathContext path = entityTypeReferenceContext.path();
        if (parameter != null) {
            return new SqmParameterizedEntityType((SqmParameter)parameter.accept(this), this.nodeBuilder());
        }
        if (path != null) {
            SqmPath sqmPath = (SqmPath)path.accept(this);
            return sqmPath.type();
        }
        throw new ParsingException("Could not interpret grammar context as entity type expression: " + ctx.getText());
    }

    @Override
    public SqmExpression<?> visitEntityIdExpression(HqlParser.EntityIdExpressionContext ctx) {
        return this.visitEntityIdReference(ctx.entityIdReference());
    }

    @Override
    public SqmPath<?> visitEntityIdReference(HqlParser.EntityIdReferenceContext ctx) {
        if (ctx.pathContinuation() != null) {
            throw new UnsupportedOperationException("Path continuation from 'id()' reference not yet implemented");
        }
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        DomainType sqmPathType = sqmPath.getReferencedPathSource().getPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableType = (IdentifiableDomainType)sqmPathType;
            PathSource<?> identifierDescriptor = identifiableType.getIdentifierDescriptor();
            if (identifierDescriptor == null) {
                throw new FunctionArgumentException("Argument '" + String.valueOf(sqmPath.getNavigablePath()) + "' of 'id()' is a '" + identifiableType.getTypeName() + "' and does not have a well-defined '@Id' attribute");
            }
            return sqmPath.get(identifierDescriptor.getPathName(), true);
        }
        if (sqmPath instanceof SqmAnyValuedSimplePath) {
            return sqmPath.resolvePathPart("{key}", true, this.processingStateStack.getCurrent().getCreationState());
        }
        throw new FunctionArgumentException("Argument '" + String.valueOf(sqmPath.getNavigablePath()) + "' of 'id()' does not resolve to an entity type");
    }

    @Override
    public SqmExpression<?> visitEntityVersionExpression(HqlParser.EntityVersionExpressionContext ctx) {
        return this.visitEntityVersionReference(ctx.entityVersionReference());
    }

    @Override
    public SqmPath<?> visitEntityVersionReference(HqlParser.EntityVersionReferenceContext ctx) {
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        DomainType sqmPathType = sqmPath.getReferencedPathSource().getPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableType = (IdentifiableDomainType)sqmPathType;
            if (!identifiableType.hasVersionAttribute()) {
                throw new FunctionArgumentException("Argument '" + String.valueOf(sqmPath.getNavigablePath()) + "' of 'version()' is a '" + identifiableType.getTypeName() + "' and does not have a '@Version' attribute");
            }
            SingularPersistentAttribute versionAttribute = identifiableType.findVersionAttribute();
            return sqmPath.get((SingularAttribute)versionAttribute);
        }
        throw new FunctionArgumentException("Argument '" + String.valueOf(sqmPath.getNavigablePath()) + "' of 'version()' does not resolve to an entity type");
    }

    @Override
    public SqmPath<?> visitEntityNaturalIdExpression(HqlParser.EntityNaturalIdExpressionContext ctx) {
        return this.visitEntityNaturalIdReference(ctx.entityNaturalIdReference());
    }

    @Override
    public SqmPath<?> visitEntityNaturalIdReference(HqlParser.EntityNaturalIdReferenceContext ctx) {
        if (ctx.pathContinuation() != null) {
            throw new UnsupportedOperationException("Path continuation from 'naturalid()' reference not yet implemented");
        }
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        DomainType domainType = sqmPath.getReferencedPathSource().getPathType();
        if (domainType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableType = (IdentifiableDomainType)domainType;
            List attributes = identifiableType.findNaturalIdAttributes();
            if (attributes == null) {
                throw new FunctionArgumentException("Argument '" + String.valueOf(sqmPath.getNavigablePath()) + "' of 'naturalid()' is a '" + identifiableType.getTypeName() + "' and does not have a natural id");
            }
            if (attributes.size() > 1) {
                throw new FunctionArgumentException("Argument '" + String.valueOf(sqmPath.getNavigablePath()) + "' of 'naturalid()' is a '" + identifiableType.getTypeName() + "' and has a composite natural id");
            }
            SingularAttribute naturalIdAttribute = (SingularAttribute)((Object)attributes.get(0));
            return sqmPath.get(naturalIdAttribute);
        }
        throw new FunctionArgumentException("Argument '" + String.valueOf(sqmPath.getNavigablePath()) + "' of 'naturalid()' does not resolve to an entity type");
    }

    @Override
    public SqmFkExpression<?> visitToOneFkReference(HqlParser.ToOneFkReferenceContext ctx) {
        boolean validToOneRef;
        SqmPath<?> sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        SqmPathSource<?> toOneReference = sqmPath.getReferencedPathSource();
        boolean bl = validToOneRef = toOneReference.getBindableType() == Bindable.BindableType.SINGULAR_ATTRIBUTE && toOneReference instanceof EntitySqmPathSource;
        if (!validToOneRef) {
            throw new FunctionArgumentException(String.format(Locale.ROOT, "Argument '%s' of 'fk()' function is not a single-valued association", sqmPath.getNavigablePath()));
        }
        return new SqmFkExpression(sqmPath);
    }

    @Override
    public SqmMapEntryReference<?, ?> visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        return new SqmMapEntryReference(this.consumePluralAttributeReference(ctx.path()), this.nodeBuilder());
    }

    @Override
    public SqmExpression<?> visitConcatenationExpression(HqlParser.ConcatenationExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new SyntaxException("Expecting two operands to the '||' operator");
        }
        SqmExpression lhs = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression(1).accept(this);
        SqmBindableType lhsExpressible = lhs.getExpressible();
        SqmBindableType rhsExpressible = rhs.getExpressible();
        if (lhsExpressible != null && lhsExpressible.getSqmType() instanceof BasicPluralType) {
            if (rhsExpressible == null || rhsExpressible.getSqmType() instanceof BasicPluralType) {
                return this.getFunctionDescriptor("array_concat").generateSqmExpression(Arrays.asList(lhs, rhs), null, this.queryEngine());
            }
            return this.getFunctionDescriptor("array_append").generateSqmExpression(Arrays.asList(lhs, rhs), null, this.queryEngine());
        }
        if (rhsExpressible != null && rhsExpressible.getSqmType() instanceof BasicPluralType) {
            if (lhsExpressible == null) {
                return this.getFunctionDescriptor("array_concat").generateSqmExpression(Arrays.asList(lhs, rhs), null, this.queryEngine());
            }
            return this.getFunctionDescriptor("array_prepend").generateSqmExpression(Arrays.asList(lhs, rhs), null, this.queryEngine());
        }
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(lhs, rhs), null, this.queryEngine());
    }

    @Override
    public Object visitSignOperator(HqlParser.SignOperatorContext ctx) {
        Token symbol = ((TerminalNode)ctx.getChild(0)).getSymbol();
        return switch (symbol.getType()) {
            case 30 -> UnaryArithmeticOperator.UNARY_PLUS;
            case 31 -> UnaryArithmeticOperator.UNARY_MINUS;
            default -> throw new ParsingException("Unrecognized sign operator");
        };
    }

    @Override
    public Object visitAdditiveOperator(HqlParser.AdditiveOperatorContext ctx) {
        Token symbol = ((TerminalNode)ctx.getChild(0)).getSymbol();
        return switch (symbol.getType()) {
            case 30 -> BinaryArithmeticOperator.ADD;
            case 31 -> BinaryArithmeticOperator.SUBTRACT;
            default -> throw new ParsingException("Unrecognized additive operator");
        };
    }

    @Override
    public Object visitMultiplicativeOperator(HqlParser.MultiplicativeOperatorContext ctx) {
        Token symbol = ((TerminalNode)ctx.getChild(0)).getSymbol();
        return switch (symbol.getType()) {
            case 32 -> BinaryArithmeticOperator.MULTIPLY;
            case 34 -> BinaryArithmeticOperator.MODULO;
            case 33 -> {
                if (this.creationOptions.isPortableIntegerDivisionEnabled()) {
                    yield BinaryArithmeticOperator.DIVIDE_PORTABLE;
                }
                yield BinaryArithmeticOperator.DIVIDE;
            }
            default -> throw new ParsingException("Unrecognized multiplicative operator");
        };
    }

    @Override
    public Object visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new SyntaxException("Expecting two operands to the additive operator");
        }
        SqmExpression left = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression right = (SqmExpression)ctx.expression(1).accept(this);
        BinaryArithmeticOperator operator = (BinaryArithmeticOperator)((Object)ctx.additiveOperator().accept(this));
        TypecheckUtil.assertOperable(left, right, operator);
        return new SqmBinaryArithmetic(operator, left, right, this.nodeBuilder());
    }

    @Override
    public Object visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new SyntaxException("Expecting two operands to the multiplicative operator");
        }
        SqmExpression left = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression right = (SqmExpression)ctx.expression(1).accept(this);
        BinaryArithmeticOperator operator = (BinaryArithmeticOperator)((Object)ctx.multiplicativeOperator().accept(this));
        TypecheckUtil.assertOperable(left, right, operator);
        if (operator == BinaryArithmeticOperator.MODULO) {
            return this.getFunctionDescriptor("mod").generateSqmExpression(Arrays.asList(left, right), null, this.queryEngine());
        }
        return new SqmBinaryArithmetic(operator, left, right, this.nodeBuilder());
    }

    @Override
    public Object visitToDurationExpression(HqlParser.ToDurationExpressionContext ctx) {
        return new SqmToDuration<Duration>((SqmExpression)ctx.expression().accept(this), this.toDurationUnit((SqmExtractUnit)ctx.datetimeField().accept(this)), this.resolveExpressibleTypeBasic(Duration.class), this.nodeBuilder());
    }

    private SqmDurationUnit<Long> toDurationUnit(SqmExtractUnit<?> extractUnit) {
        return new SqmDurationUnit<Long>(extractUnit.getUnit(), this.resolveExpressibleTypeBasic(Long.class), this.nodeBuilder());
    }

    @Override
    public Object visitFromDurationExpression(HqlParser.FromDurationExpressionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        TypecheckUtil.assertDuration(expression);
        return new SqmByUnit(this.toDurationUnit((SqmExtractUnit)ctx.datetimeField().accept(this)), expression, this.resolveExpressibleTypeBasic(Long.class), this.nodeBuilder());
    }

    @Override
    public SqmUnaryOperation<?> visitUnaryExpression(HqlParser.UnaryExpressionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        UnaryArithmeticOperator operator = (UnaryArithmeticOperator)((Object)ctx.signOperator().accept(this));
        TypecheckUtil.assertNumeric(expression, operator);
        return new SqmUnaryOperation(operator, expression);
    }

    @Override
    public Object visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        return ctx.getChild(1).accept(this);
    }

    @Override
    public Object visitCollateFunction(HqlParser.CollateFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.COLLATIONS);
        }
        SqmExpression expressionToCollate = (SqmExpression)ctx.expression().accept(this);
        SqmCollation castTargetExpression = (SqmCollation)ctx.collation().accept(this);
        return this.getFunctionDescriptor("collate").generateSqmExpression(Arrays.asList(expressionToCollate, castTargetExpression), null, this.queryEngine());
    }

    @Override
    public Object visitCollation(HqlParser.CollationContext ctx) {
        boolean quoted;
        StringBuilder collation = new StringBuilder();
        HqlParser.SimplePathContext simplePathContext = ctx.simplePath();
        boolean bl = quoted = simplePathContext.getStart().getType() == 253;
        if (quoted) {
            collation.append("\"");
        }
        collation.append(this.visitIdentifier(simplePathContext.identifier()));
        for (HqlParser.SimplePathElementContext pathElementContext : simplePathContext.simplePathElement()) {
            collation.append(this.visitIdentifier(pathElementContext.identifier()));
        }
        if (quoted) {
            collation.append("\"");
        }
        return new SqmCollation(collation.toString(), null, this.nodeBuilder());
    }

    @Override
    public Object visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.TUPLES);
        }
        List<SqmExpression<?>> expressions = this.visitExpressions(ctx);
        return new SqmTuple(expressions, this.nodeBuilder());
    }

    private List<SqmExpression<?>> visitExpressions(ParserRuleContext parentContext) {
        int size = parentContext.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        ArrayList expressions = new ArrayList(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = parentContext.getChild(i);
            if (!(parseTree instanceof HqlParser.ExpressionOrPredicateContext)) continue;
            expressions.add((SqmExpression)parseTree.accept(this));
        }
        return expressions;
    }

    @Override
    public Object visitCaseExpression(HqlParser.CaseExpressionContext ctx) {
        return ctx.getChild(0).accept(this);
    }

    @Override
    public SqmCaseSimple<?, ?> visitSimpleCaseList(HqlParser.SimpleCaseListContext ctx) {
        int size = ctx.simpleCaseWhen().size();
        SqmExpression expression = (SqmExpression)ctx.expressionOrPredicate().accept(this);
        SqmCaseSimple caseExpression = new SqmCaseSimple(expression, size, this.nodeBuilder());
        for (int i = 0; i < size; ++i) {
            HqlParser.SimpleCaseWhenContext simpleCaseWhenContext = ctx.simpleCaseWhen(i);
            HqlParser.ExpressionContext testExpression = simpleCaseWhenContext.expression();
            Set<String> possibleEnumTypes = this.getPossibleEnumTypes(testExpression);
            SqmExpression<?> test = possibleEnumTypes != null ? this.resolveEnumShorthandLiteral(testExpression, this.getPossibleEnumValue(testExpression), expression.getJavaTypeName(), possibleEnumTypes) : (SqmExpression<?>)testExpression.accept(this);
            SqmExpression result = (SqmExpression)simpleCaseWhenContext.expressionOrPredicate().accept(this);
            caseExpression.when(test, result);
        }
        HqlParser.CaseOtherwiseContext caseOtherwiseContext = ctx.caseOtherwise();
        if (caseOtherwiseContext != null) {
            caseExpression.otherwise((SqmExpression)caseOtherwiseContext.expressionOrPredicate().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmCaseSearched<?> visitSearchedCaseList(HqlParser.SearchedCaseListContext ctx) {
        int size = ctx.searchedCaseWhen().size();
        SqmCaseSearched caseExpression = new SqmCaseSearched(size, this.nodeBuilder());
        for (int i = 0; i < size; ++i) {
            HqlParser.SearchedCaseWhenContext searchedCaseWhenContext = ctx.searchedCaseWhen(i);
            caseExpression.when((SqmPredicate)searchedCaseWhenContext.predicate().accept(this), (SqmExpression)searchedCaseWhenContext.expressionOrPredicate().accept(this));
        }
        HqlParser.CaseOtherwiseContext caseOtherwiseContext = ctx.caseOtherwise();
        if (caseOtherwiseContext != null) {
            caseExpression.otherwise((SqmExpression)caseOtherwiseContext.expressionOrPredicate().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmExpression<?> visitCurrentDateFunction(HqlParser.CurrentDateFunctionContext ctx) {
        return this.getFunctionDescriptor("current_date").generateSqmExpression(this.resolveExpressibleTypeBasic(Date.class), this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitCurrentTimeFunction(HqlParser.CurrentTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("current_time").generateSqmExpression(this.resolveExpressibleTypeBasic(Time.class), this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitCurrentTimestampFunction(HqlParser.CurrentTimestampFunctionContext ctx) {
        return this.getFunctionDescriptor("current_timestamp").generateSqmExpression(this.resolveExpressibleTypeBasic(Timestamp.class), this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitInstantFunction(HqlParser.InstantFunctionContext ctx) {
        return this.getFunctionDescriptor("instant").generateSqmExpression(this.resolveExpressibleTypeBasic(Instant.class), this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitLocalDateFunction(HqlParser.LocalDateFunctionContext ctx) {
        return this.getFunctionDescriptor("local_date").generateSqmExpression(this.resolveExpressibleTypeBasic(LocalDate.class), this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitLocalTimeFunction(HqlParser.LocalTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_time").generateSqmExpression(this.resolveExpressibleTypeBasic(LocalTime.class), this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitLocalDateTimeFunction(HqlParser.LocalDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_datetime").generateSqmExpression(this.resolveExpressibleTypeBasic(LocalDateTime.class), this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitOffsetDateTimeFunction(HqlParser.OffsetDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("offset_datetime").generateSqmExpression(this.resolveExpressibleTypeBasic(OffsetDateTime.class), this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        return (SqmExpression)ctx.getChild(0).accept(this);
    }

    @Override
    public SqmExpression<?> visitUnaryNumericLiteralExpression(HqlParser.UnaryNumericLiteralExpressionContext ctx) {
        TerminalNode node = (TerminalNode)ctx.getChild(1).getChild(0);
        Token symbol = ((TerminalNode)ctx.getChild(0).getChild(0)).getSymbol();
        Object text = symbol.getType() == 31 ? "-" + node.getText() : node.getText();
        return switch (node.getSymbol().getType()) {
            case 3 -> this.integerLiteral((String)text);
            case 4 -> this.longLiteral((String)text);
            case 7 -> this.bigIntegerLiteral((String)text);
            case 9 -> this.hexLiteral((String)text);
            case 5 -> this.floatLiteral((String)text);
            case 6 -> this.doubleLiteral((String)text);
            case 8 -> this.bigDecimalLiteral((String)text);
            default -> throw new ParsingException("Unexpected terminal node [" + (String)text + "]");
        };
    }

    @Override
    public Object visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx) {
        TerminalNode firstNode = (TerminalNode)ctx.getChild(0);
        if (firstNode.getSymbol().getType() == 12) {
            return this.binaryLiteral(firstNode.getText());
        }
        StringBuilder text = new StringBuilder("x'");
        int size = ctx.getChildCount();
        for (int i = 0; i < size; ++i) {
            TerminalNode hex = (TerminalNode)ctx.getChild(i);
            if (hex.getSymbol().getType() != 9) continue;
            String hexText = hex.getText();
            if (hexText.length() != 4) {
                throw new LiteralNumberFormatException("not a byte: " + hexText);
            }
            text.append(hexText, 2, hexText.length());
        }
        return this.binaryLiteral(text.append("'").toString());
    }

    @Override
    public Object visitArrayLiteral(HqlParser.ArrayLiteralContext ctx) {
        List<HqlParser.ExpressionContext> expressionContexts = ctx.expression();
        int count = expressionContexts.size();
        ArrayList<SqmTypedNode> arguments = new ArrayList<SqmTypedNode>(count);
        for (HqlParser.ExpressionContext expressionContext : expressionContexts) {
            arguments.add((SqmTypedNode)expressionContext.accept(this));
        }
        return this.getFunctionDescriptor("array").generateSqmExpression(arguments, null, this.queryEngine());
    }

    @Override
    public Object visitGeneralizedLiteral(HqlParser.GeneralizedLiteralContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqmExpression<?> visitTerminal(TerminalNode node) {
        if (node.getSymbol().getType() == -1) {
            return null;
        }
        return switch (node.getSymbol().getType()) {
            case 10 -> this.stringLiteral(node.getText());
            case 11 -> this.javaStringLiteral(node.getText());
            case 3 -> this.integerLiteral(node.getText());
            case 4 -> this.longLiteral(node.getText());
            case 7 -> this.bigIntegerLiteral(node.getText());
            case 9 -> this.hexLiteral(node.getText());
            case 5 -> this.floatLiteral(node.getText());
            case 6 -> this.doubleLiteral(node.getText());
            case 8 -> this.bigDecimalLiteral(node.getText());
            case 250 -> this.booleanLiteral(false);
            case 249 -> this.booleanLiteral(true);
            case 251 -> new SqmLiteralNull(this.nodeBuilder());
            case 12 -> this.binaryLiteral(node.getText());
            default -> throw new ParsingException("Unexpected terminal node [" + node.getText() + "]");
        };
    }

    @Override
    public Object visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx) {
        return ctx.getChild(0).accept(this);
    }

    @Override
    public Object visitLocalDateTimeLiteral(HqlParser.LocalDateTimeLiteralContext ctx) {
        return ctx.localDateTime().accept(this);
    }

    @Override
    public Object visitZonedDateTimeLiteral(HqlParser.ZonedDateTimeLiteralContext ctx) {
        return ctx.zonedDateTime().accept(this);
    }

    @Override
    public Object visitOffsetDateTimeLiteral(HqlParser.OffsetDateTimeLiteralContext ctx) {
        if (ctx.offsetDateTime() != null) {
            return ctx.offsetDateTime().accept(this);
        }
        if (ctx.offsetDateTimeWithMinutes() != null) {
            return ctx.offsetDateTimeWithMinutes().accept(this);
        }
        return null;
    }

    @Override
    public Object visitDateLiteral(HqlParser.DateLiteralContext ctx) {
        return ctx.date().accept(this);
    }

    @Override
    public Object visitTimeLiteral(HqlParser.TimeLiteralContext ctx) {
        return ctx.time().accept(this);
    }

    @Override
    public Object visitJdbcTimestampLiteral(HqlParser.JdbcTimestampLiteralContext ctx) {
        HqlParser.DateTimeContext dateTime = ctx.dateTime();
        if (dateTime != null) {
            return dateTime.accept(this);
        }
        return this.sqlTimestampLiteralFrom(ctx.genericTemporalLiteralText().getText());
    }

    @Override
    public Object visitJdbcDateLiteral(HqlParser.JdbcDateLiteralContext ctx) {
        HqlParser.DateContext date = ctx.date();
        if (date != null) {
            return date.accept(this);
        }
        return this.sqlDateLiteralFrom(ctx.genericTemporalLiteralText().getText());
    }

    @Override
    public Object visitJdbcTimeLiteral(HqlParser.JdbcTimeLiteralContext ctx) {
        HqlParser.TimeContext time = ctx.time();
        if (time != null) {
            return time.accept(this);
        }
        return this.sqlTimeLiteralFrom(ctx.genericTemporalLiteralText().getText());
    }

    @Override
    public Object visitDateTime(HqlParser.DateTimeContext ctx) {
        return ctx.getChild(0).accept(this);
    }

    @Override
    public Object visitLocalDateTime(HqlParser.LocalDateTimeContext ctx) {
        return this.localDateTimeLiteralFrom(ctx.date(), ctx.time());
    }

    @Override
    public Object visitOffsetDateTime(HqlParser.OffsetDateTimeContext ctx) {
        return this.offsetDatetimeLiteralFrom(ctx.date(), ctx.time(), ctx.offset());
    }

    @Override
    public Object visitOffsetDateTimeWithMinutes(HqlParser.OffsetDateTimeWithMinutesContext ctx) {
        return this.offsetDatetimeLiteralFrom(ctx.date(), ctx.time(), ctx.offsetWithMinutes());
    }

    @Override
    public Object visitZonedDateTime(HqlParser.ZonedDateTimeContext ctx) {
        return this.zonedDateTimeLiteralFrom(ctx.date(), ctx.time(), ctx.zoneId());
    }

    private SqmLiteral<?> localDateTimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time) {
        return new SqmLiteral<LocalDateTime>(LocalDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time)), this.resolveExpressibleTypeBasic(LocalDateTime.class), this.nodeBuilder());
    }

    private SqmLiteral<?> zonedDateTimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.ZoneIdContext timezone) {
        return new SqmLiteral<ZonedDateTime>(ZonedDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), this.visitZoneId(timezone)), this.resolveExpressibleTypeBasic(ZonedDateTime.class), this.nodeBuilder());
    }

    @Override
    public ZoneId visitZoneId(HqlParser.ZoneIdContext ctx) {
        TerminalNode firstChild = (TerminalNode)ctx.getChild(0);
        String timezoneText = firstChild.getSymbol().getType() == 10 ? QuotingHelper.unquoteStringLiteral(ctx.getText()) : ctx.getText();
        String timezoneFullName = ZoneId.SHORT_IDS.get(timezoneText);
        if (timezoneFullName == null) {
            return ZoneId.of(timezoneText);
        }
        return ZoneId.of(timezoneFullName);
    }

    private SqmLiteral<?> offsetDatetimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.OffsetContext offset) {
        return new SqmLiteral<OffsetDateTime>(OffsetDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), SemanticQueryBuilder.zoneOffset(offset)), this.resolveExpressibleTypeBasic(OffsetDateTime.class), this.nodeBuilder());
    }

    private SqmLiteral<?> offsetDatetimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.OffsetWithMinutesContext offset) {
        return new SqmLiteral<OffsetDateTime>(OffsetDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), SemanticQueryBuilder.zoneOffset(offset)), this.resolveExpressibleTypeBasic(OffsetDateTime.class), this.nodeBuilder());
    }

    @Override
    public Object visitDate(HqlParser.DateContext ctx) {
        return new SqmLiteral<LocalDate>(SemanticQueryBuilder.localDate(ctx), this.resolveExpressibleTypeBasic(LocalDate.class), this.nodeBuilder());
    }

    @Override
    public Object visitTime(HqlParser.TimeContext ctx) {
        return new SqmLiteral<LocalTime>(SemanticQueryBuilder.localTime(ctx), this.resolveExpressibleTypeBasic(LocalTime.class), this.nodeBuilder());
    }

    private static LocalTime localTime(HqlParser.TimeContext ctx) {
        int hour = Integer.parseInt(ctx.hour().getText());
        int minute = Integer.parseInt(ctx.minute().getText());
        HqlParser.SecondContext secondContext = ctx.second();
        if (secondContext != null) {
            String secondText = secondContext.getText();
            int index = secondText.indexOf(46);
            if (index < 0) {
                return LocalTime.of(hour, minute, Integer.parseInt(secondText));
            }
            String secondFractions = secondText.substring(index + 1);
            return LocalTime.of(hour, minute, Integer.parseInt(secondText.substring(0, index)), Integer.parseInt(secondFractions) * (int)Math.pow(10.0, 9 - secondFractions.length()));
        }
        return LocalTime.of(hour, minute);
    }

    private static LocalDate localDate(HqlParser.DateContext ctx) {
        return LocalDate.of(Integer.parseInt(ctx.year().getText()), Integer.parseInt(ctx.month().getText()), Integer.parseInt(ctx.day().getText()));
    }

    private static ZoneOffset zoneOffset(HqlParser.OffsetContext offset) {
        int factor = ((TerminalNode)offset.getChild(0)).getSymbol().getType() == 30 ? 1 : -1;
        int hour = factor * Integer.parseInt(offset.hour().getText());
        if (offset.getChildCount() == 2) {
            return ZoneOffset.ofHours(hour);
        }
        return ZoneOffset.ofHoursMinutes(hour, factor * Integer.parseInt(offset.minute().getText()));
    }

    private static ZoneOffset zoneOffset(HqlParser.OffsetWithMinutesContext offset) {
        int factor = ((TerminalNode)offset.getChild(0)).getSymbol().getType() == 30 ? 1 : -1;
        int hour = factor * Integer.parseInt(offset.hour().getText());
        if (offset.getChildCount() == 2) {
            return ZoneOffset.ofHours(hour);
        }
        return ZoneOffset.ofHoursMinutes(hour, factor * Integer.parseInt(offset.minute().getText()));
    }

    private static CharSequence stripQuotes(String literalText) {
        return literalText.subSequence(1, literalText.length() - 1);
    }

    private SqmLiteral<?> sqlTimestampLiteralFrom(String literalText) {
        TemporalAccessor parsed = DateTimeUtils.DATE_TIME.parse(SemanticQueryBuilder.stripQuotes(literalText));
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.from(parsed);
            GregorianCalendar literal = GregorianCalendar.from(zonedDateTime);
            return new SqmLiteral<Calendar>(literal, this.resolveExpressibleTypeBasic(Calendar.class), this.nodeBuilder());
        }
        catch (DateTimeException dte) {
            LocalDateTime localDateTime = LocalDateTime.from(parsed);
            Timestamp literal = Timestamp.valueOf(localDateTime);
            return new SqmLiteral<Timestamp>(literal, this.resolveExpressibleTypeBasic(Timestamp.class), this.nodeBuilder());
        }
    }

    private SqmLiteral<Date> sqlDateLiteralFrom(String literalText) {
        LocalDate localDate = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(SemanticQueryBuilder.stripQuotes(literalText)));
        Date literal = Date.valueOf(localDate);
        return new SqmLiteral<Date>(literal, this.resolveExpressibleTypeBasic(Date.class), this.nodeBuilder());
    }

    private SqmLiteral<Time> sqlTimeLiteralFrom(String literalText) {
        LocalTime localTime = LocalTime.from(DateTimeFormatter.ISO_LOCAL_TIME.parse(SemanticQueryBuilder.stripQuotes(literalText)));
        Time literal = Time.valueOf(localTime);
        return new SqmLiteral<Time>(literal, this.resolveExpressibleTypeBasic(Time.class), this.nodeBuilder());
    }

    private SqmLiteral<Boolean> booleanLiteral(boolean value) {
        return new SqmLiteral<Boolean>(value, this.resolveExpressibleTypeBasic(Boolean.class), this.nodeBuilder());
    }

    private SqmLiteral<String> stringLiteral(String text) {
        return new SqmLiteral<String>(QuotingHelper.unquoteStringLiteral(text), this.resolveExpressibleTypeBasic(String.class), this.nodeBuilder());
    }

    private SqmLiteral<String> javaStringLiteral(String text) {
        String unquoted = QuotingHelper.unquoteJavaStringLiteral(text);
        return new SqmLiteral<String>(unquoted, this.resolveExpressibleTypeBasic(String.class), this.nodeBuilder());
    }

    private SqmLiteral<byte[]> binaryLiteral(String text) {
        return new SqmLiteral<byte[]>(PrimitiveByteArrayJavaType.INSTANCE.fromString(CharSequenceHelper.subSequence(text, 2, text.length() - 1)), this.resolveExpressibleTypeBasic(byte[].class), this.nodeBuilder());
    }

    private SqmHqlNumericLiteral<Integer> integerLiteral(String text) {
        if (this.isHexOrOctal(text = text.replace("_", ""))) {
            int intValue = Integer.decode(text);
            text = Integer.toString(intValue);
        }
        return new SqmHqlNumericLiteral<Integer>(text, (BasicDomainType<Integer>)this.integerDomainType, this.nodeBuilder());
    }

    private boolean isHexOrOctal(String text) {
        if (text.startsWith("0x") || text.startsWith("-0x")) {
            return true;
        }
        return text.startsWith("0") && text.length() > 1 || text.startsWith("-0") && text.length() > 2;
    }

    private SqmHqlNumericLiteral<Long> longLiteral(String text) {
        assert (text.endsWith("l") || text.endsWith("L"));
        return new SqmHqlNumericLiteral<Long>(text.substring(0, text.length() - 1).replace("_", ""), (BasicDomainType<Long>)this.resolveExpressibleTypeBasic(Long.class), this.nodeBuilder());
    }

    private SqmHqlNumericLiteral<BigInteger> bigIntegerLiteral(String text) {
        assert (text.endsWith("bi") || text.endsWith("BI"));
        return new SqmHqlNumericLiteral<BigInteger>(text.substring(0, text.length() - 2).replace("_", ""), (BasicDomainType<BigInteger>)this.resolveExpressibleTypeBasic(BigInteger.class), this.nodeBuilder());
    }

    private SqmHqlNumericLiteral<? extends Number> floatLiteral(String text) {
        assert (text.endsWith("f") || text.endsWith("F"));
        return new SqmHqlNumericLiteral<Float>(text.substring(0, text.length() - 1).replace("_", ""), (BasicDomainType<Float>)this.resolveExpressibleTypeBasic(Float.class), this.nodeBuilder());
    }

    private SqmHqlNumericLiteral<Double> doubleLiteral(String text) {
        if (text.endsWith("d") || text.endsWith("D")) {
            text = text.substring(0, text.length() - 1);
        }
        return new SqmHqlNumericLiteral<Double>(text.replace("_", ""), (BasicDomainType<Double>)this.resolveExpressibleTypeBasic(Double.class), this.nodeBuilder());
    }

    private SqmHqlNumericLiteral<BigDecimal> bigDecimalLiteral(String text) {
        assert (text.endsWith("bd") || text.endsWith("BD"));
        return new SqmHqlNumericLiteral<BigDecimal>(text.substring(0, text.length() - 2).replace("_", ""), (BasicDomainType<BigDecimal>)this.resolveExpressibleTypeBasic(BigDecimal.class), this.nodeBuilder());
    }

    private SqmHqlNumericLiteral<? extends Number> hexLiteral(String text) {
        if (text.endsWith("l") || text.endsWith("L")) {
            return this.longLiteral(text);
        }
        return this.integerLiteral(text);
    }

    private <J> BasicType<J> resolveExpressibleTypeBasic(Class<J> javaType) {
        return this.creationContext.getTypeConfiguration().standardBasicTypeForJavaType(javaType);
    }

    @Override
    public Object visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return ctx.getChild(0).accept(this);
    }

    @Override
    public SqmNamedParameter<?> visitNamedParameter(HqlParser.NamedParameterContext ctx) {
        return this.visitNamedParameter(ctx, null);
    }

    private <T> SqmNamedParameter<T> visitNamedParameter(HqlParser.NamedParameterContext ctx, SqmBindableType<T> expressibleType) {
        this.parameterStyle = this.parameterStyle.withNamed();
        return this.resolveParameter(new SqmNamedParameter<T>(ctx.getChild(1).getText(), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), expressibleType, this.nodeBuilder()));
    }

    @Override
    public SqmPositionalParameter<?> visitPositionalParameter(HqlParser.PositionalParameterContext ctx) {
        return this.visitPositionalParameter(ctx, null);
    }

    private <T> SqmPositionalParameter<T> visitPositionalParameter(HqlParser.PositionalParameterContext ctx, SqmBindableType<T> expressibleType) {
        if (ctx.getChildCount() == 1) {
            throw new ParameterLabelException("Unlabeled ordinal parameter ('?' rather than ?1)");
        }
        this.parameterStyle = this.parameterStyle.withPositional();
        return this.resolveParameter(new SqmPositionalParameter<T>(Integer.parseInt(ctx.getChild(1).getText()), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), expressibleType, this.nodeBuilder()));
    }

    private <T extends AbstractSqmParameter<?>> T resolveParameter(T parameter) {
        Object key;
        AbstractSqmParameter<?> existingParameter;
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        if ((existingParameter = this.parameters.putIfAbsent(key = parameter.getName() == null ? parameter.getPosition() : parameter.getName(), parameter)) == null) {
            this.parameterCollector.addParameter(parameter);
            return parameter;
        }
        if (existingParameter.allowMultiValuedBinding() && !parameter.allowMultiValuedBinding()) {
            existingParameter.disallowMultiValuedBinding();
        }
        return (T)existingParameter;
    }

    private String toName(HqlParser.JpaNonstandardFunctionNameContext ctx) {
        return ctx.STRING_LITERAL() == null ? ctx.identifier().getText().toLowerCase() : QuotingHelper.unquoteStringLiteral(ctx.STRING_LITERAL().getText()).toLowerCase();
    }

    @Override
    public SqmSetReturningFunction<?> visitSimpleSetReturningFunction(HqlParser.SimpleSetReturningFunctionContext ctx) {
        String functionName = this.visitIdentifier(ctx.identifier());
        HqlParser.GenericFunctionArgumentsContext argumentsContext = ctx.genericFunctionArguments();
        List functionArguments = argumentsContext == null ? Collections.emptyList() : (List)argumentsContext.accept(this);
        SqmSetReturningFunctionDescriptor functionTemplate = this.getSetReturningFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            throw new SemanticException("The %s() set-returning function was not registered for the dialect".formatted(functionName), this.query);
        }
        return functionTemplate.generateSqmExpression(functionArguments, this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitJpaNonstandardFunction(HqlParser.JpaNonstandardFunctionContext ctx) {
        String functionName = this.toName(ctx.jpaNonstandardFunctionName());
        HqlParser.GenericFunctionArgumentsContext argumentsContext = ctx.genericFunctionArguments();
        List functionArguments = argumentsContext == null ? Collections.emptyList() : (List)argumentsContext.accept(this);
        BasicType<?> returnableType = this.returnType(ctx.castTarget());
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(returnableType), null);
        }
        return functionTemplate.generateSqmExpression(functionArguments, returnableType, this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitColumnFunction(HqlParser.ColumnFunctionContext ctx) {
        String columnName = this.toName(ctx.jpaNonstandardFunctionName());
        SemanticPathPart semanticPathPart = this.visitPath(ctx.path());
        BasicType<?> resultType = this.returnType(ctx.castTarget());
        return new SqlColumn(columnName, resultType).generateSqmExpression((SqmTypedNode)((Object)semanticPathPart), resultType, this.queryEngine());
    }

    private BasicType<?> returnType(HqlParser.CastTargetContext castTarget) {
        if (castTarget == null) {
            return OBJECT_BASIC_TYPE;
        }
        return (BasicType)((SqmCastTarget)this.visitCastTarget(castTarget)).getType();
    }

    @Override
    public String visitGenericFunctionName(HqlParser.GenericFunctionNameContext ctx) {
        StringBuilder functionName = new StringBuilder(this.visitIdentifier(ctx.simplePath().identifier()));
        for (HqlParser.SimplePathElementContext sp : ctx.simplePath().simplePathElement()) {
            functionName.append('.').append(this.visitIdentifier(sp.identifier()));
        }
        return functionName.toString();
    }

    private String getFunctionName(HqlParser.GenericFunctionContext ctx) {
        String originalFunctionName = this.visitGenericFunctionName(ctx.genericFunctionName());
        String functionName = originalFunctionName.toLowerCase();
        if (this.creationOptions.useStrictJpaCompliance() && !JPA_STANDARD_FUNCTIONS.contains(functionName)) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [" + originalFunctionName + "], but strict JPA compliance was requested; use FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        return functionName;
    }

    @Override
    public Object visitGenericFunction(HqlParser.GenericFunctionContext ctx) {
        SqmFunctionDescriptor functionTemplate = this.getFunctionTemplate(ctx);
        List<SqmTypedNode<?>> functionArguments = this.getFunctionArguments(ctx);
        SqmPredicate filterExpression = this.getFilterExpression(ctx);
        SelfRenderingSqmFunction function = switch (functionTemplate.getFunctionKind()) {
            case FunctionKind.ORDERED_SET_AGGREGATE -> functionTemplate.generateOrderedSetAggregateSqmExpression(functionArguments, filterExpression, ctx.withinGroupClause() == null ? null : this.visitOrderByClause(ctx.withinGroupClause().orderByClause(), false), null, this.queryEngine());
            case FunctionKind.AGGREGATE -> functionTemplate.generateAggregateSqmExpression(functionArguments, filterExpression, null, this.queryEngine());
            case FunctionKind.WINDOW -> functionTemplate.generateWindowSqmExpression(functionArguments, filterExpression, null, null, null, this.queryEngine());
            default -> functionTemplate.generateSqmExpression(functionArguments, null, this.queryEngine());
        };
        return this.applyOverClause(ctx.overClause(), function);
    }

    private SqmFunctionDescriptor getFunctionTemplate(HqlParser.GenericFunctionContext ctx) {
        String functionName = this.getFunctionName(ctx);
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            return new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(this.resolveExpressibleTypeBasic(Object.class)), null, functionName, SemanticQueryBuilder.inferFunctionKind(ctx), null, SqlAstNodeRenderingMode.DEFAULT);
        }
        FunctionKind functionKind = functionTemplate.getFunctionKind();
        if (ctx.filterClause() != null && functionKind == FunctionKind.NORMAL) {
            throw new SemanticException("'FILTER' clause is illegal for non-aggregate function: " + functionName, this.query);
        }
        if (ctx.overClause() != null && functionKind == FunctionKind.NORMAL) {
            throw new SemanticException("'OVER' clause is illegal for non-aggregate function: " + functionName, this.query);
        }
        if (ctx.withinGroupClause() != null && functionKind == FunctionKind.NORMAL) {
            throw new SemanticException("'WITHIN' GROUP clause is illegal for non-aggregate function: " + functionName, this.query);
        }
        if (ctx.overClause() == null && functionKind == FunctionKind.WINDOW) {
            throw new SemanticException("'OVER' clause is mandatory for window-only function: " + functionName, this.query);
        }
        if (ctx.withinGroupClause() == null && ctx.overClause() == null && functionKind == FunctionKind.ORDERED_SET_AGGREGATE) {
            throw new SemanticException("'WITHIN GROUP' or 'OVER' clause is mandatory for ordered set aggregate function: " + functionName, this.query);
        }
        if (ctx.nullsClause() != null) {
            switch (functionName) {
                case "lag": 
                case "lead": 
                case "first_value": 
                case "last_value": 
                case "nth_value": {
                    break;
                }
                default: {
                    throw new SemanticException("'RESPECT NULLS' or 'IGNORE NULLS' are illegal for function: " + functionName, this.query);
                }
            }
        }
        if (ctx.nthSideClause() != null && !"nth_value".equals(functionName)) {
            throw new SemanticException("'FROM FIRST' or 'FROM LAST' are illegal for function: " + functionName, this.query);
        }
        return functionTemplate;
    }

    private static FunctionKind inferFunctionKind(HqlParser.GenericFunctionContext ctx) {
        if (ctx.withinGroupClause() != null) {
            return FunctionKind.ORDERED_SET_AGGREGATE;
        }
        if (ctx.overClause() != null) {
            return FunctionKind.WINDOW;
        }
        if (ctx.filterClause() != null) {
            return FunctionKind.AGGREGATE;
        }
        return FunctionKind.NORMAL;
    }

    private List<SqmTypedNode<?>> getFunctionArguments(HqlParser.GenericFunctionContext ctx) {
        if (ctx.genericFunctionArguments() != null) {
            List node = (List)ctx.genericFunctionArguments().accept(this);
            return node;
        }
        if (ctx.ASTERISK() != null) {
            return Collections.singletonList(new SqmStar(this.getCreationContext().getNodeBuilder()));
        }
        return Collections.emptyList();
    }

    @Override
    public Object visitListaggFunction(HqlParser.ListaggFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [listagg], but strict JPA compliance was requested; use FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor("listagg");
        if (functionTemplate == null) {
            throw new SemanticException("The listagg() function was not registered for the dialect", this.query);
        }
        return this.applyOverClause(ctx.overClause(), functionTemplate.generateOrderedSetAggregateSqmExpression(this.getListaggArguments(ctx), this.getFilterExpression(ctx), ctx.withinGroupClause() == null ? null : this.visitOrderByClause(ctx.withinGroupClause().orderByClause(), false), null, this.queryEngine()));
    }

    private List<SqmTypedNode<?>> getListaggArguments(HqlParser.ListaggFunctionContext ctx) {
        SqmExpression firstArgument = (SqmExpression)ctx.expressionOrPredicate(0).accept(this);
        SqmExpression secondArgument = (SqmExpression)ctx.expressionOrPredicate(1).accept(this);
        HqlParser.OnOverflowClauseContext overflowCtx = ctx.onOverflowClause();
        ArrayList functionArguments = new ArrayList(3);
        if (ctx.DISTINCT() != null) {
            functionArguments.add(new SqmDistinct(firstArgument, this.nodeBuilder()));
        } else {
            functionArguments.add(firstArgument);
        }
        if (overflowCtx != null) {
            if (overflowCtx.ERROR() != null) {
                functionArguments.add(new SqmOverflow(secondArgument, null, false));
            } else {
                SqmLiteral<String> fillerExpression = overflowCtx.expression() != null ? (SqmLiteral<String>)overflowCtx.expression().accept(this) : new SqmLiteral<String>("...", this.resolveExpressibleTypeBasic(String.class), secondArgument.nodeBuilder());
                boolean withCount = overflowCtx.WITH() != null;
                functionArguments.add(new SqmOverflow<String>(secondArgument, fillerExpression, withCount));
            }
        } else {
            functionArguments.add(secondArgument);
        }
        return functionArguments;
    }

    @Override
    public List<SqmTypedNode<?>> visitGenericFunctionArguments(HqlParser.GenericFunctionArgumentsContext ctx) {
        List<HqlParser.ExpressionOrPredicateContext> argumentContexts = ctx.expressionOrPredicate();
        int count = argumentContexts.size();
        ArrayList arguments = new ArrayList(count + 1);
        HqlParser.DatetimeFieldContext datetimeFieldContext = ctx.datetimeField();
        if (datetimeFieldContext != null) {
            arguments.add(this.toDurationUnit((SqmExtractUnit)datetimeFieldContext.accept(this)));
        }
        for (int i = 0; i < count - 1; ++i) {
            HqlParser.ExpressionOrPredicateContext argumentContext = argumentContexts.get(i);
            arguments.add((SqmTypedNode)argumentContext.accept(this));
        }
        HqlParser.ExpressionOrPredicateContext argumentContext = argumentContexts.get(count - 1);
        arguments.add(this.visitFinalFunctionArgument(argumentContext));
        if (ctx.DISTINCT() != null) {
            NodeBuilder nodeBuilder = this.getCreationContext().getNodeBuilder();
            if (arguments.size() == 1) {
                arguments.set(0, new SqmDistinct((SqmExpression)arguments.get(0), nodeBuilder));
            } else {
                ArrayList newArguments = new ArrayList(1);
                ArrayList expressions = arguments;
                newArguments.add(new SqmDistinct(new SqmTuple(expressions, nodeBuilder), nodeBuilder));
                return newArguments;
            }
        }
        return arguments;
    }

    private SqmExpression<?> visitFinalFunctionArgument(ParseTree expression) {
        this.parameterDeclarationContextStack.push(() -> !this.creationOptions.useStrictJpaCompliance());
        try {
            SqmExpression sqmExpression = (SqmExpression)expression.accept(this);
            return sqmExpression;
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
    }

    private SqmFunctionDescriptor getFunctionDescriptor(String name) {
        return this.queryEngine().getSqmFunctionRegistry().findFunctionDescriptor(name);
    }

    private SqmSetReturningFunctionDescriptor getSetReturningFunctionDescriptor(String name) {
        return this.queryEngine().getSqmFunctionRegistry().findSetReturningFunctionDescriptor(name);
    }

    @Override
    public SqmExtractUnit<?> visitDatetimeField(HqlParser.DatetimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.nodeBuilder();
        Token symbol = ((TerminalNode)ctx.getChild(0)).getSymbol();
        return switch (symbol.getType()) {
            case 79 -> new SqmExtractUnit<Integer>(TemporalUnit.DAY, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 162 -> new SqmExtractUnit<Integer>(TemporalUnit.MONTH, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 247 -> new SqmExtractUnit<Integer>(TemporalUnit.YEAR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 112 -> new SqmExtractUnit<Integer>(TemporalUnit.HOUR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 161 -> new SqmExtractUnit<Integer>(TemporalUnit.MINUTE, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 203 -> new SqmExtractUnit<Float>(TemporalUnit.SECOND, this.resolveExpressibleTypeBasic(Float.class), nodeBuilder);
            case 164 -> new SqmExtractUnit<Long>(TemporalUnit.NANOSECOND, this.resolveExpressibleTypeBasic(Long.class), nodeBuilder);
            case 231 -> new SqmExtractUnit<Integer>(TemporalUnit.WEEK, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 194 -> new SqmExtractUnit<Integer>(TemporalUnit.QUARTER, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 92 -> new SqmExtractUnit<Long>(TemporalUnit.EPOCH, this.resolveExpressibleTypeBasic(Long.class), nodeBuilder);
            default -> throw new ParsingException("Unsupported datetime field [" + ctx.getText() + "]");
        };
    }

    @Override
    public Object visitDayField(HqlParser.DayFieldContext ctx) {
        NodeBuilder nodeBuilder = this.nodeBuilder();
        Token symbol = ((TerminalNode)ctx.getChild(2)).getSymbol();
        return switch (symbol.getType()) {
            case 162 -> new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_MONTH, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 231 -> new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_WEEK, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 247 -> new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_YEAR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            default -> throw new ParsingException("Unsupported day field [" + ctx.getText() + "]");
        };
    }

    @Override
    public Object visitWeekField(HqlParser.WeekFieldContext ctx) {
        NodeBuilder nodeBuilder = this.nodeBuilder();
        Token symbol = ((TerminalNode)ctx.getChild(2)).getSymbol();
        return switch (symbol.getType()) {
            case 162 -> new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_MONTH, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 247 -> new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_YEAR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            default -> throw new ParsingException("Unsupported week field [" + ctx.getText() + "]");
        };
    }

    @Override
    public Object visitDateOrTimeField(HqlParser.DateOrTimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.nodeBuilder();
        Token symbol = ((TerminalNode)ctx.getChild(0)).getSymbol();
        return switch (symbol.getType()) {
            case 77 -> {
                if (this.isExtractingJdbcTemporalType) {
                    yield new SqmExtractUnit<Date>(TemporalUnit.DATE, this.resolveExpressibleTypeBasic(Date.class), nodeBuilder);
                }
                yield new SqmExtractUnit<LocalDate>(TemporalUnit.DATE, this.resolveExpressibleTypeBasic(LocalDate.class), nodeBuilder);
            }
            case 212 -> {
                if (this.isExtractingJdbcTemporalType) {
                    yield new SqmExtractUnit<Time>(TemporalUnit.TIME, this.resolveExpressibleTypeBasic(Time.class), nodeBuilder);
                }
                yield new SqmExtractUnit<LocalTime>(TemporalUnit.TIME, this.resolveExpressibleTypeBasic(LocalTime.class), nodeBuilder);
            }
            default -> throw new ParsingException("Unsupported date or time field [" + ctx.getText() + "]");
        };
    }

    @Override
    public Object visitTimeZoneField(HqlParser.TimeZoneFieldContext ctx) {
        NodeBuilder nodeBuilder = this.nodeBuilder();
        Token symbol = ((TerminalNode)ctx.getChild(ctx.getChildCount() - 1)).getSymbol();
        return switch (symbol.getType()) {
            case 112, 214 -> new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_HOUR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 161, 215 -> new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_MINUTE, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            case 174 -> new SqmExtractUnit<ZoneOffset>(TemporalUnit.OFFSET, this.resolveExpressibleTypeBasic(ZoneOffset.class), nodeBuilder);
            default -> throw new ParsingException("Unsupported time zone field [" + ctx.getText() + "]");
        };
    }

    @Override
    public Object visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        SqmExtractUnit extractFieldExpression = ctx.extractField() != null ? (SqmExtractUnit)ctx.extractField().accept(this) : (SqmExtractUnit)ctx.datetimeField().accept(this);
        SqmExpression expressionToExtract = (SqmExpression)ctx.expression().accept(this);
        this.isExtractingJdbcTemporalType = TypeConfiguration.isJdbcTemporalType(expressionToExtract.getNodeType());
        return this.getFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(extractFieldExpression, expressionToExtract), extractFieldExpression.getType(), this.queryEngine());
    }

    @Override
    public Object visitTruncFunction(HqlParser.TruncFunctionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression(0).accept(this);
        SqmTypedNode secondArg = ctx.expression().size() > 1 ? (SqmTypedNode)ctx.expression(1).accept(this) : (ctx.datetimeField() != null ? (SqmTypedNode)ctx.datetimeField().accept(this) : null);
        return this.getFunctionDescriptor("trunc").generateSqmExpression(secondArg == null ? Collections.singletonList(expression) : Arrays.asList(expression, secondArg), null, this.queryEngine());
    }

    @Override
    public Object visitFormat(HqlParser.FormatContext ctx) {
        String format = QuotingHelper.unquoteStringLiteral(ctx.STRING_LITERAL().getText());
        return new SqmFormat(format, (SqmBindableType<String>)this.resolveExpressibleTypeBasic(String.class), this.nodeBuilder());
    }

    @Override
    public SqmExpression<?> visitFormatFunction(HqlParser.FormatFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.expression().accept(this);
        SqmLiteral format = (SqmLiteral)ctx.format().accept(this);
        return this.getFunctionDescriptor("format").generateSqmExpression(Arrays.asList(expressionToCast, format), null, this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitCastFunction(HqlParser.CastFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.expression().accept(this);
        SqmCastTarget castTargetExpression = (SqmCastTarget)ctx.castTarget().accept(this);
        return this.getFunctionDescriptor("cast").generateSqmExpression((List<? extends SqmTypedNode<?>>)Arrays.asList(expressionToCast, castTargetExpression), castTargetExpression.getType(), this.queryEngine());
    }

    @Override
    public SqmCastTarget<?> visitCastTarget(HqlParser.CastTargetContext castTargetContext) {
        HqlParser.CastTargetTypeContext castTargetTypeContext = castTargetContext.castTargetType();
        String targetName = castTargetTypeContext.fullTargetName;
        TerminalNode firstArg = castTargetContext.INTEGER_LITERAL(0);
        TerminalNode secondArg = castTargetContext.INTEGER_LITERAL(1);
        Long length = firstArg == null ? null : Long.valueOf(firstArg.getText());
        Integer precision = firstArg == null ? null : Integer.valueOf(firstArg.getText());
        Integer scale = secondArg == null ? null : Integer.valueOf(secondArg.getText());
        return new SqmCastTarget(this.creationContext.getTypeConfiguration().resolveCastTargetType(targetName), length, precision, scale, this.nodeBuilder());
    }

    @Override
    public Object visitPositionFunction(HqlParser.PositionFunctionContext ctx) {
        SqmExpression patternOrElement = (SqmExpression)ctx.positionFunctionPatternArgument().accept(this);
        SqmExpression stringOrArray = (SqmExpression)ctx.positionFunctionStringArgument().accept(this);
        SqmBindableType stringOrArrayExpressible = stringOrArray.getExpressible();
        if (stringOrArrayExpressible != null && stringOrArrayExpressible.getSqmType() instanceof BasicPluralType) {
            return this.getFunctionDescriptor("array_position").generateSqmExpression(Arrays.asList(stringOrArray, patternOrElement), null, this.queryEngine());
        }
        return this.getFunctionDescriptor("position").generateSqmExpression(Arrays.asList(patternOrElement, stringOrArray), null, this.queryEngine());
    }

    @Override
    public Object visitOverlayFunction(HqlParser.OverlayFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.overlayFunctionStringArgument().accept(this);
        SqmExpression replacement = (SqmExpression)ctx.overlayFunctionReplacementArgument().accept(this);
        SqmExpression start = (SqmExpression)ctx.overlayFunctionStartArgument().accept(this);
        SqmExpression length = ctx.overlayFunctionLengthArgument() != null ? (SqmExpression)ctx.overlayFunctionLengthArgument().accept(this) : null;
        return this.getFunctionDescriptor("overlay").generateSqmExpression(length == null ? Arrays.asList(string, replacement, start) : Arrays.asList(string, replacement, start, length), null, this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitEveryFunction(HqlParser.EveryFunctionContext ctx) {
        if (ctx.subquery() != null) {
            SqmSubQuery subquery = (SqmSubQuery)ctx.subquery().accept(this);
            return new SqmEvery(subquery, this.nodeBuilder());
        }
        if (ctx.predicate() != null) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.FUNCTION_CALL);
            }
            SqmExpression argument = (SqmExpression)ctx.predicate().accept(this);
            return this.applyOverClause(ctx.overClause(), this.getFunctionDescriptor("every").generateAggregateSqmExpression(Collections.singletonList(argument), this.getFilterExpression(ctx), this.resolveExpressibleTypeBasic(Boolean.class), this.queryEngine()));
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmEvery(this.createCollectionReferenceSubQuery(ctx.simplePath(), (TerminalNode)ctx.collectionQuantifier().getChild(0).getChild(0)), this.nodeBuilder());
    }

    @Override
    public SqmExpression<?> visitAnyFunction(HqlParser.AnyFunctionContext ctx) {
        if (ctx.subquery() != null) {
            SqmSubQuery subquery = (SqmSubQuery)ctx.subquery().accept(this);
            return new SqmAny(subquery, this.nodeBuilder());
        }
        if (ctx.predicate() != null) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.FUNCTION_CALL);
            }
            SqmExpression argument = (SqmExpression)ctx.predicate().accept(this);
            return this.applyOverClause(ctx.overClause(), this.getFunctionDescriptor("any").generateAggregateSqmExpression(Collections.singletonList(argument), this.getFilterExpression(ctx), this.resolveExpressibleTypeBasic(Boolean.class), this.queryEngine()));
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmAny(this.createCollectionReferenceSubQuery(ctx.simplePath(), (TerminalNode)ctx.collectionQuantifier().getChild(0).getChild(0)), this.nodeBuilder());
    }

    private <X> SqmSubQuery<X> createCollectionReferenceSubQuery(HqlParser.SimplePathContext pathCtx, TerminalNode collectionReferenceCtx) {
        SqmCorrelation correlation;
        SqmPath<?> pluralAttributePath = this.consumeDomainPath(pathCtx);
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new SemanticException("Path is not a plural path '" + String.valueOf(pluralAttributePath.getNavigablePath()) + "'", this.query);
        }
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.nodeBuilder());
        SqmSelectClause selectClause = new SqmSelectClause(false, 1, this.nodeBuilder());
        SqmFromClause fromClause = new SqmFromClause(1);
        JpaPath lhs = pluralAttributePath.getLhs();
        ArrayList<String> implicitJoinPaths = new ArrayList<String>();
        while (true) {
            if (lhs instanceof AbstractSqmFrom) break;
            implicitJoinPaths.add(lhs.getNavigablePath().getLocalName());
            lhs = lhs.getLhs();
        }
        AbstractSqmFrom correlationBase = (AbstractSqmFrom)lhs;
        JpaFrom<Object, Object> joinBase = correlation = correlationBase.createCorrelation();
        for (int i = implicitJoinPaths.size() - 1; i >= 0; --i) {
            joinBase = joinBase.join((String)implicitJoinPaths.get(i));
        }
        JpaJoin collectionJoin = joinBase.join(pluralAttributePath.getNavigablePath().getLocalName());
        fromClause.addRoot(correlation.getCorrelatedRoot());
        if (collectionReferenceCtx == null) {
            SqmLiteral<Integer> literal = new SqmLiteral<Integer>(1, this.nodeBuilder().getIntegerType(), this.nodeBuilder());
            subQuery.applyInferableType(literal.getNodeType());
            selectClause.setSelection(literal);
        } else {
            String partName = switch (collectionReferenceCtx.getSymbol().getType()) {
                case 87 -> CollectionPart.Nature.ELEMENT.getName();
                case 118 -> CollectionPart.Nature.INDEX.getName();
                default -> throw new ParsingException("Unexpected collection reference: " + collectionReferenceCtx.getText());
            };
            SemanticPathPart path = collectionJoin.resolvePathPart(partName, true, this);
            subQuery.applyInferableType(path.getNodeType());
            selectClause.setSelection((SqmSelectableNode<?>)((Object)path));
        }
        JpaQueryStructure querySpec = subQuery.getQuerySpec();
        ((SqmQuerySpec)querySpec).setFromClause(fromClause);
        ((SqmQuerySpec)querySpec).setSelectClause(selectClause);
        return subQuery;
    }

    private SqmPredicate getFilterExpression(ParseTree functionCtx) {
        for (int i = functionCtx.getChildCount() - 2; i < functionCtx.getChildCount(); ++i) {
            ParseTree child = functionCtx.getChild(i);
            if (!(child instanceof HqlParser.FilterClauseContext)) continue;
            return (SqmPredicate)child.getChild(2).getChild(1).accept(this);
        }
        return null;
    }

    private SqmExpression<?> applyOverClause(HqlParser.OverClauseContext ctx, SqmFunction<?> function) {
        FrameExclusion exclusion;
        SqmExpression startExpression;
        FrameKind startKind;
        SqmExpression endExpression;
        FrameKind endKind;
        FrameMode mode;
        List<SqmExpression<?>> partitions;
        if (ctx == null) {
            return function;
        }
        if (ctx.partitionClause() != null) {
            HqlParser.PartitionClauseContext partitionClause = ctx.partitionClause();
            partitions = new ArrayList((partitionClause.getChildCount() >> 1) - 1);
            for (int i = 2; i < partitionClause.getChildCount(); i += 2) {
                partitions.add((SqmExpression)partitionClause.getChild(i).accept(this));
            }
        } else {
            partitions = Collections.emptyList();
        }
        List<SqmSortSpecification> orderList = ctx.orderByClause() != null ? this.visitOrderByClause(ctx.orderByClause(), false).getSortSpecifications() : Collections.emptyList();
        HqlParser.FrameClauseContext frameClause = ctx.frameClause();
        if (frameClause != null) {
            int frameStartIndex;
            Token symbol = ((TerminalNode)frameClause.getChild(0)).getSymbol();
            mode = switch (symbol.getType()) {
                case 195 -> FrameMode.RANGE;
                case 201 -> FrameMode.ROWS;
                case 110 -> FrameMode.GROUPS;
                default -> throw new IllegalArgumentException("Unexpected frame mode: " + String.valueOf(frameClause.getChild(0)));
            };
            if (frameClause.getChild(1) instanceof TerminalNode) {
                frameStartIndex = 2;
                endKind = this.getFrameKind(frameClause.getChild(4));
                endExpression = endKind == FrameKind.OFFSET_FOLLOWING || endKind == FrameKind.OFFSET_PRECEDING ? (SqmExpression)frameClause.getChild(4).getChild(0).accept(this) : null;
            } else {
                frameStartIndex = 1;
                endKind = FrameKind.CURRENT_ROW;
                endExpression = null;
            }
            startKind = this.getFrameKind(frameClause.getChild(frameStartIndex));
            startExpression = startKind == FrameKind.OFFSET_FOLLOWING || startKind == FrameKind.OFFSET_PRECEDING ? (SqmExpression)frameClause.getChild(frameStartIndex).getChild(0).accept(this) : null;
            ParseTree lastChild = frameClause.getChild(frameClause.getChildCount() - 1);
            if (lastChild instanceof HqlParser.FrameExclusionContext) {
                Token token = ((TerminalNode)lastChild.getChild(1)).getSymbol();
                exclusion = switch (token.getType()) {
                    case 71 -> FrameExclusion.CURRENT_ROW;
                    case 109 -> FrameExclusion.GROUP;
                    case 211 -> FrameExclusion.TIES;
                    case 168 -> FrameExclusion.NO_OTHERS;
                    default -> throw new IllegalArgumentException("Unexpected frame exclusion: " + String.valueOf(lastChild));
                };
            } else {
                exclusion = FrameExclusion.NO_OTHERS;
            }
        } else {
            mode = FrameMode.RANGE;
            startKind = FrameKind.UNBOUNDED_PRECEDING;
            startExpression = null;
            endKind = FrameKind.CURRENT_ROW;
            endExpression = null;
            exclusion = FrameExclusion.NO_OTHERS;
        }
        return new SqmOver(function, partitions, orderList, mode, startKind, startExpression, endKind, endExpression, exclusion);
    }

    private FrameKind getFrameKind(ParseTree child) {
        Token symbol = ((TerminalNode)child.getChild(1)).getSymbol();
        return switch (symbol.getType()) {
            case 193 -> {
                if (child.getChild(0) instanceof TerminalNode) {
                    yield FrameKind.UNBOUNDED_PRECEDING;
                }
                yield FrameKind.OFFSET_PRECEDING;
            }
            case 103 -> {
                if (child.getChild(0) instanceof TerminalNode) {
                    yield FrameKind.UNBOUNDED_FOLLOWING;
                }
                yield FrameKind.OFFSET_FOLLOWING;
            }
            case 200 -> FrameKind.CURRENT_ROW;
            default -> throw new IllegalArgumentException("Illegal frame kind: " + String.valueOf(child));
        };
    }

    @Override
    public SqmExpression<?> visitCube(HqlParser.CubeContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.CUBE, this.visitExpressions(ctx), this.nodeBuilder());
    }

    @Override
    public SqmExpression<?> visitRollup(HqlParser.RollupContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.ROLLUP, this.visitExpressions(ctx), this.nodeBuilder());
    }

    @Override
    public SqmExpression<?> visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmExpression start = (SqmExpression)ctx.substringFunctionStartArgument().accept(this);
        SqmExpression length = ctx.substringFunctionLengthArgument() != null ? (SqmExpression)ctx.substringFunctionLengthArgument().accept(this) : null;
        return this.getFunctionDescriptor("substring").generateSqmExpression(length == null ? Arrays.asList(source, start) : Arrays.asList(source, start, length), null, this.queryEngine());
    }

    @Override
    public SqmExpression<?> visitPadFunction(HqlParser.PadFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmExpression length = (SqmExpression)ctx.padLength().accept(this);
        SqmTrimSpecification padSpec = this.visitPadSpecification(ctx.padSpecification());
        Object padChar = ctx.padCharacter() != null ? this.visitPadCharacter(ctx.padCharacter()) : null;
        return this.getFunctionDescriptor("pad").generateSqmExpression(padChar != null ? Arrays.asList(source, length, padSpec, padChar) : Arrays.asList(source, length, padSpec), null, this.queryEngine());
    }

    @Override
    public SqmTrimSpecification visitPadSpecification(HqlParser.PadSpecificationContext ctx) {
        Token symbol = ((TerminalNode)ctx.getChild(0)).getSymbol();
        return switch (symbol.getType()) {
            case 140 -> new SqmTrimSpecification(TrimSpec.LEADING, this.nodeBuilder());
            case 217 -> new SqmTrimSpecification(TrimSpec.TRAILING, this.nodeBuilder());
            default -> throw new ParsingException("Unsupported pad specification [" + ctx.getText() + "]");
        };
    }

    @Override
    public SqmLiteral<Character> visitPadCharacter(HqlParser.PadCharacterContext ctx) {
        String padCharText = ctx.STRING_LITERAL().getText();
        if (padCharText.length() != 3) {
            throw new SemanticException("Pad character for pad() function must be single character, found '" + padCharText + "'", this.query);
        }
        return new SqmLiteral<Character>(Character.valueOf(padCharText.charAt(1)), this.resolveExpressibleTypeBasic(Character.class), this.nodeBuilder());
    }

    @Override
    public SqmExpression<?> visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmTrimSpecification trimSpec = this.visitTrimSpecification(ctx.trimSpecification());
        Object trimChar = this.visitTrimCharacter(ctx.trimCharacter());
        return this.getFunctionDescriptor("trim").generateSqmExpression(Arrays.asList(trimSpec, trimChar, source), null, this.queryEngine());
    }

    @Override
    public SqmTrimSpecification visitTrimSpecification(HqlParser.TrimSpecificationContext ctx) {
        TrimSpec spec = ctx != null ? SemanticQueryBuilder.trimSpec(ctx) : TrimSpec.BOTH;
        return new SqmTrimSpecification(spec, this.nodeBuilder());
    }

    private static TrimSpec trimSpec(HqlParser.TrimSpecificationContext ctx) {
        Token symbol = ((TerminalNode)ctx.getChild(0)).getSymbol();
        return switch (symbol.getType()) {
            case 140 -> TrimSpec.LEADING;
            case 217 -> TrimSpec.TRAILING;
            case 56 -> TrimSpec.BOTH;
            default -> throw new ParsingException("Unrecognized trim specification");
        };
    }

    @Override
    public SqmExpression<Character> visitTrimCharacter(HqlParser.TrimCharacterContext ctx) {
        String trimCharText;
        if (ctx == null) {
            trimCharText = " ";
        } else {
            ParseTree child = ctx.getChild(0);
            if (child instanceof HqlParser.ParameterContext) {
                return (SqmExpression)child.accept(this);
            }
            trimCharText = QuotingHelper.unquoteStringLiteral(ctx.getText());
            if (trimCharText.length() != 1) {
                throw new SemanticException("Trim character for trim() function must be single character, found '" + trimCharText + "'", this.query);
            }
        }
        return new SqmLiteral<Character>(Character.valueOf(trimCharText.charAt(0)), this.resolveExpressibleTypeBasic(Character.class), this.nodeBuilder());
    }

    @Override
    public SqmCollectionSize visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx) {
        return new SqmCollectionSize(this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2)), this.resolveExpressibleTypeBasic(Integer.class), this.nodeBuilder());
    }

    private boolean isIndexedPluralAttribute(SqmPath<?> path) {
        return path.getReferencedPathSource() instanceof PluralPersistentAttribute;
    }

    @Override
    public SqmPath<?> visitCollectionFunctionMisuse(HqlParser.CollectionFunctionMisuseContext ctx) {
        log.warn("Misuse of HQL elements() or indices() function, use element() or index() instead");
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath<?> pluralAttributePath = this.consumeDomainPath(ctx.path());
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        TerminalNode firstNode = (TerminalNode)ctx.getChild(0).getChild(0);
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new FunctionArgumentException(String.format("Argument '%s' of '%s()' function is not a plural path ", pluralAttributePath.getNavigablePath(), firstNode.getSymbol().getText()));
        }
        CollectionPart.Nature nature = switch (firstNode.getSymbol().getType()) {
            case 87 -> CollectionPart.Nature.ELEMENT;
            case 118 -> CollectionPart.Nature.INDEX;
            default -> throw new ParsingException("Impossible symbol");
        };
        return pluralAttributePath.resolvePathPart(nature.getName(), true, this);
    }

    @Override
    public SqmExpression<?> visitElementAggregateFunction(HqlParser.ElementAggregateFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        String functionName = ctx.getChild(0).getText().substring(0, 3);
        SqmPath<?> pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (pluralPath instanceof SqmPluralValuedSimplePath) {
            return new SqmElementAggregateFunction(pluralPath, functionName);
        }
        if (pluralPath instanceof SqmMapJoin) {
            throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' resolved to a joined map instead of a compound path");
        }
        if (pluralPath instanceof SqmListJoin) {
            throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' resolved to a joined list instead of a compound path");
        }
        throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' did not resolve to a many-valued attribute");
    }

    @Override
    public SqmExpression<?> visitIndexAggregateFunction(HqlParser.IndexAggregateFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        String functionName = ctx.getChild(0).getText().substring(0, 3);
        SqmPath<?> pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (pluralPath instanceof SqmPluralValuedSimplePath) {
            if (this.isIndexedPluralAttribute(pluralPath)) {
                return new SqmIndexAggregateFunction(pluralPath, functionName);
            }
            throw new FunctionArgumentException("Path '" + String.valueOf(ctx.path()) + "' resolved to '" + String.valueOf(pluralPath.getReferencedPathSource()) + "' which is not an indexed collection");
        }
        if (pluralPath instanceof SqmMapJoin) {
            throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' resolved to a joined map instead of a compound path");
        }
        if (pluralPath instanceof SqmListJoin) {
            throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' resolved to a joined list instead of a compound path");
        }
        throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' did not resolve to a many-valued attribute");
    }

    @Override
    public SqmSubQuery<?> visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx) {
        return this.visitSubquery((HqlParser.SubqueryContext)ctx.getChild(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSubQuery<?> visitSubquery(HqlParser.SubqueryContext ctx) {
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.nodeBuilder());
        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), subQuery, this));
        try {
            SqmBindableType expressible;
            queryExpressionContext.accept(this);
            List<SqmSelection<?>> selections = ((SqmQuerySpec)subQuery.getQuerySpec()).getSelectClause().getSelections();
            if (selections.size() == 1 && (expressible = selections.get(0).getExpressible()) != null) {
                subQuery.applyInferableType(expressible.getSqmType());
            }
            SqmSubQuery sqmSubQuery = subQuery;
            return sqmSubQuery;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    @Override
    public SemanticPathPart visitPath(HqlParser.PathContext ctx) {
        HqlParser.SyntacticDomainPathContext syntacticDomainPath = ctx.syntacticDomainPath();
        HqlParser.GeneralPathFragmentContext generalPathFragment = ctx.generalPathFragment();
        if (syntacticDomainPath != null) {
            return this.visitPathContinuation(this.visitSyntacticDomainPath(syntacticDomainPath), ctx.pathContinuation());
        }
        if (generalPathFragment != null) {
            return (SemanticPathPart)generalPathFragment.accept(this);
        }
        throw new ParsingException("Illegal path '" + ctx.getText() + "'");
    }

    @Override
    public SemanticPathPart visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        return this.visitIndexedPathAccessFragment(this.visitSimplePath(ctx.simplePath()), ctx.indexedPathAccessFragment());
    }

    @Override
    public SemanticPathPart visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx) {
        if (ctx.treatedNavigablePath() != null) {
            return this.visitTreatedNavigablePath(ctx.treatedNavigablePath());
        }
        if (ctx.collectionValueNavigablePath() != null) {
            return this.visitCollectionValueNavigablePath(ctx.collectionValueNavigablePath());
        }
        if (ctx.mapKeyNavigablePath() != null) {
            return this.visitMapKeyNavigablePath(ctx.mapKeyNavigablePath());
        }
        if (ctx.toOneFkReference() != null) {
            return this.visitToOneFkReference(ctx.toOneFkReference());
        }
        if (ctx.function() != null) {
            HqlParser.SlicedPathAccessFragmentContext slicedFragmentsCtx = ctx.slicedPathAccessFragment();
            if (slicedFragmentsCtx != null) {
                List<HqlParser.ExpressionContext> slicedFragments = slicedFragmentsCtx.expression();
                return this.getFunctionDescriptor("array_slice").generateSqmExpression(List.of((SqmTypedNode)this.visitFunction(ctx.function()), (SqmTypedNode)slicedFragments.get(0).accept(this), (SqmTypedNode)slicedFragments.get(1).accept(this)), null, this.queryEngine());
            }
            return this.visitPathContinuation(this.visitIndexedPathAccessFragment((SemanticPathPart)this.visitFunction(ctx.function()), ctx.indexedPathAccessFragment()), ctx.pathContinuation());
        }
        if (ctx.simplePath() != null && ctx.indexedPathAccessFragment() != null) {
            return this.visitIndexedPathAccessFragment(this.visitSimplePath(ctx.simplePath()), ctx.indexedPathAccessFragment());
        }
        if (ctx.simplePath() != null && ctx.slicedPathAccessFragment() != null) {
            List<HqlParser.ExpressionContext> slicedFragments = ctx.slicedPathAccessFragment().expression();
            SqmTypedNode lhs = (SqmTypedNode)((Object)this.visitSimplePath(ctx.simplePath()));
            SqmBindableType lhsExpressible = lhs.getExpressible();
            if (lhsExpressible == null) {
                throw new SemanticException("Slice operator applied to expression of unknown type", this.query);
            }
            if (lhsExpressible.getSqmType() instanceof BasicPluralType) {
                return this.getFunctionDescriptor("array_slice").generateSqmExpression(List.of(lhs, (SqmTypedNode)slicedFragments.get(0).accept(this), (SqmTypedNode)slicedFragments.get(1).accept(this)), null, this.queryEngine());
            }
            if (lhsExpressible.getRelationalJavaType() instanceof StringJavaType && !(lhs instanceof SqmPluralValuedSimplePath)) {
                SqmExpression start = (SqmExpression)slicedFragments.get(0).accept(this);
                SqmExpression end = (SqmExpression)slicedFragments.get(1).accept(this);
                return this.getFunctionDescriptor("substring").generateSqmExpression(List.of(lhs, start, new SqmBinaryArithmetic(BinaryArithmeticOperator.ADD, new SqmBinaryArithmetic(BinaryArithmeticOperator.SUBTRACT, end, start, this.nodeBuilder()), new SqmLiteral<Integer>(1, this.nodeBuilder().getIntegerType(), this.nodeBuilder()), this.nodeBuilder())), null, this.queryEngine());
            }
            throw new SemanticException("Slice operator applied to expression which is not a string or SQL array", this.query);
        }
        throw new ParsingException("Illegal domain path '" + ctx.getText() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemanticPathPart visitIndexedPathAccessFragment(SemanticPathPart pathPart, HqlParser.IndexedPathAccessFragmentContext idxCtx) {
        if (idxCtx == null) {
            return pathPart;
        }
        SqmExpression indexExpression = (SqmExpression)idxCtx.expression().accept(this);
        boolean hasIndexContinuation = idxCtx.DOT() != null;
        SqmPath<?> indexedPath = pathPart.resolveIndexedAccess(indexExpression, !hasIndexContinuation, this);
        if (hasIndexContinuation) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(indexedPath, this){

                @Override
                protected void reset() {
                }
            });
            try {
                SemanticPathPart semanticPathPart = (SemanticPathPart)idxCtx.generalPathFragment().accept(this);
                return semanticPathPart;
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        return indexedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemanticPathPart visitPathContinuation(SemanticPathPart pathPart, HqlParser.PathContinuationContext pathContinuation) {
        if (pathContinuation == null) {
            return pathPart;
        }
        this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(pathPart, this){

            @Override
            protected void reset() {
            }
        });
        try {
            SemanticPathPart semanticPathPart = (SemanticPathPart)pathContinuation.simplePath().accept(this);
            return semanticPathPart;
        }
        finally {
            this.dotIdentifierConsumerStack.pop();
        }
    }

    @Override
    public SemanticPathPart visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext idxCtx) {
        throw new UnsupportedOperationException("Should be handled by #visitIndexedPathAccessFragment");
    }

    @Override
    public SemanticPathPart visitSimplePath(HqlParser.SimplePathContext ctx) {
        int numberOfContinuations = ctx.simplePathElement().size();
        DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
        HqlParser.IdentifierContext identifierContext = ctx.identifier();
        assert (identifierContext.getChildCount() == 1);
        dotIdentifierConsumer.consumeIdentifier(this.visitIdentifier(identifierContext), true, numberOfContinuations == 0);
        for (int i = 0; i < numberOfContinuations; ++i) {
            HqlParser.SimplePathElementContext continuation = ctx.simplePathElement(i);
            HqlParser.IdentifierContext identifier = continuation.identifier();
            assert (identifier.getChildCount() == 1);
            dotIdentifierConsumer.consumeIdentifier(this.visitIdentifier(identifier), false, i + 1 == numberOfContinuations);
        }
        return dotIdentifierConsumer.getConsumedPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        boolean madeNested;
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            boolean bl = madeNested = !qualifiedJoinPathConsumer.isNested();
            if (madeNested) {
                qualifiedJoinPathConsumer.setNested(true);
            }
        } else {
            madeNested = false;
        }
        this.consumeManagedTypeReference(ctx.path());
        String treatTargetName = ctx.simplePath().getText();
        String importableName = this.getJpaMetamodel().qualifyImportableName(treatTargetName);
        if (importableName == null) {
            throw new SemanticException("Could not resolve treat target type '" + treatTargetName + "'", this.query);
        }
        boolean hasContinuation = ctx.getChildCount() == 7;
        consumer.consumeTreat(importableName, !hasContinuation);
        SqmPath<?> result = (SqmPath<?>)consumer.getConsumedPart();
        if (hasContinuation) {
            boolean addConsumer;
            if (madeNested) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            boolean bl = addConsumer = !(consumer instanceof QualifiedJoinPathConsumer);
            if (addConsumer) {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                    @Override
                    protected void reset() {
                    }
                });
            }
            try {
                result = this.consumeDomainPath(ctx.pathContinuation().simplePath());
            }
            finally {
                if (addConsumer) {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitCollectionValueNavigablePath(HqlParser.CollectionValueNavigablePathContext ctx) {
        SqmPath<?> result;
        PluralPersistentAttribute attribute;
        boolean madeNested;
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            boolean bl = madeNested = !qualifiedJoinPathConsumer.isNested();
            if (madeNested) {
                qualifiedJoinPathConsumer.setNested(true);
            }
        } else {
            madeNested = false;
        }
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        boolean hasContinuation = ctx.getChildCount() == 5;
        SqmPathSource<?> referencedPathSource = sqmPath.getReferencedPathSource();
        TerminalNode firstNode = (TerminalNode)ctx.elementValueQuantifier().getChild(0);
        this.checkPluralPath(sqmPath, referencedPathSource, firstNode);
        if (this.getCreationOptions().useStrictJpaCompliance() && (attribute = (PluralPersistentAttribute)((Object)referencedPathSource)).getCollectionClassification() != CollectionClassification.MAP && firstNode.getSymbol().getType() == 229) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.VALUE_FUNCTION_ON_NON_MAP);
        }
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            if (madeNested && !hasContinuation) {
                qualifiedJoinPathConsumer.setNested(false);
            }
            consumer.consumeIdentifier(CollectionPart.Nature.ELEMENT.getName(), false, !hasContinuation);
            result = (SqmPath)consumer.getConsumedPart();
        } else {
            result = sqmPath.resolvePathPart(CollectionPart.Nature.ELEMENT.getName(), true, this);
        }
        if (hasContinuation) {
            if (madeNested) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            HqlParser.SimplePathContext identCtx = ctx.pathContinuation().simplePath();
            if (consumer instanceof QualifiedJoinPathConsumer) {
                result = this.consumeDomainPath(identCtx);
            } else {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    result = this.consumeDomainPath(identCtx);
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx) {
        SqmPath<?> result;
        PluralPersistentAttribute attribute;
        boolean madeNested;
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            boolean bl = madeNested = !qualifiedJoinPathConsumer.isNested();
            if (madeNested) {
                qualifiedJoinPathConsumer.setNested(true);
            }
        } else {
            madeNested = false;
        }
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        boolean hasContinuation = ctx.getChildCount() == 5;
        SqmPathSource<?> referencedPathSource = sqmPath.getReferencedPathSource();
        TerminalNode firstNode = (TerminalNode)ctx.indexKeyQuantifier().getChild(0);
        if (firstNode.getSymbol().getType() == 117 && referencedPathSource instanceof AnonymousTupleType) {
            AnonymousTupleType tupleType = (AnonymousTupleType)referencedPathSource;
            if (tupleType.findSubPathSource(CollectionPart.Nature.INDEX.getName()) == null) {
                throw new FunctionArgumentException(String.format("The set-returning from node '%s' does not specify an index/ordinality", sqmPath.getNavigablePath()));
            }
        } else {
            this.checkPluralPath(sqmPath, referencedPathSource, firstNode);
        }
        if (this.getCreationOptions().useStrictJpaCompliance() && (attribute = (PluralPersistentAttribute)((Object)referencedPathSource)).getCollectionClassification() != CollectionClassification.MAP && firstNode.getSymbol().getType() == 136) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.KEY_FUNCTION_ON_NON_MAP);
        }
        if (sqmPath instanceof SqmMapJoin) {
            SqmMapJoin sqmMapJoin = (SqmMapJoin)sqmPath;
            if (consumer instanceof QualifiedJoinPathConsumer) {
                QualifiedJoinPathConsumer pathConsumer = (QualifiedJoinPathConsumer)consumer;
                if (madeNested && !hasContinuation) {
                    pathConsumer.setNested(false);
                }
                consumer.consumeIdentifier(CollectionPart.Nature.INDEX.getName(), false, !hasContinuation);
                result = (SqmPath)consumer.getConsumedPart();
            } else {
                result = sqmMapJoin.key();
            }
        } else if (sqmPath instanceof SqmListJoin) {
            SqmListJoin listJoin = (SqmListJoin)sqmPath;
            if (hasContinuation) {
                throw new TerminalPathException("List index has no attributes");
            }
            result = listJoin.resolvePathPart(CollectionPart.Nature.INDEX.getName(), true, this);
        } else if (sqmPath instanceof SqmFunctionRoot) {
            SqmFunctionRoot functionRoot = (SqmFunctionRoot)sqmPath;
            if (hasContinuation) {
                throw new TerminalPathException("List index has no attributes");
            }
            result = functionRoot.index();
        } else if (sqmPath instanceof SqmFunctionJoin) {
            SqmFunctionJoin functionJoin = (SqmFunctionJoin)sqmPath;
            if (hasContinuation) {
                throw new TerminalPathException("List index has no attributes");
            }
            result = functionJoin.index();
        } else {
            assert (sqmPath instanceof SqmPluralValuedSimplePath);
            SqmPluralValuedSimplePath mapPath = (SqmPluralValuedSimplePath)sqmPath;
            result = mapPath.resolvePathPart(CollectionPart.Nature.INDEX.getName(), !hasContinuation, this);
        }
        if (hasContinuation) {
            if (madeNested) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            HqlParser.SimplePathContext identCtx = ctx.pathContinuation().simplePath();
            if (consumer instanceof QualifiedJoinPathConsumer) {
                result = this.consumeDomainPath(identCtx);
            } else {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    result = this.consumeDomainPath(identCtx);
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
        }
        return result;
    }

    private void checkPluralPath(SqmPath<?> pluralAttributePath, SqmPathSource<?> referencedPathSource, TerminalNode firstNode) {
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new FunctionArgumentException(String.format("Argument of '%s' is not a plural path '%s'", firstNode.getSymbol().getText(), pluralAttributePath.getNavigablePath()));
        }
    }

    private SqmPath<?> consumeDomainPath(HqlParser.PathContext parserPath) {
        SemanticPathPart consumedPart = (SemanticPathPart)parserPath.accept(this);
        if (consumedPart instanceof SqmPath) {
            SqmPath sqmPath = (SqmPath)consumedPart;
            return sqmPath;
        }
        throw new PathException("Expecting domain-model path, but found: " + String.valueOf(consumedPart));
    }

    private SqmPath<?> consumeDomainPath(HqlParser.SimplePathContext sequence) {
        SemanticPathPart consumedPart = (SemanticPathPart)sequence.accept(this);
        if (consumedPart instanceof SqmPath) {
            SqmPath sqmPath = (SqmPath)consumedPart;
            return sqmPath;
        }
        throw new PathException("Expecting domain-model path, but found: " + String.valueOf(consumedPart));
    }

    private SqmPath<?> consumeManagedTypeReference(HqlParser.PathContext parserPath) {
        SqmPath<?> sqmPath = this.consumeDomainPath(parserPath);
        SqmPathSource<?> pathSource = sqmPath.getReferencedPathSource();
        if (pathSource.getPathType() instanceof ManagedDomainType) {
            return sqmPath;
        }
        throw new PathException("Expecting ManagedType valued path [" + String.valueOf(sqmPath.getNavigablePath()) + "], but found: " + String.valueOf(pathSource.getPathType()));
    }

    private SqmPath<?> consumePluralAttributeReference(HqlParser.PathContext parserPath) {
        SqmPath<?> sqmPath = this.consumeDomainPath(parserPath);
        if (sqmPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return sqmPath;
        }
        throw new PathException("Expecting plural attribute valued path [" + String.valueOf(sqmPath.getNavigablePath()) + "], but found: " + String.valueOf(sqmPath.getReferencedPathSource().getPathType()));
    }

    private void checkFQNEntityNameJpaComplianceViolationIfNeeded(String name, EntityDomainType<?> entityDescriptor) {
        if (this.getCreationOptions().useStrictJpaCompliance() && !name.equals(entityDescriptor.getName())) {
            throw new StrictJpaComplianceViolation("Encountered FQN entity name [" + name + "], but strict JPQL compliance was requested ( [" + entityDescriptor.getName() + "] should be used instead )", StrictJpaComplianceViolation.Type.FQN_ENTITY_NAME);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ParameterStyle {
        UNKNOWN{

            @Override
            ParameterStyle withNamed() {
                return NAMED;
            }

            @Override
            ParameterStyle withPositional() {
                return POSITIONAL;
            }
        }
        ,
        NAMED{

            @Override
            ParameterStyle withNamed() {
                return NAMED;
            }

            @Override
            ParameterStyle withPositional() {
                throw new StrictJpaComplianceViolation("Cannot mix ordinal and named parameters", StrictJpaComplianceViolation.Type.MIXED_POSITIONAL_NAMED_PARAMETERS);
            }
        }
        ,
        POSITIONAL{

            @Override
            ParameterStyle withNamed() {
                throw new StrictJpaComplianceViolation("Cannot mix positional and named parameters", StrictJpaComplianceViolation.Type.MIXED_POSITIONAL_NAMED_PARAMETERS);
            }

            @Override
            ParameterStyle withPositional() {
                return POSITIONAL;
            }
        }
        ,
        MIXED{

            @Override
            ParameterStyle withNamed() {
                return MIXED;
            }

            @Override
            ParameterStyle withPositional() {
                return MIXED;
            }
        };


        abstract ParameterStyle withNamed();

        abstract ParameterStyle withPositional();
    }
}

