/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import org.hibernate.Internal;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.type.BindableType;

@Internal
public abstract class AbstractQueryParameter<T>
implements QueryParameterImplementor<T> {
    private boolean allowMultiValuedBinding;
    private BindableType<T> anticipatedType;

    public AbstractQueryParameter(boolean allowMultiValuedBinding, BindableType<T> anticipatedType) {
        this.allowMultiValuedBinding = allowMultiValuedBinding;
        this.anticipatedType = anticipatedType;
    }

    @Override
    public void disallowMultiValuedBinding() {
        QueryLogging.QUERY_MESSAGE_LOGGER.debugf("QueryParameter#disallowMultiValuedBinding() called: %s", (Object)this);
        this.allowMultiValuedBinding = true;
    }

    @Override
    public boolean allowsMultiValuedBinding() {
        return this.allowMultiValuedBinding;
    }

    @Override
    public BindableType<T> getHibernateType() {
        return this.anticipatedType;
    }

    @Override
    public void applyAnticipatedType(BindableType<?> type) {
        this.anticipatedType = type;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Integer getPosition() {
        return null;
    }

    @Override
    public Class<T> getParameterType() {
        return this.anticipatedType == null ? null : this.anticipatedType.getJavaType();
    }
}

