/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hibernate.Internal;
import org.hibernate.metamodel.model.domain.BagPersistentAttribute;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.SetPersistentAttribute;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaCrossJoin;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaDerivedJoin;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaFunctionJoin;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.JpaSetReturningFunction;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmBagPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmEntityDomainType;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmListPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSetPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmTreatedFrom;
import org.hibernate.query.sqm.tree.expression.SqmSetReturningFunction;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmCteJoin;
import org.hibernate.query.sqm.tree.from.SqmDerivedJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFunctionJoin;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.spi.NavigablePath;

public abstract class AbstractSqmFrom<O, T>
extends AbstractSqmPath<T>
implements SqmFrom<O, T> {
    private String alias;
    private List<SqmJoin<T, ?>> joins;
    private List<SqmTreatedFrom<?, ?, ?>> treats;
    private int aliasCounter = 0;

    protected AbstractSqmFrom(NavigablePath navigablePath, SqmPathSource<T> referencedNavigable, SqmFrom<?, ?> lhs, String alias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, lhs, nodeBuilder);
        if (lhs == null) {
            throw new IllegalArgumentException("LHS cannot be null");
        }
        this.alias = alias;
    }

    protected AbstractSqmFrom(EntityDomainType<T> entityType, String alias, NodeBuilder nodeBuilder) {
        super(SqmCreationHelper.buildRootNavigablePath(entityType.getHibernateEntityName(), alias), (SqmEntityDomainType)entityType, null, nodeBuilder);
        this.alias = alias;
    }

    protected AbstractSqmFrom(NavigablePath navigablePath, SqmPathSource<T> entityType, String alias, NodeBuilder nodeBuilder) {
        super(navigablePath, entityType, null, nodeBuilder);
        this.alias = alias;
    }

    protected AbstractSqmFrom(NavigablePath navigablePath, SqmPathSource<T> referencedNavigable, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, null, nodeBuilder);
    }

    protected void copyTo(AbstractSqmFrom<O, T> target, SqmCopyContext context) {
        super.copyTo(target, context);
        if (this.joins != null) {
            target.joins = new ArrayList(this.joins.size());
            for (SqmJoin sqmJoin : this.joins) {
                target.joins.add((SqmJoin<T, ?>)sqmJoin.copy(context));
            }
        }
        if (this.treats != null) {
            target.treats = new ArrayList(this.treats.size());
            for (SqmTreatedFrom sqmTreatedFrom : this.treats) {
                target.treats.add((SqmTreatedFrom<?, ?, ?>)sqmTreatedFrom.copy(context));
            }
        }
    }

    @Override
    public String getExplicitAlias() {
        return this.alias;
    }

    @Override
    public void setExplicitAlias(String explicitAlias) {
        this.alias = explicitAlias;
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmJoin<T, ?> resolvedPath = null;
        for (SqmJoin<T, ?> sqmJoin : this.getSqmJoins()) {
            if (!(sqmJoin instanceof SqmSingularJoin)) continue;
            SqmSingularJoin attributeJoin = (SqmSingularJoin)sqmJoin;
            if (!name.equals(sqmJoin.getReferencedPathSource().getPathName()) || attributeJoin.getOn() != null) continue;
            resolvedPath = sqmJoin;
            if (!attributeJoin.isFetched()) continue;
            break;
        }
        if (resolvedPath != null) {
            return resolvedPath;
        }
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }

    @Override
    public boolean hasJoins() {
        return this.joins != null && !this.joins.isEmpty();
    }

    @Override
    public List<SqmJoin<T, ?>> getSqmJoins() {
        return this.joins == null ? Collections.emptyList() : Collections.unmodifiableList(this.joins);
    }

    @Override
    public int getNumberOfJoins() {
        return this.joins == null ? 0 : this.joins.size();
    }

    @Override
    public void addSqmJoin(SqmJoin<T, ?> join) {
        if (this.joins == null) {
            this.joins = new ArrayList();
        }
        this.joins.add(join);
        this.findRoot().addOrderedJoin(join);
    }

    @Internal
    public void removeLeftFetchJoins() {
        if (this.joins != null) {
            for (SqmJoin<T, ?> join : new ArrayList(this.joins)) {
                SqmAttributeJoin attributeJoin;
                if (!(join instanceof SqmAttributeJoin) || !(attributeJoin = (SqmAttributeJoin)join).isFetched()) continue;
                if (join.getSqmJoinType() == SqmJoinType.LEFT) {
                    this.joins.remove(join);
                    List<SqmJoin<?, ?>> orderedJoins = this.findRoot().getOrderedJoins();
                    if (orderedJoins == null) continue;
                    orderedJoins.remove(join);
                    continue;
                }
                attributeJoin.clearFetched();
            }
        }
    }

    @Override
    public void visitSqmJoins(Consumer<SqmJoin<T, ?>> consumer) {
        if (this.joins != null) {
            this.joins.forEach(consumer);
        }
    }

    @Override
    public List<SqmTreatedFrom<?, ?, ?>> getSqmTreats() {
        return this.treats == null ? Collections.emptyList() : this.treats;
    }

    protected <S extends T, X extends SqmTreatedFrom<O, T, S>> X findTreat(ManagedDomainType<S> targetType, String alias) {
        if (this.treats != null) {
            for (SqmTreatedFrom<?, ?, ?> treat : this.treats) {
                if (treat.getModel() != targetType || !Objects.equals(treat.getExplicitAlias(), alias)) continue;
                return (X)treat;
            }
        }
        return null;
    }

    protected <X extends SqmTreatedFrom<?, ?, ?>> X addTreat(X treat) {
        if (this.treats == null) {
            this.treats = new ArrayList();
        }
        this.treats.add(treat);
        return treat;
    }

    @Override
    public JpaPath<?> getParentPath() {
        return this.getLhs();
    }

    @Override
    public SqmFrom<O, T> getCorrelationParent() {
        throw new IllegalStateException("Not correlated");
    }

    public abstract SqmCorrelation<O, T> createCorrelation();

    @Override
    public boolean isCorrelated() {
        return false;
    }

    @Override
    public Set<Join<T, ?>> getJoins() {
        return this.getSqmJoins().stream().filter(sqmJoin -> {
            SqmAttributeJoin attributeJoin;
            return sqmJoin instanceof SqmAttributeJoin && !(attributeJoin = (SqmAttributeJoin)sqmJoin).isFetched();
        }).collect(Collectors.toSet());
    }

    @Override
    public boolean hasImplicitlySelectableJoin() {
        return this.getSqmJoins().stream().anyMatch(sqmJoin -> {
            SqmAttributeJoin attributeJoin;
            return sqmJoin instanceof SqmAttributeJoin && (attributeJoin = (SqmAttributeJoin)sqmJoin).isImplicitlySelectable();
        });
    }

    @Override
    public <A> SqmSingularJoin<T, A> join(SingularAttribute<? super T, A> attribute) {
        return this.join((SingularAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <A> SqmSingularJoin<T, A> join(SingularAttribute<? super T, A> attribute, JoinType jt) {
        SqmSingularJoin<T, A> join = this.buildSingularJoin((SqmSingularPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin((SqmJoin<T, ?>)join);
        return join;
    }

    @Override
    public <X> SqmEntityJoin<T, X> join(Class<X> targetEntityClass, SqmJoinType joinType) {
        return this.join((EntityDomainType)this.nodeBuilder().getJpaMetamodel().entity((Class)targetEntityClass), joinType);
    }

    @Override
    public <X> SqmEntityJoin<T, X> join(EntityDomainType<X> targetEntityDescriptor) {
        return this.join((EntityDomainType)targetEntityDescriptor, SqmJoinType.INNER);
    }

    @Override
    public <X> SqmEntityJoin<T, X> join(EntityDomainType<X> targetEntityDescriptor, SqmJoinType joinType) {
        SqmRoot<X> root = this.findRoot();
        SqmEntityJoin sqmEntityJoin = new SqmEntityJoin(targetEntityDescriptor, this.generateAlias(), joinType, root);
        root.addSqmJoin(sqmEntityJoin);
        return sqmEntityJoin;
    }

    @Override
    public <A> SqmBagJoin<T, A> join(CollectionAttribute<? super T, A> attribute) {
        return this.join(attribute, JoinType.INNER);
    }

    @Override
    public <E> SqmBagJoin<T, E> join(CollectionAttribute<? super T, E> attribute, JoinType jt) {
        SqmBagJoin<T, E> join = this.buildBagJoin((BagPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin((SqmJoin<T, ?>)join);
        return join;
    }

    @Override
    public <E> SqmSetJoin<T, E> join(SetAttribute<? super T, E> attribute) {
        return this.join((SetAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <E> SqmSetJoin<T, E> join(SetAttribute<? super T, E> attribute, JoinType jt) {
        SqmSetJoin<T, E> join = this.buildSetJoin((SetPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin((SqmJoin<T, ?>)join);
        return join;
    }

    @Override
    public <E> SqmListJoin<T, E> join(ListAttribute<? super T, E> attribute) {
        return this.join((ListAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <E> SqmListJoin<T, E> join(ListAttribute<? super T, E> attribute, JoinType jt) {
        SqmListJoin<T, E> join = this.buildListJoin((ListPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin((SqmJoin<T, ?>)join);
        return join;
    }

    @Override
    public <K, V> SqmMapJoin<T, K, V> join(MapAttribute<? super T, K, V> attribute) {
        return this.join((MapAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <K, V> SqmMapJoin<T, K, V> join(MapAttribute<? super T, K, V> attribute, JoinType jt) {
        SqmMapJoin<T, K, V> join = this.buildMapJoin((MapPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin((SqmJoin<T, ?>)join);
        return join;
    }

    @Override
    public <X, Y> SqmAttributeJoin<X, Y> join(String attributeName) {
        return this.join(attributeName, JoinType.INNER);
    }

    @Override
    public <X, Y> SqmAttributeJoin<X, Y> join(String attributeName, JoinType jt) {
        SqmPathSource<?> subPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        return this.buildJoin(subPathSource, SqmJoinType.from(jt), false);
    }

    @Override
    public <X, Y> SqmBagJoin<X, Y> joinCollection(String attributeName) {
        return this.joinCollection(attributeName, JoinType.INNER);
    }

    @Override
    public <X, Y> SqmBagJoin<X, Y> joinCollection(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        if (joinedPathSource instanceof BagPersistentAttribute) {
            SqmBagJoin join = this.buildBagJoin((BagPersistentAttribute)((Object)joinedPathSource), SqmJoinType.from(jt), false);
            this.addSqmJoin(join);
            return join;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (bag) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath()));
    }

    @Override
    public <X, Y> SqmSetJoin<X, Y> joinSet(String attributeName) {
        return this.joinSet(attributeName, JoinType.INNER);
    }

    @Override
    public <X, Y> SqmSetJoin<X, Y> joinSet(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        if (joinedPathSource instanceof SetPersistentAttribute) {
            SqmSetJoin join = this.buildSetJoin((SetPersistentAttribute)((Object)joinedPathSource), SqmJoinType.from(jt), false);
            this.addSqmJoin(join);
            return join;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (set) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath()));
    }

    @Override
    public <X, Y> SqmListJoin<X, Y> joinList(String attributeName) {
        return this.joinList(attributeName, JoinType.INNER);
    }

    @Override
    public <X, Y> SqmListJoin<X, Y> joinList(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        if (joinedPathSource instanceof ListPersistentAttribute) {
            SqmListJoin join = this.buildListJoin((ListPersistentAttribute)((Object)joinedPathSource), SqmJoinType.from(jt), false);
            this.addSqmJoin(join);
            return join;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (list) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath()));
    }

    @Override
    public <X, K, V> SqmMapJoin<X, K, V> joinMap(String attributeName) {
        return this.joinMap(attributeName, JoinType.INNER);
    }

    @Override
    public <X, K, V> SqmMapJoin<X, K, V> joinMap(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        if (joinedPathSource instanceof MapPersistentAttribute) {
            SqmMapJoin<T, K, V> join = this.buildMapJoin((MapPersistentAttribute)((Object)joinedPathSource), SqmJoinType.from(jt), false);
            this.addSqmJoin((SqmJoin<T, ?>)join);
            return join;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (map) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath()));
    }

    @Override
    public <R> SqmEntityJoin<T, R> join(Class<R> entityJavaType) {
        return this.join((EntityDomainType)this.nodeBuilder().getDomainModel().entity(entityJavaType));
    }

    @Override
    public <R> SqmEntityJoin<T, R> join(EntityType<R> entityType) {
        return this.join(entityType, JoinType.INNER);
    }

    @Override
    public <Y> SqmEntityJoin<T, Y> join(Class<Y> entityJavaType, JoinType joinType) {
        return this.join(this.nodeBuilder().getDomainModel().entity(entityJavaType), joinType);
    }

    @Override
    public <Y> SqmEntityJoin<T, Y> join(EntityType<Y> entity, JoinType joinType) {
        SqmEntityJoin join = new SqmEntityJoin(entity, this.generateAlias(), joinType, this.findRoot());
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <X> JpaDerivedJoin<X> join(Subquery<X> subquery) {
        return this.join(subquery, SqmJoinType.INNER, false, this.generateAlias());
    }

    @Override
    public <X> JpaDerivedJoin<X> join(Subquery<X> subquery, SqmJoinType joinType) {
        return this.join(subquery, joinType, false, this.generateAlias());
    }

    @Override
    public <X> JpaDerivedJoin<X> joinLateral(Subquery<X> subquery) {
        return this.join(subquery, SqmJoinType.INNER, true, this.generateAlias());
    }

    @Override
    public <X> JpaDerivedJoin<X> joinLateral(Subquery<X> subquery, SqmJoinType joinType) {
        return this.join(subquery, joinType, true, this.generateAlias());
    }

    @Override
    public <X> JpaDerivedJoin<X> join(Subquery<X> subquery, SqmJoinType joinType, boolean lateral) {
        return this.join(subquery, joinType, lateral, this.generateAlias());
    }

    public <X> JpaDerivedJoin<X> join(Subquery<X> subquery, SqmJoinType joinType, boolean lateral, String alias) {
        this.validateComplianceFromSubQuery();
        SqmDerivedJoin join = new SqmDerivedJoin((SqmSubQuery)subquery, alias, joinType, lateral, this.findRoot());
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <X> SqmJoin<?, X> join(JpaCteCriteria<X> cte) {
        return this.join(cte, SqmJoinType.INNER, this.generateAlias());
    }

    @Override
    public <X> SqmJoin<?, X> join(JpaCteCriteria<X> cte, SqmJoinType joinType) {
        return this.join(cte, joinType, this.generateAlias());
    }

    public <X> SqmJoin<?, X> join(JpaCteCriteria<X> cte, SqmJoinType joinType, String alias) {
        this.validateComplianceFromSubQuery();
        SqmCteJoin join = new SqmCteJoin((SqmCteStatement)cte, alias, joinType, this.findRoot());
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <X> JpaFunctionJoin<X> joinLateral(JpaSetReturningFunction<X> function, SqmJoinType joinType) {
        return this.join(function, joinType, true);
    }

    @Override
    public <X> JpaFunctionJoin<X> joinLateral(JpaSetReturningFunction<X> function) {
        return this.join(function, SqmJoinType.INNER, true);
    }

    @Override
    public <X> JpaFunctionJoin<X> join(JpaSetReturningFunction<X> function, SqmJoinType joinType) {
        return this.join(function, joinType, false);
    }

    @Override
    public <X> JpaFunctionJoin<X> join(JpaSetReturningFunction<X> function) {
        return this.join(function, SqmJoinType.INNER, false);
    }

    @Override
    public <X> JpaFunctionJoin<X> join(JpaSetReturningFunction<X> function, SqmJoinType joinType, boolean lateral) {
        this.validateComplianceFromFunction();
        SqmFunctionJoin join = new SqmFunctionJoin((SqmSetReturningFunction)function, this.generateAlias(), joinType, lateral, this.findRoot());
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <X> JpaFunctionJoin<X> joinArray(String arrayAttributeName) {
        return this.joinArray(arrayAttributeName, SqmJoinType.INNER);
    }

    @Override
    public <X> JpaFunctionJoin<X> joinArray(String arrayAttributeName, SqmJoinType joinType) {
        return this.join(this.nodeBuilder().unnestArray((Expression)this.get(arrayAttributeName)), joinType, true);
    }

    @Override
    public <X> JpaFunctionJoin<X> joinArray(SingularAttribute<? super T, X[]> arrayAttribute) {
        return this.joinArray(arrayAttribute, SqmJoinType.INNER);
    }

    @Override
    public <X> JpaFunctionJoin<X> joinArray(SingularAttribute<? super T, X[]> arrayAttribute, SqmJoinType joinType) {
        return this.join(this.nodeBuilder().unnestArray((Expression)this.get(arrayAttribute)), joinType, true);
    }

    @Override
    public <X> JpaFunctionJoin<X> joinArrayCollection(String collectionAttributeName) {
        return this.joinArrayCollection(collectionAttributeName, SqmJoinType.INNER);
    }

    @Override
    public <X> JpaFunctionJoin<X> joinArrayCollection(String collectionAttributeName, SqmJoinType joinType) {
        return this.join(this.nodeBuilder().unnestCollection((Expression)this.get(collectionAttributeName)), joinType, true);
    }

    @Override
    public <X> JpaFunctionJoin<X> joinArrayCollection(SingularAttribute<? super T, ? extends Collection<X>> collectionAttribute) {
        return this.joinArrayCollection(collectionAttribute, SqmJoinType.INNER);
    }

    @Override
    public <X> JpaFunctionJoin<X> joinArrayCollection(SingularAttribute<? super T, ? extends Collection<X>> collectionAttribute, SqmJoinType joinType) {
        return this.join(this.nodeBuilder().unnestCollection((Expression)this.get(collectionAttribute)), joinType, true);
    }

    private void validateComplianceFromSubQuery() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support subqueries in the from clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    private void validateComplianceFromFunction() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support functions in the from clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    @Override
    public <X> JpaCrossJoin<X> crossJoin(Class<X> entityJavaType) {
        return this.crossJoin((EntityDomainType<X>)this.nodeBuilder().getDomainModel().entity((Class)entityJavaType));
    }

    @Override
    public <X> JpaCrossJoin<X> crossJoin(EntityDomainType<X> entity) {
        SqmCrossJoin crossJoin = new SqmCrossJoin((SqmEntityDomainType)entity, this.generateAlias(), this.findRoot());
        this.addSqmJoin(crossJoin);
        return crossJoin;
    }

    @Override
    public Set<Fetch<T, ?>> getFetches() {
        return this.getSqmJoins().stream().filter(sqmJoin -> {
            SqmAttributeJoin attributeJoin;
            return sqmJoin instanceof SqmAttributeJoin && (attributeJoin = (SqmAttributeJoin)sqmJoin).isFetched();
        }).collect(Collectors.toSet());
    }

    @Override
    public <A> SqmSingularJoin<T, A> fetch(SingularAttribute<? super T, A> attribute) {
        return this.fetch((SingularAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <A> SqmSingularJoin<T, A> fetch(SingularAttribute<? super T, A> attribute, JoinType jt) {
        SqmSingularPersistentAttribute persistentAttribute = (SqmSingularPersistentAttribute)attribute;
        SqmAttributeJoin compatibleFetchJoin = SqmUtil.findCompatibleFetchJoin(this, persistentAttribute, SqmJoinType.from(jt));
        if (compatibleFetchJoin != null) {
            return (SqmSingularJoin)compatibleFetchJoin;
        }
        SqmSingularJoin<T, A> join = this.buildSingularJoin(persistentAttribute, SqmJoinType.from(jt), true);
        this.addSqmJoin((SqmJoin<T, ?>)join);
        return join;
    }

    @Override
    public <A> SqmAttributeJoin<T, A> fetch(PluralAttribute<? super T, ?, A> attribute) {
        return this.fetch((PluralAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <A> SqmAttributeJoin<T, A> fetch(PluralAttribute<? super T, ?, A> attribute, JoinType jt) {
        return this.buildJoin((SqmPluralPersistentAttribute)attribute, SqmJoinType.from(jt), true);
    }

    @Override
    public <X, A> SqmAttributeJoin<X, A> fetch(String attributeName) {
        return this.fetch(attributeName, JoinType.INNER);
    }

    @Override
    public <X, A> SqmAttributeJoin<X, A> fetch(String attributeName, JoinType jt) {
        return this.buildJoin(this.getReferencedPathSource().getSubPathSource(attributeName), SqmJoinType.from(jt), true);
    }

    private <A> SqmAttributeJoin<T, A> buildJoin(SqmPathSource<A> joinedPathSource, SqmJoinType joinType, boolean fetched) {
        SqmAttributeJoin compatibleFetchJoin;
        if (fetched && (compatibleFetchJoin = SqmUtil.findCompatibleFetchJoin(this, joinedPathSource, joinType)) != null) {
            return compatibleFetchJoin;
        }
        SqmAttributeJoin<T, A> sqmJoin = this.buildAttributeJoin(joinedPathSource, joinType, fetched);
        this.addSqmJoin((SqmJoin<T, ?>)sqmJoin);
        return sqmJoin;
    }

    private <A> SqmAttributeJoin<T, A> buildAttributeJoin(SqmPathSource<A> joinedPathSource, SqmJoinType joinType, boolean fetched) {
        if (joinedPathSource instanceof SqmSingularPersistentAttribute) {
            return this.buildSingularJoin((SqmSingularPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        if (joinedPathSource instanceof SqmBagPersistentAttribute) {
            return this.buildBagJoin((SqmBagPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        if (joinedPathSource instanceof SqmListPersistentAttribute) {
            return this.buildListJoin((SqmListPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        if (joinedPathSource instanceof SqmMapPersistentAttribute) {
            return this.buildMapJoin((SqmMapPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        if (joinedPathSource instanceof SqmSetPersistentAttribute) {
            return this.buildSetJoin((SqmSetPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute [%s] did not correspond to a joinable reference [%s] relative to %s", joinedPathSource.getPathName(), joinedPathSource, this.getNavigablePath()));
    }

    private <A> SqmSingularJoin<T, A> buildSingularJoin(SqmSingularPersistentAttribute<? super T, A> attribute, SqmJoinType joinType, boolean fetched) {
        if (attribute.getPathType() instanceof ManagedDomainType) {
            return new SqmSingularJoin<T, A>(this, attribute, this.generateAlias(), joinType, fetched, (NodeBuilder)this.nodeBuilder());
        }
        throw new SemanticException("Attribute '" + String.valueOf(attribute) + "' is not joinable");
    }

    private <E> SqmBagJoin<T, E> buildBagJoin(BagPersistentAttribute<? super T, E> attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmBagJoin(this, (SqmBagPersistentAttribute)attribute, this.generateAlias(), joinType, fetched, (NodeBuilder)this.nodeBuilder());
    }

    private <E> SqmListJoin<T, E> buildListJoin(ListPersistentAttribute<? super T, E> attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmListJoin(this, (SqmListPersistentAttribute)attribute, this.generateAlias(), joinType, fetched, (NodeBuilder)this.nodeBuilder());
    }

    private <K, V> SqmMapJoin<T, K, V> buildMapJoin(MapPersistentAttribute<? super T, K, V> attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmMapJoin(this, (SqmMapPersistentAttribute)attribute, this.generateAlias(), joinType, fetched, (NodeBuilder)this.nodeBuilder());
    }

    private <E> SqmSetJoin<T, E> buildSetJoin(SetPersistentAttribute<? super T, E> attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmSetJoin(this, (SqmSetPersistentAttribute)attribute, this.generateAlias(), joinType, fetched, (NodeBuilder)this.nodeBuilder());
    }

    @Override
    public <S extends T> SqmTreatedFrom<O, T, S> treatAs(Class<S> treatJavaType) {
        return (SqmTreatedFrom)super.treatAs((Class)treatJavaType);
    }

    @Override
    public <S extends T> SqmTreatedFrom<O, T, S> treatAs(EntityDomainType<S> treatTarget) {
        return (SqmTreatedFrom)super.treatAs((EntityDomainType)treatTarget);
    }

    @Override
    public <S extends T> SqmTreatedFrom<O, T, S> treatAs(Class<S> treatJavaType, String alias) {
        return (SqmTreatedFrom)super.treatAs(treatJavaType, alias);
    }

    @Override
    public <S extends T> SqmTreatedFrom<O, T, S> treatAs(EntityDomainType<S> treatTarget, String alias) {
        return (SqmTreatedFrom)super.treatAs(treatTarget, alias);
    }

    public <S extends T> SqmTreatedFrom<O, T, S> treatAs(Class<S> treatJavaType, String alias, boolean fetch) {
        return (SqmTreatedFrom)super.treatAs(treatJavaType, alias, fetch);
    }

    public <S extends T> SqmTreatedFrom<O, T, S> treatAs(EntityDomainType<S> treatTarget, String alias, boolean fetch) {
        return (SqmTreatedFrom)super.treatAs(treatTarget, alias, fetch);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append(this.resolveAlias(context));
    }

    @Override
    public JpaSelection<T> alias(String name) {
        if (this.getExplicitAlias() == null) {
            this.setExplicitAlias(name);
        }
        return super.alias(name);
    }

    @Override
    public JpaExpression<?> id() {
        return this.nodeBuilder().id((Path)this);
    }

    private String generateAlias() {
        Object prefix = this.alias == null ? "var_" : (this.alias.startsWith("var_") ? this.alias : "var_" + this.alias);
        return (String)prefix + "_" + ++this.aliasCounter;
    }
}

