/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.Type;
import java.util.Arrays;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.PathException;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmFunctionPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmBasicValuedSimplePath<T>
extends AbstractSqmSimplePath<T>
implements SqmBindableType<T> {
    public SqmBasicValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        this(navigablePath, referencedPathSource, lhs, null, nodeBuilder);
    }

    public SqmBasicValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, String explicitAlias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, explicitAlias, nodeBuilder);
    }

    @Override
    public SqmBasicValuedSimplePath<T> copy(SqmCopyContext context) {
        SqmBasicValuedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmExpression lhsCopy = this.getLhs().copy(context);
        SqmBasicValuedSimplePath<T> path = context.registerCopy(this, new SqmBasicValuedSimplePath<T>(this.getNavigablePathCopy((SqmPath<?>)lhsCopy), this.getModel(), (SqmPath<?>)lhsCopy, this.getExplicitAlias(), this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmBindableType<T> getExpressible() {
        return this;
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new UnknownPathException(String.format("Could not interpret attribute '%s' of basic-valued path '%s'", name, this.getNavigablePath()));
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        SqmPathRegistry pathRegistry = creationState.getCurrentProcessingState().getPathRegistry();
        String alias = selector.toHqlString();
        NavigablePath navigablePath = this.getNavigablePath().getParent().append(CollectionPart.Nature.ELEMENT.getName(), alias);
        Object indexedPath = pathRegistry.findFromByPath(navigablePath);
        if (indexedPath != null) {
            return indexedPath;
        }
        SqmFunctionPath path = new SqmFunctionPath(this.getIndexFunction(selector, (SqmDomainType<T>)this.getReferencedPathSource().getPathType(), creationState.getCreationContext().getQueryEngine()));
        pathRegistry.register(path);
        return path;
    }

    private SelfRenderingSqmFunction<?> getIndexFunction(SqmExpression<?> selector, SqmDomainType<T> sqmPathType, QueryEngine queryEngine) {
        SqmFunctionRegistry registry = queryEngine.getSqmFunctionRegistry();
        if (sqmPathType instanceof BasicPluralType) {
            return registry.findFunctionDescriptor("array_get").generateSqmExpression(Arrays.asList(this, selector), null, queryEngine);
        }
        if (this.getJavaTypeClass(sqmPathType) == String.class) {
            return registry.findFunctionDescriptor("substring").generateSqmExpression(Arrays.asList(this, selector, this.nodeBuilder().literal((Object)1)), this.nodeBuilder().getCharacterType(), queryEngine);
        }
        throw new UnsupportedOperationException("Index access is only supported for basic plural and string types, but got: " + String.valueOf(sqmPathType));
    }

    private Class<?> getJavaTypeClass(SqmDomainType<T> sqmPathType) {
        return this.nodeBuilder().resolveExpressible(sqmPathType).getRelationalJavaType().getJavaTypeClass();
    }

    @Override
    public BasicJavaType<T> getJavaTypeDescriptor() {
        return (BasicJavaType)super.getJavaTypeDescriptor();
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) throws PathException {
        throw new UnsupportedOperationException("Basic-value cannot be treated (downcast)");
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        throw new UnsupportedOperationException("Basic-value cannot be treated (downcast)");
    }

    @Override
    public Class<T> getJavaType() {
        return this.getJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return super.getExpressible().getExpressibleJavaType();
    }

    @Override
    public SqmDomainType<T> getSqmType() {
        return this.getResolvedModel().getSqmType();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitBasicValuedPath(this);
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return super.getExpressible().getRelationalJavaType();
    }
}

