/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmMapEntryReference<K, V>
implements SqmSelectableNode<Map.Entry<K, V>>,
Expression<Map.Entry<K, V>>,
SqmBindableType<Map.Entry<K, V>> {
    private final SqmPath<?> mapPath;
    private final NodeBuilder nodeBuilder;
    private final JavaType<Map.Entry<K, V>> mapEntryTypeDescriptor;
    private String explicitAlias;

    public SqmMapEntryReference(SqmPath<?> mapPath, NodeBuilder nodeBuilder) {
        this.mapPath = mapPath;
        this.nodeBuilder = nodeBuilder;
        this.mapEntryTypeDescriptor = nodeBuilder.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Map.Entry.class));
    }

    @Override
    public SqmMapEntryReference<K, V> copy(SqmCopyContext context) {
        SqmMapEntryReference existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        return context.registerCopy(this, new SqmMapEntryReference<K, V>((SqmPath<?>)this.mapPath.copy(context), this.nodeBuilder()));
    }

    @Override
    public String getAlias() {
        return this.explicitAlias;
    }

    public SqmPath<?> getMapPath() {
        return this.mapPath;
    }

    @Override
    public Class<Map.Entry<K, V>> getJavaType() {
        Class<Map.Entry> entryClass = Map.Entry.class;
        return entryClass;
    }

    @Override
    public JpaSelection<Map.Entry<K, V>> alias(String name) {
        this.explicitAlias = name;
        return this;
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    @Override
    public JavaType<Map.Entry<K, V>> getJavaTypeDescriptor() {
        return this.mapEntryTypeDescriptor;
    }

    @Override
    public JavaType<Map.Entry<K, V>> getNodeJavaType() {
        return this.mapEntryTypeDescriptor;
    }

    @Override
    public JavaType<Map.Entry<K, V>> getExpressibleJavaType() {
        return this.mapEntryTypeDescriptor;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitMapEntryFunction(this);
    }

    @Override
    public void visitSubSelectableNodes(Consumer<SqmSelectableNode<?>> jpaSelectionConsumer) {
        jpaSelectionConsumer.accept(this);
    }

    @Override
    public boolean isCompoundSelection() {
        return false;
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return Collections.emptyList();
    }

    @Override
    public SqmBindableType<Map.Entry<K, V>> getNodeType() {
        return this;
    }

    @Override
    public SqmDomainType<Map.Entry<K, V>> getSqmType() {
        return null;
    }

    @Override
    public NodeBuilder nodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("entry(");
        this.mapPath.appendHqlString(hql, context);
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmMapEntryReference)) return false;
        SqmMapEntryReference that = (SqmMapEntryReference)object;
        if (!Objects.equals(this.mapPath, that.mapPath)) return false;
        if (!Objects.equals(this.explicitAlias, that.explicitAlias)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.mapPath, this.explicitAlias);
    }

    @Override
    public Predicate isNull() {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public Predicate isNotNull() {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public Predicate equalTo(Expression<?> value) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public Predicate equalTo(Object value) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public Predicate notEqualTo(Expression<?> value) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public Predicate notEqualTo(Object value) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public Predicate in(Object ... values) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public Predicate in(Expression<?> ... values) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public Predicate in(Collection<?> values) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public Predicate in(Expression<Collection<?>> values) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public <X> Expression<X> as(Class<X> type) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    @Override
    public <X> Expression<X> cast(Class<X> type) {
        throw new UnsupportedOperationException("Whatever JPA");
    }
}

