/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaSimpleCase;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmCaseSimple<T, R>
extends AbstractSqmExpression<R>
implements JpaSimpleCase<T, R> {
    private final SqmExpression<T> fixture;
    private final List<WhenFragment<? extends T, ? extends R>> whenFragments;
    private SqmExpression<? extends R> otherwise;

    public SqmCaseSimple(SqmExpression<T> fixture, NodeBuilder nodeBuilder) {
        this(fixture, null, 10, nodeBuilder);
    }

    public SqmCaseSimple(SqmExpression<T> fixture, int estimatedWhenSize, NodeBuilder nodeBuilder) {
        this(fixture, null, estimatedWhenSize, nodeBuilder);
    }

    public SqmCaseSimple(SqmExpression<T> fixture, SqmBindableType<R> inherentType, NodeBuilder nodeBuilder) {
        this(fixture, inherentType, 10, nodeBuilder);
    }

    private SqmCaseSimple(SqmExpression<T> fixture, SqmBindableType<R> inherentType, int estimatedWhenSize, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.whenFragments = new ArrayList<WhenFragment<? extends T, ? extends R>>(estimatedWhenSize);
        this.fixture = fixture;
    }

    @Override
    public SqmCaseSimple<T, R> copy(SqmCopyContext context) {
        SqmCaseSimple existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCaseSimple caseSearched = context.registerCopy(this, new SqmCaseSimple(this.fixture.copy(context), this.getNodeType(), this.whenFragments.size(), this.nodeBuilder()));
        for (WhenFragment<? extends T, ? extends R> whenFragment : this.whenFragments) {
            caseSearched.whenFragments.add(new WhenFragment(whenFragment.checkValue.copy(context), whenFragment.result.copy(context)));
        }
        if (this.otherwise != null) {
            caseSearched.otherwise = this.otherwise.copy(context);
        }
        this.copyTo(caseSearched, context);
        return caseSearched;
    }

    public SqmExpression<T> getFixture() {
        return this.fixture;
    }

    public List<WhenFragment<? extends T, ? extends R>> getWhenFragments() {
        return this.whenFragments;
    }

    public SqmExpression<? extends R> getOtherwise() {
        return this.otherwise;
    }

    public void otherwise(SqmExpression<? extends R> otherwiseExpression) {
        this.otherwise = otherwiseExpression;
        this.applyInferableResultType(otherwiseExpression.getNodeType());
    }

    public void when(SqmExpression<? extends T> test, SqmExpression<? extends R> result) {
        this.whenFragments.add(new WhenFragment<T, R>(test, result));
        test.applyInferableType(this.fixture.getNodeType());
        this.applyInferableResultType(result.getNodeType());
    }

    private void applyInferableResultType(SqmBindableType<?> type) {
        SqmBindableType oldType;
        SqmBindableType newType;
        if (type != null && (newType = QueryHelper.highestPrecedenceType2(oldType = this.getExpressible(), type)) != null && newType != oldType) {
            this.internalApplyInferableType(newType);
        }
    }

    @Override
    protected void internalApplyInferableType(SqmBindableType<?> newType) {
        super.internalApplyInferableType(newType);
        if (this.otherwise != null) {
            this.otherwise.applyInferableType(newType);
        }
        if (this.whenFragments != null) {
            this.whenFragments.forEach(whenFragment -> whenFragment.getResult().applyInferableType(newType));
        }
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitSimpleCaseExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "<simple-case>";
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("case ");
        this.fixture.appendHqlString(hql, context);
        for (WhenFragment<? extends T, ? extends R> whenFragment : this.whenFragments) {
            hql.append(" when ");
            whenFragment.checkValue.appendHqlString(hql, context);
            hql.append(" then ");
            whenFragment.result.appendHqlString(hql, context);
        }
        if (this.otherwise != null) {
            hql.append(" else ");
            this.otherwise.appendHqlString(hql, context);
        }
        hql.append(" end");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmCaseSimple)) return false;
        SqmCaseSimple that = (SqmCaseSimple)object;
        if (!Objects.equals(this.fixture, that.fixture)) return false;
        if (!Objects.equals(this.whenFragments, that.whenFragments)) return false;
        if (!Objects.equals(this.otherwise, that.otherwise)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.fixture, this.whenFragments, this.otherwise);
    }

    @Override
    public JpaExpression<T> getExpression() {
        return this.getFixture();
    }

    @Override
    public JpaSimpleCase<T, R> when(T condition, R result) {
        this.when((SqmExpression<? extends T>)this.nodeBuilder().value((Object)condition), (SqmExpression<? extends R>)this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> when(T condition, Expression<? extends R> result) {
        this.when(this.nodeBuilder().value(condition, this.fixture), (SqmExpression)result);
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> when(Expression<? extends T> condition, R result) {
        this.when((Expression)condition, (Expression)this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> when(Expression<? extends T> condition, Expression<? extends R> result) {
        this.when((SqmExpression)condition, (SqmExpression)result);
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> otherwise(R result) {
        this.otherwise((SqmExpression<? extends R>)this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> otherwise(Expression<? extends R> result) {
        this.otherwise((SqmExpression)result);
        return this;
    }

    public static class WhenFragment<T, R> {
        private final SqmExpression<T> checkValue;
        private final SqmExpression<R> result;

        public WhenFragment(SqmExpression<T> checkValue, SqmExpression<R> result) {
            this.checkValue = checkValue;
            this.result = result;
        }

        public SqmExpression<T> getCheckValue() {
            return this.checkValue;
        }

        public SqmExpression<R> getResult() {
            return this.result;
        }
    }
}

