/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CommonAbstractCriteria;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.PluralJoin;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.PluralAttribute;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.criteria.JpaCrossJoin;
import org.hibernate.query.criteria.JpaCteContainer;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedCrossJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedEntityJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedListJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedSingularValuedJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularValuedJoin;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmSubQuery<T>
extends AbstractSqmSelectQuery<T>
implements SqmSelectQuery<T>,
JpaSubQuery<T>,
SqmExpression<T> {
    private final SqmQuery<?> parent;
    private SqmBindableType<T> expressibleType;
    private String alias;

    public SqmSubQuery(SqmQuery<?> parent, SqmQueryPart<T> queryPart, Class<T> resultType, NodeBuilder builder) {
        super(queryPart, resultType, builder);
        this.parent = parent;
        this.applyInferableType(resultType);
    }

    public SqmSubQuery(SqmQuery<?> parent, SqmQueryPart<T> queryPart, Class<T> resultType, Map<String, SqmCteStatement<?>> cteStatements, NodeBuilder builder) {
        super(builder, cteStatements, resultType);
        this.parent = parent;
        this.setQueryPart(queryPart);
        this.applyInferableType(resultType);
    }

    public SqmSubQuery(SqmQuery<?> parent, Class<T> resultType, NodeBuilder builder) {
        super(resultType, builder);
        this.parent = parent;
        this.applyInferableType(resultType);
    }

    public SqmSubQuery(SqmQuery<?> parent, EntityType<T> resultType, NodeBuilder builder) {
        super(resultType.getJavaType(), builder);
        this.parent = parent;
        this.applyInferableType(resultType.getJavaType());
    }

    public SqmSubQuery(SqmQuery<?> parent, NodeBuilder builder) {
        super(null, builder);
        this.parent = parent;
    }

    private SqmSubQuery(NodeBuilder builder, Map<String, SqmCteStatement<?>> cteStatements, Class<T> resultType, SqmQuery<?> parent, SqmBindableType<T> expressibleType, String alias) {
        super(builder, cteStatements, resultType);
        this.parent = parent;
        this.expressibleType = expressibleType;
        this.alias = alias;
    }

    @Override
    public SqmSubQuery<T> copy(SqmCopyContext context) {
        SqmSubQuery existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmSubQuery statement = context.registerCopy(this, new SqmSubQuery(this.nodeBuilder(), this.copyCteStatements(context), this.getResultType(), (SqmQuery<?>)this.parent.copy(context), this.getExpressible(), this.getAlias()));
        statement.setQueryPart(((SqmQueryPart)this.getQueryPart()).copy(context));
        return statement;
    }

    @Override
    public Integer getTupleLength() {
        SqmSelectClause selectClause = ((SqmQuerySpec)this.getQuerySpec()).getSelectClause();
        return selectClause != null ? Integer.valueOf(this.getTupleLength(selectClause.getSelectionItems())) : null;
    }

    private int getTupleLength(List<SqmSelectableNode<?>> selectionItems) {
        int count = 0;
        for (SqmSelectableNode<?> selection : selectionItems) {
            count += selection.getTupleLength().intValue();
        }
        return count;
    }

    @Override
    public SqmCteStatement<?> getCteStatement(String cteLabel) {
        SqmCteStatement<?> sqmCteStatement;
        SqmQuery<?> sqmQuery;
        SqmCteStatement<?> cteCriteria = super.getCteStatement(cteLabel);
        if (cteCriteria == null && (sqmQuery = this.parent) instanceof SqmCteContainer) {
            SqmCteContainer cteContainer = (SqmCteContainer)((Object)sqmQuery);
            sqmCteStatement = cteContainer.getCteStatement(cteLabel);
        } else {
            sqmCteStatement = cteCriteria;
        }
        return sqmCteStatement;
    }

    @Override
    public <X> JpaCteCriteria<X> getCteCriteria(String cteName) {
        JpaCteCriteria<Object> jpaCteCriteria;
        SqmQuery<?> sqmQuery;
        JpaCteCriteria cteCriteria = super.getCteCriteria(cteName);
        if (cteCriteria == null && (sqmQuery = this.parent) instanceof JpaCteContainer) {
            JpaCteContainer cteContainer = (JpaCteContainer)((Object)sqmQuery);
            jpaCteCriteria = cteContainer.getCteCriteria(cteName);
        } else {
            jpaCteCriteria = cteCriteria;
        }
        return jpaCteCriteria;
    }

    @Override
    protected <X> JpaCteCriteria<X> withInternal(String name, AbstractQuery<X> criteria) {
        SqmSubQuery sqmSubQuery;
        if (criteria instanceof SqmSubQuery && (sqmSubQuery = (SqmSubQuery)criteria).getParent() == this.parent) {
            return super.withInternal(name, criteria);
        }
        throw new IllegalArgumentException("Invalid query type provided to subquery 'with' method, expecting a subquery with the same parent to use as CTE");
    }

    @Override
    protected <X> JpaCteCriteria<X> withInternal(String name, AbstractQuery<X> baseCriteria, boolean unionDistinct, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        SqmSubQuery sqmSubQuery;
        if (baseCriteria instanceof SqmSubQuery && (sqmSubQuery = (SqmSubQuery)baseCriteria).getParent() == this.parent) {
            return super.withInternal(name, baseCriteria, unionDistinct, recursiveCriteriaProducer);
        }
        throw new IllegalArgumentException("Invalid query type provided to subquery 'with' method, expecting a subquery with the same parent to use as CTE");
    }

    @Override
    public SqmQuery<?> getContainingQuery() {
        return this.parent;
    }

    @Override
    public SqmSelectQuery<?> getParent() {
        CommonAbstractCriteria commonAbstractCriteria = this.getContainingQuery();
        if (commonAbstractCriteria instanceof SqmSelectQuery) {
            SqmSelectQuery sqmSelectQuery = (SqmSelectQuery)commonAbstractCriteria;
            return sqmSelectQuery;
        }
        throw new IllegalStateException("Cannot call getParent() on update/delete criteria");
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public SqmSubQuery<T> alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public SqmSubQuery<T> select(Expression<T> expression) {
        JpaQueryStructure querySpec = this.getQuerySpec();
        if (((SqmQuerySpec)querySpec).getSelectClause() == null) {
            ((SqmQuerySpec)querySpec).setSelectClause(new SqmSelectClause(false, 1, this.nodeBuilder()));
        }
        ((SqmQuerySpec)querySpec).setSelection((JpaSelection)((Object)expression));
        return this;
    }

    @Override
    public SqmSubQuery<T> multiselect(Selection<?> ... selections) {
        this.validateComplianceMultiselect();
        Selection resultSelection = this.getResultSelection(selections);
        JpaQueryStructure querySpec = this.getQuerySpec();
        if (((SqmQuerySpec)querySpec).getSelectClause() == null) {
            ((SqmQuerySpec)querySpec).setSelectClause(new SqmSelectClause(false, 1, this.nodeBuilder()));
        }
        ((SqmQuerySpec)querySpec).setSelection((JpaSelection)resultSelection);
        return this;
    }

    @Override
    public SqmSubQuery<T> multiselect(List<Selection<?>> selectionList) {
        this.validateComplianceMultiselect();
        JpaQueryStructure querySpec = this.getQuerySpec();
        if (((SqmQuerySpec)querySpec).getSelectClause() == null) {
            ((SqmQuerySpec)querySpec).setSelectClause(new SqmSelectClause(false, 1, this.nodeBuilder()));
        }
        ((SqmQuerySpec)querySpec).setSelection((JpaSelection)this.getResultSelection(selectionList));
        return this;
    }

    private JpaSelection<T> getResultSelection(List<Selection<?>> selections) {
        Class resultType = this.getResultType();
        if (resultType == null || resultType == Object.class) {
            Selection selection = switch (selections.size()) {
                case 0 -> throw new IllegalArgumentException("empty selections passed to criteria query typed as Object");
                case 1 -> (JpaSelection)selections.get(0);
                default -> this.nodeBuilder().array((List)selections);
            };
            return selection;
        }
        if (Tuple.class.isAssignableFrom(resultType)) {
            return this.nodeBuilder().tuple((List)selections);
        }
        if (resultType.isArray()) {
            return this.nodeBuilder().array(resultType, selections);
        }
        return this.nodeBuilder().construct(resultType, selections);
    }

    @Override
    public SqmExpression<T> getSelection() {
        SqmSelectClause selectClause = ((SqmQuerySpec)this.getQuerySpec()).getSelectClause();
        return selectClause == null ? null : this;
    }

    @Override
    public boolean isCompoundSelection() {
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection().isCompoundSelection();
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return null;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        if (!this.isCompoundSelection()) {
            throw new IllegalStateException("JPA selection is not compound");
        }
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection().getCompoundSelectionItems();
    }

    @Override
    public SqmSubQuery<T> distinct(boolean distinct) {
        super.distinct(distinct);
        return this;
    }

    @Override
    public SqmSubQuery<T> where(Expression<Boolean> restriction) {
        super.where((Expression)restriction);
        return this;
    }

    @Override
    public SqmSubQuery<T> where(Predicate ... restrictions) {
        super.where(restrictions);
        return this;
    }

    @Override
    public SqmSubQuery<T> where(List<Predicate> restrictions) {
        super.where((List)restrictions);
        return this;
    }

    @Override
    public SqmSubQuery<T> groupBy(Expression<?> ... expressions) {
        super.groupBy((Expression[])expressions);
        return this;
    }

    @Override
    public SqmSubQuery<T> groupBy(List<Expression<?>> grouping) {
        super.groupBy((List)grouping);
        return this;
    }

    @Override
    public SqmSubQuery<T> having(Expression<Boolean> booleanExpression) {
        super.having((Expression)booleanExpression);
        return this;
    }

    @Override
    public SqmSubQuery<T> having(Predicate ... predicates) {
        super.having(predicates);
        return this;
    }

    @Override
    public SqmSubQuery<T> having(List<Predicate> restrictions) {
        super.having(restrictions);
        return this;
    }

    @Override
    public JpaExpression<Number> getOffset() {
        return ((SqmQueryPart)this.getQueryPart()).getOffset();
    }

    @Override
    public JpaSubQuery<T> offset(JpaExpression<? extends Number> offset) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setOffset((JpaExpression)offset);
        return this;
    }

    @Override
    public JpaSubQuery<T> offset(Number offset) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setOffset(this.nodeBuilder().value(offset));
        return this;
    }

    @Override
    public JpaExpression<Number> getFetch() {
        return ((SqmQueryPart)this.getQueryPart()).getFetch();
    }

    @Override
    public JpaSubQuery<T> fetch(JpaExpression<? extends Number> fetch) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch((JpaExpression)fetch);
        return this;
    }

    @Override
    public JpaSubQuery<T> fetch(JpaExpression<? extends Number> fetch, FetchClauseType fetchClauseType) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(fetch, fetchClauseType);
        return this;
    }

    @Override
    public JpaSubQuery<T> fetch(Number fetch) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch));
        return this;
    }

    @Override
    public JpaSubQuery<T> fetch(Number fetch, FetchClauseType fetchClauseType) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch), fetchClauseType);
        return this;
    }

    @Override
    public FetchClauseType getFetchClauseType() {
        return ((SqmQueryPart)this.getQueryPart()).getFetchClauseType();
    }

    @Override
    public List<JpaOrder> getOrderList() {
        return ((SqmQueryPart)this.getQueryPart()).getSortSpecifications();
    }

    @Override
    public JpaSubQuery<T> orderBy(Order ... orders) {
        this.validateComplianceOrderBy();
        SqmOrderByClause sqmOrderByClause = new SqmOrderByClause(orders.length);
        for (Order order : orders) {
            sqmOrderByClause.addSortSpecification((SqmSortSpecification)order);
        }
        ((SqmQueryPart)this.getQueryPart()).setOrderByClause(sqmOrderByClause);
        return this;
    }

    @Override
    public JpaSubQuery<T> orderBy(List<Order> orders) {
        this.validateComplianceOrderBy();
        SqmOrderByClause sqmOrderByClause = new SqmOrderByClause(orders.size());
        for (Order order : orders) {
            sqmOrderByClause.addSortSpecification((SqmSortSpecification)order);
        }
        ((SqmQueryPart)this.getQueryPart()).setOrderByClause(sqmOrderByClause);
        return this;
    }

    private void validateComplianceMultiselect() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support subqueries having multiple select items. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    private void validateComplianceOrderBy() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support subqueries having an order by clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    private void validateComplianceFetchOffset() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support subqueries having a fetch or offset clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    @Override
    public <Y> SqmRoot<Y> correlate(Root<Y> parentRoot) {
        SqmCorrelation correlated = ((SqmRoot)parentRoot).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((Object)correlated));
        return correlated;
    }

    @Override
    public <X, Y> SqmCorrelatedJoin<X, Y> correlate(Join<X, Y> join) {
        if (join instanceof PluralJoin) {
            PluralJoin pluralJoin = (PluralJoin)join;
            return switch (pluralJoin.getModel().getCollectionType()) {
                default -> throw new IncompatibleClassChangeError();
                case PluralAttribute.CollectionType.COLLECTION -> this.correlate((CollectionJoin)join);
                case PluralAttribute.CollectionType.LIST -> this.correlate((ListJoin)join);
                case PluralAttribute.CollectionType.SET -> this.correlate((SetJoin)join);
                case PluralAttribute.CollectionType.MAP -> this.correlate((MapJoin)join);
            };
        }
        SqmCorrelatedSingularValuedJoin correlated = ((SqmSingularValuedJoin)join).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)correlated.getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X, Y> SqmCorrelatedBagJoin<X, Y> correlate(CollectionJoin<X, Y> parentCollection) {
        SqmCorrelation correlated = ((SqmBagJoin)parentCollection).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedBagJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X, Y> SqmCorrelatedSetJoin<X, Y> correlate(SetJoin<X, Y> parentSet) {
        SqmCorrelation correlated = ((SqmSetJoin)parentSet).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedSetJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X, Y> SqmCorrelatedListJoin<X, Y> correlate(ListJoin<X, Y> parentList) {
        SqmCorrelation correlated = ((SqmListJoin)parentList).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedListJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X, K, V> SqmCorrelatedMapJoin<X, K, V> correlate(MapJoin<X, K, V> parentMap) {
        SqmCorrelation correlated = ((SqmMapJoin)parentMap).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedMapJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X> SqmCorrelatedCrossJoin<X> correlate(JpaCrossJoin<X> parentCrossJoin) {
        SqmCorrelation correlated = ((SqmCrossJoin)parentCrossJoin).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedCrossJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X> JpaEntityJoin<T, X> correlate(JpaEntityJoin<T, X> parentEntityJoin) {
        SqmCorrelation correlated = ((SqmEntityJoin)parentEntityJoin).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedEntityJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public Set<Join<?, ?>> getCorrelatedJoins() {
        Set<Join<?, ?>> correlatedJoins = Collections.newSetFromMap(new IdentityHashMap());
        SqmFromClause fromClause = ((SqmQuerySpec)this.getQuerySpec()).getFromClause();
        if (fromClause != null) {
            for (SqmRoot<?> root : fromClause.getRoots()) {
                if (!(root instanceof SqmCorrelation)) continue;
                for (SqmJoin sqmJoin : root.getSqmJoins()) {
                    if (!(sqmJoin instanceof SqmCorrelation)) continue;
                    correlatedJoins.add(sqmJoin);
                }
            }
        }
        return correlatedJoins;
    }

    @Override
    public SqmPredicate isNull() {
        return this.nodeBuilder().isNull((Expression)this);
    }

    @Override
    public SqmPredicate isNotNull() {
        return this.nodeBuilder().isNotNull((Expression)this);
    }

    @Override
    public SqmPredicate equalTo(Expression<?> that) {
        return this.nodeBuilder().equal((Expression)this, (Expression)that);
    }

    @Override
    public SqmPredicate equalTo(Object that) {
        return this.nodeBuilder().equal((Expression)this, that);
    }

    @Override
    public SqmInPredicate<?> in(Object ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmInPredicate<?> in(Expression<?> ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmInPredicate<?> in(Collection<?> values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmInPredicate<?> in(Expression<Collection<?>> values) {
        return this.nodeBuilder().in((Expression)this, new Expression[]{values});
    }

    @Override
    public @Nullable SqmBindableType<T> getNodeType() {
        return this.expressibleType;
    }

    @Override
    public void applyInferableType(@Nullable SqmBindableType<?> type) {
        this.expressibleType = type;
    }

    @Override
    private void applyInferableType(Class<T> type) {
        if (type != null) {
            NodeBuilder nodeBuilder = this.nodeBuilder();
            EntityDomainType<T> entityDescriptor = nodeBuilder.getDomainModel().findEntityType(type);
            this.expressibleType = entityDescriptor != null ? nodeBuilder.resolveExpressible(entityDescriptor) : nodeBuilder.getTypeConfiguration().getBasicTypeForJavaType(type);
        }
    }

    private <B> SqmExpression<B> castToBasicType(Class<B> type) {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(type));
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.castToBasicType(Long.class);
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.castToBasicType(Integer.class);
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.castToBasicType(Float.class);
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.castToBasicType(Double.class);
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        return this.castToBasicType(BigDecimal.class);
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        return this.castToBasicType(BigInteger.class);
    }

    @Override
    public SqmExpression<String> asString() {
        return this.castToBasicType(String.class);
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)type);
    }

    @Override
    public JavaType<T> getJavaTypeDescriptor() {
        SqmBindableType<T> nodeType = this.getNodeType();
        return nodeType == null ? null : nodeType.getExpressibleJavaType();
    }

    @Override
    public Class<? extends T> getJavaType() {
        return this.getResultType();
    }

    public <U> SqmSubQuery<U> subquery(Class<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    @Override
    public <U> Subquery<U> subquery(EntityType<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        return Collections.emptySet();
    }

    @Override
    public JpaPredicate notEqualTo(Expression<?> value) {
        return this.nodeBuilder().notEqual((Expression)this, (Expression)value);
    }

    @Override
    public JpaPredicate notEqualTo(Object value) {
        return this.nodeBuilder().notEqual((Expression)this, value);
    }

    @Override
    public <X> SqmExpression<X> cast(Class<X> targetType) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)targetType);
    }

    @Override
    public String asLoggableText() {
        return "<sub-query>";
    }

    public <T1> T1 accept(SemanticQueryWalker<T1> walker) {
        return walker.visitSubQueryExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append('(');
        super.appendHqlString(hql, context);
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmSubQuery)) return false;
        SqmSubQuery that = (SqmSubQuery)object;
        if (!Objects.equals(this.alias, that.alias)) return false;
        if (!super.equals(object)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.alias);
    }

    @Override
    public String generateAlias() {
        return this.parent.generateAlias();
    }
}

