/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tuple.internal;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.internal.PathHelper;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleSqmPathSource<J>
implements SqmPathSource<J> {
    private final String localPathName;
    private final SqmPath<J> path;

    public AnonymousTupleSqmPathSource(String localPathName, SqmPath<J> path) {
        this.localPathName = localPathName;
        this.path = path;
    }

    @Override
    public Class<J> getBindableJavaType() {
        return this.path.getNodeJavaType().getJavaTypeClass();
    }

    @Override
    public String getPathName() {
        return this.localPathName;
    }

    @Override
    public SqmDomainType<J> getPathType() {
        return this.path.getResolvedModel().getPathType();
    }

    @Override
    public Bindable.BindableType getBindableType() {
        return this.path.getResolvedModel().getBindableType();
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.path.getNodeJavaType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return this.path.getReferencedPathSource().findSubPathSource(name);
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        DomainType domainType = this.path.getReferencedPathSource().getPathType();
        if (domainType instanceof BasicDomainType) {
            return new SqmBasicValuedSimplePath(PathHelper.append(lhs, this, intermediatePathSource), this, lhs, lhs.nodeBuilder());
        }
        if (domainType instanceof EmbeddableDomainType) {
            return new SqmEmbeddedValuedSimplePath(PathHelper.append(lhs, this, intermediatePathSource), this, lhs, lhs.nodeBuilder());
        }
        if (domainType instanceof EntityDomainType) {
            return new SqmEntityValuedSimplePath(PathHelper.append(lhs, this, intermediatePathSource), this, lhs, lhs.nodeBuilder());
        }
        throw new UnsupportedOperationException("Unsupported path source: " + String.valueOf(domainType));
    }
}

