/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.relational.internal;

import jakarta.persistence.SchemaValidationException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.relational.SchemaManager;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public class SchemaManagerImpl
implements SchemaManager {
    private final SessionFactoryImplementor sessionFactory;
    private final MetadataImplementor metadata;
    private final String schemaName;
    private final String catalogName;

    public SchemaManagerImpl(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata) {
        this(sessionFactory, metadata, null, null);
    }

    public SchemaManagerImpl(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata, String schemaName, String catalogName) {
        this.sessionFactory = sessionFactory;
        this.metadata = metadata;
        this.schemaName = schemaName;
        this.catalogName = catalogName;
    }

    @Override
    public SchemaManager forSchema(String schemaName) {
        return new SchemaManagerImpl(this.sessionFactory, this.metadata, schemaName, this.catalogName);
    }

    @Override
    public SchemaManager forCatalog(String catalogName) {
        return new SchemaManagerImpl(this.sessionFactory, this.metadata, this.schemaName, catalogName);
    }

    private void addSchemaAndCatalog(Map<String, Object> properties) {
        if (this.schemaName != null) {
            properties.put("hibernate.default_schema", this.schemaName);
        }
        if (this.catalogName != null) {
            properties.put("hibernate.default_catalog", this.catalogName);
        }
    }

    @Override
    public void exportMappedObjects(boolean createSchemas) {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.CREATE_ONLY);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        properties.put("jakarta.persistence.create-database-schemas", createSchemas);
        this.addSchemaAndCatalog(properties);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    @Override
    public void dropMappedObjects(boolean dropSchemas) {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.DROP);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        properties.put("jakarta.persistence.create-database-schemas", dropSchemas);
        this.addSchemaAndCatalog(properties);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    @Override
    public void validateMappedObjects() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.VALIDATE);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        properties.put("jakarta.persistence.create-database-schemas", false);
        this.addSchemaAndCatalog(properties);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    @Override
    public void truncateMappedObjects() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.TRUNCATE);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        this.addSchemaAndCatalog(properties);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    @Override
    public void populate() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.POPULATE);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        this.addSchemaAndCatalog(properties);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    @Override
    public void create(boolean createSchemas) {
        this.exportMappedObjects(createSchemas);
    }

    @Override
    public void drop(boolean dropSchemas) {
        this.dropMappedObjects(dropSchemas);
    }

    @Override
    public void validate() throws SchemaValidationException {
        try {
            this.validateMappedObjects();
        }
        catch (SchemaManagementException sme) {
            throw new SchemaValidationException(sme.getMessage(), sme);
        }
    }

    @Override
    public void truncate() {
        this.truncateMappedObjects();
    }
}

