/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jta.internal;

import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.TransactionException;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.exception.internal.SQLStateConversionDelegate;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.backend.jta.internal.JtaLogging;
import org.hibernate.resource.transaction.spi.IsolationDelegate;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;

public final class JtaIsolationDelegate
implements IsolationDelegate {
    private final JdbcConnectionAccess connectionAccess;
    private final BiFunction<SQLException, String, JDBCException> sqlExceptionConverter;
    private final TransactionManager transactionManager;

    public JtaIsolationDelegate(TransactionCoordinatorOwner transactionCoordinatorOwner, TransactionManager transactionManager) {
        this(transactionCoordinatorOwner.getJdbcSessionOwner(), transactionManager);
    }

    public JtaIsolationDelegate(JdbcSessionOwner jdbcSessionOwner, TransactionManager transactionManager) {
        this(jdbcSessionOwner.getJdbcConnectionAccess(), jdbcSessionOwner.getSqlExceptionHelper(), transactionManager);
    }

    public JtaIsolationDelegate(JdbcConnectionAccess connectionAccess, SqlExceptionHelper sqlExceptionConverter, TransactionManager transactionManager) {
        this.connectionAccess = connectionAccess;
        this.transactionManager = transactionManager;
        if (sqlExceptionConverter != null) {
            this.sqlExceptionConverter = sqlExceptionConverter::convert;
        } else {
            SQLStateConversionDelegate delegate = new SQLStateConversionDelegate(() -> {
                throw new AssertionFailure("Unexpected call to ConversionContext.getViolatedConstraintNameExtractor");
            });
            this.sqlExceptionConverter = (sqlException, message) -> delegate.convert((SQLException)sqlException, (String)message, null);
        }
    }

    @Override
    public <T> T delegateWork(WorkExecutorVisitable<T> work, boolean transacted) throws HibernateException {
        return (T)this.doInSuspendedTransaction(() -> transacted ? this.doInNewTransaction(() -> this.doTheWork(work), this.transactionManager) : this.doTheWork(work));
    }

    @Override
    public <T> T delegateCallable(Callable<T> callable, boolean transacted) throws HibernateException {
        return (T)this.doInSuspendedTransaction(() -> transacted ? this.doInNewTransaction(() -> JtaIsolationDelegate.call(callable), this.transactionManager) : JtaIsolationDelegate.call(callable));
    }

    private static <T> T call(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException(e);
        }
    }

    private <T> T doInSuspendedTransaction(HibernateCallable<T> callable) {
        Transaction surroundingTransaction;
        try {
            surroundingTransaction = this.suspend();
        }
        catch (SystemException systemException) {
            throw new TransactionException("Unable to suspend current JTA transaction", systemException);
        }
        Throwable exception = null;
        try {
            T t = callable.call();
            return t;
        }
        catch (HibernateException he) {
            exception = he;
            throw he;
        }
        catch (Throwable throwable) {
            exception = throwable;
            throw new HibernateException("Unable to perform isolated work", throwable);
        }
        finally {
            try {
                this.resume(surroundingTransaction);
            }
            catch (Throwable throwable) {
                if (exception == null) {
                    throw new TransactionException("Unable to resume suspended transaction", throwable);
                }
                exception.addSuppressed(throwable);
            }
        }
    }

    private void resume(Transaction surroundingTransaction) throws InvalidTransactionException, SystemException {
        if (surroundingTransaction != null) {
            this.transactionManager.resume(surroundingTransaction);
            JtaLogging.JTA_LOGGER.transactionResumed(surroundingTransaction);
        }
    }

    private Transaction suspend() throws SystemException {
        Transaction surroundingTransaction = this.transactionManager.suspend();
        if (surroundingTransaction != null) {
            JtaLogging.JTA_LOGGER.transactionSuspended(surroundingTransaction);
        }
        return surroundingTransaction;
    }

    private <T> T doInNewTransaction(HibernateCallable<T> callable, TransactionManager transactionManager) {
        try {
            transactionManager.begin();
        }
        catch (NotSupportedException | SystemException exception) {
            throw new TransactionException("Unable to start isolated transaction", exception);
        }
        try {
            T result = callable.call();
            transactionManager.commit();
            return result;
        }
        catch (Exception exception) {
            JtaIsolationDelegate.rollBack(transactionManager, exception);
            if (exception instanceof HibernateException) {
                HibernateException he = (HibernateException)exception;
                throw he;
            }
            throw new HibernateException("Error performing work", exception);
        }
    }

    private static void rollBack(TransactionManager transactionManager, Exception original) {
        try {
            transactionManager.rollback();
        }
        catch (Exception exception) {
            JtaLogging.JTA_LOGGER.unableToRollBackIsolatedTransaction(original, exception);
            original.addSuppressed(exception);
        }
    }

    private <T> T doTheWork(WorkExecutorVisitable<T> work) {
        Connection connection;
        try {
            connection = this.connectionAccess.obtainConnection();
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "Unable to obtain isolated JDBC connection");
        }
        try {
            T sqle = work.accept(new WorkExecutor(), connection);
            return sqle;
        }
        catch (HibernateException he) {
            throw he;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "Error performing isolated work");
        }
        catch (Exception e) {
            throw new HibernateException("Error performing isolated work", e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    private void releaseConnection(Connection connection) {
        try {
            this.connectionAccess.releaseConnection(connection);
        }
        catch (Throwable throwable) {
            JtaLogging.JTA_LOGGER.unableToReleaseIsolatedConnection(throwable);
        }
    }

    private HibernateException convert(SQLException sqle, String message) {
        JDBCException jdbcException = this.sqlExceptionConverter.apply(sqle, message);
        return jdbcException == null ? new HibernateException(message, sqle) : jdbcException;
    }

    private static interface HibernateCallable<T> {
        public T call() throws HibernateException;
    }
}

