/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.internal.AbstractSchemaPopulator;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.GenerationTarget;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.SchemaPopulator;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class SchemaPopulatorImpl
extends AbstractSchemaPopulator
implements SchemaPopulator {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SchemaPopulatorImpl.class);
    private final HibernateSchemaManagementTool tool;

    public SchemaPopulatorImpl(HibernateSchemaManagementTool tool) {
        this.tool = tool;
    }

    public SchemaPopulatorImpl(ServiceRegistry serviceRegistry) {
        SchemaManagementTool schemaManagementTool = serviceRegistry.getService(SchemaManagementTool.class);
        if (schemaManagementTool instanceof HibernateSchemaManagementTool) {
            HibernateSchemaManagementTool schemaManagementTool2;
            this.tool = schemaManagementTool2 = (HibernateSchemaManagementTool)schemaManagementTool;
        } else {
            this.tool = new HibernateSchemaManagementTool();
            this.tool.injectServices((ServiceRegistryImplementor)serviceRegistry);
        }
    }

    @Override
    public void doPopulation(ExecutionOptions options, TargetDescriptor targetDescriptor) {
        if (!targetDescriptor.getTargetTypes().isEmpty()) {
            Map<String, Object> configuration = options.getConfigurationValues();
            JdbcContext context = this.tool.resolveJdbcContext(configuration);
            this.doPopulation(context.getDialect(), options, this.tool.buildGenerationTargets(targetDescriptor, context, configuration, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void doPopulation(Dialect dialect, ExecutionOptions options, GenerationTarget ... targets) {
        for (GenerationTarget target : targets) {
            target.prepare();
        }
        try {
            this.performPopulation(dialect, options, targets);
        }
        finally {
            for (GenerationTarget target : targets) {
                try {
                    target.release();
                }
                catch (Exception e) {
                    log.debugf("Problem releasing GenerationTarget [%s] : %s", (Object)target, (Object)e.getMessage());
                }
            }
        }
    }

    private void performPopulation(Dialect dialect, ExecutionOptions options, GenerationTarget ... targets) {
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        this.applyImportSources(options, this.getCommandExtractor(), format, dialect, targets);
    }

    private SqlScriptCommandExtractor getCommandExtractor() {
        return this.tool.getServiceRegistry().getService(SqlScriptCommandExtractor.class);
    }

    @Override
    ClassLoaderService getClassLoaderService() {
        return this.tool.getServiceRegistry().getService(ClassLoaderService.class);
    }
}

