/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.spi;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.ExceptionHandlerHaltImpl;
import org.hibernate.tool.schema.internal.ExceptionHandlerLoggedImpl;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.DelayedDropRegistry;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.JpaTargetAndSourceDescriptor;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.jboss.logging.Logger;

public class SchemaManagementToolCoordinator {
    private static final Logger log = Logger.getLogger(SchemaManagementToolCoordinator.class);

    public static void process(Metadata metadata, ServiceRegistry serviceRegistry, Map<String, Object> configurationValues, DelayedDropRegistry delayedDropRegistry) {
        Set<ActionGrouping> groupings = ActionGrouping.interpret(metadata, configurationValues);
        if (groupings.isEmpty()) {
            log.debug("No schema management actions found");
            return;
        }
        HashMap<Action, Set> databaseActionMap = null;
        HashMap<Action, Set> scriptActionMap = null;
        for (ActionGrouping grouping : groupings) {
            Set<String> contributors2;
            if (grouping.databaseAction != Action.NONE) {
                if (databaseActionMap == null) {
                    databaseActionMap = new HashMap<Action, Set>();
                    contributors2 = new HashSet<String>();
                    databaseActionMap.put(grouping.databaseAction, contributors2);
                } else {
                    contributors2 = databaseActionMap.computeIfAbsent(grouping.databaseAction, action -> new HashSet());
                }
                contributors2.add(grouping.contributor);
            }
            if (grouping.scriptAction == Action.NONE) continue;
            if (scriptActionMap == null) {
                scriptActionMap = new HashMap<Action, Set>();
                contributors2 = new HashSet();
                scriptActionMap.put(grouping.scriptAction, contributors2);
            } else {
                contributors2 = scriptActionMap.computeIfAbsent(grouping.scriptAction, action -> new HashSet());
            }
            contributors2.add(grouping.contributor);
        }
        SchemaManagementTool tool = serviceRegistry.getService(SchemaManagementTool.class);
        ConfigurationService configService = serviceRegistry.requireService(ConfigurationService.class);
        boolean haltOnError = configService.getSetting("hibernate.hbm2ddl.halt_on_error", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        ExecutionOptions executionOptions = SchemaManagementToolCoordinator.buildExecutionOptions(configurationValues, haltOnError ? ExceptionHandlerHaltImpl.INSTANCE : ExceptionHandlerLoggedImpl.INSTANCE);
        if (scriptActionMap != null) {
            scriptActionMap.forEach((action, contributors) -> SchemaManagementToolCoordinator.performScriptAction(action, metadata, tool, serviceRegistry, executionOptions, configService));
        }
        if (databaseActionMap != null) {
            databaseActionMap.forEach((action, contributors) -> {
                SchemaManagementToolCoordinator.performDatabaseAction(action, metadata, tool, serviceRegistry, executionOptions, exportable -> contributors.contains(exportable.getContributor()));
                if (action == Action.CREATE_DROP) {
                    delayedDropRegistry.registerOnCloseAction(tool.getSchemaDropper(configurationValues).buildDelayedAction(metadata, executionOptions, exportable -> contributors.contains(exportable.getContributor()), SchemaManagementToolCoordinator.buildDatabaseTargetDescriptor(configurationValues, DropSettingSelector.INSTANCE, serviceRegistry)));
                }
            });
        }
    }

    public static ExecutionOptions buildExecutionOptions(final Map<String, Object> configurationValues, final ExceptionHandler exceptionHandler) {
        return new ExecutionOptions(){

            @Override
            public boolean shouldManageNamespaces() {
                return Helper.interpretNamespaceHandling(configurationValues);
            }

            @Override
            public Map<String, Object> getConfigurationValues() {
                return configurationValues;
            }

            @Override
            public ExceptionHandler getExceptionHandler() {
                return exceptionHandler;
            }
        };
    }

    private static void performDatabaseAction(Action action, Metadata metadata, SchemaManagementTool tool, ServiceRegistry serviceRegistry, ExecutionOptions executionOptions, ContributableMatcher contributableInclusionFilter) {
        switch (action) {
            case CREATE_ONLY: {
                JpaTargetAndSourceDescriptor createDescriptor = SchemaManagementToolCoordinator.buildDatabaseTargetDescriptor(executionOptions.getConfigurationValues(), CreateSettingSelector.INSTANCE, serviceRegistry);
                tool.getSchemaCreator(executionOptions.getConfigurationValues()).doCreation(metadata, executionOptions, contributableInclusionFilter, createDescriptor, createDescriptor);
                break;
            }
            case CREATE: 
            case CREATE_DROP: {
                JpaTargetAndSourceDescriptor dropDescriptor = SchemaManagementToolCoordinator.buildDatabaseTargetDescriptor(executionOptions.getConfigurationValues(), DropSettingSelector.INSTANCE, serviceRegistry);
                tool.getSchemaDropper(executionOptions.getConfigurationValues()).doDrop(metadata, executionOptions, contributableInclusionFilter, dropDescriptor, dropDescriptor);
                JpaTargetAndSourceDescriptor createDescriptor = SchemaManagementToolCoordinator.buildDatabaseTargetDescriptor(executionOptions.getConfigurationValues(), CreateSettingSelector.INSTANCE, serviceRegistry);
                tool.getSchemaCreator(executionOptions.getConfigurationValues()).doCreation(metadata, executionOptions, contributableInclusionFilter, createDescriptor, createDescriptor);
                break;
            }
            case DROP: {
                JpaTargetAndSourceDescriptor dropDescriptor = SchemaManagementToolCoordinator.buildDatabaseTargetDescriptor(executionOptions.getConfigurationValues(), DropSettingSelector.INSTANCE, serviceRegistry);
                tool.getSchemaDropper(executionOptions.getConfigurationValues()).doDrop(metadata, executionOptions, contributableInclusionFilter, dropDescriptor, dropDescriptor);
                break;
            }
            case UPDATE: {
                JpaTargetAndSourceDescriptor migrateDescriptor = SchemaManagementToolCoordinator.buildDatabaseTargetDescriptor(executionOptions.getConfigurationValues(), MigrateSettingSelector.INSTANCE, serviceRegistry);
                tool.getSchemaMigrator(executionOptions.getConfigurationValues()).doMigration(metadata, executionOptions, contributableInclusionFilter, migrateDescriptor);
                break;
            }
            case VALIDATE: {
                tool.getSchemaValidator(executionOptions.getConfigurationValues()).doValidation(metadata, executionOptions, contributableInclusionFilter);
                break;
            }
            case TRUNCATE: {
                tool.getSchemaTruncator(executionOptions.getConfigurationValues()).doTruncate(metadata, executionOptions, contributableInclusionFilter, SchemaManagementToolCoordinator.buildDatabaseTargetDescriptor(executionOptions.getConfigurationValues(), CreateSettingSelector.INSTANCE, serviceRegistry));
                break;
            }
            case POPULATE: {
                tool.getSchemaPopulator(executionOptions.getConfigurationValues()).doPopulation(executionOptions, SchemaManagementToolCoordinator.buildDatabaseTargetDescriptor(executionOptions.getConfigurationValues(), CreateSettingSelector.INSTANCE, serviceRegistry));
            }
        }
    }

    private static JpaTargetAndSourceDescriptor buildDatabaseTargetDescriptor(Map<?, ?> configurationValues, SettingSelector settingSelector, ServiceRegistry serviceRegistry) {
        boolean includesScripts;
        Object scriptSourceSetting = settingSelector.getScriptSourceSetting(configurationValues);
        final SourceType sourceType = SourceType.interpret(settingSelector.getSourceTypeSetting(configurationValues), scriptSourceSetting != null ? SourceType.SCRIPT : SourceType.METADATA);
        boolean bl = includesScripts = sourceType != SourceType.METADATA;
        if (includesScripts && scriptSourceSetting == null) {
            throw new SchemaManagementException("Schema generation configuration indicated to include CREATE scripts, but no script was specified");
        }
        final ScriptSourceInput scriptSourceInput = includesScripts ? Helper.interpretScriptSourceSetting(scriptSourceSetting, serviceRegistry.getService(ClassLoaderService.class), (String)configurationValues.get("hibernate.hbm2ddl.charset_name")) : null;
        return new JpaTargetAndSourceDescriptor(){

            @Override
            public EnumSet<TargetType> getTargetTypes() {
                return EnumSet.of(TargetType.DATABASE);
            }

            @Override
            public ScriptTargetOutput getScriptTargetOutput() {
                return null;
            }

            @Override
            public SourceType getSourceType() {
                return sourceType;
            }

            @Override
            public ScriptSourceInput getScriptSourceInput() {
                return scriptSourceInput;
            }
        };
    }

    private static void performScriptAction(Action scriptAction, Metadata metadata, SchemaManagementTool tool, ServiceRegistry serviceRegistry, ExecutionOptions executionOptions, ConfigurationService configurationService) {
        switch (scriptAction) {
            case CREATE_ONLY: {
                JpaTargetAndSourceDescriptor createDescriptor = SchemaManagementToolCoordinator.buildScriptTargetDescriptor(executionOptions.getConfigurationValues(), CreateSettingSelector.INSTANCE, serviceRegistry, configurationService);
                tool.getSchemaCreator(executionOptions.getConfigurationValues()).doCreation(metadata, executionOptions, contributed -> true, createDescriptor, createDescriptor);
                break;
            }
            case CREATE: 
            case CREATE_DROP: {
                JpaTargetAndSourceDescriptor dropDescriptor = SchemaManagementToolCoordinator.buildScriptTargetDescriptor(executionOptions.getConfigurationValues(), DropSettingSelector.INSTANCE, serviceRegistry, configurationService);
                tool.getSchemaDropper(executionOptions.getConfigurationValues()).doDrop(metadata, executionOptions, contributed -> true, dropDescriptor, dropDescriptor);
                JpaTargetAndSourceDescriptor createDescriptor = SchemaManagementToolCoordinator.buildScriptTargetDescriptor(executionOptions.getConfigurationValues(), CreateSettingSelector.INSTANCE, serviceRegistry, configurationService);
                tool.getSchemaCreator(executionOptions.getConfigurationValues()).doCreation(metadata, executionOptions, contributed -> true, createDescriptor, createDescriptor);
                break;
            }
            case DROP: {
                JpaTargetAndSourceDescriptor dropDescriptor = SchemaManagementToolCoordinator.buildScriptTargetDescriptor(executionOptions.getConfigurationValues(), DropSettingSelector.INSTANCE, serviceRegistry, configurationService);
                tool.getSchemaDropper(executionOptions.getConfigurationValues()).doDrop(metadata, executionOptions, contributed -> true, dropDescriptor, dropDescriptor);
                break;
            }
            case UPDATE: {
                JpaTargetAndSourceDescriptor migrateDescriptor = SchemaManagementToolCoordinator.buildScriptTargetDescriptor(executionOptions.getConfigurationValues(), MigrateSettingSelector.INSTANCE, serviceRegistry, configurationService);
                tool.getSchemaMigrator(executionOptions.getConfigurationValues()).doMigration(metadata, executionOptions, contributed -> true, migrateDescriptor);
                break;
            }
            case VALIDATE: {
                throw new SchemaManagementException("VALIDATE is not valid SchemaManagementTool action for script output");
            }
        }
    }

    private static JpaTargetAndSourceDescriptor buildScriptTargetDescriptor(Map<?, ?> configurationValues, SettingSelector settingSelector, ServiceRegistry serviceRegistry, ConfigurationService configurationService) {
        boolean includesScripts;
        Object scriptSourceSetting = settingSelector.getScriptSourceSetting(configurationValues);
        final SourceType sourceType = SourceType.interpret(settingSelector.getSourceTypeSetting(configurationValues), scriptSourceSetting != null ? SourceType.SCRIPT : SourceType.METADATA);
        boolean bl = includesScripts = sourceType != SourceType.METADATA;
        if (includesScripts && scriptSourceSetting == null) {
            throw new SchemaManagementException("Schema generation configuration indicated to include CREATE scripts, but no script was specified");
        }
        String charsetName = (String)configurationValues.get("hibernate.hbm2ddl.charset_name");
        final ScriptSourceInput scriptSourceInput = includesScripts ? Helper.interpretScriptSourceSetting(scriptSourceSetting, serviceRegistry.getService(ClassLoaderService.class), charsetName) : null;
        boolean append = configurationService.getSetting("hibernate.hbm2ddl.schema-generation.script.append", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        final ScriptTargetOutput scriptTargetOutput = Helper.interpretScriptTargetSetting(settingSelector.getScriptTargetSetting(configurationValues), serviceRegistry.getService(ClassLoaderService.class), charsetName, append);
        return new JpaTargetAndSourceDescriptor(){

            @Override
            public EnumSet<TargetType> getTargetTypes() {
                return EnumSet.of(TargetType.SCRIPT);
            }

            @Override
            public ScriptTargetOutput getScriptTargetOutput() {
                return scriptTargetOutput;
            }

            @Override
            public SourceType getSourceType() {
                return sourceType;
            }

            @Override
            public ScriptSourceInput getScriptSourceInput() {
                return scriptSourceInput;
            }
        };
    }

    private static Object getConfigurationValue(Map<?, ?> configurationValues, String referenceKey, String legacyKey) {
        Object setting = configurationValues.get(referenceKey);
        if (setting == null && (setting = configurationValues.get(legacyKey)) != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting(referenceKey, legacyKey);
        }
        return setting;
    }

    public static class ActionGrouping {
        private final String contributor;
        private final Action databaseAction;
        private final Action scriptAction;

        public ActionGrouping(String contributor, Action databaseAction, Action scriptAction) {
            this.contributor = contributor;
            this.databaseAction = databaseAction;
            this.scriptAction = scriptAction;
        }

        public String getContributor() {
            return this.contributor;
        }

        public Action getDatabaseAction() {
            return this.databaseAction;
        }

        public Action getScriptAction() {
            return this.scriptAction;
        }

        @Internal
        public static ActionGrouping interpret(Map<?, ?> configurationValues) {
            Action autoAction;
            Action databaseAction = ActionGrouping.determineJpaDbActionSetting(configurationValues);
            Action scriptAction = ActionGrouping.determineJpaScriptActionSetting(configurationValues);
            if (databaseAction == null && scriptAction == null && (autoAction = ActionGrouping.determineAutoSettingImpliedAction(configurationValues, null, null)) != null) {
                databaseAction = autoAction;
            }
            if (databaseAction == null) {
                databaseAction = Action.NONE;
            }
            if (scriptAction == null) {
                scriptAction = Action.NONE;
            }
            return new ActionGrouping("orm", databaseAction, scriptAction);
        }

        private static Action determineJpaDbActionSetting(Map<?, ?> configurationValues) {
            return ActionGrouping.determineJpaDbActionSetting(configurationValues, null, null);
        }

        @Internal
        public static Action determineJpaDbActionSetting(Map<?, ?> configurationValues, String contributor, Action defaultValue) {
            Object jakartaSettingName = contributor == null ? "jakarta.persistence.schema-generation.database.action" : "jakarta.persistence.schema-generation.database.action." + contributor;
            Object javaxSettingName = contributor == null ? "javax.persistence.schema-generation.database.action" : "javax.persistence.schema-generation.database.action." + contributor;
            Object databaseActionSetting = configurationValues.get(jakartaSettingName);
            if (databaseActionSetting == null && (databaseActionSetting = configurationValues.get(javaxSettingName)) != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.schema-generation.database.action", "jakarta.persistence.schema-generation.database.action");
            }
            return databaseActionSetting == null ? defaultValue : Action.interpretJpaSetting(databaseActionSetting);
        }

        private static Action determineJpaScriptActionSetting(Map<?, ?> configurationValues) {
            return ActionGrouping.determineJpaScriptActionSetting(configurationValues, null, null);
        }

        @Internal
        public static Action determineJpaScriptActionSetting(Map<?, ?> configurationValues, String contributor, Action defaultValue) {
            Object jakartaSettingName = contributor == null ? "jakarta.persistence.schema-generation.scripts.action" : "jakarta.persistence.schema-generation.scripts.action." + contributor;
            Object javaxSettingName = contributor == null ? "javax.persistence.schema-generation.scripts.action" : "javax.persistence.schema-generation.scripts.action." + contributor;
            Object scriptsActionSetting = configurationValues.get(jakartaSettingName);
            if (scriptsActionSetting == null && (scriptsActionSetting = configurationValues.get(javaxSettingName)) != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.schema-generation.scripts.action", "jakarta.persistence.schema-generation.scripts.action");
            }
            return scriptsActionSetting == null ? defaultValue : Action.interpretJpaSetting(scriptsActionSetting);
        }

        public static Action determineAutoSettingImpliedAction(Map<?, ?> settings, String contributor, Action defaultValue) {
            Object settingName = contributor == null ? "hibernate.hbm2ddl.auto" : "hibernate.hbm2ddl.auto." + contributor;
            Object scriptsActionSetting = settings.get(settingName);
            if (scriptsActionSetting == null) {
                return defaultValue;
            }
            return Action.interpretHbm2ddlSetting(scriptsActionSetting);
        }

        public static Set<ActionGrouping> interpret(Set<String> contributors, Map<?, ?> configurationValues) {
            Action rootDatabaseAction = ActionGrouping.determineJpaDbActionSetting(configurationValues, null, null);
            Action rootScriptAction = ActionGrouping.determineJpaScriptActionSetting(configurationValues, null, null);
            Action rootAutoAction = ActionGrouping.determineAutoSettingImpliedAction(configurationValues, null, null);
            HashSet<ActionGrouping> groupings = new HashSet<ActionGrouping>(contributors.size());
            for (String contributor : contributors) {
                Action contributorAutoSetting;
                Action databaseActionToUse = ActionGrouping.determineJpaDbActionSetting(configurationValues, contributor, rootDatabaseAction);
                Action scriptActionToUse = ActionGrouping.determineJpaScriptActionSetting(configurationValues, contributor, rootScriptAction);
                if (databaseActionToUse == null && scriptActionToUse == null && (contributorAutoSetting = ActionGrouping.determineAutoSettingImpliedAction(configurationValues, contributor, rootAutoAction)) != null) {
                    databaseActionToUse = contributorAutoSetting;
                }
                if (databaseActionToUse == null) {
                    databaseActionToUse = Action.NONE;
                }
                if (scriptActionToUse == null) {
                    scriptActionToUse = Action.NONE;
                }
                if (databaseActionToUse == Action.NONE && scriptActionToUse == Action.NONE) {
                    log.debugf("No schema actions specified for contributor '%s'", (Object)contributor);
                    continue;
                }
                groupings.add(new ActionGrouping(contributor, databaseActionToUse, scriptActionToUse));
            }
            return groupings;
        }

        public static Set<ActionGrouping> interpret(Metadata metadata, Map<?, ?> configurationValues) {
            return ActionGrouping.interpret(metadata.getContributors(), configurationValues);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionGrouping that = (ActionGrouping)o;
            return this.contributor.equals(that.contributor) && this.databaseAction == that.databaseAction && this.scriptAction == that.scriptAction;
        }

        public int hashCode() {
            return Objects.hash(this.contributor);
        }
    }

    private static class CreateSettingSelector
    implements SettingSelector {
        public static final CreateSettingSelector INSTANCE = new CreateSettingSelector();

        private CreateSettingSelector() {
        }

        @Override
        public Object getSourceTypeSetting(Map<?, ?> configurationValues) {
            return SchemaManagementToolCoordinator.getConfigurationValue(configurationValues, "jakarta.persistence.schema-generation.create-source", "javax.persistence.schema-generation.create-source");
        }

        @Override
        public Object getScriptSourceSetting(Map<?, ?> configurationValues) {
            return SchemaManagementToolCoordinator.getConfigurationValue(configurationValues, "jakarta.persistence.schema-generation.create-script-source", "javax.persistence.schema-generation.create-script-source");
        }

        @Override
        public Object getScriptTargetSetting(Map<?, ?> configurationValues) {
            return SchemaManagementToolCoordinator.getConfigurationValue(configurationValues, "jakarta.persistence.schema-generation.scripts.create-target", "javax.persistence.schema-generation.scripts.create-target");
        }
    }

    private static interface SettingSelector {
        public Object getSourceTypeSetting(Map<?, ?> var1);

        public Object getScriptSourceSetting(Map<?, ?> var1);

        public Object getScriptTargetSetting(Map<?, ?> var1);
    }

    private static class DropSettingSelector
    implements SettingSelector {
        public static final DropSettingSelector INSTANCE = new DropSettingSelector();

        private DropSettingSelector() {
        }

        @Override
        public Object getSourceTypeSetting(Map<?, ?> configurationValues) {
            return SchemaManagementToolCoordinator.getConfigurationValue(configurationValues, "jakarta.persistence.schema-generation.drop-source", "javax.persistence.schema-generation.drop-source");
        }

        @Override
        public Object getScriptSourceSetting(Map<?, ?> configurationValues) {
            return SchemaManagementToolCoordinator.getConfigurationValue(configurationValues, "jakarta.persistence.schema-generation.drop-script-source", "javax.persistence.schema-generation.drop-script-source");
        }

        @Override
        public Object getScriptTargetSetting(Map<?, ?> configurationValues) {
            return SchemaManagementToolCoordinator.getConfigurationValue(configurationValues, "jakarta.persistence.schema-generation.scripts.drop-target", "javax.persistence.schema-generation.scripts.drop-target");
        }
    }

    private static class MigrateSettingSelector
    implements SettingSelector {
        public static final MigrateSettingSelector INSTANCE = new MigrateSettingSelector();

        private MigrateSettingSelector() {
        }

        @Override
        public Object getSourceTypeSetting(Map<?, ?> configurationValues) {
            return SourceType.METADATA;
        }

        @Override
        public Object getScriptSourceSetting(Map<?, ?> configurationValues) {
            return null;
        }

        @Override
        public Object getScriptTargetSetting(Map<?, ?> configurationValues) {
            return SchemaManagementToolCoordinator.getConfigurationValue(configurationValues, "jakarta.persistence.schema-generation.scripts.create-target", "javax.persistence.schema-generation.scripts.create-target");
        }
    }
}

