/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.collection.spi.AbstractPersistentCollection;
import org.hibernate.collection.spi.PersistentArrayHolder;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.MappingContext;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class CollectionType
extends AbstractType
implements AssociationType {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(MethodHandles.lookup(), CoreMessageLogger.class, CollectionType.class.getName());
    @Internal
    public static final Object UNFETCHED_COLLECTION = new MarkerObject("UNFETCHED COLLECTION");
    private final String role;
    private final String foreignKeyPropertyName;
    private volatile CollectionPersister persister;

    public CollectionType(String role, String foreignKeyPropertyName) {
        this.role = role;
        this.foreignKeyPropertyName = foreignKeyPropertyName;
    }

    public abstract CollectionClassification getCollectionClassification();

    public String getRole() {
        return this.role;
    }

    public Object indexOf(Object collection, Object element) {
        throw new UnsupportedOperationException("generic collections don't have indexes");
    }

    public boolean contains(Object collection, Object childObject, SharedSessionContractImplementor session) {
        Iterator<?> elems = this.getElementsIterator(collection);
        while (elems.hasNext()) {
            Object maybeProxy = elems.next();
            LazyInitializer initializer = HibernateProxy.extractLazyInitializer(maybeProxy);
            Object element = initializer != null && !initializer.isUninitialized() ? initializer.getImplementation() : maybeProxy;
            if (element != childObject) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCollectionType() {
        return true;
    }

    @Override
    public final boolean isEqual(Object x, Object y) {
        PersistentCollection yc;
        PersistentCollection xc;
        return x == y || x instanceof PersistentCollection && this.isEqual(xc = (PersistentCollection)x, y) || y instanceof PersistentCollection && this.isEqual(yc = (PersistentCollection)y, x);
    }

    private boolean isEqual(PersistentCollection<?> collection, Object other) {
        return collection.wasInitialized() && (collection.isWrapper(other) || collection.isDirectlyProvidedCollection(other));
    }

    @Override
    public int compare(Object x, Object y) {
        return 0;
    }

    @Override
    public int compare(Object x, Object y, SessionFactoryImplementor sessionFactory) {
        return this.compare(x, y);
    }

    @Override
    public int getHashCode(Object x) {
        throw new UnsupportedOperationException("cannot doAfterTransactionCompletion lookups on collections");
    }

    public abstract PersistentCollection<?> instantiate(SharedSessionContractImplementor var1, CollectionPersister var2, Object var3);

    @Override
    public final void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws HibernateException, SQLException {
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
    }

    @Override
    public int[] getSqlTypeCodes(MappingContext mappingContext) throws MappingException {
        return ArrayHelper.EMPTY_INT_ARRAY;
    }

    @Override
    public int getColumnSpan(MappingContext session) throws MappingException {
        return 0;
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        if (value == null) {
            return "null";
        }
        if (!this.getReturnedClass().isInstance(value) && !(value instanceof PersistentCollection)) {
            CollectionPersister persister = this.getPersister(factory);
            Type keyType = persister.getKeyType();
            Type identifierType = persister.getIdentifierType();
            if (keyType.getReturnedClass().isInstance(value)) {
                return this.getRole() + "#" + keyType.toLoggableString(value, factory);
            }
            if (identifierType != null && identifierType.getReturnedClass().isInstance(value)) {
                return this.getRole() + "#" + identifierType.toLoggableString(value, factory);
            }
        }
        return this.renderLoggableString(value, factory);
    }

    protected String renderLoggableString(Object value, SessionFactoryImplementor factory) {
        if (!Hibernate.isInitialized(value)) {
            return "<uninitialized>";
        }
        ArrayList list = new ArrayList();
        Type elemType = this.getElementType(factory);
        this.getElementsIterator(value).forEachRemaining(element -> list.add(CollectionType.elementString(factory, element, elemType)));
        return ((Object)list).toString();
    }

    private static String elementString(SessionFactoryImplementor factory, Object element, Type elemType) {
        return element == LazyPropertyInitializer.UNFETCHED_PROPERTY || !Hibernate.isInitialized(element) ? "<uninitialized>" : elemType.toLoggableString(element, factory);
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) {
        return value;
    }

    @Override
    public String getName() {
        return this.getReturnedClassName() + "(" + this.getRole() + ")";
    }

    @Deprecated
    public Iterator<?> getElementsIterator(Object collection, SharedSessionContractImplementor session) {
        return this.getElementsIterator(collection);
    }

    public Iterator<?> getElementsIterator(Object collection) {
        return ((Collection)collection).iterator();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Internal
    @Incubating
    public boolean isInverse(SessionFactoryImplementor factory) {
        return this.getPersister(factory).isInverse();
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        Object key = this.getKeyOfOwner(owner, session);
        return key == null ? null : this.getPersister(session).getKeyType().disassemble(key, session, owner);
    }

    @Override
    public Serializable disassemble(Object value, SessionFactoryImplementor sessionFactory) throws HibernateException {
        throw new UnsupportedOperationException("CollectionType not supported as part of cache key!");
    }

    @Override
    public Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        Object key = this.getPersister(session).getKeyType().assemble(cached, session, owner);
        return this.resolveKey(key, session, owner);
    }

    private CollectionPersister getPersister(SharedSessionContractImplementor session) {
        return this.getPersister(session.getFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionPersister getPersister(SessionFactoryImplementor factory) {
        CollectionPersister persister = this.persister;
        if (persister != null) {
            return persister;
        }
        CollectionType collectionType = this;
        synchronized (collectionType) {
            persister = this.persister;
            if (persister != null) {
                return persister;
            }
            this.persister = persister = factory.getMappingMetamodel().getCollectionDescriptor(this.role);
            return persister;
        }
    }

    @Override
    public boolean isDirty(Object old, Object current, SharedSessionContractImplementor session) throws HibernateException {
        return super.isDirty(old, current, session);
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        return this.isDirty(old, current, session);
    }

    public abstract PersistentCollection<?> wrap(SharedSessionContractImplementor var1, Object var2);

    @Override
    public boolean isAssociationType() {
        return true;
    }

    @Override
    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.TO_PARENT;
    }

    public @Nullable Object getKeyOfOwner(Object owner, SharedSessionContractImplementor session) {
        EntityEntry entityEntry = session.getPersistenceContextInternal().getEntry(owner);
        if (entityEntry == null) {
            return null;
        }
        if (this.foreignKeyPropertyName == null) {
            return entityEntry.getId();
        }
        Object loadedValue = entityEntry.getLoadedValue(this.foreignKeyPropertyName);
        return loadedValue == null ? entityEntry.getPersister().getPropertyValue(owner, this.foreignKeyPropertyName) : loadedValue;
    }

    public Object getIdOfOwnerOrNull(Object key, SharedSessionContractImplementor session) {
        if (this.foreignKeyPropertyName == null) {
            return key;
        }
        EntityPersister ownerPersister = this.getPersister(session).getOwnerEntityPersister();
        Class<?> keyClass = this.keyClass(session);
        if (ownerPersister.getMappedClass().isAssignableFrom(keyClass) && keyClass.isInstance(key)) {
            return ownerPersister.getIdentifier(key, session);
        }
        return null;
    }

    private Class<?> keyClass(SharedSessionContractImplementor session) {
        return this.getPersister(session).getKeyType().getReturnedClass();
    }

    private Object resolveKey(Object key, SharedSessionContractImplementor session, Object owner) {
        return key == null ? null : this.getCollection(key, session, owner, null);
    }

    public boolean isArrayType() {
        return false;
    }

    @Override
    public boolean useLHSPrimaryKey() {
        return this.foreignKeyPropertyName == null;
    }

    @Override
    public String getRHSUniqueKeyPropertyName() {
        return null;
    }

    @Override
    public Joinable getAssociatedJoinable(SessionFactoryImplementor factory) throws MappingException {
        return (Joinable)((Object)factory.getMappingMetamodel().getCollectionDescriptor(this.role));
    }

    @Override
    public boolean isModified(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) {
        return false;
    }

    @Override
    public String getAssociatedEntityName(SessionFactoryImplementor factory) throws MappingException {
        CollectionPersister persister = factory.getMappingMetamodel().getCollectionDescriptor(this.role);
        if (persister.getElementType().isEntityType()) {
            return persister.getElementPersister().getEntityName();
        }
        throw new MappingException("Collection is not an association: " + persister.getRole());
    }

    public Object replaceElements(Object original, Object target, Object owner, Map<Object, Object> copyCache, SharedSessionContractImplementor session) {
        Collection result = (Collection)target;
        result.clear();
        Type elemType = this.getElementType(session.getFactory());
        for (Object element : (Collection)original) {
            result.add(elemType.replace(element, null, session, owner, copyCache));
        }
        if (original instanceof PersistentCollection) {
            PersistentCollection originalPersistentCollection = (PersistentCollection)original;
            if (result instanceof PersistentCollection) {
                PersistentCollection resultPersistentCollection = (PersistentCollection)((Object)result);
                this.preserveSnapshot(originalPersistentCollection, resultPersistentCollection, elemType, owner, copyCache, session);
                if (!originalPersistentCollection.isDirty()) {
                    resultPersistentCollection.clearDirty();
                }
            }
        }
        return result;
    }

    private void preserveSnapshot(PersistentCollection<?> original, PersistentCollection<?> result, Type elemType, Object owner, Map<Object, Object> copyCache, SharedSessionContractImplementor session) {
        CollectionEntry ce = session.getPersistenceContextInternal().getCollectionEntry(result);
        if (ce != null) {
            ce.resetStoredSnapshot(result, CollectionType.createSnapshot(original, result, elemType, owner, copyCache, session));
        }
    }

    private static Serializable createSnapshot(PersistentCollection<?> original, PersistentCollection<?> result, Type elemType, Object owner, Map<Object, Object> copyCache, SharedSessionContractImplementor session) {
        Serializable originalSnapshot = original.getStoredSnapshot();
        if (originalSnapshot instanceof List) {
            List list = (List)((Object)originalSnapshot);
            return CollectionType.createListSnapshot(list, elemType, owner, copyCache, session);
        }
        if (originalSnapshot instanceof Map) {
            Map map = (Map)((Object)originalSnapshot);
            return CollectionType.createMapSnapshot(map, result, elemType, owner, copyCache, session);
        }
        if (originalSnapshot instanceof Object[]) {
            Object[] array = (Object[])originalSnapshot;
            return CollectionType.createArraySnapshot(array, elemType, owner, copyCache, session);
        }
        return result.getStoredSnapshot();
    }

    private static Serializable createArraySnapshot(Object[] array, Type elemType, Object owner, Map<Object, Object> copyCache, SharedSessionContractImplementor session) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = elemType.replace(array[i], null, session, owner, copyCache);
        }
        return array;
    }

    private static <K, V> Serializable createMapSnapshot(Map<K, V> map, PersistentCollection<?> result, Type elemType, Object owner, Map<Object, Object> copyCache, SharedSessionContractImplementor session) {
        AbstractMap snapshot;
        AbstractMap targetMap;
        if (map instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)map;
            TreeMap treeMap = new TreeMap(sortedMap.comparator());
            targetMap = treeMap;
            snapshot = treeMap;
        } else {
            HashMap hashMap = CollectionHelper.mapOfSize(map.size());
            targetMap = hashMap;
            snapshot = hashMap;
        }
        Map resultSnapshot = (Map)((Object)result.getStoredSnapshot());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            Object resultSnapshotValue = resultSnapshot == null ? null : resultSnapshot.get(key);
            Object newValue = elemType.replace(value, resultSnapshotValue, session, owner, copyCache);
            targetMap.put(key == value ? newValue : key, newValue);
        }
        return snapshot;
    }

    private static ArrayList<Object> createListSnapshot(List<?> list, Type elemType, Object owner, Map<Object, Object> copyCache, SharedSessionContractImplementor session) {
        ArrayList<Object> targetList = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            targetList.add(elemType.replace(obj, null, session, owner, copyCache));
        }
        return targetList;
    }

    protected Object instantiateResult(Object original) {
        return this.instantiate(-1);
    }

    public abstract Object instantiate(int var1);

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) throws HibernateException {
        if (original == null) {
            return CollectionType.replaceNullOriginal(target, session);
        }
        if (!Hibernate.isInitialized(original)) {
            return this.replaceUninitializedOriginal(original, target, session, copyCache);
        }
        return this.replaceOriginal(original, target, session, owner, copyCache);
    }

    private Object replaceOriginal(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) {
        Object result = this.replaceElements(original, this.instantiateResultIfNecessary(original, target), owner, copyCache, session);
        if (original == target) {
            PersistentCollection oldCollection;
            PersistentCollection collection;
            boolean wasClean;
            boolean bl = wasClean = target instanceof PersistentCollection && !(collection = (PersistentCollection)target).isDirty();
            if (target instanceof PersistentCollection && (oldCollection = (PersistentCollection)target).isDirectlyAccessible()) {
                CollectionPersister collectionPersister = this.getPersister(session);
                Object key = oldCollection.getKey();
                PersistentCollection<?> newCollection = this.instantiate(session, collectionPersister, key);
                newCollection.initializeEmptyCollection(collectionPersister);
                newCollection.setSnapshot(key, oldCollection.getRole(), oldCollection.getStoredSnapshot());
                session.getPersistenceContextInternal().replaceCollection(collectionPersister, oldCollection, newCollection);
                target = newCollection;
            }
            this.replaceElements(result, target, owner, copyCache, session);
            if (wasClean) {
                ((PersistentCollection)target).clearDirty();
            }
            return target;
        }
        return result;
    }

    private Object instantiateResultIfNecessary(Object original, Object target) {
        PersistentCollection collection;
        return target == null || target == original || target == LazyPropertyInitializer.UNFETCHED_PROPERTY || target instanceof PersistentCollection && (collection = (PersistentCollection)target).isWrapper(original) ? this.instantiateResult(original) : target;
    }

    private Object replaceUninitializedOriginal(Object original, Object target, SharedSessionContractImplementor session, Map<Object, Object> copyCache) {
        PersistentCollection collection = (PersistentCollection)original;
        if (collection.hasQueuedOperations()) {
            if (original == target) {
                AbstractPersistentCollection pc = (AbstractPersistentCollection)original;
                pc.replaceQueuedOperationValues(this.getPersister(session), copyCache);
            } else {
                LOG.ignoreQueuedOperationsOnMerge(MessageHelper.collectionInfoString(this.getRole(), collection.getKey()));
            }
        }
        return target;
    }

    private static Object replaceNullOriginal(Object target, SharedSessionContractImplementor session) {
        if (target == null) {
            return null;
        }
        if (target instanceof Collection) {
            Collection collection = (Collection)target;
            collection.clear();
            return collection;
        }
        if (target instanceof Map) {
            Map map = (Map)target;
            map.clear();
            return map;
        }
        PersistenceContext persistenceContext = session.getPersistenceContext();
        PersistentCollection<?> collectionHolder = persistenceContext.getCollectionHolder(target);
        if (collectionHolder != null && collectionHolder instanceof PersistentArrayHolder) {
            PersistentArrayHolder arrayHolder = (PersistentArrayHolder)collectionHolder;
            persistenceContext.removeCollectionHolder(target);
            arrayHolder.beginRead();
            PluralAttributeMapping attributeMapping = persistenceContext.getCollectionEntry(collectionHolder).getLoadedPersister().getAttributeMapping();
            arrayHolder.injectLoadedState(attributeMapping, (List)null);
            arrayHolder.endRead();
            arrayHolder.dirty();
            persistenceContext.addCollectionHolder(collectionHolder);
            return arrayHolder.getArray();
        }
        return null;
    }

    public final Type getElementType(SessionFactoryImplementor factory) throws MappingException {
        return factory.getMappingMetamodel().getCollectionDescriptor(this.role).getElementType();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getRole() + ")";
    }

    public Object getCollection(Object key, SharedSessionContractImplementor session, Object owner, Boolean overridingEager) {
        PersistentCollection<?> collection;
        CollectionPersister persister = this.getPersister(session);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        CollectionKey collectionKey = new CollectionKey(persister, key);
        LoadingCollectionEntry loadingCollectionEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(collectionKey);
        PersistentCollection<?> persistentCollection = collection = loadingCollectionEntry == null ? null : loadingCollectionEntry.getCollectionInstance();
        if (collection == null && (collection = persistenceContext.useUnownedCollection(collectionKey)) == null && (collection = persistenceContext.getCollection(collectionKey)) == null) {
            return this.createNewWrapper(key, owner, overridingEager, persister, session).getValue();
        }
        collection.setOwner(owner);
        return collection.getValue();
    }

    private PersistentCollection<?> createNewWrapper(Object key, Object owner, Boolean overridingEager, CollectionPersister persister, SharedSessionContractImplementor session) {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        PersistentCollection<?> collection = this.instantiate(session, persister, key);
        collection.setOwner(owner);
        persistenceContext.addUninitializedCollection(persister, collection, key);
        if (this.initializeImmediately()) {
            session.initializeCollection(collection, false);
        } else if (overridingEager != null ? overridingEager != false : !persister.isLazy()) {
            persistenceContext.addNonLazyCollection(collection);
        }
        if (this.hasHolder()) {
            persistenceContext.addCollectionHolder(collection);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created collection wrapper: " + MessageHelper.collectionInfoString(persister, collection, key, session));
        }
        return collection;
    }

    public boolean hasHolder() {
        return false;
    }

    protected boolean initializeImmediately() {
        return false;
    }

    @Override
    public String getLHSPropertyName() {
        return this.foreignKeyPropertyName;
    }

    @Override
    public boolean isAlwaysDirtyChecked() {
        return true;
    }

    @Override
    public boolean[] toColumnNullness(Object value, MappingContext mapping) {
        return ArrayHelper.EMPTY_BOOLEAN_ARRAY;
    }
}

