/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.PersistenceException;
import java.util.Objects;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public final class AttributeConverterInstance<O, R>
implements BasicValueConverter<O, R> {
    private final AttributeConverter<O, R> converter;
    private final JavaType<O> domainJavaType;
    private final JavaType<R> jdbcJavaType;

    public AttributeConverterInstance(AttributeConverter<O, R> converter, JavaType<O> domainJavaType, JavaType<R> jdbcJavaType) {
        this.converter = converter;
        this.domainJavaType = domainJavaType;
        this.jdbcJavaType = jdbcJavaType;
    }

    @Override
    public O toDomainValue(R relationalForm) {
        try {
            return this.converter.convertToEntityAttribute(relationalForm);
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new PersistenceException("Error attempting to apply AttributeConverter", re);
        }
    }

    @Override
    public R toRelationalValue(O domainForm) {
        try {
            return this.converter.convertToDatabaseColumn(domainForm);
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new PersistenceException("Error attempting to apply AttributeConverter: " + re.getMessage(), re);
        }
    }

    @Override
    public JavaType<O> getDomainJavaType() {
        return this.domainJavaType;
    }

    @Override
    public JavaType<R> getRelationalJavaType() {
        return this.jdbcJavaType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AttributeConverterInstance)) return false;
        AttributeConverterInstance that = (AttributeConverterInstance)object;
        if (!Objects.equals(this.converter, that.converter)) return false;
        if (!Objects.equals(this.domainJavaType, that.domainJavaType)) return false;
        if (!Objects.equals(this.jdbcJavaType, that.jdbcJavaType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.converter, this.domainJavaType, this.jdbcJavaType);
    }
}

