/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.type.descriptor.java.ArrayJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeBaseline;
import org.hibernate.type.descriptor.java.spi.JavaTypeBasicAdaptor;
import org.hibernate.type.descriptor.java.spi.RegistryHelper;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.jboss.logging.Logger;

public class JavaTypeRegistry
implements JavaTypeBaseline.BaselineTarget,
Serializable {
    private static final Logger log = Logger.getLogger(JavaTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final ConcurrentHashMap<String, JavaType<?>> descriptorsByTypeName = new ConcurrentHashMap();

    public JavaTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        JavaTypeBaseline.prime(this);
    }

    @Override
    public void addBaselineDescriptor(JavaType<?> descriptor) {
        if (descriptor.getJavaType() == null) {
            throw new IllegalStateException("Illegal to add BasicJavaType with null Java type");
        }
        this.addBaselineDescriptor(descriptor.getJavaType(), descriptor);
    }

    @Override
    public void addBaselineDescriptor(Type describedJavaType, JavaType<?> descriptor) {
        this.performInjections(descriptor);
        this.descriptorsByTypeName.put(describedJavaType.getTypeName(), descriptor);
    }

    private void performInjections(JavaType<?> descriptor) {
        if (descriptor instanceof TypeConfigurationAware) {
            TypeConfigurationAware typeConfigurationAware = (TypeConfigurationAware)((Object)descriptor);
            typeConfigurationAware.setTypeConfiguration(this.typeConfiguration);
        }
    }

    public void forEachDescriptor(Consumer<JavaType<?>> consumer) {
        this.descriptorsByTypeName.values().forEach(consumer);
    }

    public <T> JavaType<T> getDescriptor(Type javaType) {
        return this.resolveDescriptor(javaType);
    }

    public void addDescriptor(JavaType<?> descriptor) {
        JavaType<?> old = this.descriptorsByTypeName.put(descriptor.getJavaType().getTypeName(), descriptor);
        if (old != null) {
            log.debugf("JavaTypeRegistry entry replaced : %s -> %s (was %s)", (Object)descriptor.getJavaType(), (Object)descriptor, (Object)old);
        }
        this.performInjections(descriptor);
    }

    public <J> JavaType<J> findDescriptor(Type javaType) {
        return this.descriptorsByTypeName.get(javaType.getTypeName());
    }

    public <J> JavaType<J> resolveDescriptor(Type javaType, Supplier<JavaType<J>> creator) {
        return this.resolveDescriptor(javaType.getTypeName(), creator);
    }

    private <J> JavaType<J> resolveDescriptor(String javaTypeName, Supplier<JavaType<J>> creator) {
        JavaType<?> cached = this.descriptorsByTypeName.get(javaTypeName);
        if (cached != null) {
            return cached;
        }
        JavaType<J> created = creator.get();
        this.descriptorsByTypeName.put(javaTypeName, created);
        return created;
    }

    public <J> JavaType<J> resolveDescriptor(Type javaType) {
        return this.resolveDescriptor(javaType, JavaTypeRegistry::createMutabilityPlan);
    }

    private static <J> MutabilityPlan<?> createMutabilityPlan(Type elementJavaType, TypeConfiguration typeConfiguration) {
        MutabilityPlan determinedPlan = RegistryHelper.INSTANCE.determineMutabilityPlan(elementJavaType, typeConfiguration);
        if (determinedPlan != null) {
            return determinedPlan;
        }
        return MutableMutabilityPlan.INSTANCE;
    }

    public JavaType<?> resolveArrayDescriptor(Class<?> elementJavaType) {
        return this.resolveDescriptor(elementJavaType.getTypeName() + "[]", () -> this.createArrayTypeDescriptor(elementJavaType, JavaTypeRegistry::createMutabilityPlan));
    }

    public <J> JavaType<J> resolveDescriptor(Type javaType, BiFunction<Type, TypeConfiguration, MutabilityPlan<?>> mutabilityPlanCreator) {
        return this.resolveDescriptor(javaType.getTypeName(), () -> {
            Class javaClass;
            if (javaType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)javaType;
                JavaType rawType = this.findDescriptor(parameterizedType.getRawType());
                if (rawType != null) {
                    return rawType.createJavaType(parameterizedType, this.typeConfiguration);
                }
            } else if (javaType instanceof Class && (javaClass = (Class)javaType).isArray()) {
                return this.createArrayTypeDescriptor(javaClass.getComponentType(), mutabilityPlanCreator);
            }
            return this.createTypeDescriptor(javaType, mutabilityPlanCreator);
        });
    }

    private <J> JavaType<J[]> createArrayTypeDescriptor(Class<J> elementJavaType, BiFunction<Type, TypeConfiguration, MutabilityPlan<?>> mutabilityPlanCreator) {
        JavaType<J> elementTypeDescriptor = this.findDescriptor(elementJavaType);
        if (elementTypeDescriptor == null) {
            elementTypeDescriptor = this.createTypeDescriptor(elementJavaType, mutabilityPlanCreator);
        }
        return new ArrayJavaType<J>(elementTypeDescriptor);
    }

    private <J> JavaType<J> createTypeDescriptor(Type javaType, BiFunction<Type, TypeConfiguration, MutabilityPlan<?>> mutabilityPlanCreator) {
        return RegistryHelper.INSTANCE.createTypeDescriptor(javaType, () -> (MutabilityPlan)mutabilityPlanCreator.apply(javaType, this.typeConfiguration), this.typeConfiguration);
    }

    public <J> JavaType<J> resolveManagedTypeDescriptor(Type javaType) {
        return this.resolveManagedTypeDescriptor(javaType, false);
    }

    public <J> JavaType<J> resolveEntityTypeDescriptor(Type javaType) {
        return this.resolveManagedTypeDescriptor(javaType, true);
    }

    private <J> JavaType<J> resolveManagedTypeDescriptor(Type javaType, boolean entity) {
        return this.resolveDescriptor(javaType, () -> {
            Class javaTypeClass;
            if (javaType instanceof Class) {
                javaTypeClass = (Class)javaType;
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)javaType;
                javaTypeClass = (Class)parameterizedType.getRawType();
            }
            MutabilityPlan determinedPlan = RegistryHelper.INSTANCE.determineMutabilityPlan(javaType, this.typeConfiguration);
            MutabilityPlan mutabilityPlan = determinedPlan != null ? determinedPlan : MutableMutabilityPlan.INSTANCE;
            return entity ? new EntityJavaType(javaTypeClass, mutabilityPlan) : new JavaTypeBasicAdaptor(javaTypeClass, mutabilityPlan);
        });
    }
}

