/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.JoinTable;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AnnotationException;
import org.hibernate.boot.model.internal.AbstractPropertyHolder;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AttributeConversionInfo;
import org.hibernate.boot.model.internal.ClassPropertyHolder;
import org.hibernate.boot.model.internal.CollectionPropertyHolder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.TypeDetails;

public class ComponentPropertyHolder
extends AbstractPropertyHolder {
    private final Component component;
    private final boolean isOrWithinEmbeddedId;
    private final boolean isWithinElementCollection;
    private final Map<ClassDetails, InheritanceState> inheritanceStatePerClass;
    private final String embeddedAttributeName;
    private final Map<String, AttributeConversionInfo> attributeConversionInfoMap;

    public ComponentPropertyHolder(Component component, String path, PropertyData inferredData, PropertyHolder parent, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass) {
        super(path, parent, inferredData.getPropertyType().determineRawClass(), context);
        MemberDetails embeddedMemberDetails = inferredData.getAttributeMember();
        this.setCurrentProperty(embeddedMemberDetails);
        this.component = component;
        this.isOrWithinEmbeddedId = parent.isOrWithinEmbeddedId() || embeddedMemberDetails != null && PropertyBinder.hasIdAnnotation(embeddedMemberDetails);
        this.isWithinElementCollection = parent.isWithinElementCollection() || parent instanceof CollectionPropertyHolder;
        this.inheritanceStatePerClass = inheritanceStatePerClass;
        if (embeddedMemberDetails != null) {
            this.embeddedAttributeName = embeddedMemberDetails.getName();
            this.attributeConversionInfoMap = this.processAttributeConversions(embeddedMemberDetails);
        } else {
            this.embeddedAttributeName = "";
            this.attributeConversionInfoMap = this.processAttributeConversions(inferredData.getClassOrElementType());
        }
    }

    public Component getComponent() {
        return this.component;
    }

    private Map<String, AttributeConversionInfo> processAttributeConversions(MemberDetails embeddedMemberDetails) {
        HashMap<String, AttributeConversionInfo> infoMap = new HashMap<String, AttributeConversionInfo>();
        TypeDetails embeddableTypeDetails = embeddedMemberDetails.getType();
        this.processAttributeConversions(embeddableTypeDetails, infoMap);
        embeddedMemberDetails.forEachAnnotationUsage(Convert.class, this.getSourceModelContext(), usage -> {
            AttributeConversionInfo info = new AttributeConversionInfo((Convert)usage, embeddedMemberDetails);
            if (StringHelper.isEmpty(info.getAttributeName())) {
                throw new IllegalStateException("Convert placed on Embedded attribute must define (sub)attributeName");
            }
            infoMap.put(info.getAttributeName(), info);
        });
        return infoMap;
    }

    private void processAttributeConversions(TypeDetails embeddableTypeDetails, Map<String, AttributeConversionInfo> infoMap) {
        ClassDetails embeddableClassDetails = embeddableTypeDetails.determineRawClass();
        embeddableClassDetails.forEachAnnotationUsage(Convert.class, this.getSourceModelContext(), usage -> {
            AttributeConversionInfo info = new AttributeConversionInfo((Convert)usage, embeddableClassDetails);
            if (StringHelper.isEmpty(info.getAttributeName())) {
                throw new IllegalStateException("@Convert placed on @Embeddable must define attributeName");
            }
            infoMap.put(info.getAttributeName(), info);
        });
    }

    private Map<String, AttributeConversionInfo> processAttributeConversions(TypeDetails embeddableTypeDetails) {
        HashMap<String, AttributeConversionInfo> infoMap = new HashMap<String, AttributeConversionInfo>();
        this.processAttributeConversions(embeddableTypeDetails, infoMap);
        return infoMap;
    }

    @Override
    protected String normalizeCompositePath(String attributeName) {
        return this.embeddedAttributeName + "." + attributeName;
    }

    @Override
    protected String normalizeCompositePathForLogging(String attributeName) {
        return this.normalizeCompositePath(attributeName);
    }

    @Override
    public void startingProperty(MemberDetails propertyMemberDetails) {
        if (propertyMemberDetails == null) {
            return;
        }
        String attributeName = propertyMemberDetails.resolveAttributeName();
        String path = this.embeddedAttributeName + "." + attributeName;
        if (this.attributeConversionInfoMap.containsKey(path)) {
            return;
        }
        propertyMemberDetails.forEachAnnotationUsage(Convert.class, this.getSourceModelContext(), usage -> {
            AttributeConversionInfo info = new AttributeConversionInfo((Convert)usage, propertyMemberDetails);
            this.attributeConversionInfoMap.put(attributeName, info);
        });
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(MemberDetails attributeMember) {
        return this.locateAttributeConversionInfo(attributeMember.resolveAttributeName());
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(String path) {
        String embeddedPath = StringHelper.qualifyConditionally(this.embeddedAttributeName, path);
        AttributeConversionInfo fromParent = this.parent.locateAttributeConversionInfo(embeddedPath);
        if (fromParent != null) {
            return fromParent;
        }
        AttributeConversionInfo fromEmbedded = this.attributeConversionInfoMap.get(embeddedPath);
        if (fromEmbedded != null) {
            return fromEmbedded;
        }
        return this.attributeConversionInfoMap.get(path);
    }

    @Override
    public String getEntityName() {
        return this.component.getComponentClassName();
    }

    @Override
    public void addProperty(Property property, MemberDetails attributeMemberDetails, @Nullable AnnotatedColumns columns, ClassDetails declaringClass) {
        assert (columns == null || property.getValue().getTable() == columns.getTable());
        this.setTable(property.getValue().getTable());
        this.addProperty(property, attributeMemberDetails, declaringClass);
    }

    private void setTable(Table table) {
        if (!table.equals(this.getTable())) {
            if (this.component.getPropertySpan() != 0) {
                throw new AnnotationException("Embeddable class '" + this.component.getComponentClassName() + "' has properties mapped to two different tables (all properties of the embeddable class must map to the same table)");
            }
            this.component.setTable(table);
            AbstractPropertyHolder abstractPropertyHolder = this.parent;
            if (abstractPropertyHolder instanceof ComponentPropertyHolder) {
                ComponentPropertyHolder parentComponentHolder = (ComponentPropertyHolder)abstractPropertyHolder;
                parentComponentHolder.setTable(table);
            }
        }
    }

    @Override
    public Join addJoin(JoinTable joinTable, boolean noDelayInPkColumnCreation) {
        return this.parent.addJoin(joinTable, noDelayInPkColumnCreation);
    }

    @Override
    public Join addJoin(JoinTable joinTable, Table table, boolean noDelayInPkColumnCreation) {
        return this.parent.addJoin(joinTable, table, noDelayInPkColumnCreation);
    }

    @Override
    public String getClassName() {
        return this.component.getComponentClassName();
    }

    @Override
    public String getEntityOwnerClassName() {
        return this.component.getOwner().getClassName();
    }

    public AggregateColumn getAggregateColumn() {
        AggregateColumn aggregateColumn = this.component.getAggregateColumn();
        return aggregateColumn != null ? aggregateColumn : this.component.getParentAggregateColumn();
    }

    @Override
    public Table getTable() {
        return this.component.getTable();
    }

    @Override
    public void addProperty(Property prop, MemberDetails attributeMemberDetails, ClassDetails declaringClass) {
        InheritanceState inheritanceState;
        ClassPropertyHolder.handleGenericComponentProperty(prop, attributeMemberDetails, this.getContext());
        if (declaringClass != null && (inheritanceState = this.inheritanceStatePerClass.get(declaringClass)) != null && inheritanceState.isEmbeddableSuperclass()) {
            ClassPropertyHolder.addPropertyToMappedSuperclass(prop, attributeMemberDetails, declaringClass, this.getContext());
        }
        this.component.addProperty(prop, declaringClass);
    }

    @Override
    public KeyValue getIdentifier() {
        return this.component.getOwner().getIdentifier();
    }

    @Override
    public boolean isOrWithinEmbeddedId() {
        return this.isOrWithinEmbeddedId;
    }

    @Override
    public boolean isWithinElementCollection() {
        return this.isWithinElementCollection;
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.component.getOwner();
    }

    @Override
    public boolean isComponent() {
        return true;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public void setParentProperty(String parentProperty) {
        this.component.setParentProperty(parentProperty);
    }

    @Override
    public Column[] getOverriddenColumn(String propertyName) {
        String userPropertyName;
        Column[] result = super.getOverriddenColumn(propertyName);
        if (result == null && (userPropertyName = this.extractUserPropertyName("id", propertyName)) != null) {
            result = super.getOverriddenColumn(userPropertyName);
        }
        if (result == null && (userPropertyName = this.extractUserPropertyName("_identifierMapper", propertyName)) != null) {
            result = super.getOverriddenColumn(userPropertyName);
        }
        return result;
    }

    private String extractUserPropertyName(String redundantString, String propertyName) {
        String className = this.component.getOwner().getClassName();
        if (className != null && propertyName.startsWith(className)) {
            boolean specialCase;
            boolean bl = specialCase = propertyName.length() > className.length() + 2 + redundantString.length() && propertyName.substring(className.length() + 1, className.length() + 1 + redundantString.length()).equals(redundantString);
            if (specialCase) {
                return className + propertyName.substring(className.length() + 1 + redundantString.length());
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.parent.normalizeCompositePathForLogging(this.embeddedAttributeName) + ")";
    }
}

