/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.FetchType;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.annotations.spi.AttributeMarker;
import org.hibernate.models.spi.ModelsContext;

public class ElementCollectionJpaAnnotation
implements ElementCollection,
AttributeMarker.Fetchable {
    private Class<?> targetClass;
    private FetchType fetch;

    public ElementCollectionJpaAnnotation(ModelsContext modelContext) {
        this.targetClass = Void.TYPE;
        this.fetch = FetchType.LAZY;
    }

    public ElementCollectionJpaAnnotation(ElementCollection annotation, ModelsContext modelContext) {
        this.targetClass = annotation.targetClass();
        this.fetch = annotation.fetch();
    }

    public ElementCollectionJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.targetClass = (Class)attributeValues.get("targetClass");
        this.fetch = (FetchType)((Object)attributeValues.get("fetch"));
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ElementCollection.class;
    }

    @Override
    public Class<?> targetClass() {
        return this.targetClass;
    }

    public void targetClass(Class<?> value) {
        this.targetClass = value;
    }

    @Override
    public FetchType fetch() {
        return this.fetch;
    }

    @Override
    public void fetch(FetchType value) {
        this.fetch = value;
    }
}

