/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.Column;
import jakarta.persistence.MapKeyColumn;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMapKeyColumnImpl;
import org.hibernate.boot.models.annotations.internal.ColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.spi.ColumnDetails;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.ModelsContext;

public class MapKeyColumnJpaAnnotation
implements MapKeyColumn,
ColumnDetails.Nullable,
ColumnDetails.Mutable,
ColumnDetails.Sizable,
ColumnDetails.Uniqueable,
ColumnDetails.Definable,
ColumnDetails.AlternateTableCapable {
    private String name;
    private boolean unique;
    private boolean nullable;
    private boolean insertable;
    private boolean updatable;
    private String columnDefinition;
    private String options;
    private String table;
    private int length;
    private int precision;
    private int scale;

    public MapKeyColumnJpaAnnotation(ModelsContext modelContext) {
        this.name = "";
        this.unique = false;
        this.nullable = false;
        this.insertable = true;
        this.updatable = true;
        this.columnDefinition = "";
        this.options = "";
        this.table = "";
        this.length = 255;
        this.precision = 0;
        this.scale = 0;
    }

    public MapKeyColumnJpaAnnotation(MapKeyColumn annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.unique = annotation.unique();
        this.nullable = annotation.nullable();
        this.insertable = annotation.insertable();
        this.updatable = annotation.updatable();
        this.columnDefinition = annotation.columnDefinition();
        this.options = annotation.options();
        this.table = annotation.table();
        this.length = annotation.length();
        this.precision = annotation.precision();
        this.scale = annotation.scale();
    }

    public MapKeyColumnJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.unique = (Boolean)attributeValues.get("unique");
        this.nullable = (Boolean)attributeValues.get("nullable");
        this.insertable = (Boolean)attributeValues.get("insertable");
        this.updatable = (Boolean)attributeValues.get("updatable");
        this.columnDefinition = (String)attributeValues.get("columnDefinition");
        this.options = (String)attributeValues.get("options");
        this.table = (String)attributeValues.get("table");
        this.length = (Integer)attributeValues.get("length");
        this.precision = (Integer)attributeValues.get("precision");
        this.scale = (Integer)attributeValues.get("scale");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return MapKeyColumn.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String value) {
        this.name = value;
    }

    @Override
    public boolean unique() {
        return this.unique;
    }

    @Override
    public void unique(boolean value) {
        this.unique = value;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public void nullable(boolean value) {
        this.nullable = value;
    }

    @Override
    public boolean insertable() {
        return this.insertable;
    }

    @Override
    public void insertable(boolean value) {
        this.insertable = value;
    }

    @Override
    public boolean updatable() {
        return this.updatable;
    }

    @Override
    public void updatable(boolean value) {
        this.updatable = value;
    }

    @Override
    public String columnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void columnDefinition(String value) {
        this.columnDefinition = value;
    }

    @Override
    public String options() {
        return this.options;
    }

    @Override
    public void options(String value) {
        this.options = value;
    }

    @Override
    public String table() {
        return this.table;
    }

    @Override
    public void table(String value) {
        this.table = value;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void length(int value) {
        this.length = value;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public void precision(int value) {
        this.precision = value;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public void scale(int value) {
        this.scale = value;
    }

    public void apply(JaxbMapKeyColumnImpl jaxbColumn, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbColumn.getName())) {
            this.name(jaxbColumn.getName());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getTable())) {
            this.table(jaxbColumn.getTable());
        }
        if (jaxbColumn.isNullable() != null) {
            this.nullable(jaxbColumn.isNullable());
        }
        if (jaxbColumn.isUnique() != null) {
            this.unique(jaxbColumn.isUnique());
        }
        if (jaxbColumn.isInsertable() != null) {
            this.insertable(jaxbColumn.isInsertable());
        }
        if (jaxbColumn.isUpdatable() != null) {
            this.updatable(jaxbColumn.isUpdatable());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getColumnDefinition())) {
            this.columnDefinition(jaxbColumn.getColumnDefinition());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getOptions())) {
            this.options(jaxbColumn.getOptions());
        }
        if (jaxbColumn.getLength() != null) {
            this.length(jaxbColumn.getLength());
        }
        if (jaxbColumn.getPrecision() != null) {
            this.precision(jaxbColumn.getPrecision());
        }
        if (jaxbColumn.getScale() != null) {
            this.scale(jaxbColumn.getScale());
        }
    }

    public static Column toColumnAnnotation(MapKeyColumn mapKeyColumn, ModelsContext ModelsContext2) {
        ColumnJpaAnnotation column = new ColumnJpaAnnotation(ModelsContext2);
        column.name(mapKeyColumn.name());
        column.table(mapKeyColumn.table());
        column.nullable(mapKeyColumn.nullable());
        column.unique(mapKeyColumn.unique());
        column.insertable(mapKeyColumn.insertable());
        column.updatable(mapKeyColumn.updatable());
        column.columnDefinition(mapKeyColumn.columnDefinition());
        column.options(mapKeyColumn.options());
        column.length(mapKeyColumn.length());
        column.precision(mapKeyColumn.precision());
        column.scale(mapKeyColumn.scale());
        return column;
    }
}

