/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.pool.TypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CoreCacheProvider;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CorePrefixFilter;

public class CoreTypePool
extends TypePool.AbstractBase
implements TypePool {
    private final ClassLoader hibernateClassLoader = CoreTypePool.class.getClassLoader();
    private final ConcurrentHashMap<String, TypePool.Resolution> resolutions = new ConcurrentHashMap();
    private final CorePrefixFilter acceptedPrefixes;

    public CoreTypePool() {
        this(CorePrefixFilter.DEFAULT_INSTANCE);
    }

    @Deprecated
    public CoreTypePool(String ... acceptedPrefixes) {
        this(new CorePrefixFilter(acceptedPrefixes));
    }

    public CoreTypePool(CorePrefixFilter acceptedPrefixes) {
        super(new CoreCacheProvider(acceptedPrefixes));
        this.acceptedPrefixes = Objects.requireNonNull(acceptedPrefixes);
    }

    @Override
    protected TypePool.Resolution doDescribe(String name) {
        if (this.acceptedPrefixes.isCoreClassName(name)) {
            TypePool.Resolution resolution = this.resolutions.get(name);
            if (resolution != null) {
                return resolution;
            }
            return this.resolutions.computeIfAbsent(name, this::actualResolve);
        }
        return new TypePool.Resolution.Illegal(name);
    }

    private TypePool.Resolution actualResolve(String name) {
        try {
            Class<?> aClass = Class.forName(name, false, this.hibernateClassLoader);
            return new TypePool.Resolution.Simple(TypeDescription.ForLoadedType.of(aClass));
        }
        catch (ClassNotFoundException e) {
            return new TypePool.Resolution.Illegal(name);
        }
    }
}

