/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Update;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class UpdateLockingStrategy
implements LockingStrategy {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(MethodHandles.lookup(), CoreMessageLogger.class, UpdateLockingStrategy.class.getName());
    private final EntityPersister lockable;
    private final LockMode lockMode;
    private final String sql;

    public UpdateLockingStrategy(EntityPersister lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        if (lockMode.lessThan(LockMode.WRITE)) {
            throw new HibernateException("[" + String.valueOf(lockMode) + "] not valid for update statement");
        }
        if (!lockable.isVersioned()) {
            LOG.writeLocksNotSupported(lockable.getEntityName());
            this.sql = null;
        } else {
            this.sql = this.generateLockString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Object id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, JDBCException {
        String lockableEntityName = this.lockable.getEntityName();
        if (!this.lockable.isVersioned()) {
            throw new HibernateException("write locks via update not supported for non-versioned entities [" + lockableEntityName + "]");
        }
        SessionFactoryImplementor factory = session.getFactory();
        try {
            JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
            PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(this.sql);
            try {
                int affected;
                BasicType<?> lockableVersionType = this.lockable.getVersionType();
                lockableVersionType.nullSafeSet(st, version, 1, session);
                int offset = 2;
                Type lockableIdentifierType = this.lockable.getIdentifierType();
                lockableIdentifierType.nullSafeSet(st, id, offset, session);
                offset += lockableIdentifierType.getColumnSpan(factory.getRuntimeMetamodels());
                if (this.lockable.isVersioned()) {
                    lockableVersionType.nullSafeSet(st, version, offset, session);
                }
                if ((affected = jdbcCoordinator.getResultSetReturn().executeUpdate(st, this.sql)) < 0) {
                    StatisticsImplementor statistics = factory.getStatistics();
                    if (statistics.isStatisticsEnabled()) {
                        statistics.optimisticFailure(lockableEntityName);
                    }
                    throw new StaleObjectStateException(lockableEntityName, id);
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not lock: " + MessageHelper.infoString(this.lockable, id, session.getFactory()), this.sql);
        }
    }

    protected String generateLockString() {
        SessionFactoryImplementor factory = this.lockable.getFactory();
        Update update = new Update(factory);
        update.setTableName(this.lockable.getRootTableName());
        update.addAssignment(this.lockable.getVersionColumnName());
        update.addRestriction(this.lockable.getRootTableIdentifierColumnNames());
        update.addRestriction(this.lockable.getVersionColumnName());
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            update.setComment(String.valueOf(this.lockMode) + " lock " + this.lockable.getEntityName());
        }
        return update.toStatementString();
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }
}

