/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.event.internal.EntityCopyAllowedLoggedObserver;
import org.hibernate.event.internal.EntityCopyAllowedObserver;
import org.hibernate.event.internal.EntityCopyNotAllowedObserver;
import org.hibernate.event.spi.EntityCopyObserver;
import org.hibernate.event.spi.EntityCopyObserverFactory;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class EntityCopyObserverFactoryInitiator
implements StandardServiceInitiator<EntityCopyObserverFactory> {
    public static final EntityCopyObserverFactoryInitiator INSTANCE = new EntityCopyObserverFactoryInitiator();
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityCopyObserverFactoryInitiator.class);

    @Override
    public EntityCopyObserverFactory initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        Object value = this.getConfigurationValue(configurationValues);
        if (value instanceof EntityCopyObserverFactory) {
            EntityCopyObserverFactory factory = (EntityCopyObserverFactory)value;
            return factory;
        }
        if (value.equals("disallow") || value.equals(EntityCopyNotAllowedObserver.class.getName())) {
            LOG.tracef("Configured EntityCopyObserver strategy: %s", (Object)"disallow");
            return EntityCopyNotAllowedObserver.FACTORY_OF_SELF;
        }
        if (value.equals("allow") || value.equals(EntityCopyAllowedObserver.class.getName())) {
            LOG.tracef("Configured EntityCopyObserver strategy: %s", (Object)"allow");
            return EntityCopyAllowedObserver.FACTORY_OF_SELF;
        }
        if (value.equals("log") || value.equals(EntityCopyAllowedLoggedObserver.class.getName())) {
            LOG.tracef("Configured EntityCopyObserver strategy: %s", (Object)"log");
            return EntityCopyAllowedLoggedObserver.FACTORY_OF_SELF;
        }
        EntityCopyObserver exampleInstance = registry.requireService(StrategySelector.class).resolveStrategy(EntityCopyObserver.class, value);
        Class<?> observerType = exampleInstance.getClass();
        LOG.tracef("Configured EntityCopyObserver is a custom implementation of type '%s'", (Object)observerType.getName());
        return new EntityCopyObserverFactoryFromClass(observerType);
    }

    private Object getConfigurationValue(Map<?, ?> configurationValues) {
        Object value = configurationValues.get("hibernate.event.merge.entity_copy_observer");
        if (value == null) {
            return "disallow";
        }
        if (value instanceof String) {
            String string = (String)value;
            return string.trim();
        }
        return value;
    }

    @Override
    public Class<EntityCopyObserverFactory> getServiceInitiated() {
        return EntityCopyObserverFactory.class;
    }

    private record EntityCopyObserverFactoryFromClass(Class<? extends EntityCopyObserver> observerClass) implements EntityCopyObserverFactory
    {
        @Override
        public EntityCopyObserver createEntityCopyObserver() {
            try {
                return this.observerClass.newInstance();
            }
            catch (Exception e) {
                throw new HibernateException("Could not instantiate class of type " + this.observerClass.getName());
            }
        }
    }
}

