/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph;

import jakarta.persistence.AttributeNode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.Subgraph;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.metamodel.EntityType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.graph.Graph;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.model.domain.EntityDomainType;

public final class EntityGraphs {
    public static <T> EntityGraph<T> createGraph(EntityType<T> rootType) {
        return new RootGraphImpl(null, (EntityDomainType)rootType);
    }

    public static EntityGraph<Map<String, ?>> createGraphForDynamicEntity(EntityType<?> rootType) {
        EntityDomainType domainType = (EntityDomainType)rootType;
        if (domainType.getRepresentationMode() != RepresentationMode.MAP) {
            throw new IllegalArgumentException("Entity '" + domainType.getHibernateEntityName() + "' is not a dynamic entity");
        }
        EntityDomainType dynamicEntity = domainType;
        return new RootGraphImpl(null, dynamicEntity);
    }

    @SafeVarargs
    public static <T> EntityGraph<T> merge(EntityManager entityManager, Class<T> root, jakarta.persistence.Graph<T> ... graphs) {
        return EntityGraphs.merge(entityManager, root, Arrays.stream(graphs));
    }

    public static <T> EntityGraph<T> merge(EntityManager entityManager, Class<T> root, List<? extends jakarta.persistence.Graph<T>> graphs) {
        return EntityGraphs.merge(entityManager, root, graphs.stream());
    }

    public static <T> EntityGraph<T> merge(EntityManager entityManager, Class<T> root, Stream<? extends jakarta.persistence.Graph<T>> graphs) {
        EntityGraph merged = ((SessionImplementor)entityManager).createEntityGraph((Class)root);
        graphs.forEach(arg_0 -> EntityGraphs.lambda$merge$0((RootGraphImplementor)merged, arg_0));
        return merged;
    }

    public static <R> void setGraph(TypedQuery<R> query, EntityGraph<R> graph, GraphSemantic semantic) {
        ((org.hibernate.query.Query)query).setEntityGraph(graph, semantic);
    }

    public static <R> void setLoadGraph(TypedQuery<R> query, EntityGraph<R> graph) {
        EntityGraphs.setGraph(query, graph, GraphSemantic.LOAD);
    }

    public static <R> void setFetchGraph(TypedQuery<R> query, EntityGraph<R> graph) {
        EntityGraphs.setGraph(query, graph, GraphSemantic.FETCH);
    }

    public <S> Subgraph<S> addTreatedSubgraph(jakarta.persistence.Graph<? super S> graph, Class<S> subtype) {
        return ((Graph)graph).addTreatedSubgraph(subtype);
    }

    @Deprecated(since="7.0")
    public static List executeList(Query query, EntityGraph<?> graph, GraphSemantic semantic) {
        return query.unwrap(org.hibernate.query.Query.class).applyGraph((RootGraph)graph, semantic).getResultList();
    }

    @Deprecated(since="7.0")
    public static <R> List<R> executeList(TypedQuery<R> query, EntityGraph<R> graph, GraphSemantic semantic) {
        org.hibernate.query.Query unwrapped = query.unwrap(org.hibernate.query.Query.class);
        return unwrapped.setEntityGraph(graph, semantic).getResultList();
    }

    @Deprecated(since="7.0")
    public static List executeList(Query query, EntityGraph<?> graph, String semanticJpaHintName) {
        return EntityGraphs.executeList(query, graph, GraphSemantic.fromHintName(semanticJpaHintName));
    }

    @Deprecated(since="7.0")
    public static <R> List<R> executeList(TypedQuery<R> query, EntityGraph<R> graph, String semanticJpaHintName) {
        return EntityGraphs.executeList(query, graph, GraphSemantic.fromHintName(semanticJpaHintName));
    }

    @Deprecated(since="7.0")
    public static List executeList(Query query, EntityGraph<?> graph) {
        return EntityGraphs.executeList(query, graph, GraphSemantic.FETCH);
    }

    @Deprecated(since="7.0")
    public static <R> List<R> executeList(TypedQuery<R> query, EntityGraph<R> graph) {
        return EntityGraphs.executeList(query, graph, GraphSemantic.FETCH);
    }

    public static <T> boolean areEqual(EntityGraph<T> a, EntityGraph<T> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        List<AttributeNode<?>> aNodes = a.getAttributeNodes();
        List<AttributeNode<?>> bNodes = b.getAttributeNodes();
        if (aNodes.size() != bNodes.size()) {
            return false;
        }
        for (AttributeNode<?> aNode : aNodes) {
            String attributeName = aNode.getAttributeName();
            AttributeNode<?> bNode = null;
            for (AttributeNode<?> bCandidate : bNodes) {
                if (!attributeName.equals(bCandidate.getAttributeName())) continue;
                bNode = bCandidate;
                break;
            }
            if (EntityGraphs.areEqual(aNode, bNode)) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(AttributeNode<?> a, AttributeNode<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getAttributeName().equals(b.getAttributeName())) {
            return EntityGraphs.areEqual(a.getSubgraphs(), b.getSubgraphs()) && EntityGraphs.areEqual(a.getKeySubgraphs(), b.getKeySubgraphs());
        }
        return false;
    }

    public static boolean areEqual(Map<Class, Subgraph> a, Map<Class, Subgraph> b) {
        Set<Class> bKeys;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Set<Class> aKeys = a.keySet();
        if (aKeys.equals(bKeys = b.keySet())) {
            for (Class clazz : aKeys) {
                if (!bKeys.contains(clazz)) {
                    return false;
                }
                if (EntityGraphs.areEqual(a.get(clazz), b.get(clazz))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean areEqual(Subgraph a, Subgraph b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClassType() != b.getClassType()) {
            return false;
        }
        List<AttributeNode<?>> aNodes = a.getAttributeNodes();
        List<AttributeNode<?>> bNodes = b.getAttributeNodes();
        if (aNodes.size() != bNodes.size()) {
            return false;
        }
        for (AttributeNode<?> aNode : aNodes) {
            String attributeName = aNode.getAttributeName();
            AttributeNode<?> bNode = null;
            for (AttributeNode<?> bCandidate : bNodes) {
                if (!attributeName.equals(bCandidate.getAttributeName())) continue;
                bNode = bCandidate;
                break;
            }
            if (EntityGraphs.areEqual(aNode, bNode)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$merge$0(RootGraphImplementor merged, jakarta.persistence.Graph graph) {
        merged.merge((GraphImplementor)graph);
    }
}

