/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.hibernate.Internal;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.TransientObjectException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.ImplicitDatabaseObjectNamingStrategy;
import org.hibernate.id.enhanced.StandardNamingStrategy;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.IncubationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

@Internal
public final class IdentifierGeneratorHelper {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(IdentifierGeneratorHelper.class);
    @Deprecated(forRemoval=true, since="6.2")
    public static final Serializable SHORT_CIRCUIT_INDICATOR = new Serializable(){

        public String toString() {
            return "SHORT_CIRCUIT_INDICATOR";
        }
    };

    public static IntegralDataTypeHolder getIntegralDataTypeHolder(Class<?> integralType) {
        if (integralType == Long.class || integralType == Integer.class || integralType == Short.class) {
            return new BasicHolder(integralType);
        }
        if (integralType == BigInteger.class) {
            return new BigIntegerHolder();
        }
        if (integralType == BigDecimal.class) {
            return new BigDecimalHolder();
        }
        throw new IdentifierGenerationException("Unknown integral data type for ids : " + integralType.getName());
    }

    public static Object getForeignId(String entityName, String propertyName, SharedSessionContractImplementor sessionImplementor, Object object) {
        SessionImplementor statefulSession;
        EntityPersister entityDescriptor = sessionImplementor.getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
        if (sessionImplementor instanceof SessionImplementor && (statefulSession = (SessionImplementor)sessionImplementor).contains(entityName, object)) {
            return SHORT_CIRCUIT_INDICATOR;
        }
        return IdentifierGeneratorHelper.identifier(sessionImplementor, IdentifierGeneratorHelper.entityType(propertyName, entityDescriptor), IdentifierGeneratorHelper.associatedEntity(entityName, propertyName, object, entityDescriptor));
    }

    private static Object associatedEntity(String entityName, String propertyName, Object object, EntityPersister entityDescriptor) {
        Object associatedObject = entityDescriptor.getPropertyValue(object, propertyName);
        if (associatedObject == null) {
            throw new IdentifierGenerationException("Could not assign id from null association '" + propertyName + "' of entity '" + entityName + "'");
        }
        return associatedObject;
    }

    private static Object identifier(SharedSessionContractImplementor sessionImplementor, EntityType foreignValueSourceType, Object associatedEntity) {
        String associatedEntityName = foreignValueSourceType.getAssociatedEntityName();
        try {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved(associatedEntityName, associatedEntity, sessionImplementor);
        }
        catch (TransientObjectException toe) {
            if (sessionImplementor instanceof Session) {
                Session statefulSession = (Session)((Object)sessionImplementor);
                statefulSession.persist(associatedEntityName, associatedEntity);
                return sessionImplementor.getContextEntityIdentifier(associatedEntity);
            }
            if (sessionImplementor instanceof StatelessSession) {
                StatelessSession statelessSession = (StatelessSession)((Object)sessionImplementor);
                return statelessSession.insert(associatedEntityName, associatedEntity);
            }
            throw new IdentifierGenerationException("sessionImplementor is neither Session nor StatelessSession");
        }
    }

    private static EntityType entityType(String propertyName, EntityPersister entityDescriptor) {
        Type propertyType = entityDescriptor.getPropertyType(propertyName);
        if (propertyType instanceof EntityType) {
            return (EntityType)propertyType;
        }
        String mapperPropertyName = "_identifierMapper." + propertyName;
        return (EntityType)entityDescriptor.getPropertyType(mapperPropertyName);
    }

    public static ImplicitDatabaseObjectNamingStrategy getNamingStrategy(Properties params, ServiceRegistry serviceRegistry) {
        StrategySelector strategySelector = serviceRegistry.requireService(StrategySelector.class);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> {
            String localSetting = ConfigurationHelper.getString("hibernate.id.db_structure_naming_strategy", params);
            if (localSetting != null) {
                IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.id.db_structure_naming_strategy");
            }
            return localSetting;
        };
        supplierArray[1] = () -> {
            ConfigurationService configurationService = serviceRegistry.requireService(ConfigurationService.class);
            String globalSetting = ConfigurationHelper.getString("hibernate.id.db_structure_naming_strategy", configurationService.getSettings());
            if (globalSetting != null) {
                IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.id.db_structure_naming_strategy");
            }
            return globalSetting;
        };
        supplierArray[2] = StandardNamingStrategy.class::getName;
        String namingStrategySetting = (String)NullnessHelper.coalesceSuppliedValues(supplierArray);
        return strategySelector.resolveStrategy(ImplicitDatabaseObjectNamingStrategy.class, namingStrategySetting);
    }

    private IdentifierGeneratorHelper() {
    }

    @Internal
    public static class BasicHolder
    implements IntegralDataTypeHolder {
        private final Class<?> exactType;
        private long value = Long.MIN_VALUE;

        public BasicHolder(Class<?> exactType) {
            this.exactType = exactType;
            if (exactType != Long.class && exactType != Integer.class && exactType != Short.class) {
                throw new IdentifierGenerationException("Invalid type for basic integral holder : " + String.valueOf(exactType));
            }
        }

        public long getActualLongValue() {
            return this.value;
        }

        @Override
        public IntegralDataTypeHolder initialize(long value) {
            this.value = value;
            return this;
        }

        @Override
        public IntegralDataTypeHolder initialize(ResultSet resultSet, long defaultValue) throws SQLException {
            long value = resultSet.getLong(1);
            if (resultSet.wasNull()) {
                value = defaultValue;
            }
            return this.initialize(value);
        }

        @Override
        public void bind(PreparedStatement preparedStatement, int position) throws SQLException {
            LOG.tracef("binding parameter [%s] - [%s]", (long)position, this.value);
            preparedStatement.setLong(position, this.value);
        }

        @Override
        public IntegralDataTypeHolder increment() {
            this.checkInitialized();
            ++this.value;
            return this;
        }

        private void checkInitialized() {
            if (this.value == Long.MIN_VALUE) {
                throw new IdentifierGenerationException("integral holder was not initialized");
            }
        }

        @Override
        public IntegralDataTypeHolder add(long addend) {
            this.checkInitialized();
            this.value += addend;
            return this;
        }

        @Override
        public IntegralDataTypeHolder decrement() {
            this.checkInitialized();
            --this.value;
            return this;
        }

        @Override
        public IntegralDataTypeHolder subtract(long subtrahend) {
            this.checkInitialized();
            this.value -= subtrahend;
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(IntegralDataTypeHolder factor) {
            return this.multiplyBy(factor.toLong());
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(long factor) {
            this.checkInitialized();
            this.value *= factor;
            return this;
        }

        @Override
        public boolean eq(IntegralDataTypeHolder other) {
            return this.eq(other.toLong());
        }

        @Override
        public boolean eq(long value) {
            this.checkInitialized();
            return this.value == value;
        }

        @Override
        public boolean lt(IntegralDataTypeHolder other) {
            return this.lt(other.toLong());
        }

        @Override
        public boolean lt(long value) {
            this.checkInitialized();
            return this.value < value;
        }

        @Override
        public boolean gt(IntegralDataTypeHolder other) {
            return this.gt(other.toLong());
        }

        @Override
        public boolean gt(long value) {
            this.checkInitialized();
            return this.value > value;
        }

        @Override
        public IntegralDataTypeHolder copy() {
            BasicHolder copy = new BasicHolder(this.exactType);
            copy.value = this.value;
            return copy;
        }

        @Override
        public Number makeValue() {
            this.checkInitialized();
            if (this.exactType == Long.class) {
                return this.value;
            }
            if (this.exactType == Integer.class) {
                return (int)this.value;
            }
            return (short)this.value;
        }

        @Override
        public Number makeValueThenIncrement() {
            Number result = this.makeValue();
            ++this.value;
            return result;
        }

        @Override
        public Number makeValueThenAdd(long addend) {
            Number result = this.makeValue();
            this.value += addend;
            return result;
        }

        @Override
        public long toLong() {
            this.checkInitialized();
            return this.value;
        }

        @Override
        public BigDecimal toBigDecimal() {
            this.checkInitialized();
            return BigDecimal.valueOf(this.value);
        }

        @Override
        public BigInteger toBigInteger() {
            this.checkInitialized();
            return BigInteger.valueOf(this.value);
        }

        public String toString() {
            return "BasicHolder[" + this.exactType.getName() + "[" + this.value + "]]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BasicHolder)) {
                return false;
            }
            BasicHolder that = (BasicHolder)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }
    }

    public static class BigIntegerHolder
    implements IntegralDataTypeHolder {
        private BigInteger value;

        @Override
        public IntegralDataTypeHolder initialize(long value) {
            this.value = BigInteger.valueOf(value);
            return this;
        }

        @Override
        public IntegralDataTypeHolder initialize(ResultSet resultSet, long defaultValue) throws SQLException {
            BigDecimal rsValue = resultSet.getBigDecimal(1);
            if (resultSet.wasNull()) {
                return this.initialize(defaultValue);
            }
            this.value = rsValue.setScale(0, RoundingMode.UNNECESSARY).toBigInteger();
            return this;
        }

        @Override
        public void bind(PreparedStatement preparedStatement, int position) throws SQLException {
            preparedStatement.setBigDecimal(position, new BigDecimal(this.value));
        }

        @Override
        public IntegralDataTypeHolder increment() {
            this.checkInitialized();
            this.value = this.value.add(BigInteger.ONE);
            return this;
        }

        private void checkInitialized() {
            if (this.value == null) {
                throw new IdentifierGenerationException("integral holder was not initialized");
            }
        }

        @Override
        public IntegralDataTypeHolder add(long increment) {
            this.checkInitialized();
            this.value = this.value.add(BigInteger.valueOf(increment));
            return this;
        }

        @Override
        public IntegralDataTypeHolder decrement() {
            this.checkInitialized();
            this.value = this.value.subtract(BigInteger.ONE);
            return this;
        }

        @Override
        public IntegralDataTypeHolder subtract(long subtrahend) {
            this.checkInitialized();
            this.value = this.value.subtract(BigInteger.valueOf(subtrahend));
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(IntegralDataTypeHolder factor) {
            this.checkInitialized();
            this.value = this.value.multiply(factor.toBigInteger());
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(long factor) {
            this.checkInitialized();
            this.value = this.value.multiply(BigInteger.valueOf(factor));
            return this;
        }

        @Override
        public boolean eq(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(other.toBigInteger()) == 0;
        }

        @Override
        public boolean eq(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigInteger.valueOf(value)) == 0;
        }

        @Override
        public boolean lt(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(other.toBigInteger()) < 0;
        }

        @Override
        public boolean lt(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigInteger.valueOf(value)) < 0;
        }

        @Override
        public boolean gt(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(other.toBigInteger()) > 0;
        }

        @Override
        public boolean gt(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigInteger.valueOf(value)) > 0;
        }

        @Override
        public IntegralDataTypeHolder copy() {
            BigIntegerHolder copy = new BigIntegerHolder();
            copy.value = this.value;
            return copy;
        }

        @Override
        public Number makeValue() {
            this.checkInitialized();
            return this.value;
        }

        @Override
        public Number makeValueThenIncrement() {
            Number result = this.makeValue();
            this.value = this.value.add(BigInteger.ONE);
            return result;
        }

        @Override
        public Number makeValueThenAdd(long addend) {
            Number result = this.makeValue();
            this.value = this.value.add(BigInteger.valueOf(addend));
            return result;
        }

        @Override
        public long toLong() {
            this.checkInitialized();
            return this.value.longValue();
        }

        @Override
        public BigInteger toBigInteger() {
            this.checkInitialized();
            return this.value;
        }

        @Override
        public BigDecimal toBigDecimal() {
            this.checkInitialized();
            return new BigDecimal(this.value);
        }

        public String toString() {
            return "BigIntegerHolder[" + String.valueOf(this.value) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BigIntegerHolder)) {
                return false;
            }
            BigIntegerHolder that = (BigIntegerHolder)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }

    public static class BigDecimalHolder
    implements IntegralDataTypeHolder {
        private BigDecimal value;

        @Override
        public IntegralDataTypeHolder initialize(long value) {
            this.value = BigDecimal.valueOf(value);
            return this;
        }

        @Override
        public IntegralDataTypeHolder initialize(ResultSet resultSet, long defaultValue) throws SQLException {
            BigDecimal rsValue = resultSet.getBigDecimal(1);
            if (resultSet.wasNull()) {
                return this.initialize(defaultValue);
            }
            this.value = rsValue.setScale(0, RoundingMode.UNNECESSARY);
            return this;
        }

        @Override
        public void bind(PreparedStatement preparedStatement, int position) throws SQLException {
            preparedStatement.setBigDecimal(position, this.value);
        }

        @Override
        public IntegralDataTypeHolder increment() {
            this.checkInitialized();
            this.value = this.value.add(BigDecimal.ONE);
            return this;
        }

        private void checkInitialized() {
            if (this.value == null) {
                throw new IdentifierGenerationException("integral holder was not initialized");
            }
        }

        @Override
        public IntegralDataTypeHolder add(long increment) {
            this.checkInitialized();
            this.value = this.value.add(BigDecimal.valueOf(increment));
            return this;
        }

        @Override
        public IntegralDataTypeHolder decrement() {
            this.checkInitialized();
            this.value = this.value.subtract(BigDecimal.ONE);
            return this;
        }

        @Override
        public IntegralDataTypeHolder subtract(long subtrahend) {
            this.checkInitialized();
            this.value = this.value.subtract(BigDecimal.valueOf(subtrahend));
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(IntegralDataTypeHolder factor) {
            this.checkInitialized();
            this.value = this.value.multiply(factor.toBigDecimal());
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(long factor) {
            this.checkInitialized();
            this.value = this.value.multiply(BigDecimal.valueOf(factor));
            return this;
        }

        @Override
        public boolean eq(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(other.toBigDecimal()) == 0;
        }

        @Override
        public boolean eq(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigDecimal.valueOf(value)) == 0;
        }

        @Override
        public boolean lt(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(other.toBigDecimal()) < 0;
        }

        @Override
        public boolean lt(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigDecimal.valueOf(value)) < 0;
        }

        @Override
        public boolean gt(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(other.toBigDecimal()) > 0;
        }

        @Override
        public boolean gt(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigDecimal.valueOf(value)) > 0;
        }

        @Override
        public IntegralDataTypeHolder copy() {
            BigDecimalHolder copy = new BigDecimalHolder();
            copy.value = this.value;
            return copy;
        }

        @Override
        public Number makeValue() {
            this.checkInitialized();
            return this.value;
        }

        @Override
        public Number makeValueThenIncrement() {
            Number result = this.makeValue();
            this.value = this.value.add(BigDecimal.ONE);
            return result;
        }

        @Override
        public Number makeValueThenAdd(long addend) {
            Number result = this.makeValue();
            this.value = this.value.add(BigDecimal.valueOf(addend));
            return result;
        }

        @Override
        public long toLong() {
            this.checkInitialized();
            return this.value.longValue();
        }

        @Override
        public BigInteger toBigInteger() {
            this.checkInitialized();
            return this.value.toBigInteger();
        }

        @Override
        public BigDecimal toBigDecimal() {
            this.checkInitialized();
            return this.value;
        }

        public String toString() {
            return "BigDecimalHolder[" + String.valueOf(this.value) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BigDecimalHolder)) {
                return false;
            }
            BigDecimalHolder that = (BigDecimalHolder)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }
}

