/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import jakarta.persistence.Transient;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Locale;
import java.util.function.Supplier;
import org.hibernate.AssertionFailure;
import org.hibernate.InstantiationException;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyGetterImpl;
import org.hibernate.property.access.spi.Getter;

public final class ReflectHelper {
    public static final Class<?>[] NO_PARAM_SIGNATURE;
    public static final Class<?>[] SINGLE_OBJECT_PARAM_SIGNATURE;
    private static final Method OBJECT_EQUALS;
    private static final Method OBJECT_HASHCODE;
    private static final Class<?> RECORD_CLASS;
    private static final Method GET_RECORD_COMPONENTS;
    private static final Method GET_NAME;
    private static final Method GET_TYPE;

    private ReflectHelper() {
    }

    public static Method extractEqualsMethod(Class<?> clazz) throws NoSuchMethodException {
        return clazz.getMethod("equals", SINGLE_OBJECT_PARAM_SIGNATURE);
    }

    public static Method extractHashCodeMethod(Class<?> clazz) throws NoSuchMethodException {
        return clazz.getMethod("hashCode", NO_PARAM_SIGNATURE);
    }

    public static boolean overridesEquals(Class<?> clazz) {
        Method equals;
        if (clazz.isRecord() || clazz.isEnum()) {
            return true;
        }
        try {
            equals = ReflectHelper.extractEqualsMethod(clazz);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static boolean overridesHashCode(Class<?> clazz) {
        Method hashCode;
        if (clazz.isRecord() || clazz.isEnum()) {
            return true;
        }
        try {
            hashCode = ReflectHelper.extractHashCodeMethod(clazz);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_HASHCODE.equals(hashCode);
    }

    @Deprecated(since="7", forRemoval=true)
    public static boolean implementsInterface(Class<?> clazz, Class<?> intf) {
        assert (intf.isInterface()) : "Interface to check was not an interface";
        return intf.isAssignableFrom(clazz);
    }

    public static Class<?> classForName(String name, Class<?> caller) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name, true, caller.getClassLoader());
    }

    @Deprecated
    public static Class<?> classForName(String name) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name);
    }

    public static boolean isPublic(Class<?> clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Class<?> reflectedPropertyClass(String className, String name, ClassLoaderService classLoaderService) throws MappingException {
        try {
            Class clazz = classLoaderService.classForName(className);
            return ReflectHelper.getter(clazz, name).getReturnTypeClass();
        }
        catch (ClassLoadingException e) {
            throw new MappingException("class " + className + " not found while looking for property: " + name, e);
        }
    }

    public static Type reflectedPropertyType(String className, String name, ClassLoaderService classLoaderService) throws MappingException {
        try {
            Class clazz = classLoaderService.classForName(className);
            return ReflectHelper.getter(clazz, name).getReturnType();
        }
        catch (ClassLoadingException e) {
            throw new MappingException("class " + className + " not found while looking for property: " + name, e);
        }
    }

    public static Class<?> reflectedPropertyClass(Class<?> clazz, String name) throws MappingException {
        return ReflectHelper.getter(clazz, name).getReturnTypeClass();
    }

    private static Getter getter(Class<?> clazz, String name) throws MappingException {
        return PropertyAccessStrategyGetterImpl.INSTANCE.buildPropertyAccess(clazz, name, true).getGetter();
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) throws PropertyNotFoundException {
        if (ReflectHelper.isAbstractClass(clazz)) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(NO_PARAM_SIGNATURE);
            ReflectHelper.ensureAccessibility(constructor);
            return constructor;
        }
        catch (NoSuchMethodException nme) {
            throw new PropertyNotFoundException("Object class [" + clazz.getName() + "] must declare a default (no-argument) constructor");
        }
    }

    public static <T> Supplier<T> getDefaultSupplier(Class<T> clazz) {
        if (ReflectHelper.isAbstractClass(clazz)) {
            throw new IllegalArgumentException("Abstract class cannot be instantiated: " + clazz.getName());
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(NO_PARAM_SIGNATURE);
            ReflectHelper.ensureAccessibility(constructor);
            return () -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | java.lang.InstantiationException | InvocationTargetException e) {
                    throw new InstantiationException("Constructor threw exception", clazz, e);
                }
            };
        }
        catch (NoSuchMethodException nme) {
            return () -> {
                try {
                    return clazz.newInstance();
                }
                catch (IllegalAccessException | java.lang.InstantiationException e) {
                    throw new InstantiationException("Default constructor threw exception", clazz, e);
                }
            };
        }
    }

    public static boolean isAbstractClass(Class<?> clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    public static boolean isFinalClass(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static <T> Constructor<T> getConstructorOrNull(Class<T> clazz, Class<?> ... constructorArgs) {
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(constructorArgs);
            try {
                ReflectHelper.ensureAccessibility(constructor);
            }
            catch (SecurityException e) {
                constructor = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return constructor;
    }

    public static Method getMethod(Class<?> clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Field findField(Class<?> containerClass, String propertyName) {
        if (containerClass == null) {
            throw new IllegalArgumentException("Class<?> on which to find field [" + propertyName + "] cannot be null");
        }
        if (containerClass == Object.class) {
            throw new IllegalArgumentException("Illegal attempt to locate field [" + propertyName + "] on Object.class");
        }
        Field field = ReflectHelper.locateField(containerClass, propertyName);
        if (field == null) {
            throw new PropertyNotFoundException(String.format(Locale.ROOT, "Could not locate field name [%s] on class [%s]", propertyName, containerClass.getName()));
        }
        ReflectHelper.ensureAccessibility(field);
        return field;
    }

    public static void ensureAccessibility(AccessibleObject accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }

    private static Field locateField(Class<?> clazz, String propertyName) {
        if (clazz == null || Object.class.equals(clazz)) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(propertyName);
            return !ReflectHelper.isStaticField(field) ? field : ReflectHelper.locateField(clazz.getSuperclass(), propertyName);
        }
        catch (NoSuchFieldException nsfe) {
            return ReflectHelper.locateField(clazz.getSuperclass(), propertyName);
        }
    }

    public static boolean isStaticField(Field field) {
        return field != null && (field.getModifiers() & 8) == 8;
    }

    public static Method findGetterMethod(Class<?> containerClass, String propertyName) {
        Class<?> checkClass = containerClass;
        Method getter = null;
        if (ReflectHelper.isRecord(containerClass)) {
            try {
                getter = containerClass.getMethod(propertyName, NO_PARAM_SIGNATURE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        while (getter == null && checkClass != null && !checkClass.equals(Object.class)) {
            getter = ReflectHelper.getGetterOrNull(checkClass, propertyName);
            if (getter == null) {
                getter = ReflectHelper.getGetterOrNull(checkClass.getInterfaces(), propertyName);
            }
            checkClass = checkClass.getSuperclass();
        }
        if (getter == null) {
            throw new PropertyNotFoundException(String.format(Locale.ROOT, "Could not locate getter method for property '%s' of class '%s'", propertyName, containerClass.getName()));
        }
        ReflectHelper.ensureAccessibility(getter);
        return getter;
    }

    private static Method getGetterOrNull(Class<?>[] interfaces, String propertyName) {
        Method getter = null;
        for (int i = 0; getter == null && i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (ReflectHelper.shouldSkipInterfaceCheck(anInterface) || (getter = ReflectHelper.getGetterOrNull(anInterface, propertyName)) != null) continue;
            getter = ReflectHelper.getGetterOrNull(anInterface.getInterfaces(), propertyName);
        }
        return getter;
    }

    public static Method getGetterOrNull(Class<?> containerClass, String propertyName) {
        if (ReflectHelper.isRecord(containerClass)) {
            try {
                return containerClass.getMethod(propertyName, NO_PARAM_SIGNATURE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (Method method : containerClass.getDeclaredMethods()) {
            String stemName;
            if (method.getParameterCount() != 0 || Modifier.isStatic(method.getModifiers()) || method.isBridge() || method.getAnnotation(Transient.class) != null) continue;
            String methodName = method.getName();
            if (methodName.startsWith("get") && ((stemName = methodName.substring(3)).equals(propertyName) || Introspector.decapitalize(stemName).equals(propertyName))) {
                ReflectHelper.verifyNoIsVariantExists(containerClass, propertyName, method, stemName);
                return method;
            }
            if (!methodName.startsWith("is") || !(stemName = methodName.substring(2)).equals(propertyName) && !Introspector.decapitalize(stemName).equals(propertyName)) continue;
            ReflectHelper.verifyNoGetVariantExists(containerClass, propertyName, method, stemName);
            return method;
        }
        return null;
    }

    public static void verifyNoIsVariantExists(Class<?> containerClass, String propertyName, Method getMethod, String stemName) {
        try {
            Method isMethod = containerClass.getDeclaredMethod("is" + stemName, new Class[0]);
            if (!Modifier.isStatic(isMethod.getModifiers()) && isMethod.getAnnotation(Transient.class) == null) {
                ReflectHelper.checkGetAndIsVariants(containerClass, propertyName, getMethod, isMethod);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static void checkGetAndIsVariants(Class<?> containerClass, String propertyName, Method getMethod, Method isMethod) {
        if (!isMethod.getReturnType().equals(getMethod.getReturnType())) {
            throw new MappingException(String.format(Locale.ROOT, "Class<?> '%s' declares both 'get' [%s] and 'is' [%s] variants of getter for property '%s'", containerClass.getName(), getMethod, isMethod, propertyName));
        }
    }

    public static void verifyNoGetVariantExists(Class<?> containerClass, String propertyName, Method isMethod, String stemName) {
        try {
            Method getMethod = containerClass.getDeclaredMethod("get" + stemName, new Class[0]);
            if (!Modifier.isStatic(getMethod.getModifiers()) && getMethod.getAnnotation(Transient.class) == null) {
                ReflectHelper.checkGetAndIsVariants(containerClass, propertyName, getMethod, isMethod);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static Method getterMethodOrNull(Class<?> containerJavaType, String propertyName) {
        try {
            return ReflectHelper.findGetterMethod(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    public static Method setterMethodOrNull(Class<?> containerClass, String propertyName, Class<?> propertyType) {
        String likelyMethodName = ReflectHelper.likelySetterMethodNameForProperty(propertyName);
        try {
            Method setter = containerClass.getMethod(likelyMethodName, propertyType);
            ReflectHelper.ensureAccessibility(setter);
            return setter;
        }
        catch (NoSuchMethodException setter) {
            Method setter2 = null;
            for (Class<?> checkClass = containerClass; setter2 == null && checkClass != null && !checkClass.equals(Object.class); checkClass = checkClass.getSuperclass()) {
                setter2 = ReflectHelper.setterOrNull(checkClass, propertyName, propertyType, likelyMethodName);
                if (setter2 == null) {
                    setter2 = ReflectHelper.setterOrNull(checkClass.getInterfaces(), propertyName, propertyType, likelyMethodName);
                    continue;
                }
                ReflectHelper.ensureAccessibility(setter2);
            }
            return setter2;
        }
    }

    public static Method setterMethodOrNullBySetterName(Class<?> containerClass, String setterName, Class<?> propertyType) {
        Method setter = null;
        for (Class<?> checkClass = containerClass; setter == null && checkClass != null && !checkClass.equals(Object.class); checkClass = checkClass.getSuperclass()) {
            setter = ReflectHelper.setterOrNullBySetterName(checkClass, setterName, propertyType);
            if (setter == null) {
                setter = ReflectHelper.setterOrNullBySetterName(checkClass.getInterfaces(), setterName, propertyType);
                continue;
            }
            ReflectHelper.ensureAccessibility(setter);
        }
        return setter;
    }

    private static Method setterOrNullBySetterName(Class<?>[] interfaces, String setterName, Class<?> propertyType) {
        Method setter = null;
        for (int i = 0; setter == null && i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (ReflectHelper.shouldSkipInterfaceCheck(anInterface) || (setter = ReflectHelper.setterOrNullBySetterName(anInterface, setterName, propertyType)) != null) continue;
            setter = ReflectHelper.setterOrNullBySetterName(anInterface.getInterfaces(), setterName, propertyType);
        }
        return setter;
    }

    private static boolean shouldSkipInterfaceCheck(Class<?> anInterface) {
        String interfaceName = anInterface.getName();
        if (interfaceName.startsWith("org.hibernate.engine.")) {
            return true;
        }
        return interfaceName.startsWith("jakarta.persistence.");
    }

    private static Method setterOrNullBySetterName(Class<?> theClass, String setterName, Class<?> propertyType) {
        Method potentialSetter = null;
        for (Method method : theClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (method.getParameterCount() != 1 || !methodName.equals(setterName)) continue;
            potentialSetter = method;
            if (propertyType == null || method.getParameterTypes()[0].equals(propertyType)) break;
        }
        return potentialSetter;
    }

    public static Method findSetterMethod(Class<?> containerClass, String propertyName, Class<?> propertyType) {
        Method setter = ReflectHelper.setterMethodOrNull(containerClass, propertyName, propertyType);
        if (setter == null) {
            throw new PropertyNotFoundException(String.format(Locale.ROOT, "Could not locate setter method for property '%s' of class '%s'", propertyName, containerClass.getName()));
        }
        return setter;
    }

    private static Method setterOrNull(Class<?>[] interfaces, String propertyName, Class<?> propertyType, String likelyMethodName) {
        Method setter = null;
        for (int i = 0; setter == null && i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (ReflectHelper.shouldSkipInterfaceCheck(anInterface) || (setter = ReflectHelper.setterOrNull(anInterface, propertyName, propertyType, likelyMethodName)) != null) continue;
            setter = ReflectHelper.setterOrNull(anInterface.getInterfaces(), propertyName, propertyType, likelyMethodName);
        }
        return setter;
    }

    private static Method setterOrNull(Class<?> theClass, String propertyName, Class<?> propertyType, String likelyMethodName) {
        try {
            return theClass.getDeclaredMethod(likelyMethodName, propertyType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method potentialSetter = null;
            for (Method method : theClass.getDeclaredMethods()) {
                String testOldMethod;
                String testStdMethod;
                String methodName = method.getName();
                if (method.getParameterCount() != 1 || !methodName.startsWith("set") || !(testStdMethod = Introspector.decapitalize(testOldMethod = methodName.substring(3))).equals(propertyName) && !testOldMethod.equals(propertyName)) continue;
                potentialSetter = method;
                if (propertyType == null || method.getParameterTypes()[0].equals(propertyType)) break;
            }
            return potentialSetter;
        }
    }

    private static String likelySetterMethodNameForProperty(String propertyName) {
        char firstCharacter = propertyName.charAt(0);
        return Character.isLowerCase(firstCharacter) ? "set" + Character.toUpperCase(firstCharacter) + propertyName.substring(1) : "set" + propertyName;
    }

    public static Method findGetterMethodForFieldAccess(Field field, String propertyName) {
        for (Method method : field.getDeclaringClass().getDeclaredMethods()) {
            String stemName;
            if (method.getParameterCount() != 0 || Modifier.isStatic(method.getModifiers()) || !method.getReturnType().isAssignableFrom(field.getType())) continue;
            String methodName = method.getName();
            if (methodName.startsWith("get") && ((stemName = methodName.substring(3)).equals(propertyName) || Introspector.decapitalize(stemName).equals(propertyName))) {
                return method;
            }
            if (!methodName.startsWith("is") || !(stemName = methodName.substring(2)).equals(propertyName) && !Introspector.decapitalize(stemName).equals(propertyName)) continue;
            return method;
        }
        if (ReflectHelper.isRecord(field.getDeclaringClass())) {
            try {
                return field.getDeclaringClass().getMethod(field.getName(), NO_PARAM_SIGNATURE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isRecord(Class<?> declaringClass) {
        return RECORD_CLASS != null && RECORD_CLASS.isAssignableFrom(declaringClass);
    }

    public static Class<?>[] getRecordComponentTypes(Class<?> javaType) {
        try {
            Object[] recordComponents = (Object[])GET_RECORD_COMPONENTS.invoke(javaType, new Object[0]);
            Class[] componentTypes = new Class[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                componentTypes[i] = (Class)GET_TYPE.invoke(recordComponents[i], new Object[0]);
            }
            return componentTypes;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not determine the record components for: " + javaType.getName(), e);
        }
    }

    public static String[] getRecordComponentNames(Class<?> javaType) {
        try {
            Object[] recordComponents = (Object[])GET_RECORD_COMPONENTS.invoke(javaType, new Object[0]);
            String[] componentNames = new String[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                componentNames[i] = (String)GET_NAME.invoke(recordComponents[i], new Object[0]);
            }
            return componentNames;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not determine the record components for: " + javaType.getName(), e);
        }
    }

    public static <T> Class<T> getClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return ReflectHelper.getClass(typeVariable.getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return ReflectHelper.getClass(wildcardType.getUpperBounds()[0]);
        }
        throw new UnsupportedOperationException("Can't get java type class from type: " + String.valueOf(type));
    }

    public static Class<?> getPropertyType(Member member) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return field.getType();
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            return method.getReturnType();
        }
        throw new AssertionFailure("member should have been a method or field");
    }

    public static boolean isClass(Class<?> resultClass) {
        return !resultClass.isArray() && !resultClass.isPrimitive() && !resultClass.isEnum() && !resultClass.isInterface();
    }

    public static <T> Class<T> getClass(T instance) {
        return instance.getClass();
    }

    public static <T extends Enum<T>> Class<T> getClass(Enum<T> value) {
        return value.getClass();
    }

    @AllowReflection
    public static <T> Class<T[]> arrayClass(Class<T> clazz) {
        Object instance = Array.newInstance(clazz, 0);
        Object[] array = (Object[])instance;
        return ReflectHelper.getClass(array);
    }

    static {
        Method hash;
        Method eq;
        NO_PARAM_SIGNATURE = ArrayHelper.EMPTY_CLASS_ARRAY;
        SINGLE_OBJECT_PARAM_SIGNATURE = new Class[]{Object.class};
        try {
            eq = ReflectHelper.extractEqualsMethod(Object.class);
            hash = ReflectHelper.extractHashCodeMethod(Object.class);
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not find Object.equals() or Object.hashCode()", e);
        }
        OBJECT_EQUALS = eq;
        OBJECT_HASHCODE = hash;
        Class<?> recordClass = null;
        Method getRecordComponents = null;
        Method getName = null;
        Method getType = null;
        try {
            recordClass = Class.forName("java.lang.Record");
            getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
            Class<?> recordComponentClass = Class.forName("java.lang.reflect.RecordComponent");
            getName = recordComponentClass.getMethod("getName", new Class[0]);
            getType = recordComponentClass.getMethod("getType", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RECORD_CLASS = recordClass;
        GET_RECORD_COMPONENTS = getRecordComponents;
        GET_NAME = getName;
        GET_TYPE = getType;
    }
}

