/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.PersistenceException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;

public abstract class ConfigurationHelper {
    public static void overrideProperties(Properties properties, Map<?, ?> overrides) {
        for (Map.Entry<?, ?> entry : overrides.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            properties.put(key, value);
        }
    }

    public static FlushMode getFlushMode(Object value, FlushMode defaultFlushMode) {
        if (value instanceof FlushMode) {
            FlushMode mode = (FlushMode)((Object)value);
            return mode;
        }
        if (value instanceof FlushModeType) {
            FlushModeType flushModeType = (FlushModeType)((Object)value);
            return ConfigurationHelper.getFlushMode(flushModeType);
        }
        if (value instanceof String) {
            String string = (String)value;
            return ConfigurationHelper.getFlushMode(string);
        }
        if (defaultFlushMode == null) {
            throw new PersistenceException("Unable to parse org.hibernate.flushMode: " + String.valueOf(value));
        }
        return defaultFlushMode;
    }

    public static FlushMode getFlushMode(Object value) {
        return ConfigurationHelper.getFlushMode(value, null);
    }

    private static FlushMode getFlushMode(String flushMode) {
        return flushMode == null ? null : FlushMode.valueOf(flushMode.toUpperCase(Locale.ROOT));
    }

    private static FlushMode getFlushMode(FlushModeType flushMode) {
        return switch (flushMode) {
            default -> throw new IncompatibleClassChangeError();
            case FlushModeType.AUTO -> FlushMode.AUTO;
            case FlushModeType.COMMIT -> FlushMode.COMMIT;
        };
    }

    public static Integer getInteger(Object value) {
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer;
        }
        if (value instanceof String) {
            String string = (String)value;
            return Integer.valueOf(string);
        }
        throw new IllegalArgumentException("value must be a string or integer: " + String.valueOf(value));
    }

    public static Boolean getBoolean(Object value) {
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        if (value instanceof String) {
            String string = (String)value;
            return Boolean.valueOf(string);
        }
        throw new IllegalArgumentException("value must be a string or boolean: " + String.valueOf(value));
    }

    public static CacheMode getCacheMode(Object value) {
        if (value instanceof CacheMode) {
            CacheMode cacheMode = (CacheMode)value;
            return cacheMode;
        }
        if (value instanceof String) {
            String string = (String)value;
            return CacheMode.valueOf(string);
        }
        throw new IllegalArgumentException("value must be a string or CacheMode: " + String.valueOf(value));
    }
}

