/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.JDBCException;
import org.hibernate.LazyInitializationException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.MappingException;
import org.hibernate.PropertyValueException;
import org.hibernate.QueryException;
import org.hibernate.Timeouts;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.internal.SoftDeleteHelper;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementHelper;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeDescriptor;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributesMetadata;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.cache.spi.entry.ReferenceCacheEntryImpl;
import org.hibernate.cache.spi.entry.StandardCacheEntryImpl;
import org.hibernate.cache.spi.entry.StructuredCacheEntry;
import org.hibernate.cache.spi.entry.UnstructuredCacheEntry;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.ImmutableEntityEntryFactory;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.MutableEntityEntryFactory;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.profile.internal.FetchProfileAffectee;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryFactory;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.NaturalIdResolutions;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.generator.internal.VersionGeneration;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.LockModeEnumMap;
import org.hibernate.jdbc.Expectation;
import org.hibernate.loader.ast.internal.EntityConcreteTypeLoader;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.internal.MultiIdEntityLoaderArrayParam;
import org.hibernate.loader.ast.internal.MultiIdEntityLoaderInPredicate;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.SingleIdArrayLoadPlan;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderProvidedQueryImpl;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderStandardImpl;
import org.hibernate.loader.ast.internal.SingleUniqueKeyEntityLoaderStandard;
import org.hibernate.loader.ast.spi.BatchLoaderFactory;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.MultiIdEntityLoader;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.loader.ast.spi.SingleIdEntityLoader;
import org.hibernate.loader.ast.spi.SingleUniqueKeyEntityLoader;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.AttributeMappingsMap;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.BasicEntityIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.CompoundNaturalIdMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatorTypeImpl;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityRowIdMappingImpl;
import org.hibernate.metamodel.mapping.internal.EntityVersionMappingImpl;
import org.hibernate.metamodel.mapping.internal.ExplicitColumnDiscriminatorMappingImpl;
import org.hibernate.metamodel.mapping.internal.GeneratedValuesProcessor;
import org.hibernate.metamodel.mapping.internal.ImmutableAttributeMappingList;
import org.hibernate.metamodel.mapping.internal.InFlightEntityMappingType;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.MappingModelHelper;
import org.hibernate.metamodel.mapping.internal.SimpleAttributeMetadata;
import org.hibernate.metamodel.mapping.internal.SimpleNaturalIdMapping;
import org.hibernate.metamodel.mapping.internal.UnifiedAnyDiscriminatorConverter;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EntityInstantiator;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.DirtyHelper;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.persister.entity.EntityNameUse;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.EntityPropertyMapping;
import org.hibernate.persister.entity.ExplicitSqlStringGenerationContext;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.UniqueKeyEntry;
import org.hibernate.persister.entity.mutation.DeleteCoordinator;
import org.hibernate.persister.entity.mutation.DeleteCoordinatorSoft;
import org.hibernate.persister.entity.mutation.DeleteCoordinatorStandard;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.persister.entity.mutation.InsertCoordinator;
import org.hibernate.persister.entity.mutation.InsertCoordinatorStandard;
import org.hibernate.persister.entity.mutation.MergeCoordinator;
import org.hibernate.persister.entity.mutation.UpdateCoordinator;
import org.hibernate.persister.entity.mutation.UpdateCoordinatorNoOp;
import org.hibernate.persister.entity.mutation.UpdateCoordinatorStandard;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.query.PathException;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategyProvider;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.Alias;
import org.hibernate.sql.InFragment;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Template;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.AliasedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.entity.internal.EntityResultImpl;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.tuple.NonIdentifierAttribute;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.VersionProperty;
import org.hibernate.type.AnyType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

@Internal
public abstract class AbstractEntityPersister
implements EntityPersister,
InFlightEntityMappingType,
EntityMutationTarget,
LazyPropertyInitializer,
FetchProfileAffectee,
Joinable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractEntityPersister.class);
    public static final String ENTITY_CLASS = "class";
    public static final String VERSION_COLUMN_ALIAS = "version_";
    public static final String ROWID_ALIAS = "rowid_";
    private final NavigableRole navigableRole;
    private final SessionFactoryImplementor factory;
    private final EntityEntryFactory entityEntryFactory;
    private final String sqlAliasStem;
    private final String jpaEntityName;
    private SingleIdEntityLoader<?> singleIdLoader;
    private MultiIdEntityLoader<?> multiIdLoader;
    private NaturalIdLoader<?> naturalIdLoader;
    private MultiNaturalIdLoader<?> multiNaturalIdLoader;
    private final String[] rootTableKeyColumnNames;
    private final String[] rootTableKeyColumnReaders;
    private final String[] rootTableKeyColumnReaderTemplates;
    private final String[] identifierAliases;
    private final int identifierColumnSpan;
    private final String versionColumnName;
    private final boolean hasFormulaProperties;
    protected final int batchSize;
    private final boolean hasSubselectLoadableCollections;
    private final boolean hasPartitionedSelectionMapping;
    private final boolean hasCollectionNotReferencingPK;
    protected final String rowIdName;
    private final String sqlWhereStringTableExpression;
    private final String sqlWhereStringTemplate;
    private final String[][] propertyColumnAliases;
    private final String[][] propertyColumnNames;
    private final String[][] propertyColumnFormulaTemplates;
    private final boolean[][] propertyColumnUpdateable;
    private final boolean[][] propertyColumnInsertable;
    private final Set<String> sharedColumnNames;
    private final String[] lazyPropertyNames;
    private final int[] lazyPropertyNumbers;
    private final Type[] lazyPropertyTypes;
    private final Set<String> nonLazyPropertyNames;
    private final String[] subclassPropertyNameClosure;
    private final Type[] subclassPropertyTypeClosure;
    private final String[][] subclassPropertyFormulaTemplateClosure;
    private final String[][] subclassPropertyColumnNameClosure;
    private final String[][] subclassPropertyColumnReaderClosure;
    private final String[][] subclassPropertyColumnReaderTemplateClosure;
    private final FetchMode[] subclassPropertyFetchModeClosure;
    private Map<String, SingleIdArrayLoadPlan> lazyLoadPlanByFetchGroup;
    private final LockModeEnumMap<LockingStrategy> lockers = new LockModeEnumMap();
    private String sqlVersionSelectString;
    private EntityTableMapping[] tableMappings;
    private InsertCoordinator insertCoordinator;
    private UpdateCoordinator updateCoordinator;
    private DeleteCoordinator deleteCoordinator;
    private UpdateCoordinator mergeCoordinator;
    private SqmMultiTableMutationStrategy sqmMultiTableMutationStrategy;
    private SqmMultiTableInsertStrategy sqmMultiTableInsertStrategy;
    private final EntityDataAccess cacheAccessStrategy;
    private final NaturalIdDataAccess naturalIdRegionAccessStrategy;
    private final CacheEntryHelper cacheEntryHelper;
    private final boolean canReadFromCache;
    private final boolean canWriteToCache;
    private final boolean invalidateCache;
    private final boolean isLazyPropertiesCacheable;
    private final boolean useReferenceCacheEntries;
    private final boolean useShallowQueryCacheLayout;
    private final boolean storeDiscriminatorInShallowQueryCacheLayout;
    private final FilterHelper filterHelper;
    private volatile Set<String> affectingFetchProfileNames;
    protected List<? extends ModelPart> insertGeneratedProperties;
    protected List<? extends ModelPart> updateGeneratedProperties;
    private GeneratedValuesProcessor insertGeneratedValuesProcessor;
    private GeneratedValuesProcessor updateGeneratedValuesProcessor;
    private GeneratedValuesMutationDelegate insertDelegate;
    private GeneratedValuesMutationDelegate updateDelegate;
    private String identitySelectString;
    private final JavaType<?> javaType;
    private final EntityRepresentationStrategy representationStrategy;
    private EntityMappingType superMappingType;
    private SortedMap<String, EntityMappingType> subclassMappingTypes;
    private final boolean concreteProxy;
    private EntityConcreteTypeLoader concreteTypeLoader;
    private EntityIdentifierMapping identifierMapping;
    private NaturalIdMapping naturalIdMapping;
    private EntityVersionMapping versionMapping;
    private EntityRowIdMapping rowIdMapping;
    private EntityDiscriminatorMapping discriminatorMapping;
    private SoftDeleteMapping softDeleteMapping;
    private AttributeMappingsList attributeMappings;
    protected AttributeMappingsMap declaredAttributeMappings = AttributeMappingsMap.builder().build();
    protected AttributeMappingsList staticFetchableList;
    private Getter[] getterCache;
    private Setter[] setterCache;
    private final String queryLoaderName;
    private BeforeExecutionGenerator versionGenerator;
    protected ReflectionOptimizer.AccessOptimizer accessOptimizer;
    protected final String[] fullDiscriminatorSQLValues;
    private final Object[] fullDiscriminatorValues;
    private final EntityPropertyMapping propertyMapping;
    private List<UniqueKeyEntry> uniqueKeyEntries = null;
    private ConcurrentHashMap<String, SingleIdArrayLoadPlan> nonLazyPropertyLoadPlansByName;
    private static final String DISCRIMINATOR_ALIAS = "clazz_";
    private DiscriminatorType<?> discriminatorDomainType;
    private Map<SingularAttributeMapping, SingleUniqueKeyEntityLoader<?>> uniqueKeyLoadersNew;
    @Deprecated
    protected Expectation[] insertExpectations;
    @Deprecated
    protected Expectation[] updateExpectations;
    @Deprecated
    protected Expectation[] deleteExpectations;
    @Deprecated
    protected boolean[] insertCallable;
    @Deprecated
    protected boolean[] updateCallable;
    @Deprecated
    protected boolean[] deleteCallable;
    @Deprecated
    protected String[] customSQLInsert;
    @Deprecated
    protected String[] customSQLUpdate;
    @Deprecated
    protected String[] customSQLDelete;
    @Deprecated
    private final EntityMetamodel entityMetamodel;
    @Deprecated
    private final String[] subclassColumnAliasClosure;
    @Deprecated
    private final String[] subclassFormulaAliasClosure;
    @Deprecated
    private final Map<String, String[]> subclassPropertyAliases = new HashMap<String, String[]>();

    public AbstractEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, RuntimeModelCreationContext creationContext) throws HibernateException {
        this.jpaEntityName = persistentClass.getJpaEntityName();
        this.factory = creationContext.getSessionFactory();
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromEntityName(persistentClass.getEntityName());
        this.navigableRole = new NavigableRole(persistentClass.getEntityName());
        SessionFactoryOptions sessionFactoryOptions = creationContext.getSessionFactoryOptions();
        if (sessionFactoryOptions.isSecondLevelCacheEnabled()) {
            this.cacheAccessStrategy = cacheAccessStrategy;
            this.naturalIdRegionAccessStrategy = naturalIdRegionAccessStrategy;
            this.canWriteToCache = this.determineCanWriteToCache(persistentClass, cacheAccessStrategy);
            this.canReadFromCache = this.determineCanReadFromCache(persistentClass, cacheAccessStrategy);
            this.isLazyPropertiesCacheable = persistentClass.getRootClass().isLazyPropertiesCacheable();
        } else {
            this.cacheAccessStrategy = null;
            this.naturalIdRegionAccessStrategy = null;
            this.canWriteToCache = false;
            this.canReadFromCache = false;
            this.isLazyPropertiesCacheable = true;
        }
        this.entityMetamodel = creationContext.createEntityMetamodel(persistentClass, this);
        this.entityEntryFactory = this.entityMetamodel.isMutable() ? MutableEntityEntryFactory.INSTANCE : ImmutableEntityEntryFactory.INSTANCE;
        this.filterHelper = CollectionHelper.isNotEmpty(persistentClass.getFilters()) ? new FilterHelper(persistentClass.getFilters(), AbstractEntityPersister.getEntityNameByTableNameMap(persistentClass, this.factory.getSqlStringGenerationContext()), this.factory) : null;
        this.representationStrategy = creationContext.getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(persistentClass, this, creationContext);
        this.javaType = this.representationStrategy.getLoadJavaType();
        assert (this.javaType != null);
        this.accessOptimizer = AbstractEntityPersister.accessOptimizer(this.representationStrategy);
        this.concreteProxy = this.entityMetamodel.isPolymorphic() && (this.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() || this.hasProxy()) && persistentClass.isConcreteProxy();
        Dialect dialect = creationContext.getDialect();
        this.batchSize = persistentClass.getBatchSize() < 0 ? this.factory.getSessionFactoryOptions().getDefaultBatchFetchSize() : persistentClass.getBatchSize();
        this.hasSubselectLoadableCollections = persistentClass.hasSubselectLoadableCollections();
        this.hasPartitionedSelectionMapping = persistentClass.hasPartitionedSelectionMapping();
        this.hasCollectionNotReferencingPK = persistentClass.hasCollectionNotReferencingPK();
        this.propertyMapping = new EntityPropertyMapping(this);
        this.identifierColumnSpan = persistentClass.getIdentifier().getColumnSpan();
        this.rootTableKeyColumnNames = new String[this.identifierColumnSpan];
        this.rootTableKeyColumnReaders = new String[this.identifierColumnSpan];
        this.rootTableKeyColumnReaderTemplates = new String[this.identifierColumnSpan];
        this.identifierAliases = new String[this.identifierColumnSpan];
        String rowId = persistentClass.getRootTable().getRowId();
        this.rowIdName = rowId == null ? null : dialect.rowId(rowId);
        this.queryLoaderName = persistentClass.getLoaderName();
        TypeConfiguration typeConfiguration = creationContext.getTypeConfiguration();
        List<Column> columns = persistentClass.getIdentifier().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            this.rootTableKeyColumnNames[i] = column.getQuotedName(dialect);
            this.rootTableKeyColumnReaders[i] = column.getReadExpr(dialect);
            this.rootTableKeyColumnReaderTemplates[i] = column.getTemplate(dialect, typeConfiguration);
            this.identifierAliases[i] = column.getAlias(dialect, persistentClass.getRootTable());
        }
        String string = this.versionColumnName = persistentClass.isVersioned() ? persistentClass.getVersion().getColumns().get(0).getQuotedName(dialect) : null;
        if (StringHelper.isEmpty(persistentClass.getWhere())) {
            this.sqlWhereStringTableExpression = null;
            this.sqlWhereStringTemplate = null;
        } else {
            PersistentClass containingClass = persistentClass;
            while (containingClass.getSuperclass() != null) {
                PersistentClass superclass = containingClass.getSuperclass();
                if (!Objects.equals(persistentClass.getWhere(), superclass.getWhere())) break;
                containingClass = superclass;
            }
            this.sqlWhereStringTableExpression = this.determineTableName(containingClass.getTable());
            this.sqlWhereStringTemplate = Template.renderWhereStringTemplate("(" + persistentClass.getWhere() + ")", dialect, typeConfiguration);
        }
        int hydrateSpan = this.entityMetamodel.getPropertySpan();
        this.propertyColumnAliases = new String[hydrateSpan][];
        this.propertyColumnNames = new String[hydrateSpan][];
        this.propertyColumnFormulaTemplates = new String[hydrateSpan][];
        this.propertyColumnUpdateable = new boolean[hydrateSpan][];
        this.propertyColumnInsertable = new boolean[hydrateSpan][];
        this.sharedColumnNames = new HashSet<String>();
        this.nonLazyPropertyNames = new HashSet<String>();
        HashSet<Property> thisClassProperties = new HashSet<Property>();
        ArrayList<String> lazyNames = new ArrayList<String>();
        ArrayList<Integer> lazyNumbers = new ArrayList<Integer>();
        ArrayList<Type> lazyTypes = new ArrayList<Type>();
        List<Property> propertyClosure = persistentClass.getPropertyClosure();
        boolean foundFormula = false;
        for (int i = 0; i < propertyClosure.size(); ++i) {
            boolean lazy;
            Property prop = propertyClosure.get(i);
            thisClassProperties.add(prop);
            int span = prop.getColumnSpan();
            String[] colNames = new String[span];
            String[] colAliases = new String[span];
            String[] formulaTemplates = new String[span];
            List<Selectable> selectables = prop.getSelectables();
            for (int k = 0; k < selectables.size(); ++k) {
                Selectable selectable = selectables.get(k);
                colAliases[k] = selectable.getAlias(dialect, prop.getValue().getTable());
                if (selectable.isFormula()) {
                    foundFormula = true;
                    Formula formula = (Formula)selectable;
                    formula.setFormula(this.substituteBrackets(formula.getFormula()));
                    formulaTemplates[k] = selectable.getTemplate(dialect, typeConfiguration);
                    continue;
                }
                Iterator<Selectable> column = (Column)selectable;
                colNames[k] = ((Column)((Object)column)).getQuotedName(dialect);
            }
            this.propertyColumnNames[i] = colNames;
            this.propertyColumnFormulaTemplates[i] = formulaTemplates;
            this.propertyColumnAliases[i] = colAliases;
            boolean bl = lazy = !EnhancementHelper.includeInBaseFetchGroup(prop, this.entityMetamodel.isInstrumented(), entityName -> {
                PersistentClass entityBinding = creationContext.getMetadata().getEntityBinding(entityName);
                assert (entityBinding != null);
                return entityBinding.hasSubclasses();
            }, sessionFactoryOptions.isCollectionsInDefaultFetchGroupEnabled());
            if (lazy) {
                lazyNames.add(prop.getName());
                lazyNumbers.add(i);
                lazyTypes.add(prop.getValue().getType());
            } else {
                this.nonLazyPropertyNames.add(prop.getName());
            }
            this.propertyColumnUpdateable[i] = prop.getValue().getColumnUpdateability();
            this.propertyColumnInsertable[i] = prop.getValue().getColumnInsertability();
        }
        this.hasFormulaProperties = foundFormula;
        this.lazyPropertyNames = ArrayHelper.toStringArray(lazyNames);
        this.lazyPropertyNumbers = ArrayHelper.toIntArray(lazyNumbers);
        this.lazyPropertyTypes = ArrayHelper.toTypeArray(lazyTypes);
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> formulaAliases = new ArrayList<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String[]> templates = new ArrayList<String[]>();
        ArrayList<String[]> propColumns = new ArrayList<String[]>();
        ArrayList<String[]> propColumnReaders = new ArrayList<String[]>();
        ArrayList<String[]> propColumnReaderTemplates = new ArrayList<String[]>();
        ArrayList<FetchMode> joinedFetchesList = new ArrayList<FetchMode>();
        if (persistentClass.hasSubclasses()) {
            for (Selectable selectable : persistentClass.getIdentifier().getSelectables()) {
                if (selectable.isFormula()) continue;
                this.sharedColumnNames.add(((Column)selectable).getQuotedName(dialect));
            }
        }
        for (Property property : persistentClass.getSubclassPropertyClosure()) {
            names.add(property.getName());
            types.add(property.getType());
            String[] cols = new String[property.getColumnSpan()];
            String[] readers = new String[property.getColumnSpan()];
            String[] readerTemplates = new String[property.getColumnSpan()];
            String[] forms = new String[property.getColumnSpan()];
            List<Selectable> selectables = property.getSelectables();
            for (int i = 0; i < selectables.size(); ++i) {
                String colName;
                Selectable selectable = selectables.get(i);
                if (selectable.isFormula()) {
                    String template;
                    forms[i] = template = selectable.getTemplate(dialect, typeConfiguration);
                    String formulaAlias = selectable.getAlias(dialect);
                    if (!property.isSelectable() || formulaAliases.contains(formulaAlias)) continue;
                    formulaAliases.add(formulaAlias);
                    continue;
                }
                Column column = (Column)selectable;
                cols[i] = colName = column.getQuotedName(dialect);
                String columnAlias = selectable.getAlias(dialect, property.getValue().getTable());
                if (property.isSelectable() && !aliases.contains(columnAlias)) {
                    aliases.add(columnAlias);
                }
                readers[i] = column.getReadExpr(dialect);
                readerTemplates[i] = column.getTemplate(dialect, typeConfiguration);
                if (!(thisClassProperties.contains(property) ? persistentClass.hasSubclasses() : persistentClass.isDefinedOnMultipleSubclasses(column))) continue;
                this.sharedColumnNames.add(colName);
            }
            propColumns.add(cols);
            propColumnReaders.add(readers);
            propColumnReaderTemplates.add(readerTemplates);
            templates.add(forms);
            joinedFetchesList.add(property.getValue().getFetchMode());
        }
        this.subclassColumnAliasClosure = ArrayHelper.toStringArray(aliases);
        this.subclassFormulaAliasClosure = ArrayHelper.toStringArray(formulaAliases);
        this.subclassPropertyNameClosure = ArrayHelper.toStringArray(names);
        this.subclassPropertyTypeClosure = ArrayHelper.toTypeArray(types);
        this.subclassPropertyFormulaTemplateClosure = ArrayHelper.to2DStringArray(templates);
        this.subclassPropertyColumnNameClosure = ArrayHelper.to2DStringArray(propColumns);
        this.subclassPropertyColumnReaderClosure = ArrayHelper.to2DStringArray(propColumnReaders);
        this.subclassPropertyColumnReaderTemplateClosure = ArrayHelper.to2DStringArray(propColumnReaderTemplates);
        this.subclassPropertyFetchModeClosure = new FetchMode[joinedFetchesList.size()];
        int j = 0;
        for (FetchMode fetchMode : joinedFetchesList) {
            this.subclassPropertyFetchModeClosure[j++] = fetchMode;
        }
        this.useReferenceCacheEntries = this.shouldUseReferenceCacheEntries(creationContext.getSessionFactoryOptions());
        this.useShallowQueryCacheLayout = this.shouldUseShallowCacheLayout(persistentClass.getQueryCacheLayout(), creationContext.getSessionFactoryOptions());
        this.storeDiscriminatorInShallowQueryCacheLayout = AbstractEntityPersister.shouldStoreDiscriminatorInShallowQueryCacheLayout(persistentClass.getQueryCacheLayout(), creationContext.getSessionFactoryOptions());
        this.cacheEntryHelper = this.buildCacheEntryHelper(creationContext.getSessionFactoryOptions());
        this.invalidateCache = sessionFactoryOptions.isSecondLevelCacheEnabled() && this.canWriteToCache && this.shouldInvalidateCache(persistentClass, creationContext);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> sqlValues = new ArrayList<String>();
        if (persistentClass.isPolymorphic() && persistentClass.getDiscriminator() != null) {
            if (!this.getEntityMetamodel().isAbstract()) {
                arrayList.add(DiscriminatorHelper.getDiscriminatorValue(persistentClass));
                sqlValues.add(DiscriminatorHelper.getDiscriminatorSQLValue(persistentClass, dialect));
            }
            List<Subclass> subclasses = persistentClass.getSubclasses();
            for (int k = 0; k < subclasses.size(); ++k) {
                Subclass subclass = subclasses.get(k);
                if (AbstractEntityPersister.isAbstract(subclass)) continue;
                arrayList.add(DiscriminatorHelper.getDiscriminatorValue(subclass));
                sqlValues.add(DiscriminatorHelper.getDiscriminatorSQLValue(subclass, dialect));
            }
        }
        this.fullDiscriminatorSQLValues = ArrayHelper.toStringArray(sqlValues);
        this.fullDiscriminatorValues = ArrayHelper.toObjectArray(arrayList);
        if (this.hasNamedQueryLoader()) {
            this.getNamedQueryMemento(creationContext.getBootModel());
        }
    }

    private NamedQueryMemento<?> getNamedQueryMemento(MetadataImplementor bootModel) {
        NamedQueryMemento<?> memento = this.factory.getQueryEngine().getNamedObjectRepository().resolve(this.factory, bootModel, this.queryLoaderName);
        if (memento == null) {
            throw new IllegalArgumentException("Could not resolve named query '" + this.queryLoaderName + "' for loading entity '" + this.getEntityName() + "'");
        }
        return memento;
    }

    protected SingleIdEntityLoader<?> buildSingleIdEntityLoader() {
        if (this.hasNamedQueryLoader()) {
            NamedQueryMemento<?> memento = this.getNamedQueryMemento(null);
            return new SingleIdEntityLoaderProvidedQueryImpl(this, memento);
        }
        return this.buildSingleIdEntityLoader(new LoadQueryInfluencers(this.factory), null);
    }

    private SingleIdEntityLoader<?> buildSingleIdEntityLoader(LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions) {
        if (lockOptions != null && this.needsOneOffLoader(lockOptions)) {
            return new SingleIdEntityLoaderStandardImpl((EntityMappingType)this, loadQueryInfluencers);
        }
        if (loadQueryInfluencers.effectivelyBatchLoadable(this)) {
            int batchSize = loadQueryInfluencers.effectiveBatchSize(this);
            return this.factory.getServiceRegistry().requireService(BatchLoaderFactory.class).createEntityBatchLoader(batchSize, (EntityMappingType)this, loadQueryInfluencers);
        }
        return new SingleIdEntityLoaderStandardImpl((EntityMappingType)this, loadQueryInfluencers);
    }

    private boolean needsOneOffLoader(LockOptions lockOptions) {
        if (!lockOptions.getLockMode().isPessimistic()) {
            return false;
        }
        return lockOptions.hasNonDefaultOptions();
    }

    public static Map<String, String> getEntityNameByTableNameMap(PersistentClass persistentClass, SqlStringGenerationContext stringGenerationContext) {
        HashMap<String, String> entityNameByTableNameMap = new HashMap<String, String>();
        for (PersistentClass superType = persistentClass.getSuperPersistentClass(); superType != null; superType = superType.getSuperPersistentClass()) {
            entityNameByTableNameMap.put(superType.getTable().getQualifiedName(stringGenerationContext), superType.getEntityName());
            for (Join join : superType.getJoins()) {
                entityNameByTableNameMap.put(join.getTable().getQualifiedName(stringGenerationContext), superType.getEntityName());
            }
        }
        for (PersistentClass subclass : persistentClass.getSubclassClosure()) {
            entityNameByTableNameMap.put(subclass.getTable().getQualifiedName(stringGenerationContext), subclass.getEntityName());
            for (Join join : subclass.getJoins()) {
                entityNameByTableNameMap.put(join.getTable().getQualifiedName(stringGenerationContext), subclass.getEntityName());
            }
        }
        return entityNameByTableNameMap;
    }

    protected MultiIdEntityLoader<?> buildMultiIdLoader() {
        return this.getIdentifierType() instanceof BasicType && MultiKeyLoadHelper.supportsSqlArrayType(this.getDialect()) ? new MultiIdEntityLoaderArrayParam(this, this.factory) : new MultiIdEntityLoaderInPredicate(this, this.identifierColumnSpan, this.factory);
    }

    private String getIdentitySelectString(Dialect dialect) {
        try {
            int idTypeCode = ((BasicType)this.getIdentifierType()).getJdbcType().getDdlTypeCode();
            return dialect.getIdentityColumnSupport().getIdentitySelectString(this.getTableName(0), this.getKeyColumns(0)[0], idTypeCode);
        }
        catch (MappingException ex) {
            return null;
        }
    }

    static boolean isAbstract(PersistentClass subclass) {
        Boolean knownAbstract = subclass.isAbstract();
        return knownAbstract == null ? subclass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(subclass.getMappedClass()) : knownAbstract;
    }

    private boolean shouldUseReferenceCacheEntries(SessionFactoryOptions options) {
        if (!options.isDirectReferenceCacheEntriesEnabled()) {
            return false;
        }
        if (this.entityMetamodel.isMutable()) {
            return false;
        }
        for (Type type : this.getSubclassPropertyTypeClosure()) {
            if (!(type instanceof AnyType) && !(type instanceof CollectionType) && !(type instanceof EntityType)) continue;
            return false;
        }
        return true;
    }

    private static CacheLayout queryCacheLayout(CacheLayout entityQueryCacheLayout, SessionFactoryOptions options) {
        return entityQueryCacheLayout == null ? options.getQueryCacheLayout() : entityQueryCacheLayout;
    }

    private boolean shouldUseShallowCacheLayout(CacheLayout entityQueryCacheLayout, SessionFactoryOptions options) {
        return switch (AbstractEntityPersister.queryCacheLayout(entityQueryCacheLayout, options)) {
            case CacheLayout.FULL -> false;
            case CacheLayout.AUTO -> {
                if (this.canUseReferenceCacheEntries() || this.canReadFromCache()) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private static boolean shouldStoreDiscriminatorInShallowQueryCacheLayout(CacheLayout entityQueryCacheLayout, SessionFactoryOptions options) {
        return AbstractEntityPersister.queryCacheLayout(entityQueryCacheLayout, options) == CacheLayout.SHALLOW_WITH_DISCRIMINATOR;
    }

    protected abstract String[] getSubclassTableNames();

    protected abstract String[] getSubclassTableKeyColumns(int var1);

    protected abstract boolean isClassOrSuperclassTable(int var1);

    protected boolean isClassOrSuperclassJoin(int j) {
        return this.isClassOrSuperclassTable(j);
    }

    public abstract boolean isPropertyOfTable(int var1, int var2);

    protected abstract int[] getPropertyTableNumbers();

    @Override
    public String getDiscriminatorColumnName() {
        return DISCRIMINATOR_ALIAS;
    }

    public String getDiscriminatorColumnReaders() {
        return DISCRIMINATOR_ALIAS;
    }

    public String getDiscriminatorColumnReaderTemplate() {
        return this.getSubclassEntityNames().size() == 1 ? this.getDiscriminatorSQLValue() : "{@}.clazz_";
    }

    public String getDiscriminatorFormulaTemplate() {
        return null;
    }

    @Override
    public boolean isInverseTable(int j) {
        return false;
    }

    @Override
    public boolean isNullableTable(int j) {
        return false;
    }

    protected boolean isNullableSubclassTable(int j) {
        return false;
    }

    @Override
    public boolean isSubclassEntityName(String entityName) {
        return this.entityMetamodel.getSubclassEntityNames().contains(entityName);
    }

    @Override
    public boolean isSharedColumn(String columnExpression) {
        return this.sharedColumnNames.contains(columnExpression);
    }

    @Override
    public String[] getRootTableKeyColumnNames() {
        return this.rootTableKeyColumnNames;
    }

    SingleIdArrayLoadPlan getSQLLazySelectLoadPlan(String fetchGroup) {
        return this.lazyLoadPlanByFetchGroup.get(fetchGroup);
    }

    @Override
    public InsertCoordinator getInsertCoordinator() {
        return this.insertCoordinator;
    }

    @Override
    public UpdateCoordinator getUpdateCoordinator() {
        return this.updateCoordinator;
    }

    @Override
    public DeleteCoordinator getDeleteCoordinator() {
        return this.deleteCoordinator;
    }

    @Override
    public UpdateCoordinator getMergeCoordinator() {
        return this.mergeCoordinator;
    }

    public String getVersionSelectString() {
        return this.sqlVersionSelectString;
    }

    @Internal
    public GeneratedValuesProcessor getInsertGeneratedValuesProcessor() {
        return this.insertGeneratedValuesProcessor;
    }

    @Internal
    public GeneratedValuesProcessor getUpdateGeneratedValuesProcessor() {
        return this.updateGeneratedValuesProcessor;
    }

    @Override
    public boolean hasRowId() {
        return this.rowIdName != null;
    }

    @Override
    public String[] getTableNames() {
        String[] tableNames = new String[this.getTableSpan()];
        for (int i = 0; i < tableNames.length; ++i) {
            tableNames[i] = this.getTableName(i);
        }
        return tableNames;
    }

    private boolean shouldInvalidateCache(PersistentClass persistentClass, RuntimeModelCreationContext creationContext) {
        if (this.hasFormulaProperties()) {
            return true;
        }
        if (this.isVersioned()) {
            return false;
        }
        if (this.entityMetamodel.isDynamicUpdate()) {
            return true;
        }
        if (this.isCacheComplianceEnabled(creationContext)) {
            return false;
        }
        return persistentClass.getJoinClosureSpan() >= 1;
    }

    private boolean isCacheComplianceEnabled(RuntimeModelCreationContext creationContext) {
        return creationContext.getSessionFactoryOptions().getJpaCompliance().isJpaCacheComplianceEnabled();
    }

    private boolean determineCanWriteToCache(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy) {
        return cacheAccessStrategy != null && persistentClass.isCached();
    }

    private boolean determineCanReadFromCache(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy) {
        if (cacheAccessStrategy == null) {
            return false;
        }
        if (persistentClass.isCached()) {
            return true;
        }
        for (Subclass subclass : persistentClass.getSubclasses()) {
            if (!subclass.isCached()) continue;
            return true;
        }
        return false;
    }

    protected CacheEntryHelper buildCacheEntryHelper(SessionFactoryOptions options) {
        if (this.cacheAccessStrategy == null) {
            return NoopCacheEntryHelper.INSTANCE;
        }
        if (this.canUseReferenceCacheEntries()) {
            this.entityMetamodel.setLazy(false);
            return new ReferenceCacheEntryHelper(this);
        }
        return options.isStructuredCacheEntriesEnabled() ? new StructuredCacheEntryHelper(this) : new StandardCacheEntryHelper(this);
    }

    @Override
    public boolean canUseReferenceCacheEntries() {
        return this.useReferenceCacheEntries;
    }

    @Override
    public boolean useShallowQueryCacheLayout() {
        return this.useShallowQueryCacheLayout;
    }

    @Override
    public boolean storeDiscriminatorInShallowQueryCacheLayout() {
        return this.storeDiscriminatorInShallowQueryCacheLayout;
    }

    @Override
    public boolean hasFilterForLoadByKey() {
        if (this.filterHelper != null) {
            for (String filterName : this.filterHelper.getFilterNames()) {
                if (!this.factory.getFilterDefinition(filterName).isAppliedToLoadByKey()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterable<UniqueKeyEntry> uniqueKeyEntries() {
        if (this.uniqueKeyEntries == null) {
            this.uniqueKeyEntries = AbstractEntityPersister.initUniqueKeyEntries(this);
        }
        return this.uniqueKeyEntries;
    }

    private static List<UniqueKeyEntry> initUniqueKeyEntries(AbstractEntityPersister aep) {
        ArrayList<UniqueKeyEntry> uniqueKeys = new ArrayList<UniqueKeyEntry>();
        for (Type propertyType : aep.getPropertyTypes()) {
            ManyToOneType manyToOneType;
            Type type;
            int index;
            AttributeMapping attributeMapping;
            if (!(propertyType instanceof AssociationType)) continue;
            AssociationType associationType = (AssociationType)propertyType;
            String ukName = associationType.getLHSPropertyName();
            if (ukName != null) {
                attributeMapping = aep.findAttributeMapping(ukName);
                if (attributeMapping == null) continue;
                index = attributeMapping.getStateArrayPosition();
                type = aep.getPropertyTypes()[index];
                uniqueKeys.add(new UniqueKeyEntry(ukName, index, type));
                continue;
            }
            if (!(associationType instanceof ManyToOneType) || !(manyToOneType = (ManyToOneType)associationType).isLogicalOneToOne() || !manyToOneType.isReferenceToPrimaryKey() || (attributeMapping = aep.findAttributeMapping(manyToOneType.getPropertyName())) == null) continue;
            index = attributeMapping.getStateArrayPosition();
            type = aep.getPropertyTypes()[index];
            uniqueKeys.add(new UniqueKeyEntry(manyToOneType.getPropertyName(), index, type));
        }
        return CollectionHelper.toSmallList(uniqueKeys);
    }

    protected Map<String, SingleIdArrayLoadPlan> getLazyLoadPlanByFetchGroup() {
        BytecodeEnhancementMetadata metadata = this.getBytecodeEnhancementMetadata();
        return metadata.isEnhancedForLazyLoading() && metadata.getLazyAttributesMetadata().hasLazyAttributes() ? this.createLazyLoadPlanByFetchGroup(metadata) : Collections.emptyMap();
    }

    private Map<String, SingleIdArrayLoadPlan> createLazyLoadPlanByFetchGroup(BytecodeEnhancementMetadata metadata) {
        HashMap<String, SingleIdArrayLoadPlan> result = new HashMap<String, SingleIdArrayLoadPlan>();
        LazyAttributesMetadata attributesMetadata = metadata.getLazyAttributesMetadata();
        for (String groupName : attributesMetadata.getFetchGroupNames()) {
            SingleIdArrayLoadPlan loadPlan = this.createLazyLoadPlan(attributesMetadata.getFetchGroupAttributeDescriptors(groupName));
            if (loadPlan == null) continue;
            result.put(groupName, loadPlan);
        }
        return result;
    }

    private SingleIdArrayLoadPlan createLazyLoadPlan(List<LazyAttributeDescriptor> fetchGroupAttributeDescriptors) {
        ArrayList<ModelPart> partsToSelect = new ArrayList<ModelPart>(fetchGroupAttributeDescriptors.size());
        for (LazyAttributeDescriptor lazyAttributeDescriptor : fetchGroupAttributeDescriptors) {
            partsToSelect.add(this.getAttributeMapping(this.getSubclassPropertyIndex(lazyAttributeDescriptor.getName())));
        }
        return this.createLazyLoanPlan(partsToSelect);
    }

    private SingleIdArrayLoadPlan createLazyLoanPlan(List<ModelPart> partsToSelect) {
        if (partsToSelect.isEmpty()) {
            return null;
        }
        LockOptions lockOptions = new LockOptions();
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        SelectStatement select = LoaderSelectBuilder.createSelect((Loadable)this, partsToSelect, this.getIdentifierMapping(), null, 1, new LoadQueryInfluencers(this.factory), lockOptions, jdbcParametersBuilder::add, this.factory);
        return new SingleIdArrayLoadPlan(this, this.getIdentifierMapping(), select, jdbcParametersBuilder.build(), lockOptions, this.factory);
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        return ArrayHelper.contains(this.getSubclassTableNames(), tableExpression);
    }

    @Override
    public String getPartName() {
        return this.getEntityName();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        EntityResultImpl entityResult = new EntityResultImpl(navigablePath, this, tableGroup, resultVariable);
        entityResult.afterInitialize(entityResult, creationState);
        return entityResult;
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.identifierMapping.applySqlSelections(navigablePath.append(this.identifierMapping.getPartName()), tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.identifierMapping.applySqlSelections(navigablePath.append(this.identifierMapping.getPartName()), tableGroup, creationState, selectionConsumer);
    }

    @Override
    public NaturalIdMapping getNaturalIdMapping() {
        return this.naturalIdMapping;
    }

    @Override
    public TableReference createPrimaryTableReference(SqlAliasBase sqlAliasBase, SqlAstCreationState sqlAstCreationState) {
        return new NamedTableReference(this.getTableName(), sqlAliasBase.generateNewAlias());
    }

    @Override
    public TableReferenceJoin createTableReferenceJoin(String joinTableExpression, SqlAliasBase sqlAliasBase, TableReference lhs, SqlAstCreationState creationState) {
        for (int i = 1; i < this.getSubclassTableSpan(); ++i) {
            String subclassTableName = this.getSubclassTableName(i);
            if (!subclassTableName.equals(joinTableExpression)) continue;
            return this.generateTableReferenceJoin(lhs, joinTableExpression, sqlAliasBase, this.shouldInnerJoinSubclassTable(i, Collections.emptySet()), this.getSubclassTableKeyColumns(i), creationState);
        }
        return null;
    }

    protected TableReferenceJoin generateTableReferenceJoin(TableReference lhs, String joinTableExpression, SqlAliasBase sqlAliasBase, boolean innerJoin, String[] targetColumns, SqlAstCreationState creationState) {
        NamedTableReference joinedTableReference = new NamedTableReference(joinTableExpression, sqlAliasBase.generateNewAlias(), !innerJoin);
        return new TableReferenceJoin(innerJoin, joinedTableReference, this.generateJoinPredicate(lhs, joinedTableReference, this.getIdentifierColumnNames(), targetColumns, creationState));
    }

    protected Predicate generateJoinPredicate(TableReference rootTableReference, TableReference joinedTableReference, String[] pkColumnNames, String[] fkColumnNames, SqlAstCreationState creationState) {
        EntityIdentifierMapping identifierMapping = this.getIdentifierMapping();
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        assert (pkColumnNames.length == fkColumnNames.length);
        assert (pkColumnNames.length == identifierMapping.getJdbcTypeCount());
        identifierMapping.forEachSelectable((columnIndex, selection) -> {
            SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
            String rootPkColumnName = pkColumnNames[columnIndex];
            Expression pkColumnExpression = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(rootTableReference, rootPkColumnName, selection.getJdbcMapping()), sqlAstProcessingState -> new ColumnReference(rootTableReference.getIdentificationVariable(), rootPkColumnName, false, null, selection.getJdbcMapping()));
            String fkColumnName = fkColumnNames[columnIndex];
            Expression fkColumnExpression = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(joinedTableReference, fkColumnName, selection.getJdbcMapping()), sqlAstProcessingState -> new ColumnReference(joinedTableReference.getIdentificationVariable(), fkColumnName, false, null, selection.getJdbcMapping()));
            conjunction.add(new ComparisonPredicate(pkColumnExpression, ComparisonOperator.EQUAL, fkColumnExpression));
        });
        return conjunction;
    }

    @Override
    public Object initializeLazyProperty(String fieldName, Object entity, SharedSessionContractImplementor session) {
        PersistentCollection<?> persistentCollection;
        Type type;
        if (this.hasCollections() && (type = this.getPropertyType(fieldName)) instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            persistentCollection = this.initializedLazyCollection(fieldName, entity, collectionType, session);
        } else {
            persistentCollection = this.initializedLazyField(fieldName, entity, session);
        }
        return persistentCollection;
    }

    private Object initializedLazyField(String fieldName, Object entity, SharedSessionContractImplementor session) {
        CacheEntry cacheEntry;
        Object initializedValue;
        EntityDataAccess cacheAccess;
        Object cacheKey;
        Object ce;
        Object id = session.getContextEntityIdentifier(entity);
        EntityEntry entry = session.getPersistenceContext().getEntry(entity);
        if (entry == null) {
            throw new HibernateException("entity is not associated with the session: " + String.valueOf(id));
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Initializing lazy properties of: {0}, field access: {1}", (Object)MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), (Object)fieldName);
        }
        if (session.getCacheMode().isGetEnabled() && this.canReadFromCache() && this.isLazyPropertiesCacheable() && (ce = CacheHelper.fromSharedCache(session, cacheKey = (cacheAccess = this.getCacheAccessStrategy()).generateCacheKey(id, this, session.getFactory(), session.getTenantIdentifier()), this, (CachedDomainDataAccess)cacheAccess)) != null && (initializedValue = this.initializeLazyPropertiesFromCache(fieldName, entity, session, entry, cacheEntry = (CacheEntry)this.getCacheEntryStructure().destructure(ce, this.factory))) != LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            return initializedValue;
        }
        return this.initializeLazyPropertiesFromDatastore(entity, id, entry, fieldName, session);
    }

    private PersistentCollection<?> initializedLazyCollection(String fieldName, Object entity, CollectionType collectionType, SharedSessionContractImplementor session) {
        EntityEntry ownerEntry;
        CollectionPersister persister = this.factory.getMappingMetamodel().getCollectionDescriptor(collectionType.getRole());
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        Object key = AbstractEntityPersister.getCollectionKey(persister, entity, entry, session);
        assert (key != null);
        PersistentCollection<?> collection = persistenceContext.getCollection(new CollectionKey(persister, key));
        if (collection == null) {
            collection = collectionType.instantiate(session, persister, key);
            collection.setOwner(entity);
            persistenceContext.addUninitializedCollection(persister, collection, key);
        }
        PersistentAttributeInterceptor interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor();
        assert (interceptor != null) : "Expecting bytecode interceptor to be non-null";
        interceptor.attributeInitialized(fieldName);
        if (collectionType.isArrayType()) {
            persistenceContext.addCollectionHolder(collection);
        }
        if ((ownerEntry = persistenceContext.getEntry(entity)) == null) {
            throw new LazyInitializationException("Could not locate EntityEntry for the collection owner in the PersistenceContext");
        }
        ownerEntry.overwriteLoadedStateCollectionValue(fieldName, collection);
        return collection;
    }

    public static @Nullable Object getCollectionKey(CollectionPersister persister, Object owner, EntityEntry ownerEntry, SharedSessionContractImplementor session) {
        CollectionType collectionType = persister.getCollectionType();
        if (ownerEntry != null) {
            return collectionType.getKeyOfOwner(owner, session);
        }
        EntityPersister ownerPersister = persister.getOwnerEntityPersister();
        return collectionType.getLHSPropertyName() == null ? ownerPersister.getIdentifier(owner, session) : ownerPersister.getPropertyValue(owner, collectionType.getLHSPropertyName());
    }

    protected Object initializeLazyPropertiesFromDatastore(Object entity, Object id, EntityEntry entry, String fieldName, SharedSessionContractImplementor session) {
        return this.isNonLazyPropertyName(fieldName) ? this.initLazyProperty(entity, id, entry, fieldName, session) : this.initLazyProperties(entity, id, entry, fieldName, session);
    }

    protected boolean isNonLazyPropertyName(String fieldName) {
        return this.nonLazyPropertyNames.contains(fieldName);
    }

    private Object initLazyProperties(Object entity, Object id, EntityEntry entry, String fieldName, SharedSessionContractImplementor session) {
        assert (this.hasLazyProperties());
        LOG.tracef("Initializing lazy properties from datastore (triggered for '%s')", (Object)fieldName);
        PersistentAttributeInterceptor interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor();
        assert (interceptor != null) : "Expecting bytecode interceptor to be non-null";
        Set<String> initializedLazyAttributeNames = interceptor.getInitializedLazyAttributeNames();
        LazyAttributesMetadata lazyAttributesMetadata = this.getBytecodeEnhancementMetadata().getLazyAttributesMetadata();
        String fetchGroup = lazyAttributesMetadata.getFetchGroupName(fieldName);
        List<LazyAttributeDescriptor> fetchGroupAttributeDescriptors = lazyAttributesMetadata.getFetchGroupAttributeDescriptors(fetchGroup);
        SingleIdArrayLoadPlan lazySelect = this.getSQLLazySelectLoadPlan(fetchGroup);
        try {
            Object finalResult = null;
            Object[] results = (Object[])lazySelect.load(id, session);
            int i = 0;
            for (LazyAttributeDescriptor fetchGroupAttributeDescriptor : fetchGroupAttributeDescriptors) {
                Object result;
                String attributeName = fetchGroupAttributeDescriptor.getName();
                boolean previousInitialized = initializedLazyAttributeNames.contains(attributeName);
                if (previousInitialized) {
                    ++i;
                    continue;
                }
                if (!this.initializeLazyProperty(fieldName, entity, entry, fetchGroupAttributeDescriptor, result = results[i++])) continue;
                finalResult = result;
                interceptor.attributeInitialized(attributeName);
            }
            LOG.trace("Done initializing lazy properties");
            return finalResult;
        }
        catch (JDBCException ex) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(ex.getSQLException(), "could not initialize lazy properties: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), ex.getSQL());
        }
    }

    private Object initLazyProperty(Object entity, Object id, EntityEntry entry, String fieldName, SharedSessionContractImplementor session) {
        int propertyIndex = this.getPropertyIndex(fieldName);
        List<ModelPart> partsToSelect = List.of(this.getAttributeMapping(propertyIndex));
        SingleIdArrayLoadPlan lazyLoanPlan = this.getOrCreateLazyLoadPlan(fieldName, partsToSelect);
        try {
            Object[] results = (Object[])lazyLoanPlan.load(id, session);
            Object result = results[0];
            this.initializeLazyProperty(entity, entry, result, propertyIndex, this.getPropertyTypes()[propertyIndex]);
            return result;
        }
        catch (JDBCException ex) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(ex.getSQLException(), "could not initialize lazy properties: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), ex.getSQL());
        }
    }

    private SingleIdArrayLoadPlan getOrCreateLazyLoadPlan(String fieldName, List<ModelPart> partsToSelect) {
        ConcurrentHashMap<String, SingleIdArrayLoadPlan> propertyLoadPlansByName = this.nonLazyPropertyLoadPlansByName;
        if (propertyLoadPlansByName == null) {
            propertyLoadPlansByName = new ConcurrentHashMap();
            SingleIdArrayLoadPlan newLazyLoanPlan = this.createLazyLoanPlan(partsToSelect);
            propertyLoadPlansByName.put(fieldName, newLazyLoanPlan);
            this.nonLazyPropertyLoadPlansByName = propertyLoadPlansByName;
            return newLazyLoanPlan;
        }
        SingleIdArrayLoadPlan lazyLoanPlan = this.nonLazyPropertyLoadPlansByName.get(fieldName);
        if (lazyLoanPlan == null) {
            SingleIdArrayLoadPlan newLazyLoanPlan = this.createLazyLoanPlan(partsToSelect);
            this.nonLazyPropertyLoadPlansByName.put(fieldName, newLazyLoanPlan);
            return newLazyLoanPlan;
        }
        return lazyLoanPlan;
    }

    protected Object initializeLazyPropertiesFromCache(String fieldName, Object entity, SharedSessionContractImplementor session, EntityEntry entry, CacheEntry cacheEntry) {
        LOG.trace("Initializing lazy properties from second-level cache");
        Object result = null;
        Serializable[] disassembledValues = cacheEntry.getDisassembledState();
        for (int j = 0; j < this.lazyPropertyNames.length; ++j) {
            Serializable cachedValue = disassembledValues[this.lazyPropertyNumbers[j]];
            Type lazyPropertyType = this.lazyPropertyTypes[j];
            String propertyName = this.lazyPropertyNames[j];
            if (cachedValue == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                if (!fieldName.equals(propertyName)) continue;
                result = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                continue;
            }
            Object propValue = lazyPropertyType.assemble(cachedValue, session, entity);
            if (!this.initializeLazyProperty(fieldName, entity, entry, j, propValue)) continue;
            result = propValue;
        }
        LOG.trace("Done initializing lazy properties");
        return result;
    }

    protected boolean initializeLazyProperty(String fieldName, Object entity, EntityEntry entry, int index, Object propValue) {
        this.setPropertyValue(entity, this.lazyPropertyNumbers[index], propValue);
        if (entry.getLoadedState() != null) {
            entry.getLoadedState()[this.lazyPropertyNumbers[index]] = this.lazyPropertyTypes[index].deepCopy(propValue, this.factory);
        }
        if (entry.getDeletedState() != null) {
            entry.getDeletedState()[this.lazyPropertyNumbers[index]] = this.lazyPropertyTypes[index].deepCopy(propValue, this.factory);
        }
        return fieldName.equals(this.lazyPropertyNames[index]);
    }

    protected boolean initializeLazyProperty(String fieldName, Object entity, EntityEntry entry, LazyAttributeDescriptor fetchGroupAttributeDescriptor, Object propValue) {
        String name = fetchGroupAttributeDescriptor.getName();
        this.initializeLazyProperty(entity, entry, propValue, this.getPropertyIndex(name), fetchGroupAttributeDescriptor.getType());
        return fieldName.equals(name);
    }

    protected void initializeLazyProperty(Object entity, EntityEntry entry, Object propValue, int index, Type type) {
        Object[] deletedState;
        this.setPropertyValue(entity, index, propValue);
        Object[] loadedState = entry.getLoadedState();
        if (loadedState != null) {
            loadedState[index] = type.deepCopy(propValue, this.factory);
        }
        if ((deletedState = entry.getDeletedState()) != null) {
            deletedState[index] = type.deepCopy(propValue, this.factory);
        }
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Serializable[] getQuerySpaces() {
        return this.getPropertySpaces();
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public String[] getIdentifierColumnNames() {
        return this.rootTableKeyColumnNames;
    }

    public String[] getIdentifierColumnReaders() {
        return this.rootTableKeyColumnReaders;
    }

    public String[] getIdentifierColumnReaderTemplates() {
        return this.rootTableKeyColumnReaderTemplates;
    }

    public int getIdentifierColumnSpan() {
        return this.identifierColumnSpan;
    }

    public String[] getIdentifierAliases() {
        return this.identifierAliases;
    }

    @Override
    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    public String getVersionedTableName() {
        return this.getTableName(0);
    }

    @Override
    public boolean isCacheInvalidationRequired() {
        return this.invalidateCache;
    }

    @Override
    public boolean isLazyPropertiesCacheable() {
        return this.isLazyPropertiesCacheable;
    }

    @Override
    public String selectFragment(String alias, String suffix) {
        NonAggregatedIdentifierMapping nonAggregatedIdentifierMapping;
        EntityRowIdMapping selectableMapping;
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), new LockOptions(), this::fetchProcessor, true, new LoadQueryInfluencers(this.factory), this.factory.getSqlTranslationEngine());
        NavigablePath entityPath = new NavigablePath(this.getRootPathName());
        TableGroup rootTableGroup = this.createRootTableGroup(true, entityPath, null, new SqlAliasBaseConstant(alias), () -> p -> {}, sqlAstCreationState);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        this.createDomainResult(entityPath, rootTableGroup, null, sqlAstCreationState);
        SelectClause selectClause = rootQuerySpec.getSelectClause();
        List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        HashSet<String> processedExpressions = new HashSet<String>(sqlSelections.size());
        int i = 0;
        int identifierSelectionSize = this.identifierMapping.getJdbcTypeCount();
        for (int j = 0; j < identifierSelectionSize; ++j) {
            SelectableMapping selectableMapping2 = this.identifierMapping.getSelectable(j);
            if (!processedExpressions.add(selectableMapping2.getSelectionExpression())) continue;
            AbstractEntityPersister.aliasSelection(sqlSelections, i, this.identifierAliases[j] + suffix);
            ++i;
        }
        if (this.hasSubclasses()) {
            assert (this.discriminatorMapping.getJdbcTypeCount() == 1);
            SelectableMapping selectableMapping3 = this.discriminatorMapping.getSelectable(0);
            if (processedExpressions.add(selectableMapping3.getSelectionExpression())) {
                AbstractEntityPersister.aliasSelection(sqlSelections, i, this.getDiscriminatorAlias() + suffix);
                ++i;
            }
        }
        if (this.hasRowId() && processedExpressions.add((selectableMapping = this.rowIdMapping).getSelectionExpression())) {
            AbstractEntityPersister.aliasSelection(sqlSelections, i, ROWID_ALIAS + suffix);
            ++i;
        }
        String[] columnAliases = this.getSubclassColumnAliasClosure();
        String[] formulaAliases = this.getSubclassFormulaAliasClosure();
        int columnIndex = 0;
        int formulaIndex = 0;
        int size = this.getNumberOfFetchables();
        EntityIdentifierMapping entityIdentifierMapping = this.identifierMapping;
        if (entityIdentifierMapping instanceof NonAggregatedIdentifierMapping && (nonAggregatedIdentifierMapping = (NonAggregatedIdentifierMapping)entityIdentifierMapping).getIdClassEmbeddable() != null) {
            columnIndex = identifierSelectionSize;
        }
        for (int j = 0; j < size; ++j) {
            AttributeMapping fetchable = this.getFetchable(j);
            if (fetchable instanceof PluralAttributeMapping || this.skipFetchable(fetchable, fetchable.getMappedFetchOptions().getTiming()) || !fetchable.isSelectable()) continue;
            int jdbcTypeCount = fetchable.getJdbcTypeCount();
            for (int k = 0; k < jdbcTypeCount; ++k) {
                SelectableMapping selectableMapping4 = fetchable.getSelectable(k);
                if (!processedExpressions.add(selectableMapping4.getSelectionExpression())) continue;
                String baseAlias = selectableMapping4.isFormula() ? formulaAliases[formulaIndex++] : columnAliases[columnIndex++];
                AbstractEntityPersister.aliasSelection(sqlSelections, i, baseAlias + suffix);
                ++i;
            }
        }
        String sql = this.getDialect().getSqlAstTranslatorFactory().buildSelectTranslator(this.getFactory(), new SelectStatement(rootQuerySpec)).translate(null, QueryOptions.NONE).getSqlString();
        int fromIndex = sql.lastIndexOf(" from");
        return fromIndex != -1 ? sql.substring("select ".length(), fromIndex) : sql.substring("select ".length());
    }

    private static void aliasSelection(List<SqlSelection> sqlSelections, int selectionIndex, String alias) {
        Expression expression = sqlSelections.get(selectionIndex).getExpression();
        sqlSelections.set(selectionIndex, new SqlSelectionImpl(selectionIndex, new AliasedExpression(expression, alias)));
    }

    private ImmutableFetchList fetchProcessor(FetchParent fetchParent, LoaderSqlAstCreationState creationState) {
        FetchableContainer fetchableContainer = fetchParent.getReferencedMappingContainer();
        int size = fetchableContainer.getNumberOfFetchables();
        ImmutableFetchList.Builder fetches = new ImmutableFetchList.Builder(fetchableContainer);
        for (int i = 0; i < size; ++i) {
            FetchTiming fetchTiming;
            Fetchable fetchable = fetchableContainer.getFetchable(i);
            if (fetchable instanceof PluralAttributeMapping || this.skipFetchable(fetchable, fetchTiming = fetchable.getMappedFetchOptions().getTiming())) continue;
            if (fetchTiming == null) {
                throw new AssertionFailure("fetchTiming was null");
            }
            if (!fetchable.isSelectable()) continue;
            Fetch fetch = fetchParent.generateFetchableFetch(fetchable, fetchParent.resolveNavigablePath(fetchable), fetchTiming, false, null, creationState);
            fetches.add(fetch);
        }
        return fetches.build();
    }

    private boolean skipFetchable(Fetchable fetchable, FetchTiming fetchTiming) {
        if (fetchable.asBasicValuedModelPart() != null) {
            return fetchTiming == FetchTiming.DELAYED;
        }
        if (fetchable instanceof Association) {
            Association association = (Association)fetchable;
            return association.getSideNature() == ForeignKeyDescriptor.Nature.TARGET || !this.getRootTableName().equals(association.getForeignKeyDescriptor().getKeyTable());
        }
        return false;
    }

    @Override
    public String[] getIdentifierAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.getIdentifierAliases());
    }

    @Override
    public String[] getPropertyAliases(String suffix, int i) {
        return new Alias(suffix).toUnquotedAliasStrings(this.propertyColumnAliases[i]);
    }

    @Override
    public String getDiscriminatorAlias(String suffix) {
        return this.entityMetamodel.hasSubclasses() ? new Alias(suffix).toAliasString(this.getDiscriminatorAlias()) : null;
    }

    @Override
    public Object[] getDatabaseSnapshot(Object id, SharedSessionContractImplementor session) throws HibernateException {
        return this.singleIdLoader.loadDatabaseSnapshot(id, session);
    }

    @Override
    public Object getIdByUniqueKey(Object key, String uniquePropertyName, SharedSessionContractImplementor session) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("resolving unique key [%s] to identifier for entity [%s]", key, (Object)this.getEntityName());
        }
        return this.getUniqueKeyLoader(uniquePropertyName, session).resolveId(key, session);
    }

    public String generateSelectVersionString() {
        SimpleSelect select = new SimpleSelect(this.getFactory()).setTableName(this.getVersionedTableName());
        if (this.isVersioned()) {
            select.addColumn(this.getVersionColumnName(), VERSION_COLUMN_ALIAS);
        } else {
            select.addColumns(this.rootTableKeyColumnNames);
        }
        if (this.getFactory().getSessionFactoryOptions().isCommentsEnabled()) {
            select.setComment("get version " + this.getEntityName());
        }
        return select.addRestriction(this.rootTableKeyColumnNames).toStatementString();
    }

    protected GeneratedValuesProcessor createGeneratedValuesProcessor(EventType timing, List<AttributeMapping> generatedAttributes) {
        return new GeneratedValuesProcessor(this, generatedAttributes, timing, this.getFactory());
    }

    @Override
    public Object forceVersionIncrement(Object id, Object currentVersion, SharedSessionContractImplementor session) {
        assert (this.getMappedTableDetails().getTableName().equals(this.getVersionedTableName()));
        Object nextVersion = this.calculateNextVersion(id, currentVersion, session);
        this.updateCoordinator.forceVersionIncrement(id, currentVersion, nextVersion, session);
        return nextVersion;
    }

    @Override
    public Object forceVersionIncrement(Object id, Object currentVersion, boolean batching, SharedSessionContractImplementor session) throws HibernateException {
        assert (this.getMappedTableDetails().getTableName().equals(this.getVersionedTableName()));
        Object nextVersion = this.calculateNextVersion(id, currentVersion, session);
        this.updateCoordinator.forceVersionIncrement(id, currentVersion, nextVersion, batching, session);
        return nextVersion;
    }

    private Object calculateNextVersion(Object id, Object currentVersion, SharedSessionContractImplementor session) {
        assert (this.isVersioned());
        Object nextVersion = this.generatorForForceIncrement().generate(session, null, currentVersion, EventType.FORCE_INCREMENT);
        if (LOG.isTraceEnabled()) {
            BasicType<?> versionType = this.getVersionType();
            LOG.trace("Forcing version increment [" + MessageHelper.infoString((EntityPersister)this, id, this.factory) + "; " + versionType.toLoggableString(currentVersion, this.factory) + " -> " + versionType.toLoggableString(nextVersion, this.factory) + "]");
        }
        return nextVersion;
    }

    private BeforeExecutionGenerator generatorForForceIncrement() {
        BeforeExecutionGenerator generator;
        Generator generator2 = this.versionPropertyGenerator();
        if (generator2 instanceof BeforeExecutionGenerator && (generator = (BeforeExecutionGenerator)generator2).generatesOnForceIncrement()) {
            return generator;
        }
        if (this.isVersionGeneratedOnExecution()) {
            throw new HibernateException("Force-increment lock not supported for '@Version' property with OnExecutionGenerator");
        }
        BeforeExecutionGenerator generator3 = this.getVersionGenerator();
        if (!generator3.generatesOnForceIncrement()) {
            throw new HibernateException("Force-increment lock not supported for '@Version' generator");
        }
        return generator3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getCurrentVersion(Object id, SharedSessionContractImplementor session) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Getting version: {0}", (Object)MessageHelper.infoString((EntityPersister)this, id, this.getFactory()));
        }
        String versionSelectString = this.getVersionSelectString();
        try {
            JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
            PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(versionSelectString);
            try {
                ResultSet rs;
                block14: {
                    block13: {
                        this.getIdentifierType().nullSafeSet(st, id, 1, session);
                        rs = jdbcCoordinator.getResultSetReturn().extract(st, versionSelectString);
                        try {
                            if (rs.next()) break block13;
                            Object var7_8 = null;
                            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                            return var7_8;
                        }
                        catch (Throwable throwable) {
                            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                            throw throwable;
                        }
                    }
                    if (this.isVersioned()) break block14;
                    AbstractEntityPersister abstractEntityPersister = this;
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    return abstractEntityPersister;
                }
                Object obj = this.getVersionMapping().getJdbcMapping().getJdbcValueExtractor().extract(rs, 1, (WrapperOptions)session);
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                return obj;
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "could not retrieve version: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), versionSelectString);
        }
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.getIdentifierMapping().getJdbcMapping(index);
    }

    protected LockingStrategy generateLocker(LockMode lockMode, Locking.Scope lockScope) {
        return this.getDialect().getLockingStrategy(this, lockMode, lockScope);
    }

    private LockingStrategy getLocker(LockMode lockMode, Locking.Scope lockScope) {
        return lockScope != Locking.Scope.ROOT_ONLY ? this.generateLocker(lockMode, lockScope) : this.lockers.computeIfAbsent(lockMode, l -> this.generateLocker(lockMode, lockScope));
    }

    @Override
    public void lock(Object id, Object version, Object object, LockMode lockMode, SharedSessionContractImplementor session) throws HibernateException {
        this.getLocker(lockMode, Locking.Scope.ROOT_ONLY).lock(id, version, object, Timeouts.WAIT_FOREVER, session);
    }

    @Override
    public void lock(Object id, Object version, Object object, LockMode lockMode, EventSource session) {
        this.lock(id, version, object, lockMode, (SharedSessionContractImplementor)session);
    }

    @Override
    public void lock(Object id, Object version, Object object, LockOptions lockOptions, SharedSessionContractImplementor session) throws HibernateException {
        this.getLocker(lockOptions.getLockMode(), lockOptions.getScope()).lock(id, version, object, lockOptions.getTimeout(), session);
    }

    @Override
    public void lock(Object id, Object version, Object object, LockOptions lockOptions, EventSource session) {
        this.lock(id, version, object, lockOptions, (SharedSessionContractImplementor)session);
    }

    @Override
    public String getRootTableName() {
        return this.getSubclassTableName(0);
    }

    @Override
    public String[] getRootTableIdentifierColumnNames() {
        return this.getRootTableKeyColumnNames();
    }

    @Override
    public String[] toColumns(String propertyName) throws QueryException {
        return this.propertyMapping.getColumnNames(propertyName);
    }

    @Override
    public String[] getPropertyColumnNames(String propertyName) {
        return this.propertyMapping.getColumnNames(propertyName);
    }

    @Override
    public DiscriminatorType<?> getDiscriminatorDomainType() {
        if (this.discriminatorDomainType == null) {
            this.discriminatorDomainType = this.buildDiscriminatorType();
        }
        return this.discriminatorDomainType;
    }

    private DiscriminatorType<?> buildDiscriminatorType() {
        Type underlyingJdbcMapping = this.getDiscriminatorType();
        return underlyingJdbcMapping == null ? null : new DiscriminatorTypeImpl((BasicType<?>)underlyingJdbcMapping, new UnifiedAnyDiscriminatorConverter(this.getNavigableRole().append("{discriminator}"), this.factory.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(this.discriminatedType()), underlyingJdbcMapping.getRelationalJavaType(), this.getSubclassByDiscriminatorValue(), null, this.factory.getMappingMetamodel()));
    }

    private Class<?> discriminatedType() {
        return this.representationStrategy.getMode() == RepresentationMode.POJO && this.getEntityName().equals(this.getJavaType().getJavaTypeClass().getName()) ? Class.class : String.class;
    }

    public static String generateTableAlias(String rootAlias, int tableNumber) {
        if (tableNumber == 0) {
            return rootAlias;
        }
        StringBuilder alias = new StringBuilder().append(rootAlias);
        if (!rootAlias.endsWith("_")) {
            alias.append('_');
        }
        return alias.append(tableNumber).append('_').toString();
    }

    private int getSubclassPropertyIndex(String propertyName) {
        return ArrayHelper.indexOf(this.subclassPropertyNameClosure, propertyName);
    }

    public String[] getPropertyColumnNames(int i) {
        return this.propertyColumnNames[i];
    }

    public boolean hasFormulaProperties() {
        return this.hasFormulaProperties;
    }

    public FetchMode getFetchMode(int i) {
        return this.subclassPropertyFetchModeClosure[i];
    }

    public Type getSubclassPropertyType(int i) {
        return this.subclassPropertyTypeClosure[i];
    }

    @Override
    public int countSubclassProperties() {
        return this.subclassPropertyTypeClosure.length;
    }

    @Override
    public String[] getSubclassPropertyColumnNames(int i) {
        return this.subclassPropertyColumnNameClosure[i];
    }

    public String[][] getSubclassPropertyFormulaTemplateClosure() {
        return this.subclassPropertyFormulaTemplateClosure;
    }

    protected Type[] getSubclassPropertyTypeClosure() {
        return this.subclassPropertyTypeClosure;
    }

    protected String[][] getSubclassPropertyColumnNameClosure() {
        return this.subclassPropertyColumnNameClosure;
    }

    public String[][] getSubclassPropertyColumnReaderClosure() {
        return this.subclassPropertyColumnReaderClosure;
    }

    public String[][] getSubclassPropertyColumnReaderTemplateClosure() {
        return this.subclassPropertyColumnReaderTemplateClosure;
    }

    protected String[] getSubclassPropertyNameClosure() {
        return this.subclassPropertyNameClosure;
    }

    private static boolean isPrefix(AttributeMapping attributeMapping, String currentAttributeName) {
        String attributeName = attributeMapping.getAttributeName();
        int nameLength = attributeName.length();
        return currentAttributeName.startsWith(attributeName) && (currentAttributeName.length() == nameLength || currentAttributeName.charAt(nameLength) == '.');
    }

    @Override
    public int[] resolveAttributeIndexes(String[] attributeNames) {
        if (attributeNames == null || attributeNames.length == 0) {
            return ArrayHelper.EMPTY_INT_ARRAY;
        }
        ArrayList<Integer> fields = new ArrayList<Integer>(attributeNames.length);
        Arrays.sort(attributeNames);
        int index = 0;
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            if (!AbstractEntityPersister.isPrefix(attributeMapping, attributeNames[index])) continue;
            fields.add(attributeMapping.getStateArrayPosition());
            if (++index >= attributeNames.length) break;
            while (attributeNames[index].equals(attributeMapping.getAttributeName()) && ++index < attributeNames.length) {
            }
        }
        return ArrayHelper.toIntArray(fields);
    }

    @Override
    public int[] resolveDirtyAttributeIndexes(Object[] currentState, Object[] previousState, String[] attributeNames, SessionImplementor session) {
        ArrayList<Integer> fields;
        block11: {
            int i;
            BitSet mutablePropertiesIndexes = this.entityMetamodel.getMutablePropertiesIndexes();
            int estimatedSize = attributeNames == null ? 0 : attributeNames.length + mutablePropertiesIndexes.cardinality();
            fields = new ArrayList<Integer>(estimatedSize);
            if (estimatedSize == 0) {
                return ArrayHelper.EMPTY_INT_ARRAY;
            }
            if (!mutablePropertiesIndexes.isEmpty()) {
                Type[] propertyTypes = this.entityMetamodel.getPropertyTypes();
                boolean[] propertyCheckability = this.entityMetamodel.getPropertyCheckability();
                i = mutablePropertiesIndexes.nextSetBit(0);
                while (i >= 0) {
                    if (this.isDirty(currentState, previousState, propertyTypes, propertyCheckability, i, session)) {
                        fields.add(i);
                    }
                    i = mutablePropertiesIndexes.nextSetBit(i + 1);
                }
            }
            if (attributeNames.length == 0) break block11;
            boolean[] propertyUpdateability = this.entityMetamodel.getPropertyUpdateability();
            if (this.superMappingType == null) {
                Arrays.sort(attributeNames);
                int index = 0;
                for (i = 0; i < this.attributeMappings.size(); ++i) {
                    AttributeMapping attributeMapping = this.attributeMappings.get(i);
                    String attributeName = attributeMapping.getAttributeName();
                    if (!AbstractEntityPersister.isPrefix(attributeMapping, attributeNames[index])) continue;
                    int position = attributeMapping.getStateArrayPosition();
                    if (propertyUpdateability[position] && !fields.contains(position)) {
                        fields.add(position);
                    }
                    if (++index < attributeNames.length) {
                        while (attributeNames[index].equals(attributeName) && ++index < attributeNames.length) {
                        }
                        continue;
                    }
                    break;
                }
            } else {
                for (String attributeName : attributeNames) {
                    Integer index = this.entityMetamodel.getPropertyIndexOrNull(attributeName);
                    if (index == null || !propertyUpdateability[index] || fields.contains(index)) continue;
                    fields.add(index);
                }
            }
        }
        return ArrayHelper.toIntArray(fields);
    }

    private boolean isDirty(Object[] currentState, Object[] previousState, Type[] propertyTypes, boolean[] propertyCheckability, int i, SessionImplementor session) {
        return currentState[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && (previousState == null || previousState[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || propertyCheckability[i] && propertyTypes[i].isDirty(previousState[i], currentState[i], this.propertyColumnUpdateable[i], session));
    }

    @Override
    public Object loadByUniqueKey(String propertyName, Object uniqueKey, SharedSessionContractImplementor session) throws HibernateException {
        return this.loadByUniqueKey(propertyName, uniqueKey, null, session);
    }

    public Object loadByUniqueKey(String propertyName, Object uniqueKey, Boolean readOnly, SharedSessionContractImplementor session) throws HibernateException {
        return this.getUniqueKeyLoader(propertyName, session).load(uniqueKey, new LockOptions(), readOnly, session);
    }

    protected SingleUniqueKeyEntityLoader<?> getUniqueKeyLoader(String attributeName, SharedSessionContractImplementor session) {
        SingleUniqueKeyEntityLoader<?> existing;
        SingularAttributeMapping attribute = (SingularAttributeMapping)this.findByPath(attributeName);
        LoadQueryInfluencers influencers = session.getLoadQueryInfluencers();
        if (this.isAffectedByInfluencers(influencers, true)) {
            return new SingleUniqueKeyEntityLoaderStandard(this, attribute, influencers);
        }
        if (this.uniqueKeyLoadersNew == null) {
            this.uniqueKeyLoadersNew = new ConcurrentHashMap();
            existing = null;
        } else {
            existing = this.uniqueKeyLoadersNew.get(attribute);
        }
        if (existing != null) {
            return existing;
        }
        SingleUniqueKeyEntityLoaderStandard loader = new SingleUniqueKeyEntityLoaderStandard(this, attribute, new LoadQueryInfluencers(this.factory));
        this.uniqueKeyLoadersNew.put(attribute, loader);
        return loader;
    }

    @Override
    public int getPropertyIndex(String propertyName) {
        return this.entityMetamodel.getPropertyIndex(propertyName);
    }

    private void initOrdinaryPropertyPaths(Metadata mapping) throws MappingException {
        for (int i = 0; i < this.getSubclassPropertyNameClosure().length; ++i) {
            this.propertyMapping.initPropertyPaths(this.getSubclassPropertyNameClosure()[i], this.getSubclassPropertyTypeClosure()[i], this.getSubclassPropertyColumnNameClosure()[i], this.getSubclassPropertyColumnReaderClosure()[i], this.getSubclassPropertyColumnReaderTemplateClosure()[i], this.getSubclassPropertyFormulaTemplateClosure()[i], mapping);
        }
    }

    private void initIdentifierPropertyPaths(Metadata mapping) throws MappingException {
        String idProp = this.getIdentifierPropertyName();
        if (idProp != null) {
            this.propertyMapping.initPropertyPaths(idProp, this.getIdentifierType(), this.getIdentifierColumnNames(), this.getIdentifierColumnReaders(), this.getIdentifierColumnReaderTemplates(), null, mapping);
        }
        if (this.entityMetamodel.getIdentifierProperty().isEmbedded()) {
            this.propertyMapping.initPropertyPaths(null, this.getIdentifierType(), this.getIdentifierColumnNames(), this.getIdentifierColumnReaders(), this.getIdentifierColumnReaderTemplates(), null, mapping);
        }
        if (!this.entityMetamodel.hasNonIdentifierPropertyNamedId()) {
            this.propertyMapping.initPropertyPaths("id", this.getIdentifierType(), this.getIdentifierColumnNames(), this.getIdentifierColumnReaders(), this.getIdentifierColumnReaderTemplates(), null, mapping);
        }
    }

    private void initDiscriminatorPropertyPath(Metadata mapping) {
        this.propertyMapping.initPropertyPaths(ENTITY_CLASS, this.getDiscriminatorType(), new String[]{this.getDiscriminatorColumnName()}, new String[]{this.getDiscriminatorColumnReaders()}, new String[]{this.getDiscriminatorColumnReaderTemplate()}, new String[]{this.getDiscriminatorFormulaTemplate()}, mapping);
    }

    protected void initPropertyPaths(Metadata mapping) throws MappingException {
        this.initOrdinaryPropertyPaths(mapping);
        this.initOrdinaryPropertyPaths(mapping);
        this.initIdentifierPropertyPaths(mapping);
        if (this.entityMetamodel.isPolymorphic()) {
            this.initDiscriminatorPropertyPath(mapping);
        }
    }

    @Override
    public String getIdentitySelectString() {
        return this.identitySelectString;
    }

    @Override
    public String getSelectByUniqueKeyString(String propertyName) {
        return this.getSelectByUniqueKeyString(new String[]{propertyName});
    }

    @Override
    public String getSelectByUniqueKeyString(String[] propertyNames) {
        SimpleSelect select = new SimpleSelect(this.getFactory()).setTableName(this.getTableName(0)).addColumns(this.getKeyColumns(0));
        for (String propertyName : propertyNames) {
            select.addRestriction(this.getPropertyColumnNames(propertyName));
        }
        return select.toStatementString();
    }

    @Override
    public String getSelectByUniqueKeyString(String[] propertyNames, String[] columnNames) {
        SimpleSelect select = new SimpleSelect(this.getFactory()).setTableName(this.getTableName(0)).addColumns(columnNames);
        for (String propertyName : propertyNames) {
            select.addRestriction(this.getPropertyColumnNames(propertyName));
        }
        return select.toStatementString();
    }

    @Override
    public GeneratedValuesMutationDelegate getInsertDelegate() {
        return this.insertDelegate;
    }

    @Override
    public GeneratedValuesMutationDelegate getUpdateDelegate() {
        return this.updateDelegate;
    }

    @Override
    public EntityTableMapping[] getTableMappings() {
        return this.tableMappings;
    }

    protected EntityTableMapping getTableMapping(int i) {
        return this.tableMappings[i];
    }

    @Override
    public String physicalTableNameForMutation(SelectableMapping selectableMapping) {
        assert (!selectableMapping.isFormula());
        return selectableMapping.getContainingTableExpression();
    }

    @Override
    public EntityMappingType getTargetPart() {
        return this;
    }

    @Override
    public void forEachMutableTable(Consumer<EntityTableMapping> consumer) {
        for (int i = 0; i < this.tableMappings.length; ++i) {
            if (this.tableMappings[i].isInverse()) continue;
            consumer.accept(this.tableMappings[i]);
        }
    }

    @Override
    public void forEachMutableTableReverse(Consumer<EntityTableMapping> consumer) {
        for (int i = this.tableMappings.length - 1; i >= 0; --i) {
            if (this.tableMappings[i].isInverse()) continue;
            consumer.accept(this.tableMappings[i]);
        }
    }

    @Override
    public String getIdentifierTableName() {
        return this.getTableName(0);
    }

    @Override
    public EntityTableMapping getIdentifierTableMapping() {
        return this.tableMappings[0];
    }

    @Override
    public ModelPart getIdentifierDescriptor() {
        return this.identifierMapping;
    }

    protected void logStaticSQL() {
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
            MutationOperationGroup staticDeleteGroup;
            MutationOperationGroup staticUpdateGroup;
            JdbcOperation jdbcOperation;
            MutationOperation mutation;
            MutationOperationGroup staticInsertGroup;
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Static SQL for entity: %s", (Object)this.getEntityName());
            for (Map.Entry<String, SingleIdArrayLoadPlan> entry : this.lazyLoadPlanByFetchGroup.entrySet()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef(" Lazy select (%s) : %s", (Object)entry.getKey(), (Object)entry.getValue().getJdbcSelect().getSqlString());
            }
            if (this.sqlVersionSelectString != null) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef(" Version select: %s", (Object)this.sqlVersionSelectString);
            }
            if ((staticInsertGroup = this.insertCoordinator.getStaticMutationOperationGroup()) != null) {
                for (int i = 0; i < staticInsertGroup.getNumberOfOperations(); ++i) {
                    mutation = staticInsertGroup.getOperation(i);
                    if (!(mutation instanceof JdbcOperation)) continue;
                    jdbcOperation = (JdbcOperation)((Object)mutation);
                    ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef(" Insert (%s): %s", i, (Object)jdbcOperation.getSqlString());
                }
            }
            if ((staticUpdateGroup = this.updateCoordinator.getStaticMutationOperationGroup()) != null) {
                for (int i = 0; i < staticUpdateGroup.getNumberOfOperations(); ++i) {
                    mutation = staticUpdateGroup.getOperation(i);
                    if (!(mutation instanceof JdbcOperation)) continue;
                    jdbcOperation = (JdbcOperation)((Object)mutation);
                    ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef(" Update (%s): %s", i, (Object)jdbcOperation.getSqlString());
                }
            }
            if ((staticDeleteGroup = this.deleteCoordinator.getStaticMutationOperationGroup()) != null) {
                for (int i = 0; i < staticDeleteGroup.getNumberOfOperations(); ++i) {
                    mutation = staticDeleteGroup.getOperation(i);
                    if (!(mutation instanceof JdbcOperation)) continue;
                    jdbcOperation = (JdbcOperation)((Object)mutation);
                    ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef(" Delete (%s): %s", i, (Object)jdbcOperation.getSqlString());
                }
            }
        }
    }

    public abstract Map<Object, String> getSubclassByDiscriminatorValue();

    public abstract String[] getConstraintOrderedTableNameClosure();

    public abstract boolean needsDiscriminator();

    protected boolean isDiscriminatorFormula() {
        return false;
    }

    @Override
    public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationState creationState) {
        SqlAliasBase sqlAliasBase = SqlAliasBase.from(explicitSqlAliasBase, explicitSourceAlias, this, creationState.getSqlAliasBaseGenerator());
        NamedTableReference rootTableReference = new NamedTableReference(this.needsDiscriminator() ? this.getRootTableName() : this.getTableName(), sqlAliasBase.generateNewAlias());
        StandardTableGroup tableGroup = new StandardTableGroup(canUseInnerJoins, navigablePath, this, explicitSourceAlias, rootTableReference, true, sqlAliasBase, this.getRootEntityDescriptor()::containsTableReference, (tableExpression, tg) -> {
            String[] subclassTableNames = this.getSubclassTableNames();
            for (int i = 0; i < subclassTableNames.length; ++i) {
                if (!tableExpression.equals(subclassTableNames[i])) continue;
                NamedTableReference joinedTableReference = new NamedTableReference((String)tableExpression, sqlAliasBase.generateNewAlias(), this.isNullableSubclassTable(i));
                return new TableReferenceJoin(this.shouldInnerJoinSubclassTable(i, Collections.emptySet()), joinedTableReference, additionalPredicateCollectorAccess == null ? null : this.generateJoinPredicate(rootTableReference, joinedTableReference, this.needsDiscriminator() ? this.getRootTableKeyColumnNames() : this.getIdentifierColumnNames(), this.getSubclassTableKeyColumns(i), creationState));
            }
            return null;
        }, this.getFactory());
        if (additionalPredicateCollectorAccess != null) {
            if (this.needsDiscriminator()) {
                String alias = tableGroup.getPrimaryTableReference().getIdentificationVariable();
                Predicate discriminatorPredicate = this.createDiscriminatorPredicate(alias, tableGroup, creationState);
                additionalPredicateCollectorAccess.get().accept(discriminatorPredicate);
            }
            if (this.softDeleteMapping != null) {
                TableReference tableReference = tableGroup.resolveTableReference(this.getSoftDeleteTableDetails().getTableName());
                Predicate softDeletePredicate = this.softDeleteMapping.createNonDeletedRestriction(tableReference, creationState.getSqlExpressionResolver());
                additionalPredicateCollectorAccess.get().accept(softDeletePredicate);
                if (tableReference != rootTableReference && creationState.supportsEntityNameUsage()) {
                    creationState.registerEntityNameUsage(tableGroup, EntityNameUse.EXPRESSION, this.getRootEntityName());
                }
            }
        }
        return tableGroup;
    }

    @Override
    public void applyDiscriminator(Consumer<Predicate> predicateConsumer, String alias, TableGroup tableGroup, SqlAstCreationState creationState) {
        if (this.needsDiscriminator()) {
            assert (!creationState.supportsEntityNameUsage()) : "Entity name usage should have been used instead";
            Collection<EntityMappingType> subMappingTypes = this.getSubMappingTypes();
            HashMap<String, EntityNameUse> entityNameUseMap = new HashMap<String, EntityNameUse>(1 + subMappingTypes.size() + (this.isInherited() ? 1 : 0));
            if (subMappingTypes.isEmpty()) {
                entityNameUseMap.put(this.getEntityName(), EntityNameUse.TREAT);
            } else {
                entityNameUseMap.put(this.getEntityName(), EntityNameUse.TREAT);
                for (EntityMappingType subMappingType : subMappingTypes) {
                    entityNameUseMap.put(subMappingType.getEntityName(), EntityNameUse.TREAT);
                }
            }
            if (this.isInherited()) {
                tableGroup.resolveTableReference(this.getRootTableName());
                entityNameUseMap.put(this.getRootEntityName(), EntityNameUse.EXPRESSION);
            }
            this.pruneForSubclasses(tableGroup, entityNameUseMap);
        }
    }

    private Predicate createDiscriminatorPredicate(String alias, TableGroup tableGroup, SqlAstCreationState creationState) {
        SqlExpressionResolver.ColumnReferenceKey columnReferenceKey;
        String discriminatorExpression;
        if (this.isDiscriminatorFormula()) {
            discriminatorExpression = this.getDiscriminatorFormulaTemplate();
            columnReferenceKey = SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.getDiscriminatorFormulaTemplate(), (JdbcMapping)((Object)this.getDiscriminatorType()));
        } else {
            discriminatorExpression = this.getDiscriminatorColumnName();
            columnReferenceKey = SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.getDiscriminatorColumnName(), (JdbcMapping)((Object)this.getDiscriminatorType()));
        }
        BasicType discriminatorType = (BasicType)this.getDiscriminatorMapping().getJdbcMapping();
        Expression sqlExpression = creationState.getSqlExpressionResolver().resolveSqlExpression(columnReferenceKey, sqlAstProcessingState -> new ColumnReference(alias, discriminatorExpression, this.isDiscriminatorFormula(), null, discriminatorType.getJdbcMapping()));
        return this.createDisciminatorPredicate(discriminatorType, sqlExpression);
    }

    private Predicate createDisciminatorPredicate(BasicType<?> discriminatorType, Expression sqlExpression) {
        if (this.hasSubclasses()) {
            return this.createInListPredicate(discriminatorType, sqlExpression);
        }
        Object value = this.getDiscriminatorValue();
        if (value == DiscriminatorHelper.NULL_DISCRIMINATOR) {
            return new NullnessPredicate(sqlExpression);
        }
        if (value == DiscriminatorHelper.NOT_NULL_DISCRIMINATOR) {
            return new NullnessPredicate(sqlExpression, true);
        }
        return new ComparisonPredicate(sqlExpression, ComparisonOperator.EQUAL, new QueryLiteral<Object>(value, discriminatorType));
    }

    private Predicate createInListPredicate(BasicType<?> discriminatorType, Expression sqlExpression) {
        boolean hasNull = false;
        boolean hasNonNull = false;
        for (Object discriminatorValue : this.fullDiscriminatorValues) {
            if (discriminatorValue == DiscriminatorHelper.NULL_DISCRIMINATOR) {
                hasNull = true;
                continue;
            }
            if (discriminatorValue != DiscriminatorHelper.NOT_NULL_DISCRIMINATOR) continue;
            hasNonNull = true;
        }
        if (hasNull && hasNonNull) {
            return new Junction(Junction.Nature.DISJUNCTION);
        }
        if (hasNonNull) {
            return new NullnessPredicate(sqlExpression, true);
        }
        if (hasNull) {
            Junction junction = new Junction(Junction.Nature.DISJUNCTION);
            junction.add(new NullnessPredicate(sqlExpression));
            junction.add(this.discriminatorValuesPredicate(discriminatorType, sqlExpression));
            return junction;
        }
        return this.discriminatorValuesPredicate(discriminatorType, sqlExpression);
    }

    private InListPredicate discriminatorValuesPredicate(BasicType<?> discriminatorType, Expression sqlExpression) {
        ArrayList<Expression> values = new ArrayList<Expression>(this.fullDiscriminatorValues.length);
        for (Object discriminatorValue : this.fullDiscriminatorValues) {
            if (discriminatorValue instanceof MarkerObject) continue;
            values.add(new QueryLiteral<Object>(discriminatorValue, discriminatorType));
        }
        return new InListPredicate(sqlExpression, values);
    }

    protected String getPrunedDiscriminatorPredicate(Map<String, EntityNameUse> entityNameUses, MappingMetamodelImplementor mappingMetamodel, String alias) {
        InFragment fragment = new InFragment();
        if (this.isDiscriminatorFormula()) {
            fragment.setFormula(alias, this.getDiscriminatorFormulaTemplate());
        } else {
            fragment.setColumn(alias, this.getDiscriminatorColumnName());
        }
        boolean containsNotNull = false;
        for (Map.Entry<String, EntityNameUse> entry : entityNameUses.entrySet()) {
            EntityPersister persister;
            EntityNameUse.UseKind useKind = entry.getValue().getKind();
            if (useKind == EntityNameUse.UseKind.PROJECTION || useKind == EntityNameUse.UseKind.EXPRESSION || (persister = mappingMetamodel.getEntityDescriptor(entry.getKey())).isAbstract() || this != persister && this.isTypeOrSuperType(persister)) continue;
            containsNotNull = containsNotNull || "not null".equals(persister.getDiscriminatorSQLValue());
            fragment.addValue(persister.getDiscriminatorSQLValue());
        }
        AbstractEntityPersister rootEntityDescriptor = (AbstractEntityPersister)this.getRootEntityDescriptor();
        List<String> discriminatorSQLValues = Arrays.asList(rootEntityDescriptor.fullDiscriminatorSQLValues);
        if (fragment.getValues().size() == discriminatorSQLValues.size()) {
            return null;
        }
        if (containsNotNull) {
            String lhs = this.isDiscriminatorFormula() ? StringHelper.replace(this.getDiscriminatorFormulaTemplate(), "{@}", alias) : StringHelper.qualifyConditionally(alias, this.getDiscriminatorColumnName());
            ArrayList<String> actualDiscriminatorSQLValues = new ArrayList<String>(discriminatorSQLValues.size());
            for (String value : discriminatorSQLValues) {
                if (fragment.getValues().contains(value) || "null".equals(value)) continue;
                actualDiscriminatorSQLValues.add(value);
            }
            StringBuilder sb = new StringBuilder(70 + actualDiscriminatorSQLValues.size() * 10).append(" or ");
            if (!actualDiscriminatorSQLValues.isEmpty()) {
                sb.append(lhs).append(" is not in (");
                sb.append(String.join((CharSequence)",", actualDiscriminatorSQLValues));
                sb.append(") and ");
            }
            sb.append(lhs).append(" is not null");
            fragment.getValues().remove("not null");
            return fragment.toFragmentString() + String.valueOf(sb);
        }
        return fragment.toFragmentString();
    }

    @Override
    public void applyFilterRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, boolean onlyApplyLoadByKeyFilters, SqlAstCreationState creationState) {
        if (this.filterHelper != null) {
            FilterAliasGenerator filterAliasGenerator = useQualifier && tableGroup != null ? this.getFilterAliasGenerator(tableGroup) : null;
            this.filterHelper.applyEnabledFilters(predicateConsumer, filterAliasGenerator, enabledFilters, onlyApplyLoadByKeyFilters, tableGroup, creationState);
        }
    }

    @Override
    public void applyBaseRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, boolean onlyApplyLoadByKeyFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        this.applyFilterRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, onlyApplyLoadByKeyFilters, creationState);
        this.applyWhereRestrictions(predicateConsumer, tableGroup, useQualifier, creationState);
    }

    @Override
    public boolean hasWhereRestrictions() {
        return this.sqlWhereStringTemplate != null;
    }

    @Override
    public void applyWhereRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, SqlAstCreationState creationState) {
        if (this.sqlWhereStringTemplate != null) {
            String alias = this.getAliasInWhere(tableGroup, useQualifier);
            String fragment = StringHelper.replace(this.sqlWhereStringTemplate, "{@}", alias);
            predicateConsumer.accept(new SqlFragmentPredicate(fragment));
        }
    }

    private String getAliasInWhere(TableGroup tableGroup, boolean useQualifier) {
        if (tableGroup == null) {
            return null;
        }
        TableReference tableReference = tableGroup.resolveTableReference(this.sqlWhereStringTableExpression);
        if (tableReference == null) {
            return null;
        }
        return useQualifier && tableReference.getIdentificationVariable() != null ? tableReference.getIdentificationVariable() : tableReference.getTableId();
    }

    protected boolean shouldInnerJoinSubclassTable(int subclassTableNumber, Set<String> treatAsDeclarations) {
        if (this.isClassOrSuperclassJoin(subclassTableNumber)) {
            return !this.isInverseTable(subclassTableNumber) && !this.isNullableTable(subclassTableNumber);
        }
        return this.isSubclassTableIndicatedByTreatAsDeclarations(subclassTableNumber, treatAsDeclarations);
    }

    protected boolean isSubclassTableIndicatedByTreatAsDeclarations(int subclassTableNumber, Set<String> treatAsDeclarations) {
        return false;
    }

    protected void postConstruct(Metadata mapping) throws MappingException {
        this.initPropertyPaths(mapping);
    }

    @Override
    public void prepareLoaders() {
        this.singleIdLoader = this.buildSingleIdEntityLoader();
        this.multiIdLoader = this.buildMultiIdLoader();
        this.lazyLoadPlanByFetchGroup = this.getLazyLoadPlanByFetchGroup();
        this.logStaticSQL();
    }

    private void doLateInit() {
        this.tableMappings = this.buildTableMappings();
        List<AttributeMapping> insertGeneratedAttributes = this.hasInsertGeneratedProperties() ? GeneratedValuesProcessor.getGeneratedAttributes(this, EventType.INSERT) : Collections.emptyList();
        List<AttributeMapping> updateGeneratedAttributes = this.hasUpdateGeneratedProperties() ? GeneratedValuesProcessor.getGeneratedAttributes(this, EventType.UPDATE) : Collections.emptyList();
        this.insertGeneratedProperties = this.initInsertGeneratedProperties(insertGeneratedAttributes);
        this.updateGeneratedProperties = this.initUpdateGeneratedProperties(updateGeneratedAttributes);
        this.insertDelegate = this.createInsertDelegate();
        this.updateDelegate = this.createUpdateDelegate();
        if (this.isIdentifierAssignedByInsert()) {
            this.identitySelectString = this.getIdentitySelectString(this.getDialect());
        }
        if (this.hasInsertGeneratedProperties()) {
            this.insertGeneratedValuesProcessor = this.createGeneratedValuesProcessor(EventType.INSERT, insertGeneratedAttributes);
        }
        if (this.hasUpdateGeneratedProperties()) {
            this.updateGeneratedValuesProcessor = this.createGeneratedValuesProcessor(EventType.UPDATE, updateGeneratedAttributes);
        }
        this.insertCoordinator = this.buildInsertCoordinator();
        this.updateCoordinator = this.buildUpdateCoordinator();
        this.deleteCoordinator = this.buildDeleteCoordinator();
        this.mergeCoordinator = this.buildMergeCoordinator();
        this.sqlVersionSelectString = this.generateSelectVersionString();
    }

    protected GeneratedValuesMutationDelegate createInsertDelegate() {
        if (this.isIdentifierAssignedByInsert()) {
            OnExecutionGenerator generator = (OnExecutionGenerator)this.getGenerator();
            return generator.getGeneratedIdentifierDelegate(this);
        }
        return GeneratedValuesHelper.getGeneratedValuesDelegate(this, EventType.INSERT);
    }

    protected GeneratedValuesMutationDelegate createUpdateDelegate() {
        return GeneratedValuesHelper.getGeneratedValuesDelegate(this, EventType.UPDATE);
    }

    protected EntityTableMapping[] buildTableMappings() {
        LinkedHashMap tableBuilderMap = new LinkedHashMap();
        this.visitMutabilityOrderedTables((tableExpression, relativePosition, tableKeyColumnVisitationSupplier) -> {
            TableMappingBuilder tableMappingBuilder;
            TableMappingBuilder existing = (TableMappingBuilder)tableBuilderMap.get(tableExpression);
            boolean inverseTable = this.isInverseTable(relativePosition);
            if (existing == null) {
                ArrayList<EntityTableMapping.KeyColumn> keyColumns = new ArrayList<EntityTableMapping.KeyColumn>();
                ((Consumer)tableKeyColumnVisitationSupplier.get()).accept((selectionIndex, selectableMapping) -> keyColumns.add(new EntityTableMapping.KeyColumn(tableExpression, selectableMapping.getSelectionExpression(), selectableMapping.getWriteExpression(), selectableMapping.isFormula(), selectableMapping.getJdbcMapping())));
                boolean isIdentifierTable = this.isIdentifierTable(tableExpression);
                String customInsertSql = this.customSQLInsert[relativePosition] == null ? null : this.substituteBrackets(this.customSQLInsert[relativePosition]);
                String customUpdateSql = this.customSQLUpdate[relativePosition] == null ? null : this.substituteBrackets(this.customSQLUpdate[relativePosition]);
                String customDeleteSql = this.customSQLDelete[relativePosition] == null ? null : this.substituteBrackets(this.customSQLDelete[relativePosition]);
                tableMappingBuilder = new TableMappingBuilder(tableExpression, relativePosition, new EntityTableMapping.KeyMapping(keyColumns, this.identifierMapping), !isIdentifierTable && this.isNullableTable(relativePosition), inverseTable, isIdentifierTable, this.insertExpectations[relativePosition], customInsertSql, this.insertCallable[relativePosition], this.updateExpectations[relativePosition], customUpdateSql, this.updateCallable[relativePosition], this.isTableCascadeDeleteEnabled(relativePosition), this.deleteExpectations[relativePosition], customDeleteSql, this.deleteCallable[relativePosition], this.entityMetamodel.isDynamicUpdate(), this.entityMetamodel.isDynamicInsert());
                tableBuilderMap.put(tableExpression, tableMappingBuilder);
            } else {
                tableMappingBuilder = existing;
            }
            if (!inverseTable) {
                this.collectAttributesIndexesForTable(relativePosition, tableMappingBuilder.attributeIndexes::add);
            }
        });
        EntityTableMapping[] list = new EntityTableMapping[tableBuilderMap.size()];
        int i = 0;
        for (Map.Entry entry : tableBuilderMap.entrySet()) {
            list[i++] = ((TableMappingBuilder)entry.getValue()).build();
        }
        return list;
    }

    protected abstract void visitMutabilityOrderedTables(MutabilityOrderedTableConsumer var1);

    private void collectAttributesIndexesForTable(int naturalTableIndex, Consumer<Integer> indexConsumer) {
        this.forEachAttributeMapping((int attributeIndex, ? super AttributeMapping attributeMapping) -> {
            if (this.isPropertyOfTable(attributeIndex, naturalTableIndex)) {
                indexConsumer.accept(attributeIndex);
            }
        });
    }

    protected abstract boolean isIdentifierTable(String var1);

    protected InsertCoordinator buildInsertCoordinator() {
        return new InsertCoordinatorStandard(this, this.factory);
    }

    protected UpdateCoordinator buildUpdateCoordinator() {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            if (!(attributeMapping instanceof SingularAttributeMapping)) continue;
            return new UpdateCoordinatorStandard(this, this.factory);
        }
        return new UpdateCoordinatorNoOp(this);
    }

    protected UpdateCoordinator buildMergeCoordinator() {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            if (!(attributeMapping instanceof SingularAttributeMapping)) continue;
            return new MergeCoordinator(this, this.factory);
        }
        return new UpdateCoordinatorNoOp(this);
    }

    protected DeleteCoordinator buildDeleteCoordinator() {
        if (this.softDeleteMapping == null) {
            return new DeleteCoordinatorStandard(this, this.factory);
        }
        return new DeleteCoordinatorSoft(this, this.factory);
    }

    @Override
    public void addDiscriminatorToInsertGroup(MutationGroupBuilder insertGroupBuilder) {
    }

    @Override
    public void addSoftDeleteToInsertGroup(MutationGroupBuilder insertGroupBuilder) {
        if (this.softDeleteMapping != null) {
            TableInsertBuilder insertBuilder = (TableInsertBuilder)insertGroupBuilder.getTableDetailsBuilder(this.getIdentifierTableName());
            MutatingTableReference mutatingTable = insertBuilder.getMutatingTable();
            ColumnReference columnReference = new ColumnReference(mutatingTable, (SelectableMapping)this.softDeleteMapping);
            ColumnValueBinding nonDeletedValueBinding = this.softDeleteMapping.createNonDeletedValueBinding(columnReference);
            insertBuilder.addValueColumn(nonDeletedValueBinding);
        }
    }

    protected String substituteBrackets(String sql) {
        return new SQLQueryParser(sql, null, this.getFactory()).process();
    }

    @Override
    public final void postInstantiate() throws MappingException {
        this.doLateInit();
    }

    @Override
    public Object load(Object id, Object optionalObject, LockMode lockMode, SharedSessionContractImplementor session) {
        return this.load(id, optionalObject, lockMode.toLockOptions(), session);
    }

    @Override
    public Object load(Object id, Object optionalObject, LockOptions lockOptions, SharedSessionContractImplementor session) throws HibernateException {
        return this.doLoad(id, optionalObject, lockOptions, null, session);
    }

    @Override
    public Object load(Object id, Object optionalObject, LockOptions lockOptions, SharedSessionContractImplementor session, Boolean readOnly) throws HibernateException {
        return this.doLoad(id, optionalObject, lockOptions, readOnly, session);
    }

    private Object doLoad(Object id, Object optionalObject, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Fetching entity: {0}", (Object)MessageHelper.infoString((EntityPersister)this, id, this.getFactory()));
        }
        SingleIdEntityLoader<?> loader = this.determineLoaderToUse(session, lockOptions);
        return optionalObject == null ? loader.load(id, lockOptions, readOnly, session) : loader.load(id, optionalObject, lockOptions, readOnly, session);
    }

    protected SingleIdEntityLoader<?> determineLoaderToUse(SharedSessionContractImplementor session, LockOptions lockOptions) {
        if (this.hasNamedQueryLoader()) {
            return this.getSingleIdLoader();
        }
        LoadQueryInfluencers influencers = session.getLoadQueryInfluencers();
        if (this.isAffectedByInfluencers(influencers, true)) {
            return this.buildSingleIdEntityLoader(influencers, lockOptions);
        }
        return this.getSingleIdLoader();
    }

    private boolean hasNamedQueryLoader() {
        return this.queryLoaderName != null;
    }

    public SingleIdEntityLoader<?> getSingleIdLoader() {
        return this.singleIdLoader;
    }

    @Override
    public Object initializeEnhancedEntityUsedAsProxy(Object entity, String nameOfAttributeBeingAccessed, SharedSessionContractImplementor session) {
        BytecodeEnhancementMetadata enhancementMetadata = this.getBytecodeEnhancementMetadata();
        BytecodeLazyAttributeInterceptor bytecodeLazyAttributeInterceptor = enhancementMetadata.extractLazyInterceptor(entity);
        if (bytecodeLazyAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor) {
            EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)bytecodeLazyAttributeInterceptor;
            EntityKey entityKey = proxyInterceptor.getEntityKey();
            Object identifier = entityKey.getIdentifier();
            Object loaded = null;
            if (this.canReadFromCache && session.isEventSource()) {
                EventSource eventSource = (EventSource)session;
                loaded = eventSource.loadFromSecondLevelCache(this, entityKey, entity, LockMode.NONE);
            }
            if (loaded == null) {
                LockOptions lockOptions = new LockOptions();
                loaded = this.determineLoaderToUse(session, lockOptions).load(identifier, entity, lockOptions, session);
            }
            if (loaded == null) {
                PersistenceContext persistenceContext = session.getPersistenceContext();
                persistenceContext.removeEntry(entity);
                persistenceContext.removeEntity(entityKey);
                this.factory.getEntityNotFoundDelegate().handleEntityNotFound(entityKey.getEntityName(), identifier);
            }
            LazyAttributeLoadingInterceptor interceptor = enhancementMetadata.injectInterceptor(entity, identifier, session);
            if (nameOfAttributeBeingAccessed == null) {
                return null;
            }
            Object value = interceptor.isAttributeLoaded(nameOfAttributeBeingAccessed) ? this.getPropertyValue(entity, nameOfAttributeBeingAccessed) : this.initializeLazyProperty(nameOfAttributeBeingAccessed, entity, session);
            return interceptor.readObject(entity, nameOfAttributeBeingAccessed, value);
        }
        throw new IllegalStateException();
    }

    @Override
    public List<?> multiLoad(Object[] ids, EventSource session, MultiIdLoadOptions loadOptions) {
        return this.multiLoad(ids, (SharedSessionContractImplementor)session, loadOptions);
    }

    @Override
    public List<?> multiLoad(Object[] ids, SharedSessionContractImplementor session, MultiIdLoadOptions loadOptions) {
        return this.multiIdLoader.load(ids, loadOptions, session);
    }

    @Override
    public void registerAffectingFetchProfile(String fetchProfileName) {
        if (this.affectingFetchProfileNames == null) {
            this.affectingFetchProfileNames = new HashSet<String>();
        }
        this.affectingFetchProfileNames.add(fetchProfileName);
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers loadQueryInfluencers) {
        RootGraphImplementor<?> graph = loadQueryInfluencers.getEffectiveEntityGraph().getGraph();
        return graph != null && graph.appliesTo((EntityDomainType<?>)this.getFactory().getJpaMetamodel().entity(this.getEntityName()));
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers loadQueryInfluencers) {
        if (this.affectingFetchProfileNames != null && loadQueryInfluencers.hasEnabledFetchProfiles()) {
            for (String profileName : loadQueryInfluencers.getEnabledFetchProfileNames()) {
                if (!this.affectingFetchProfileNames.contains(profileName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers loadQueryInfluencers, boolean onlyApplyForLoadByKeyFilters) {
        if (this.filterHelper != null && loadQueryInfluencers.hasEnabledFilters()) {
            return this.filterHelper.isAffectedBy(loadQueryInfluencers.getEnabledFilters(), onlyApplyForLoadByKeyFilters) || this.isAffectedByEnabledFilters(new HashSet<ManagedMappingType>(), loadQueryInfluencers, onlyApplyForLoadByKeyFilters);
        }
        return false;
    }

    @Override
    public int[] findDirty(Object[] currentState, Object[] previousState, Object entity, SharedSessionContractImplementor session) throws HibernateException {
        int[] props = DirtyHelper.findDirty(this.entityMetamodel.getDirtyCheckablePropertyTypes(), currentState, previousState, this.propertyColumnUpdateable, session);
        if (props == null) {
            return null;
        }
        this.logDirtyProperties(props);
        return props;
    }

    @Override
    public int[] findModified(Object[] old, Object[] current, Object entity, SharedSessionContractImplementor session) throws HibernateException {
        int[] modified = DirtyHelper.findModified(this.entityMetamodel.getProperties(), current, old, this.propertyColumnUpdateable, this.getPropertyUpdateability(), session);
        if (modified == null) {
            return null;
        }
        this.logDirtyProperties(modified);
        return modified;
    }

    public boolean[] getPropertyUpdateability(Object entity) {
        return this.hasUninitializedLazyProperties(entity) ? this.getNonLazyPropertyUpdateability() : this.getPropertyUpdateability();
    }

    private void logDirtyProperties(int[] props) {
        if (LOG.isTraceEnabled()) {
            for (int prop : props) {
                String propertyName = this.getAttributeMapping(prop).getAttributeName();
                LOG.trace(StringHelper.qualify(this.getEntityName(), propertyName) + " is dirty");
            }
        }
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    private Dialect getDialect() {
        return this.factory.getJdbcServices().getDialect();
    }

    @Override
    public EntityMetamodel getEntityMetamodel() {
        return this.entityMetamodel;
    }

    @Override
    public boolean canReadFromCache() {
        return this.canReadFromCache;
    }

    @Override
    public boolean canWriteToCache() {
        return this.canWriteToCache;
    }

    @Override
    public boolean hasCache() {
        return this.canWriteToCache;
    }

    @Override
    public EntityDataAccess getCacheAccessStrategy() {
        return this.cacheAccessStrategy;
    }

    @Override
    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryHelper.getCacheEntryStructure();
    }

    @Override
    public CacheEntry buildCacheEntry(Object entity, Object[] state, Object version, SharedSessionContractImplementor session) {
        return this.cacheEntryHelper.buildCacheEntry(entity, state, version, session);
    }

    @Override
    public boolean hasNaturalIdCache() {
        return this.naturalIdRegionAccessStrategy != null;
    }

    @Override
    public NaturalIdDataAccess getNaturalIdCacheAccessStrategy() {
        return this.naturalIdRegionAccessStrategy;
    }

    @Override
    public final String getEntityName() {
        return this.entityMetamodel.getName();
    }

    @Override
    public @Nullable String getJpaEntityName() {
        return this.jpaEntityName;
    }

    @Override
    public boolean isInherited() {
        return this.entityMetamodel.isInherited();
    }

    @Override
    public boolean hasCascades() {
        return this.entityMetamodel.hasCascades();
    }

    @Override
    public boolean hasToOnes() {
        return this.entityMetamodel.hasToOnes();
    }

    @Override
    public boolean hasCascadePersist() {
        return this.entityMetamodel.hasCascadePersist();
    }

    @Override
    public boolean hasCascadeDelete() {
        return this.entityMetamodel.hasCascadeDelete();
    }

    @Override
    public boolean hasOwnedCollections() {
        return this.entityMetamodel.hasOwnedCollections();
    }

    @Override
    public boolean hasIdentifierProperty() {
        return !this.entityMetamodel.getIdentifierProperty().isVirtual();
    }

    @Override
    public BasicType<?> getVersionType() {
        VersionProperty versionProperty = this.entityMetamodel.getVersionProperty();
        return versionProperty == null ? null : (BasicType)versionProperty.getType();
    }

    @Override
    public int getVersionProperty() {
        return this.entityMetamodel.getVersionPropertyIndex();
    }

    @Override
    public boolean isVersioned() {
        return this.entityMetamodel.isVersioned();
    }

    @Override
    public boolean isIdentifierAssignedByInsert() {
        return this.entityMetamodel.getIdentifierProperty().isIdentifierAssignedByInsert();
    }

    @Override
    public boolean hasLazyProperties() {
        return this.entityMetamodel.hasLazyProperties();
    }

    @Override
    public void afterReassociate(Object entity, SharedSessionContractImplementor session) {
        BytecodeEnhancementMetadata metadata = this.getBytecodeEnhancementMetadata();
        if (metadata.isEnhancedForLazyLoading()) {
            BytecodeLazyAttributeInterceptor interceptor = metadata.extractLazyInterceptor(entity);
            if (interceptor == null) {
                metadata.injectInterceptor(entity, this.getIdentifier(entity, session), session);
            } else {
                interceptor.setSession(session);
            }
        }
        this.handleNaturalIdReattachment(entity, session);
    }

    private void handleNaturalIdReattachment(Object entity, SharedSessionContractImplementor session) {
        if (this.naturalIdMapping != null && this.naturalIdMapping.isMutable()) {
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            NaturalIdResolutions naturalIdResolutions = persistenceContext.getNaturalIdResolutions();
            Object id = this.getIdentifier(entity, session);
            Object[] entitySnapshot = persistenceContext.getDatabaseSnapshot(id, this);
            Object naturalIdSnapshot = this.naturalIdFromSnapshot(entitySnapshot);
            naturalIdResolutions.removeSharedResolution(id, naturalIdSnapshot, this, false);
            Object naturalId = this.naturalIdMapping.extractNaturalIdFromEntity(entity);
            naturalIdResolutions.manageLocalResolution(id, naturalId, this, CachedNaturalIdValueSource.UPDATE);
        }
    }

    private Object naturalIdFromSnapshot(Object[] entitySnapshot) {
        return entitySnapshot == PersistenceContext.NO_ROW ? null : this.naturalIdMapping.extractNaturalIdFromEntityState(entitySnapshot);
    }

    @Override
    public Boolean isTransient(Object entity, SharedSessionContractImplementor session) throws HibernateException {
        EntityDataAccess cache;
        Object ck;
        Object ce;
        Boolean result;
        Object id = this.getIdentifier(entity, session);
        if (id == null) {
            return true;
        }
        if (this.isVersioned()) {
            Object version = this.getVersion(entity);
            Boolean isUnsaved = this.versionMapping.getUnsavedStrategy().isUnsaved(version);
            if (isUnsaved != null) {
                if (isUnsaved.booleanValue()) {
                    Boolean unsaved;
                    EntityHolder holder;
                    PersistenceContext persistenceContext;
                    if (version == null && (persistenceContext = session.getPersistenceContext()).hasLoadContext() && !persistenceContext.getLoadContexts().isLoadingFinished() && (holder = persistenceContext.getEntityHolder(new EntityKey(id, this))) != null && holder.isEventuallyInitialized() && holder.getEntity() == entity) {
                        return false;
                    }
                    Generator identifierGenerator = this.getGenerator();
                    if (identifierGenerator != null && (unsaved = this.identifierMapping.getUnsavedStrategy().isUnsaved(id)) != null && !unsaved.booleanValue()) {
                        throw new PropertyValueException("Detached entity with generated id '" + String.valueOf(id) + "' has an uninitialized version value '" + String.valueOf(version) + "'", this.getEntityName(), this.getVersionColumnName());
                    }
                }
                return isUnsaved;
            }
        }
        if ((result = this.identifierMapping.getUnsavedStrategy().isUnsaved(id)) != null) {
            return result;
        }
        if (session.getCacheMode().isGetEnabled() && this.canReadFromCache() && (ce = CacheHelper.fromSharedCache(session, ck = (cache = this.getCacheAccessStrategy()).generateCacheKey(id, this, session.getFactory(), session.getTenantIdentifier()), this, (CachedDomainDataAccess)this.getCacheAccessStrategy())) != null) {
            return false;
        }
        return null;
    }

    @Override
    public boolean hasCollections() {
        return this.entityMetamodel.hasCollections();
    }

    @Override
    public boolean hasMutableProperties() {
        return this.entityMetamodel.hasMutableProperties();
    }

    @Override
    public boolean isMutable() {
        return this.entityMetamodel.isMutable();
    }

    @Override
    public boolean isAbstract() {
        return this.entityMetamodel.isAbstract();
    }

    @Override
    public boolean hasSubclasses() {
        return this.entityMetamodel.hasSubclasses();
    }

    @Override
    public boolean hasProxy() {
        return this.entityMetamodel.isLazy() && !this.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    @Override
    @Deprecated
    public IdentifierGenerator getIdentifierGenerator() throws HibernateException {
        return this.entityMetamodel.getIdentifierProperty().getIdentifierGenerator();
    }

    @Override
    public Generator getGenerator() {
        return this.entityMetamodel.getIdentifierProperty().getGenerator();
    }

    @Override
    public BeforeExecutionGenerator getVersionGenerator() {
        return this.versionGenerator;
    }

    @Override
    public String getRootEntityName() {
        return this.entityMetamodel.getRootName();
    }

    @Override
    public String getMappedSuperclass() {
        return this.entityMetamodel.getSuperclass();
    }

    @Override
    public boolean isExplicitPolymorphism() {
        return this.entityMetamodel.isExplicitPolymorphism();
    }

    @Override
    public boolean isConcreteProxy() {
        return this.concreteProxy;
    }

    @Override
    public EntityMappingType resolveConcreteProxyTypeForId(Object id, SharedSessionContractImplementor session) {
        if (!this.concreteProxy) {
            return this;
        }
        EntityConcreteTypeLoader concreteTypeLoader = this.concreteTypeLoader;
        if (concreteTypeLoader == null) {
            this.concreteTypeLoader = concreteTypeLoader = new EntityConcreteTypeLoader(this, session.getFactory());
        }
        return concreteTypeLoader.getConcreteType(id, session);
    }

    @Override
    @Deprecated
    public Type getPropertyType(String propertyName) throws MappingException {
        return this.propertyMapping.toType(propertyName);
    }

    @Override
    public boolean isSelectBeforeUpdateRequired() {
        return this.entityMetamodel.isSelectBeforeUpdate();
    }

    @Override
    public final OptimisticLockStyle optimisticLockStyle() {
        return this.entityMetamodel.getOptimisticLockStyle();
    }

    @Override
    public Object createProxy(Object id, SharedSessionContractImplementor session) throws HibernateException {
        return this.representationStrategy.getProxyFactory().getProxy(id, session);
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + "(" + this.entityMetamodel.getName() + ")";
    }

    @Override
    public boolean isInstrumented() {
        return this.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    @Override
    public boolean hasInsertGeneratedProperties() {
        return this.entityMetamodel.hasInsertGeneratedValues();
    }

    @Override
    public boolean hasUpdateGeneratedProperties() {
        return this.entityMetamodel.hasUpdateGeneratedValues();
    }

    @Override
    public boolean isVersionPropertyGenerated() {
        return this.isVersioned() && (this.isVersionGeneratedOnExecution() || this.isVersionGeneratedBeforeExecution());
    }

    private Generator versionPropertyGenerator() {
        return this.getEntityMetamodel().getGenerators()[this.getVersionProperty()];
    }

    public boolean isVersionGeneratedOnExecution() {
        Generator strategy = this.versionPropertyGenerator();
        return strategy != null && strategy.generatesSometimes() && strategy.generatedOnExecution();
    }

    public boolean isVersionGeneratedBeforeExecution() {
        Generator strategy = this.versionPropertyGenerator();
        return strategy != null && strategy.generatesSometimes() && !strategy.generatedOnExecution();
    }

    @Override
    public void afterInitialize(Object entity, SharedSessionContractImplementor session) {
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity) && this.getRepresentationStrategy().getMode() == RepresentationMode.POJO) {
            BytecodeLazyAttributeInterceptor interceptor = this.getBytecodeEnhancementMetadata().extractLazyInterceptor(entity);
            assert (interceptor != null);
            if (interceptor.getLinkedSession() == null) {
                interceptor.setSession(session);
            }
        }
    }

    @Override
    public String[] getPropertyNames() {
        return this.entityMetamodel.getPropertyNames();
    }

    @Override
    public Type[] getPropertyTypes() {
        return this.entityMetamodel.getPropertyTypes();
    }

    @Override
    public boolean[] getPropertyLaziness() {
        return this.entityMetamodel.getPropertyLaziness();
    }

    @Override
    public boolean[] getPropertyUpdateability() {
        return this.entityMetamodel.getPropertyUpdateability();
    }

    @Override
    public boolean[] getPropertyCheckability() {
        return this.entityMetamodel.getPropertyCheckability();
    }

    @Override
    public boolean[] getNonLazyPropertyUpdateability() {
        return this.entityMetamodel.getNonlazyPropertyUpdateability();
    }

    @Override
    public boolean[] getPropertyInsertability() {
        return this.entityMetamodel.getPropertyInsertability();
    }

    @Override
    public boolean[] getPropertyNullability() {
        return this.entityMetamodel.getPropertyNullability();
    }

    @Override
    public boolean[] getPropertyVersionability() {
        return this.entityMetamodel.getPropertyVersionability();
    }

    @Override
    public CascadeStyle[] getPropertyCascadeStyles() {
        return this.entityMetamodel.getCascadeStyles();
    }

    @Override
    public boolean isPropertySelectable(int propertyNumber) {
        return this.getAttributeMapping(propertyNumber).getAttributeMetadata().isSelectable();
    }

    @Override
    public final Class<?> getMappedClass() {
        return this.getMappedJavaType().getJavaTypeClass();
    }

    @Override
    public Class<?> getConcreteProxyClass() {
        JavaType<?> proxyJavaType = this.getRepresentationStrategy().getProxyJavaType();
        return proxyJavaType != null ? proxyJavaType.getJavaTypeClass() : this.javaType.getJavaTypeClass();
    }

    @Override
    public void setPropertyValues(Object object, Object[] values) {
        if (this.accessOptimizer != null) {
            this.accessOptimizer.setPropertyValues(object, values);
        } else {
            AttributeMappingsList attributeMappings = this.getAttributeMappings();
            if (this.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
                for (int i = 0; i < attributeMappings.size(); ++i) {
                    Object value = values[i];
                    if (value == UNFETCHED_PROPERTY) continue;
                    this.setterCache[i].set(object, value);
                }
            } else {
                for (int i = 0; i < attributeMappings.size(); ++i) {
                    this.setterCache[i].set(object, values[i]);
                }
            }
        }
    }

    @Override
    public void setPropertyValue(Object object, int i, Object value) {
        this.setterCache[i].set(object, value);
    }

    @Override
    public Object[] getPropertyValues(Object object) {
        if (this.accessOptimizer != null) {
            return this.accessOptimizer.getPropertyValues(object);
        }
        BytecodeEnhancementMetadata enhancementMetadata = this.getBytecodeEnhancementMetadata();
        AttributeMappingsList attributeMappings = this.getAttributeMappings();
        Object[] values = new Object[attributeMappings.size()];
        if (enhancementMetadata.isEnhancedForLazyLoading()) {
            LazyAttributesMetadata lazyAttributesMetadata = enhancementMetadata.getLazyAttributesMetadata();
            for (int i = 0; i < attributeMappings.size(); ++i) {
                AttributeMapping attributeMapping = attributeMappings.get(i);
                values[i] = !lazyAttributesMetadata.isLazyAttribute(attributeMapping.getAttributeName()) || enhancementMetadata.isAttributeLoaded(object, attributeMapping.getAttributeName()) ? this.getterCache[i].get(object) : LazyPropertyInitializer.UNFETCHED_PROPERTY;
            }
        } else {
            for (int i = 0; i < attributeMappings.size(); ++i) {
                values[i] = this.getterCache[i].get(object);
            }
        }
        return values;
    }

    @Override
    public Object getPropertyValue(Object object, int i) {
        return this.getterCache[i].get(object);
    }

    @Override
    public Object getPropertyValue(Object object, String propertyName) {
        int dotIndex = propertyName.indexOf(46);
        String basePropertyName = dotIndex == -1 ? propertyName : propertyName.substring(0, dotIndex);
        AttributeMapping attributeMapping = this.findAttributeMapping(basePropertyName);
        ManagedMappingType baseValueType = null;
        Object baseValue = null;
        if (attributeMapping != null) {
            baseValue = this.getterCache[attributeMapping.getStateArrayPosition()].get(object);
            if (dotIndex != -1) {
                baseValueType = (ManagedMappingType)attributeMapping.getMappedType();
            }
        } else {
            NonAggregatedIdentifierMapping nonAggregatedIdentifierMapping;
            AttributeMapping mapping;
            EntityIdentifierMapping entityIdentifierMapping = this.identifierMapping;
            if (entityIdentifierMapping instanceof NonAggregatedIdentifierMapping && (mapping = (nonAggregatedIdentifierMapping = (NonAggregatedIdentifierMapping)entityIdentifierMapping).findSubPart(propertyName, null).asAttributeMapping()) != null) {
                baseValue = mapping.getValue(object);
                if (dotIndex != -1) {
                    baseValueType = (ManagedMappingType)mapping.getMappedType();
                }
            }
        }
        return this.getPropertyValue(baseValue, baseValueType, propertyName, dotIndex);
    }

    private Object getPropertyValue(Object baseValue, ManagedMappingType baseValueType, String propertyName, int dotIndex) {
        if (baseValueType == null) {
            return baseValue;
        }
        int nextDotIndex = propertyName.indexOf(46, dotIndex + 1);
        int endIndex = nextDotIndex == -1 ? propertyName.length() : nextDotIndex;
        AttributeMapping attributeMapping = baseValueType.findAttributeMapping(propertyName.substring(dotIndex + 1, endIndex));
        baseValue = attributeMapping.getValue(baseValue);
        baseValueType = nextDotIndex == -1 ? null : (ManagedMappingType)attributeMapping.getMappedType();
        return this.getPropertyValue(baseValue, baseValueType, propertyName, nextDotIndex);
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        return this.identifierMapping.getIdentifier(entity);
    }

    @Override
    public Object getIdentifier(Object entity, MergeContext mergeContext) {
        return this.identifierMapping.getIdentifier(entity, mergeContext);
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        this.identifierMapping.setIdentifier(entity, id, session);
    }

    @Override
    public Object getVersion(Object object) {
        return this.getVersionMapping() == null ? null : this.getVersionMapping().getVersionAttribute().getPropertyAccess().getGetter().get(object);
    }

    @Override
    public Object instantiate(Object id, SharedSessionContractImplementor session) {
        Object instance = this.getRepresentationStrategy().getInstantiator().instantiate();
        this.linkToSession(instance, session);
        if (id != null) {
            this.setIdentifier(instance, id, session);
        }
        return instance;
    }

    protected void linkToSession(Object entity, SharedSessionContractImplementor session) {
        if (session != null) {
            ManagedTypeHelper.processIfPersistentAttributeInterceptable(entity, this::setSession, session);
        }
    }

    private void setSession(PersistentAttributeInterceptable entity, SharedSessionContractImplementor session) {
        BytecodeLazyAttributeInterceptor interceptor = this.getBytecodeEnhancementMetadata().extractLazyInterceptor(entity);
        if (interceptor != null) {
            interceptor.setSession(session);
        }
    }

    @Override
    public boolean isInstance(Object object) {
        return this.getRepresentationStrategy().getInstantiator().isInstance(object);
    }

    @Override
    public boolean hasUninitializedLazyProperties(Object object) {
        return this.getBytecodeEnhancementMetadata().hasUnFetchedAttributes(object);
    }

    @Override
    public void resetIdentifier(Object entity, Object currentId, Object currentVersion, SharedSessionContractImplementor session) {
        if (!this.getGenerator().allowAssignedIdentifiers()) {
            Object defaultIdentifier = this.identifierMapping.getUnsavedStrategy().getDefaultValue(currentId);
            this.setIdentifier(entity, defaultIdentifier, session);
        }
        if (this.versionMapping != null) {
            Object defaultVersion = this.versionMapping.getUnsavedStrategy().getDefaultValue(currentVersion);
            this.versionMapping.getVersionAttribute().getPropertyAccess().getSetter().set(entity, defaultVersion);
        }
    }

    @Override
    public EntityPersister getSubclassEntityPersister(Object instance, SessionFactoryImplementor factory) {
        if (instance != null && this.hasSubclasses() && !this.getRepresentationStrategy().getInstantiator().isSameClass(instance)) {
            for (EntityMappingType subclassMappingType : this.subclassMappingTypes.values()) {
                EntityPersister persister = subclassMappingType.getEntityPersister();
                if (!persister.getRepresentationStrategy().getInstantiator().isSameClass(instance)) continue;
                return persister;
            }
        }
        return this;
    }

    @Override
    public boolean hasMultipleTables() {
        return false;
    }

    public int getPropertySpan() {
        return this.entityMetamodel.getPropertySpan();
    }

    @Override
    public Object[] getPropertyValuesToInsert(Object entity, Map<Object, Object> mergeMap, SharedSessionContractImplementor session) throws HibernateException {
        if (this.shouldGetAllProperties(entity) && this.accessOptimizer != null) {
            return this.accessOptimizer.getPropertyValues(entity);
        }
        Object[] result = new Object[this.attributeMappings.size()];
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            result[i] = this.getterCache[i].getForInsert(entity, mergeMap, session);
        }
        return result;
    }

    protected boolean shouldGetAllProperties(Object entity) {
        BytecodeEnhancementMetadata metadata = this.getBytecodeEnhancementMetadata();
        return !metadata.isEnhancedForLazyLoading() || !metadata.hasUnFetchedAttributes(entity);
    }

    @Override
    public void processInsertGeneratedProperties(Object id, Object entity, Object[] state, GeneratedValues generatedValues, SharedSessionContractImplementor session) {
        if (this.insertGeneratedValuesProcessor == null) {
            throw new UnsupportedOperationException("Entity has no insert-generated properties - '" + this.getEntityName() + "'");
        }
        this.insertGeneratedValuesProcessor.processGeneratedValues(entity, id, state, generatedValues, session);
    }

    protected List<? extends ModelPart> initInsertGeneratedProperties(List<AttributeMapping> generatedAttributes) {
        int originalSize = generatedAttributes.size();
        ArrayList<AttributeMapping> generatedBasicAttributes = new ArrayList<AttributeMapping>(originalSize);
        for (AttributeMapping generatedAttribute : generatedAttributes) {
            if (generatedAttribute.asBasicValuedModelPart() == null || !generatedAttribute.getContainingTableExpression().equals(this.getRootTableName())) continue;
            generatedBasicAttributes.add(generatedAttribute);
        }
        List identifierList = this.isIdentifierAssignedByInsert() ? List.of(this.getIdentifierMapping()) : Collections.emptyList();
        return originalSize > 0 && generatedBasicAttributes.size() == originalSize ? Collections.unmodifiableList(CollectionHelper.combine(identifierList, generatedBasicAttributes)) : identifierList;
    }

    @Override
    public List<? extends ModelPart> getInsertGeneratedProperties() {
        return this.insertGeneratedProperties;
    }

    @Override
    public void processUpdateGeneratedProperties(Object id, Object entity, Object[] state, GeneratedValues generatedValues, SharedSessionContractImplementor session) {
        if (this.updateGeneratedValuesProcessor == null) {
            throw new AssertionFailure("Entity has no update-generated properties - '" + this.getEntityName() + "'");
        }
        this.updateGeneratedValuesProcessor.processGeneratedValues(entity, id, state, generatedValues, session);
    }

    protected List<? extends ModelPart> initUpdateGeneratedProperties(List<AttributeMapping> generatedAttributes) {
        int originalSize = generatedAttributes.size();
        ArrayList<AttributeMapping> generatedBasicAttributes = new ArrayList<AttributeMapping>(originalSize);
        for (AttributeMapping generatedAttribute : generatedAttributes) {
            SelectableMapping selectableMapping;
            if (!(generatedAttribute instanceof SelectableMapping) || !(selectableMapping = (SelectableMapping)((Object)generatedAttribute)).getContainingTableExpression().equals(this.getSubclassTableName(0))) continue;
            generatedBasicAttributes.add(generatedAttribute);
        }
        return generatedBasicAttributes.size() == originalSize ? Collections.unmodifiableList(generatedBasicAttributes) : Collections.emptyList();
    }

    @Override
    public List<? extends ModelPart> getUpdateGeneratedProperties() {
        return this.updateGeneratedProperties;
    }

    @Override
    public String getIdentifierPropertyName() {
        return this.entityMetamodel.getIdentifierProperty().getName();
    }

    @Override
    public Type getIdentifierType() {
        return this.entityMetamodel.getIdentifierProperty().getType();
    }

    @Override
    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    @Override
    public boolean hasCollectionNotReferencingPK() {
        return this.hasCollectionNotReferencingPK;
    }

    @Override
    public int[] getNaturalIdentifierProperties() {
        return this.entityMetamodel.getNaturalIdentifierProperties();
    }

    protected void verifyHasNaturalId() {
        if (!this.hasNaturalIdentifier()) {
            throw new HibernateException("Entity does not define a natural id : " + this.getEntityName());
        }
    }

    @Override
    public Object getNaturalIdentifierSnapshot(Object id, SharedSessionContractImplementor session) {
        this.verifyHasNaturalId();
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Getting current natural-id snapshot state for `%s#%s", (Object)this.getEntityName(), id);
        }
        return this.getNaturalIdLoader().resolveIdToNaturalId(id, session);
    }

    @Override
    public NaturalIdLoader<?> getNaturalIdLoader() {
        this.verifyHasNaturalId();
        if (this.naturalIdLoader == null) {
            this.naturalIdLoader = this.naturalIdMapping.makeLoader(this);
        }
        return this.naturalIdLoader;
    }

    @Override
    public MultiNaturalIdLoader<?> getMultiNaturalIdLoader() {
        this.verifyHasNaturalId();
        if (this.multiNaturalIdLoader == null) {
            this.multiNaturalIdLoader = this.naturalIdMapping.makeMultiLoader(this);
        }
        return this.multiNaturalIdLoader;
    }

    @Override
    public Object loadEntityIdByNaturalId(Object[] naturalIdValues, LockOptions lockOptions, SharedSessionContractImplementor session) {
        this.verifyHasNaturalId();
        return this.getNaturalIdLoader().resolveNaturalIdToId(naturalIdValues, session);
    }

    @Override
    public boolean hasNaturalIdentifier() {
        return this.entityMetamodel.hasNaturalIdentifier();
    }

    public static int getTableId(String tableName, String[] tables) {
        for (int j = 0; j < tables.length; ++j) {
            if (!tableName.equalsIgnoreCase(tables[j])) continue;
            return j;
        }
        throw new AssertionFailure("Table " + tableName + " not found");
    }

    @Override
    public EntityRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    @Deprecated(forRemoval=true)
    public BytecodeEnhancementMetadata getInstrumentationMetadata() {
        return this.getBytecodeEnhancementMetadata();
    }

    @Override
    public final BytecodeEnhancementMetadata getBytecodeEnhancementMetadata() {
        return this.entityMetamodel.getBytecodeEnhancementMetadata();
    }

    @Override
    public String getTableNameForColumn(String columnName) {
        return this.getTableName(this.determineTableNumberForColumn(columnName));
    }

    protected int determineTableNumberForColumn(String columnName) {
        return 0;
    }

    protected String determineTableName(Table table) {
        return table.getSubselect() != null ? "( " + this.createSqlQueryParser(table).process() + " )" : this.factory.getSqlStringGenerationContext().format(table.getQualifiedTableName());
    }

    private SQLQueryParser createSqlQueryParser(Table table) {
        return new SQLQueryParser(table.getSubselect(), null, new ExplicitSqlStringGenerationContext(table.getCatalog(), table.getSchema(), this.factory));
    }

    @Override
    public EntityEntryFactory getEntityEntryFactory() {
        return this.entityEntryFactory;
    }

    @Override
    public void forEachAttributeMapping(Consumer<? super AttributeMapping> action) {
        this.attributeMappings.forEach(action);
    }

    @Override
    public void forEachAttributeMapping(IndexedConsumer<? super AttributeMapping> consumer) {
        this.attributeMappings.indexedForEach(consumer);
    }

    @Override
    public void prepareMappingModel(MappingModelCreationProcess creationProcess) {
        if (this.identifierMapping == null) {
            this.prepareMappings(creationProcess);
            this.handleSubtypeMappings(creationProcess);
            this.prepareMultiTableMutationStrategy(creationProcess);
            this.prepareMultiTableInsertStrategy(creationProcess);
        }
    }

    private void handleSubtypeMappings(MappingModelCreationProcess creationProcess) {
        creationProcess.registerInitializationCallback("Entity(" + this.getEntityName() + ") `staticFetchableList` generator", () -> {
            ImmutableAttributeMappingList.Builder builder = new ImmutableAttributeMappingList.Builder(this.attributeMappings.size());
            this.visitSubTypeAttributeMappings(builder::add);
            assert (this.superMappingType != null || builder.assertFetchableIndexes());
            this.staticFetchableList = builder.build();
            return true;
        });
    }

    private static ReflectionOptimizer.AccessOptimizer accessOptimizer(EntityRepresentationStrategy strategy) {
        ReflectionOptimizer reflectionOptimizer = strategy.getReflectionOptimizer();
        return reflectionOptimizer == null ? null : reflectionOptimizer.getAccessOptimizer();
    }

    private void prepareMappings(MappingModelCreationProcess creationProcess) {
        PersistentClass bootEntityDescriptor = creationProcess.getCreationContext().getBootModel().getEntityBinding(this.getEntityName());
        this.initializeSpecialAttributeMappings(creationProcess, bootEntityDescriptor);
        this.versionGenerator = AbstractEntityPersister.createVersionGenerator(this.entityMetamodel, this.versionMapping);
        this.buildDeclaredAttributeMappings(creationProcess, bootEntityDescriptor);
        this.getAttributeMappings();
        this.initializeNaturalIdMapping(creationProcess, bootEntityDescriptor);
    }

    private void initializeSpecialAttributeMappings(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        if (this.superMappingType != null) {
            ((InFlightEntityMappingType)this.superMappingType).prepareMappingModel(creationProcess);
            if (this.shouldProcessSuperMapping()) {
                this.inheritSupertypeSpecialAttributeMappings();
            } else {
                this.prepareMappingModel(creationProcess, bootEntityDescriptor);
            }
        } else {
            this.prepareMappingModel(creationProcess, bootEntityDescriptor);
        }
    }

    private void inheritSupertypeSpecialAttributeMappings() {
        this.discriminatorMapping = this.superMappingType.getDiscriminatorMapping();
        this.identifierMapping = this.superMappingType.getIdentifierMapping();
        this.naturalIdMapping = this.superMappingType.getNaturalIdMapping();
        this.versionMapping = this.superMappingType.getVersionMapping();
        this.rowIdMapping = this.superMappingType.getRowIdMapping();
        this.softDeleteMapping = this.superMappingType.getSoftDeleteMapping();
    }

    private void buildDeclaredAttributeMappings(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        int stateArrayPosition = this.getStateArrayInitialPosition(creationProcess);
        NonIdentifierAttribute[] properties = this.entityMetamodel.getProperties();
        AttributeMappingsMap.Builder mappingsBuilder = AttributeMappingsMap.builder();
        int fetchableIndex = this.getFetchableIndexOffset();
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            NonIdentifierAttribute runtimeAttributeDefinition = properties[i];
            String attributeName = runtimeAttributeDefinition.getName();
            Property bootProperty = bootEntityDescriptor.getProperty(attributeName);
            if (this.superMappingType == null || this.superMappingType.findAttributeMapping(bootProperty.getName()) == null) {
                mappingsBuilder.put(attributeName, this.generateNonIdAttributeMapping(runtimeAttributeDefinition, bootProperty, stateArrayPosition++, fetchableIndex++, creationProcess));
            }
            this.declaredAttributeMappings = mappingsBuilder.build();
        }
    }

    private static BeforeExecutionGenerator createVersionGenerator(EntityMetamodel currentEntityMetamodel, EntityVersionMapping versionMapping) {
        if (currentEntityMetamodel.isVersioned()) {
            BeforeExecutionGenerator generator = currentEntityMetamodel.getVersionGenerator();
            return generator == null ? new VersionGeneration(versionMapping) : generator;
        }
        return null;
    }

    private void prepareMultiTableMutationStrategy(MappingModelCreationProcess creationProcess) {
        if (!this.isSubselect() && this.hasMultipleTables()) {
            creationProcess.registerInitializationCallback("Entity(" + this.getEntityName() + ") `sqmMultiTableMutationStrategy` interpretation", () -> {
                this.sqmMultiTableMutationStrategy = AbstractEntityPersister.interpretSqmMultiTableStrategy(this, creationProcess);
                if (this.sqmMultiTableMutationStrategy == null) {
                    return false;
                }
                this.sqmMultiTableMutationStrategy.prepare(creationProcess);
                return true;
            });
        }
    }

    private void prepareMultiTableInsertStrategy(MappingModelCreationProcess creationProcess) {
        if (!this.isSubselect() && (this.hasMultipleTables() || this.generatorNeedsMultiTableInsert())) {
            creationProcess.registerInitializationCallback("Entity(" + this.getEntityName() + ") `sqmMultiTableInsertStrategy` interpretation", () -> {
                this.sqmMultiTableInsertStrategy = AbstractEntityPersister.interpretSqmMultiTableInsertStrategy(this, creationProcess);
                if (this.sqmMultiTableInsertStrategy == null) {
                    return false;
                }
                this.sqmMultiTableInsertStrategy.prepare(creationProcess);
                return true;
            });
        }
    }

    private boolean isSubselect() {
        return this.getRootTableName().charAt(0) == '(';
    }

    private boolean generatorNeedsMultiTableInsert() {
        Generator generator = this.getGenerator();
        if (generator instanceof BulkInsertionCapableIdentifierGenerator && generator instanceof OptimizableGenerator) {
            OptimizableGenerator optimizableGenerator = (OptimizableGenerator)generator;
            Optimizer optimizer = optimizableGenerator.getOptimizer();
            return optimizer != null && optimizer.getIncrementSize() > 1;
        }
        return false;
    }

    private int getFetchableIndexOffset() {
        if (this.superMappingType != null) {
            EntityMappingType rootEntityDescriptor = this.getRootEntityDescriptor();
            int offset = rootEntityDescriptor.getNumberOfDeclaredAttributeMappings();
            for (EntityMappingType subMappingType : rootEntityDescriptor.getSubMappingTypes()) {
                if (subMappingType == this) break;
                int propertySpan = subMappingType.getEntityPersister().getEntityMetamodel().getPropertySpan();
                int superPropertySpan = subMappingType.getSuperMappingType().getEntityPersister().getEntityMetamodel().getPropertySpan();
                int numberOfDeclaredAttributeMappings = propertySpan - superPropertySpan;
                offset += numberOfDeclaredAttributeMappings;
            }
            return offset;
        }
        return 0;
    }

    private void prepareMappingModel(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        EntityInstantiator instantiator = this.getRepresentationStrategy().getInstantiator();
        Supplier<Object> instantiate = instantiator.canBeInstantiated() ? instantiator::instantiate : null;
        this.identifierMapping = creationProcess.processSubPart("{id}", (role, process) -> this.generateIdentifierMapping(instantiate, bootEntityDescriptor, process));
        this.versionMapping = this.generateVersionMapping(instantiate, bootEntityDescriptor, creationProcess);
        this.rowIdMapping = this.rowIdName == null ? null : (EntityRowIdMapping)creationProcess.processSubPart(this.rowIdName, (role, process) -> new EntityRowIdMappingImpl(this.rowIdName, this.getTableName(), this));
        this.discriminatorMapping = this.generateDiscriminatorMapping(bootEntityDescriptor);
        this.softDeleteMapping = SoftDeleteHelper.resolveSoftDeleteMapping(this, bootEntityDescriptor.getRootClass(), this.getIdentifierTableName(), creationProcess);
        if (this.softDeleteMapping != null && bootEntityDescriptor.getRootClass().getCustomSQLDelete() != null) {
            throw new UnsupportedMappingException("Entity may not define both @SoftDelete and @SQLDelete");
        }
    }

    private void initializeNaturalIdMapping(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        this.naturalIdMapping = this.superMappingType != null ? this.superMappingType.getNaturalIdMapping() : (bootEntityDescriptor.hasNaturalId() ? this.generateNaturalIdMapping(creationProcess, bootEntityDescriptor) : null);
    }

    protected NaturalIdMapping generateNaturalIdMapping(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        assert (bootEntityDescriptor.hasNaturalId());
        int[] naturalIdAttributeIndexes = this.entityMetamodel.getNaturalIdentifierProperties();
        assert (naturalIdAttributeIndexes.length > 0);
        if (naturalIdAttributeIndexes.length == 1) {
            String propertyName = this.entityMetamodel.getPropertyNames()[naturalIdAttributeIndexes[0]];
            AttributeMapping attributeMapping = this.findAttributeMapping(propertyName);
            SingularAttributeMapping singularAttributeMapping = (SingularAttributeMapping)attributeMapping;
            return new SimpleNaturalIdMapping(singularAttributeMapping, this, creationProcess);
        }
        HashSet attributeNames = CollectionHelper.setOfSize(naturalIdAttributeIndexes.length);
        for (int naturalIdAttributeIndex : naturalIdAttributeIndexes) {
            attributeNames.add(this.getPropertyNames()[naturalIdAttributeIndex]);
        }
        ArrayList<SingularAttributeMapping> collectedAttrMappings = new ArrayList<SingularAttributeMapping>();
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            if (!attributeNames.contains(attributeMapping.getAttributeName())) continue;
            collectedAttrMappings.add((SingularAttributeMapping)attributeMapping);
        }
        if (collectedAttrMappings.size() <= 1) {
            throw new MappingException("Expected multiple natural-id attributes, but found only one: " + this.getEntityName());
        }
        return new CompoundNaturalIdMapping(this, collectedAttrMappings, creationProcess);
    }

    protected static SqmMultiTableMutationStrategy interpretSqmMultiTableStrategy(AbstractEntityPersister entityMappingDescriptor, MappingModelCreationProcess creationProcess) {
        SqmMultiTableMutationStrategy sqmMultiTableMutationStrategy;
        assert (entityMappingDescriptor.hasMultipleTables());
        EntityMappingType superMappingType = entityMappingDescriptor.getSuperMappingType();
        if (superMappingType != null && (sqmMultiTableMutationStrategy = superMappingType.getSqmMultiTableMutationStrategy()) != null) {
            return sqmMultiTableMutationStrategy;
        }
        ServiceRegistry serviceRegistry = creationProcess.getCreationContext().getServiceRegistry();
        return serviceRegistry.requireService(SqmMultiTableMutationStrategyProvider.class).createMutationStrategy(entityMappingDescriptor, creationProcess);
    }

    protected static SqmMultiTableInsertStrategy interpretSqmMultiTableInsertStrategy(AbstractEntityPersister entityMappingDescriptor, MappingModelCreationProcess creationProcess) {
        ServiceRegistry serviceRegistry = creationProcess.getCreationContext().getServiceRegistry();
        return serviceRegistry.requireService(SqmMultiTableMutationStrategyProvider.class).createInsertStrategy(entityMappingDescriptor, creationProcess);
    }

    @Override
    public SqmMultiTableMutationStrategy getSqmMultiTableMutationStrategy() {
        return this.sqmMultiTableMutationStrategy;
    }

    @Override
    public SqmMultiTableInsertStrategy getSqmMultiTableInsertStrategy() {
        return this.sqmMultiTableInsertStrategy;
    }

    protected int getStateArrayInitialPosition(MappingModelCreationProcess creationProcess) {
        if (this.superMappingType == null) {
            return 0;
        }
        ((InFlightEntityMappingType)this.superMappingType).prepareMappingModel(creationProcess);
        return this.superMappingType.getNumberOfAttributeMappings();
    }

    protected boolean isPhysicalDiscriminator() {
        return this.getDiscriminatorFormulaTemplate() == null;
    }

    protected EntityDiscriminatorMapping generateDiscriminatorMapping(PersistentClass bootEntityDescriptor) {
        Integer scale;
        Integer precision;
        Long length;
        String columnDefinition;
        String discriminatorColumnExpression;
        if (this.getDiscriminatorType() == null) {
            return null;
        }
        if (this.getDiscriminatorFormulaTemplate() == null) {
            Column column = bootEntityDescriptor.getDiscriminator() == null ? null : bootEntityDescriptor.getDiscriminator().getColumns().get(0);
            discriminatorColumnExpression = this.getDiscriminatorColumnReaders();
            if (column == null) {
                columnDefinition = null;
                length = null;
                precision = null;
                scale = null;
            } else {
                columnDefinition = column.getSqlType();
                length = column.getLength();
                precision = column.getPrecision();
                scale = column.getScale();
            }
        } else {
            discriminatorColumnExpression = this.getDiscriminatorFormulaTemplate();
            columnDefinition = null;
            length = null;
            precision = null;
            scale = null;
        }
        return new ExplicitColumnDiscriminatorMappingImpl(this, discriminatorColumnExpression, this.getTableName(), discriminatorColumnExpression, this.getDiscriminatorFormulaTemplate() != null, this.isPhysicalDiscriminator(), false, columnDefinition, null, length, precision, scale, this.getDiscriminatorDomainType());
    }

    @Override
    public abstract BasicType<?> getDiscriminatorType();

    protected EntityVersionMapping generateVersionMapping(Supplier<?> templateInstanceCreator, PersistentClass bootEntityDescriptor, MappingModelCreationProcess creationProcess) {
        if (this.getVersionType() == null) {
            return null;
        }
        return creationProcess.processSubPart(this.getPropertyNames()[this.getVersionProperty()], (role, process) -> AbstractEntityPersister.generateVersionMapping(this, templateInstanceCreator, bootEntityDescriptor, creationProcess));
    }

    protected boolean shouldProcessSuperMapping() {
        return true;
    }

    @Override
    public void linkWithSuperType(MappingModelCreationProcess creationProcess) {
        if (this.getMappedSuperclass() != null) {
            this.superMappingType = creationProcess.getEntityPersister(this.getMappedSuperclass());
            InFlightEntityMappingType inFlightEntityMappingType = (InFlightEntityMappingType)this.superMappingType;
            inFlightEntityMappingType.linkWithSubType(this, creationProcess);
            if (this.subclassMappingTypes != null) {
                this.subclassMappingTypes.values().forEach(sub -> inFlightEntityMappingType.linkWithSubType((EntityMappingType)sub, creationProcess));
            }
        }
    }

    @Override
    public void linkWithSubType(EntityMappingType sub, MappingModelCreationProcess creationProcess) {
        if (this.subclassMappingTypes == null) {
            this.subclassMappingTypes = new TreeMap<String, EntityMappingType>();
        }
        this.subclassMappingTypes.put(sub.getEntityName(), sub);
        if (this.superMappingType != null) {
            ((InFlightEntityMappingType)this.superMappingType).linkWithSubType(sub, creationProcess);
        }
    }

    @Override
    public int getNumberOfAttributeMappings() {
        if (this.attributeMappings == null) {
            this.getAttributeMappings();
        }
        return this.attributeMappings.size();
    }

    @Override
    public AttributeMapping getAttributeMapping(int position) {
        return this.attributeMappings.get(position);
    }

    @Override
    public int getNumberOfDeclaredAttributeMappings() {
        return this.declaredAttributeMappings.size();
    }

    @Override
    public AttributeMappingsMap getDeclaredAttributeMappings() {
        return this.declaredAttributeMappings;
    }

    @Override
    public void visitDeclaredAttributeMappings(Consumer<? super AttributeMapping> action) {
        this.declaredAttributeMappings.forEachValue(action);
    }

    @Override
    public EntityMappingType getSuperMappingType() {
        return this.superMappingType;
    }

    @Override
    public Collection<EntityMappingType> getSubMappingTypes() {
        return this.subclassMappingTypes == null ? Collections.emptyList() : this.subclassMappingTypes.values();
    }

    @Override
    public boolean isTypeOrSuperType(EntityMappingType targetType) {
        if (targetType == null) {
            return true;
        }
        if (targetType == this) {
            return true;
        }
        if (this.superMappingType != null) {
            return this.superMappingType.isTypeOrSuperType(targetType);
        }
        return false;
    }

    protected EntityIdentifierMapping generateIdentifierMapping(Supplier<?> templateInstanceCreator, PersistentClass bootEntityDescriptor, MappingModelCreationProcess creationProcess) {
        Integer scale;
        Integer precision;
        Long length;
        String columnDefinition;
        Type idType = this.getIdentifierType();
        if (idType instanceof CompositeType) {
            boolean encapsulated;
            CompositeType cidType = (CompositeType)idType;
            boolean bl = encapsulated = !cidType.isEmbedded();
            if (encapsulated) {
                return MappingModelCreationHelper.buildEncapsulatedCompositeIdentifierMapping(this, bootEntityDescriptor.getIdentifierProperty(), bootEntityDescriptor.getIdentifierProperty().getName(), this.getTableName(), this.rootTableKeyColumnNames, cidType, creationProcess);
            }
            return this.generateNonEncapsulatedCompositeIdentifierMapping(creationProcess, bootEntityDescriptor);
        }
        if (bootEntityDescriptor.getIdentifier() == null) {
            columnDefinition = null;
            length = null;
            precision = null;
            scale = null;
        } else {
            Column column = bootEntityDescriptor.getIdentifier().getColumns().get(0);
            columnDefinition = column.getSqlType();
            length = column.getLength();
            precision = column.getPrecision();
            scale = column.getScale();
        }
        Value value = bootEntityDescriptor.getIdentifierProperty().getValue();
        return new BasicEntityIdentifierMappingImpl(this, templateInstanceCreator, bootEntityDescriptor.getIdentifierProperty().getName(), this.getTableName(), this.rootTableKeyColumnNames[0], columnDefinition, length, precision, scale, value.isColumnInsertable(0), value.isColumnUpdateable(0), (BasicType)idType, creationProcess);
    }

    protected EntityIdentifierMapping generateNonEncapsulatedCompositeIdentifierMapping(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        return MappingModelCreationHelper.buildNonEncapsulatedCompositeIdentifierMapping(this, this.getTableName(), this.getRootTableKeyColumnNames(), bootEntityDescriptor, creationProcess);
    }

    protected static EntityVersionMapping generateVersionMapping(AbstractEntityPersister entityPersister, Supplier<?> templateInstanceCreator, PersistentClass bootModelRootEntityDescriptor, MappingModelCreationProcess creationProcess) {
        Property versionProperty = bootModelRootEntityDescriptor.getVersion();
        BasicValue bootModelVersionValue = (BasicValue)versionProperty.getValue();
        BasicValue.Resolution<?> basicTypeResolution = bootModelVersionValue.resolve();
        Column column = (Column)bootModelVersionValue.getColumn();
        Dialect dialect = creationProcess.getCreationContext().getDialect();
        return new EntityVersionMappingImpl(bootModelRootEntityDescriptor.getRootClass(), templateInstanceCreator, bootModelRootEntityDescriptor.getVersion().getName(), entityPersister.getTableName(), column.getText(dialect), column.getSqlType(), column.getLength(), column.getPrecision(), column.getScale(), column.getTemporalPrecision(), basicTypeResolution.getLegacyResolvedBasicType(), entityPersister);
    }

    protected AttributeMapping generateNonIdAttributeMapping(NonIdentifierAttribute tupleAttrDefinition, Property bootProperty, int stateArrayPosition, int fetchableIndex, MappingModelCreationProcess creationProcess) {
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        String attrName = tupleAttrDefinition.getName();
        Type attrType = tupleAttrDefinition.getType();
        int propertyIndex = this.getPropertyIndex(bootProperty.getName());
        String tableExpression = this.getTableName(this.getPropertyTableNumbers()[propertyIndex]);
        String[] attrColumnNames = this.getPropertyColumnNames(propertyIndex);
        PropertyAccess propertyAccess = this.getRepresentationStrategy().resolvePropertyAccess(bootProperty);
        Value value = bootProperty.getValue();
        if (propertyIndex == this.getVersionProperty()) {
            Column column = value.getColumns().get(0);
            return MappingModelCreationHelper.buildBasicAttributeMapping(attrName, this.getNavigableRole().append(bootProperty.getName()), stateArrayPosition, fetchableIndex, bootProperty, this, (BasicType)attrType, tableExpression, attrColumnNames[0], null, false, null, "?", column.getSqlType(), column.getLength(), column.getPrecision(), column.getScale(), column.getTemporalPrecision(), column.isSqlTypeLob(creationProcess.getCreationContext().getMetadata()), column.isNullable(), value.isColumnInsertable(0), value.isColumnUpdateable(0), propertyAccess, tupleAttrDefinition.getCascadeStyle(), creationProcess);
        }
        if (attrType instanceof BasicType) {
            boolean nullable;
            boolean isLob;
            Integer scale;
            Integer temporalPrecision;
            Integer precision;
            Long length;
            String columnDefinition;
            String customWriteExpr;
            String customReadExpr;
            boolean isAttrColumnExpressionFormula;
            String attrColumnExpression;
            NavigableRole role = this.getNavigableRole().append(bootProperty.getName());
            if (value instanceof DependantValue) {
                attrColumnExpression = attrColumnNames[0];
                isAttrColumnExpressionFormula = false;
                customReadExpr = null;
                customWriteExpr = "?";
                Column column = value.getColumns().get(0);
                columnDefinition = column.getSqlType();
                length = column.getLength();
                precision = column.getPrecision();
                temporalPrecision = column.getTemporalPrecision();
                scale = column.getScale();
                isLob = column.isSqlTypeLob(creationProcess.getCreationContext().getMetadata());
                nullable = column.isNullable();
            } else {
                BasicValue basicBootValue = (BasicValue)value;
                if (attrColumnNames[0] != null) {
                    attrColumnExpression = attrColumnNames[0];
                    isAttrColumnExpressionFormula = false;
                    List<Selectable> selectables = basicBootValue.getSelectables();
                    assert (!selectables.isEmpty());
                    Selectable selectable = selectables.get(0);
                    assert (attrColumnExpression.equals(selectable.getText(creationContext.getDialect())));
                    customReadExpr = selectable.getTemplate(creationContext.getDialect(), creationContext.getTypeConfiguration());
                    customWriteExpr = selectable.getWriteExpr((JdbcMapping)((Object)attrType), creationContext.getDialect());
                    Column column = value.getColumns().get(0);
                    columnDefinition = column.getSqlType();
                    length = column.getLength();
                    precision = column.getPrecision();
                    temporalPrecision = column.getTemporalPrecision();
                    scale = column.getScale();
                    nullable = column.isNullable();
                    isLob = column.isSqlTypeLob(creationContext.getMetadata());
                    MappingModelCreationHelper.resolveAggregateColumnBasicType(creationProcess, role, column);
                } else {
                    String[] attrColumnFormulaTemplate = this.propertyColumnFormulaTemplates[propertyIndex];
                    attrColumnExpression = attrColumnFormulaTemplate[0];
                    isAttrColumnExpressionFormula = true;
                    customReadExpr = null;
                    customWriteExpr = null;
                    columnDefinition = null;
                    length = null;
                    precision = null;
                    temporalPrecision = null;
                    scale = null;
                    nullable = true;
                    isLob = false;
                }
            }
            return MappingModelCreationHelper.buildBasicAttributeMapping(attrName, role, stateArrayPosition, fetchableIndex, bootProperty, this, (BasicType)value.getType(), tableExpression, attrColumnExpression, null, isAttrColumnExpressionFormula, customReadExpr, customWriteExpr, columnDefinition, length, precision, scale, temporalPrecision, isLob, nullable, value.isColumnInsertable(0), value.isColumnUpdateable(0), propertyAccess, tupleAttrDefinition.getCascadeStyle(), creationProcess);
        }
        if (attrType instanceof AnyType) {
            AnyType anyType = (AnyType)attrType;
            JavaType baseAssociationJtd = creationContext.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)Object.class));
            DiscriminatedAssociationAttributeMapping.MutabilityPlanImpl mutabilityPlan = new DiscriminatedAssociationAttributeMapping.MutabilityPlanImpl(anyType);
            SimpleAttributeMetadata attributeMetadataAccess = new SimpleAttributeMetadata(propertyAccess, mutabilityPlan, bootProperty.isOptional(), bootProperty.isInsertable(), bootProperty.isUpdatable(), bootProperty.isOptimisticLocked(), bootProperty.isSelectable());
            return new DiscriminatedAssociationAttributeMapping(this.navigableRole.append(bootProperty.getName()), baseAssociationJtd, this, stateArrayPosition, fetchableIndex, attributeMetadataAccess, bootProperty.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE, propertyAccess, bootProperty, anyType, (Any)value, creationProcess);
        }
        if (attrType instanceof CompositeType) {
            DependantValue dependantValue = null;
            if (bootProperty.getValue() instanceof DependantValue) {
                dependantValue = (DependantValue)bootProperty.getValue();
            }
            return this.buildEmbeddedAttributeMapping(attrName, stateArrayPosition, fetchableIndex, bootProperty, dependantValue, 0, this, (CompositeType)attrType, tableExpression, null, propertyAccess, tupleAttrDefinition.getCascadeStyle(), creationProcess);
        }
        if (attrType instanceof CollectionType) {
            return this.buildPluralAttributeMapping(attrName, stateArrayPosition, fetchableIndex, bootProperty, this, propertyAccess, tupleAttrDefinition.getCascadeStyle(), this.getFetchMode(stateArrayPosition), creationProcess);
        }
        if (attrType instanceof EntityType) {
            EntityType entityType = (EntityType)attrType;
            return this.buildSingularAssociationAttributeMapping(attrName, this.getNavigableRole().append(attrName), stateArrayPosition, fetchableIndex, bootProperty, this, this, entityType, propertyAccess, tupleAttrDefinition.getCascadeStyle(), creationProcess);
        }
        return null;
    }

    protected EmbeddedAttributeMapping buildEmbeddedAttributeMapping(String attrName, int stateArrayPosition, int fetchableIndex, Property bootProperty, DependantValue dependantValue, int dependantColumnIndex, ManagedMappingType declaringType, CompositeType attrType, String tableExpression, String[] rootTableKeyColumnNames, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        return MappingModelCreationHelper.buildEmbeddedAttributeMapping(attrName, stateArrayPosition, fetchableIndex, bootProperty, dependantValue, dependantColumnIndex, declaringType, attrType, tableExpression, rootTableKeyColumnNames, propertyAccess, cascadeStyle, creationProcess);
    }

    protected AttributeMapping buildSingularAssociationAttributeMapping(String attrName, NavigableRole navigableRole, int stateArrayPosition, int fetchableIndex, Property bootProperty, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, EntityType attrType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        return MappingModelCreationHelper.buildSingularAssociationAttributeMapping(attrName, navigableRole, stateArrayPosition, fetchableIndex, bootProperty, declaringType, declaringEntityPersister, attrType, propertyAccess, cascadeStyle, creationProcess);
    }

    protected AttributeMapping buildPluralAttributeMapping(String attrName, int stateArrayPosition, int fetchableIndex, Property bootProperty, ManagedMappingType declaringType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, FetchMode fetchMode, MappingModelCreationProcess creationProcess) {
        return MappingModelCreationHelper.buildPluralAttributeMapping(attrName, stateArrayPosition, fetchableIndex, bootProperty, declaringType, propertyAccess, cascadeStyle, fetchMode, creationProcess);
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.javaType;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this;
    }

    @Override
    public EntityIdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public EntityVersionMapping getVersionMapping() {
        return this.versionMapping;
    }

    @Override
    public EntityRowIdMapping getRowIdMapping() {
        return this.rowIdMapping;
    }

    @Override
    public EntityDiscriminatorMapping getDiscriminatorMapping() {
        return this.discriminatorMapping;
    }

    @Override
    public SoftDeleteMapping getSoftDeleteMapping() {
        return this.softDeleteMapping;
    }

    @Override
    public AttributeMappingsList getAttributeMappings() {
        if (this.attributeMappings == null) {
            int sizeHint = this.declaredAttributeMappings.size();
            ImmutableAttributeMappingList.Builder builder = new ImmutableAttributeMappingList.Builder(sizeHint += this.superMappingType == null ? 0 : this.superMappingType.getAttributeMappings().size());
            if (this.superMappingType != null) {
                this.superMappingType.forEachAttributeMapping(builder::add);
            }
            for (AttributeMapping am : this.declaredAttributeMappings.valueIterator()) {
                builder.add(am);
            }
            this.attributeMappings = builder.build();
            Getter[] getters = new Getter[this.attributeMappings.size()];
            Setter[] setters = new Setter[this.attributeMappings.size()];
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                PropertyAccess propertyAccess = this.attributeMappings.get(i).getAttributeMetadata().getPropertyAccess();
                getters[i] = propertyAccess.getGetter();
                setters[i] = propertyAccess.getSetter();
            }
            this.getterCache = getters;
            this.setterCache = setters;
        }
        return this.attributeMappings;
    }

    @Override
    public AttributeMapping findDeclaredAttributeMapping(String name) {
        return this.declaredAttributeMappings.get(name);
    }

    @Override
    public AttributeMapping findAttributeMapping(String name) {
        AttributeMapping declaredAttribute = this.declaredAttributeMappings.get(name);
        if (declaredAttribute != null) {
            return declaredAttribute;
        }
        if (this.superMappingType != null) {
            return this.superMappingType.findAttributeMapping(name);
        }
        return null;
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        ModelPart identifierModelPart;
        ModelPart superDefinedAttribute;
        if (EntityDiscriminatorMapping.matchesRoleName(name)) {
            return this.discriminatorMapping;
        }
        AttributeMapping declaredAttribute = this.declaredAttributeMappings.get(name);
        if (declaredAttribute != null) {
            return declaredAttribute;
        }
        if (this.superMappingType != null && (superDefinedAttribute = this.superMappingType.findSubPart(name, this.superMappingType)) != null) {
            ModelPart identifierModelPart2;
            if (superDefinedAttribute.isEntityIdentifierMapping() && (identifierModelPart2 = this.getIdentifierModelPart(name, treatTargetType)) != null) {
                return identifierModelPart2;
            }
            return superDefinedAttribute;
        }
        if (treatTargetType == null) {
            ModelPart subDefinedAttribute = this.findSubPartInSubclassMappings(name);
            if (subDefinedAttribute != null) {
                return subDefinedAttribute;
            }
        } else if (treatTargetType != this) {
            if (!treatTargetType.isTypeOrSuperType(this)) {
                return null;
            }
            ModelPart treatTypeSubPart = treatTargetType.findSubTypesSubPart(name, null);
            if (treatTypeSubPart != null) {
                return treatTypeSubPart;
            }
            for (EntityMappingType superType = treatTargetType.getSuperMappingType(); superType != this; superType = superType.getSuperMappingType()) {
                AttributeMapping superTypeSubPart = superType.findDeclaredAttributeMapping(name);
                if (superTypeSubPart == null) continue;
                return superTypeSubPart;
            }
        }
        if ((identifierModelPart = this.getIdentifierModelPart(name, treatTargetType)) != null) {
            return identifierModelPart;
        }
        for (AttributeMapping attribute : this.declaredAttributeMappings.valueIterator()) {
            ModelPart subPart;
            if (!(attribute instanceof EmbeddableValuedModelPart)) continue;
            EmbeddableValuedModelPart part = (EmbeddableValuedModelPart)((Object)attribute);
            if (!(attribute instanceof VirtualModelPart) || (subPart = part.findSubPart(name, null)) == null) continue;
            return subPart;
        }
        return null;
    }

    private ModelPart findSubPartInSubclassMappings(String name) {
        ModelPart attribute = null;
        if (CollectionHelper.isNotEmpty(this.subclassMappingTypes)) {
            for (EntityMappingType subMappingType : this.subclassMappingTypes.values()) {
                ModelPart subDefinedAttribute = subMappingType.findSubTypesSubPart(name, null);
                if (subDefinedAttribute == null) continue;
                if (attribute != null && !MappingModelHelper.isCompatibleModelPart(attribute, subDefinedAttribute)) {
                    throw new PathException(String.format(Locale.ROOT, "Could not resolve attribute '%s' of '%s' due to the attribute being declared in multiple subtypes '%s' and '%s'", name, this.getJavaType().getTypeName(), attribute.asAttributeMapping().getDeclaringType().getJavaType().getTypeName(), subDefinedAttribute.asAttributeMapping().getDeclaringType().getJavaType().getTypeName()));
                }
                attribute = subDefinedAttribute;
            }
        }
        return attribute;
    }

    @Override
    public ModelPart findSubTypesSubPart(String name, EntityMappingType treatTargetType) {
        AttributeMapping declaredAttribute = this.declaredAttributeMappings.get(name);
        if (declaredAttribute != null) {
            return declaredAttribute;
        }
        return this.findSubPartInSubclassMappings(name);
    }

    private ModelPart getIdentifierModelPart(String name, EntityMappingType treatTargetType) {
        NonAggregatedIdentifierMapping mapping;
        ModelPart subPart;
        EntityIdentifierMapping identifierMapping = this.getIdentifierMappingForJoin();
        if (identifierMapping instanceof NonAggregatedIdentifierMapping && (subPart = (mapping = (NonAggregatedIdentifierMapping)identifierMapping).findSubPart(name, treatTargetType)) != null) {
            return subPart;
        }
        if (this.isIdentifierReference(name)) {
            return identifierMapping;
        }
        return null;
    }

    private boolean isIdentifierReference(String name) {
        return "{id}".equals(name) || this.hasIdentifierProperty() && this.getIdentifierPropertyName().equals(name) || !this.entityMetamodel.hasNonIdentifierPropertyNamedId() && "id".equals(name);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.identifierMapping);
        this.declaredAttributeMappings.forEachValue(consumer);
    }

    @Override
    public void visitKeyFetchables(Consumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
    }

    @Override
    public void visitKeyFetchables(IndexedConsumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getStaticFetchableList().size();
    }

    @Override
    public int getNumberOfFetchableKeys() {
        return this.superMappingType == null ? this.getNumberOfFetchables() : this.getRootEntityDescriptor().getNumberOfFetchables();
    }

    @Override
    public Fetchable getKeyFetchable(int position) {
        throw new IndexOutOfBoundsException(position);
    }

    @Override
    public AttributeMapping getFetchable(int position) {
        return this.getStaticFetchableList().get(position);
    }

    @Override
    public void visitFetchables(Consumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        if (treatTargetType == null) {
            this.getStaticFetchableList().forEach(fetchableConsumer);
        } else if (treatTargetType.isTypeOrSuperType(this)) {
            this.visitSubTypeAttributeMappings(fetchableConsumer);
        } else {
            this.attributeMappings.forEach(fetchableConsumer);
        }
    }

    @Override
    public void visitFetchables(IndexedConsumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        if (treatTargetType == null) {
            this.getStaticFetchableList().indexedForEach(fetchableConsumer);
        } else {
            this.attributeMappings.indexedForEach(fetchableConsumer);
            if (treatTargetType.isTypeOrSuperType(this) && this.subclassMappingTypes != null) {
                int offset = this.attributeMappings.size();
                for (EntityMappingType subtype : this.subclassMappingTypes.values()) {
                    AttributeMappingsMap declaredAttributeMappings = subtype.getDeclaredAttributeMappings();
                    for (AttributeMapping declaredAttributeMapping : declaredAttributeMappings.valueIterator()) {
                        fetchableConsumer.accept(offset++, declaredAttributeMapping);
                    }
                }
            }
        }
    }

    protected AttributeMappingsList getStaticFetchableList() {
        return this.staticFetchableList;
    }

    @Override
    public void visitAttributeMappings(Consumer<? super AttributeMapping> action) {
        this.attributeMappings.forEach(action);
    }

    @Override
    public void visitSuperTypeAttributeMappings(Consumer<? super AttributeMapping> action) {
        if (this.superMappingType != null) {
            this.superMappingType.visitSuperTypeAttributeMappings(action);
        }
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer selectableConsumer) {
        int span = 0;
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            span += attributeMapping.forEachSelectable(span + offset, selectableConsumer);
        }
        return span;
    }

    @Override
    public void visitSubTypeAttributeMappings(Consumer<? super AttributeMapping> action) {
        this.forEachAttributeMapping(action);
        if (this.subclassMappingTypes != null) {
            for (EntityMappingType subType : this.subclassMappingTypes.values()) {
                subType.visitDeclaredAttributeMappings(action);
            }
        }
    }

    @Override
    public int getJdbcTypeCount() {
        return this.getIdentifierMapping().getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.getIdentifierMapping().forEachJdbcType(offset, action);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        EntityIdentifierMapping identifierMapping = this.getIdentifierMapping();
        Object identifier = identifierMapping.getIdentifier(value);
        return identifierMapping.disassemble(identifier, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.getIdentifierMapping().forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> consumer, SharedSessionContractImplementor session) {
        EntityIdentifierMapping identifierMapping = this.getIdentifierMapping();
        Object identifier = value == null ? null : identifierMapping.disassemble(identifierMapping.getIdentifier(value), session);
        return identifierMapping.forEachDisassembledJdbcValue(identifier, offset, x, y, consumer, session);
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return this.hasPartitionedSelectionMapping;
    }

    public abstract boolean isTableCascadeDeleteEnabled(int var1);

    @Deprecated
    protected String[] getSubclassColumnAliasClosure() {
        return this.subclassColumnAliasClosure;
    }

    @Deprecated
    protected String[] getSubclassFormulaAliasClosure() {
        return this.subclassFormulaAliasClosure;
    }

    @Override
    @Deprecated
    public String[] getSubclassPropertyColumnAliases(String propertyName, String suffix) {
        String[] rawAliases = this.subclassPropertyAliases.get(propertyName);
        if (rawAliases == null) {
            return null;
        }
        String[] result = new String[rawAliases.length];
        for (int i = 0; i < rawAliases.length; ++i) {
            result[i] = new Alias(suffix).toUnquotedAliasString(rawAliases[i]);
        }
        return result;
    }

    @Deprecated
    protected void initSubclassPropertyAliasesMap(PersistentClass model) throws MappingException {
        Type type;
        this.internalInitSubclassPropertyAliasesMap(null, model.getSubclassPropertyClosure());
        if (!this.entityMetamodel.hasNonIdentifierPropertyNamedId()) {
            this.subclassPropertyAliases.put("id", this.getIdentifierAliases());
        }
        if (this.hasIdentifierProperty()) {
            this.subclassPropertyAliases.put(this.getIdentifierPropertyName(), this.getIdentifierAliases());
        }
        if ((type = this.getIdentifierType()) instanceof ComponentType) {
            ComponentType componentId = (ComponentType)type;
            String[] idPropertyNames = componentId.getPropertyNames();
            String[] idAliases = this.getIdentifierAliases();
            for (int i = 0; i < idPropertyNames.length; ++i) {
                if (this.entityMetamodel.hasNonIdentifierPropertyNamedId()) {
                    this.subclassPropertyAliases.put("id." + idPropertyNames[i], new String[]{idAliases[i]});
                }
                if (this.hasIdentifierProperty()) {
                    this.subclassPropertyAliases.put(this.getIdentifierPropertyName() + "." + idPropertyNames[i], new String[]{idAliases[i]});
                    continue;
                }
                this.subclassPropertyAliases.put(idPropertyNames[i], new String[]{idAliases[i]});
            }
        }
        if (this.entityMetamodel.isPolymorphic()) {
            this.subclassPropertyAliases.put(ENTITY_CLASS, new String[]{this.getDiscriminatorAlias()});
        }
    }

    private void internalInitSubclassPropertyAliasesMap(String path, List<Property> properties) {
        for (Property property : properties) {
            String name;
            String string = name = path == null ? property.getName() : path + "." + property.getName();
            if (property.isComposite()) {
                Component component = (Component)property.getValue();
                this.internalInitSubclassPropertyAliasesMap(name, component.getProperties());
            }
            String[] aliases = new String[property.getColumnSpan()];
            int l = 0;
            Dialect dialect = this.getDialect();
            for (Selectable selectable : property.getSelectables()) {
                aliases[l] = selectable.getAlias(dialect, property.getValue().getTable());
                ++l;
            }
            this.subclassPropertyAliases.put(name, aliases);
        }
    }

    public String getDiscriminatorAlias() {
        return DISCRIMINATOR_ALIAS;
    }

    protected String getSqlWhereStringTableExpression() {
        return this.sqlWhereStringTableExpression;
    }

    @Override
    public boolean managesColumns(String[] columnNames) {
        for (String columnName : columnNames) {
            if (this.writesToColumn(columnName)) continue;
            return false;
        }
        return true;
    }

    private boolean writesToColumn(String columnName) {
        if (ArrayHelper.contains(this.rootTableKeyColumnNames, columnName)) {
            return true;
        }
        for (int i = 0; i < this.propertyColumnNames.length; ++i) {
            if (!ArrayHelper.contains(this.propertyColumnNames[i], columnName) || !ArrayHelper.isAllTrue(this.propertyColumnInsertable[i]) || !ArrayHelper.isAllTrue(this.propertyColumnUpdateable[i])) continue;
            return true;
        }
        return false;
    }

    public static interface CacheEntryHelper {
        public CacheEntryStructure getCacheEntryStructure();

        public CacheEntry buildCacheEntry(Object var1, Object[] var2, Object var3, SharedSessionContractImplementor var4);
    }

    private static class NoopCacheEntryHelper
    implements CacheEntryHelper {
        public static final NoopCacheEntryHelper INSTANCE = new NoopCacheEntryHelper();

        private NoopCacheEntryHelper() {
        }

        @Override
        public CacheEntryStructure getCacheEntryStructure() {
            return UnstructuredCacheEntry.INSTANCE;
        }

        @Override
        public CacheEntry buildCacheEntry(Object entity, Object[] state, Object version, SharedSessionContractImplementor session) {
            throw new HibernateException("Illegal attempt to build cache entry for non-cached entity");
        }
    }

    private static class ReferenceCacheEntryHelper
    implements CacheEntryHelper {
        private final EntityPersister persister;

        private ReferenceCacheEntryHelper(EntityPersister persister) {
            this.persister = persister;
        }

        @Override
        public CacheEntryStructure getCacheEntryStructure() {
            return UnstructuredCacheEntry.INSTANCE;
        }

        @Override
        public CacheEntry buildCacheEntry(Object entity, Object[] state, Object version, SharedSessionContractImplementor session) {
            return new ReferenceCacheEntryImpl(entity, this.persister);
        }
    }

    private static class StructuredCacheEntryHelper
    implements CacheEntryHelper {
        private final EntityPersister persister;
        private final StructuredCacheEntry structure;

        private StructuredCacheEntryHelper(EntityPersister persister) {
            this.persister = persister;
            this.structure = new StructuredCacheEntry(persister);
        }

        @Override
        public CacheEntryStructure getCacheEntryStructure() {
            return this.structure;
        }

        @Override
        public CacheEntry buildCacheEntry(Object entity, Object[] state, Object version, SharedSessionContractImplementor session) {
            return new StandardCacheEntryImpl(state, this.persister, version, session, entity);
        }
    }

    private static class StandardCacheEntryHelper
    implements CacheEntryHelper {
        private final EntityPersister persister;

        private StandardCacheEntryHelper(EntityPersister persister) {
            this.persister = persister;
        }

        @Override
        public CacheEntryStructure getCacheEntryStructure() {
            return UnstructuredCacheEntry.INSTANCE;
        }

        @Override
        public CacheEntry buildCacheEntry(Object entity, Object[] state, Object version, SharedSessionContractImplementor session) {
            return new StandardCacheEntryImpl(state, this.persister, version, session, entity);
        }
    }

    protected static interface MutabilityOrderedTableConsumer {
        public void consume(String var1, int var2, Supplier<Consumer<SelectableConsumer>> var3);
    }

    private static class TableMappingBuilder {
        private final String tableName;
        private final int relativePosition;
        private final EntityTableMapping.KeyMapping keyMapping;
        private final boolean isOptional;
        private final boolean isInverse;
        private final boolean isIdentifierTable;
        private final Expectation insertExpectation;
        private final String customInsertSql;
        private final boolean insertCallable;
        private final Expectation updateExpectation;
        private final String customUpdateSql;
        private final boolean updateCallable;
        private final boolean cascadeDeleteEnabled;
        private final Expectation deleteExpectation;
        private final String customDeleteSql;
        private final boolean deleteCallable;
        private final boolean dynamicUpdate;
        private final boolean dynamicInsert;
        private final List<Integer> attributeIndexes = new ArrayList<Integer>();

        public TableMappingBuilder(String tableName, int relativePosition, EntityTableMapping.KeyMapping keyMapping, boolean isOptional, boolean isInverse, boolean isIdentifierTable, Expectation insertExpectation, String customInsertSql, boolean insertCallable, Expectation updateExpectation, String customUpdateSql, boolean updateCallable, boolean cascadeDeleteEnabled, Expectation deleteExpectation, String customDeleteSql, boolean deleteCallable, boolean dynamicUpdate, boolean dynamicInsert) {
            this.tableName = tableName;
            this.relativePosition = relativePosition;
            this.keyMapping = keyMapping;
            this.isOptional = isOptional;
            this.isInverse = isInverse;
            this.isIdentifierTable = isIdentifierTable;
            this.insertExpectation = insertExpectation;
            this.customInsertSql = customInsertSql;
            this.insertCallable = insertCallable;
            this.updateExpectation = updateExpectation;
            this.customUpdateSql = customUpdateSql;
            this.updateCallable = updateCallable;
            this.cascadeDeleteEnabled = cascadeDeleteEnabled;
            this.deleteExpectation = deleteExpectation;
            this.customDeleteSql = customDeleteSql;
            this.deleteCallable = deleteCallable;
            this.dynamicUpdate = dynamicUpdate;
            this.dynamicInsert = dynamicInsert;
        }

        private EntityTableMapping build() {
            return new EntityTableMapping(this.tableName, this.relativePosition, this.keyMapping, this.isOptional, this.isInverse, this.isIdentifierTable, ArrayHelper.toIntArray(this.attributeIndexes), this.insertExpectation, this.customInsertSql, this.insertCallable, this.updateExpectation, this.customUpdateSql, this.updateCallable, this.cascadeDeleteEnabled, this.deleteExpectation, this.customDeleteSql, this.deleteCallable, this.dynamicUpdate, this.dynamicInsert);
        }
    }
}

