/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.bytebuddy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.pool.TypePool;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.engine.spi.PrimeAmongSecondarySupertypes;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyConfiguration;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyInterceptor;
import org.hibernate.proxy.pojo.bytebuddy.SerializableProxy;

public class ByteBuddyProxyHelper
implements Serializable {
    private static final String PROXY_NAMING_SUFFIX = "HibernateProxy";
    private static final TypeDescription OBJECT = TypeDescription.ForLoadedType.of(Object.class);
    private final ByteBuddyState byteBuddyState;

    public ByteBuddyProxyHelper(ByteBuddyState byteBuddyState) {
        this.byteBuddyState = byteBuddyState;
    }

    public Class buildProxy(Class<?> persistentClass, Class<?>[] interfaces) {
        HashSet key = new HashSet();
        if (interfaces.length == 1) {
            key.add(persistentClass);
        }
        Collections.addAll(key, interfaces);
        String proxyClassName = persistentClass.getTypeName() + "$HibernateProxy";
        return this.byteBuddyState.loadProxy(persistentClass, proxyClassName, this.proxyBuilder(TypeDescription.ForLoadedType.of(persistentClass), new TypeList.Generic.ForLoadedTypes(interfaces)));
    }

    @Deprecated
    public DynamicType.Unloaded<?> buildUnloadedProxy(Class<?> persistentClass, Class<?>[] interfaces) {
        return this.byteBuddyState.make(this.proxyBuilderLegacy(TypeDescription.ForLoadedType.of(persistentClass), new TypeList.Generic.ForLoadedTypes(interfaces)));
    }

    public DynamicType.Unloaded<?> buildUnloadedProxy(TypePool typePool, TypeDefinition persistentClass, Collection<? extends TypeDefinition> interfaces) {
        return this.byteBuddyState.make(typePool, this.proxyBuilderLegacy(persistentClass, interfaces));
    }

    private Function<ByteBuddy, DynamicType.Builder<?>> proxyBuilderLegacy(TypeDefinition persistentClass, Collection<? extends TypeDefinition> interfaces) {
        BiFunction<ByteBuddy, NamingStrategy, DynamicType.Builder<?>> proxyBuilder = this.proxyBuilder(persistentClass, interfaces);
        NamingStrategy.Suffixing namingStrategy = new NamingStrategy.Suffixing(PROXY_NAMING_SUFFIX, new NamingStrategy.Suffixing.BaseNameResolver.ForFixedValue(persistentClass.getTypeName()));
        return byteBuddy -> (DynamicType.Builder)proxyBuilder.apply((ByteBuddy)byteBuddy, namingStrategy);
    }

    private BiFunction<ByteBuddy, NamingStrategy, DynamicType.Builder<?>> proxyBuilder(TypeDefinition persistentClass, Collection<? extends TypeDefinition> interfaces) {
        ByteBuddyState.ProxyDefinitionHelpers helpers = this.byteBuddyState.getProxyDefinitionHelpers();
        return (byteBuddy, namingStrategy) -> helpers.appendIgnoreAlsoAtEnd(byteBuddy.ignore(helpers.getGroovyGetMetaClassFilter()).with((NamingStrategy)namingStrategy).subclass(interfaces.size() == 1 ? persistentClass : OBJECT, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_OPENING).implement(interfaces).method(helpers.getVirtualNotFinalizerFilter()).intercept(helpers.getDelegateToInterceptorDispatcherMethodDelegation()).method(helpers.getProxyNonInterceptedMethodFilter()).intercept(SuperMethodCall.INSTANCE).defineField("$$_hibernate_interceptor", (Type)((Object)ProxyConfiguration.Interceptor.class), Visibility.PRIVATE).implement(new Type[]{ProxyConfiguration.class}).intercept(helpers.getInterceptorFieldAccessor()));
    }

    public HibernateProxy deserializeProxy(SerializableProxy serializableProxy) {
        ByteBuddyInterceptor interceptor = new ByteBuddyInterceptor(serializableProxy.getEntityName(), serializableProxy.getPersistentClass(), serializableProxy.getInterfaces(), serializableProxy.getId(), ByteBuddyProxyHelper.resolveIdGetterMethod(serializableProxy), ByteBuddyProxyHelper.resolveIdSetterMethod(serializableProxy), serializableProxy.getComponentIdType(), null, ReflectHelper.overridesEquals(serializableProxy.getPersistentClass()));
        try {
            Class proxyClass = this.buildProxy(serializableProxy.getPersistentClass(), serializableProxy.getInterfaces());
            PrimeAmongSecondarySupertypes instance = (PrimeAmongSecondarySupertypes)proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ProxyConfiguration proxyConfiguration = instance.asProxyConfiguration();
            if (proxyConfiguration == null) {
                throw new HibernateException("Produced proxy does not correctly implement ProxyConfiguration");
            }
            proxyConfiguration.$$_hibernate_set_interceptor(interceptor);
            HibernateProxy hibernateProxy = instance.asHibernateProxy();
            if (hibernateProxy == null) {
                throw new HibernateException("Produced proxy does not correctly implement HibernateProxy");
            }
            return hibernateProxy;
        }
        catch (Throwable t) {
            throw new HibernateException("Bytecode enhancement failed for entity '" + serializableProxy.getEntityName() + "'", t);
        }
    }

    private static Method resolveIdGetterMethod(SerializableProxy serializableProxy) {
        if (serializableProxy.getIdentifierGetterMethodName() == null) {
            return null;
        }
        try {
            return serializableProxy.getIdentifierGetterMethodClass().getDeclaredMethod(serializableProxy.getIdentifierGetterMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Unable to deserialize proxy [%s, %s]; could not locate id getter method [%s] on entity class [%s]", serializableProxy.getEntityName(), serializableProxy.getId(), serializableProxy.getIdentifierGetterMethodName(), serializableProxy.getIdentifierGetterMethodClass()));
        }
    }

    private static Method resolveIdSetterMethod(SerializableProxy serializableProxy) {
        if (serializableProxy.getIdentifierSetterMethodName() == null) {
            return null;
        }
        try {
            return serializableProxy.getIdentifierSetterMethodClass().getDeclaredMethod(serializableProxy.getIdentifierSetterMethodName(), serializableProxy.getIdentifierSetterMethodParams());
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Unable to deserialize proxy [%s, %s]; could not locate id setter method [%s] on entity class [%s]", serializableProxy.getEntityName(), serializableProxy.getId(), serializableProxy.getIdentifierSetterMethodName(), serializableProxy.getIdentifierSetterMethodClass()));
        }
    }
}

