/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaSelect;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Nulls;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.criteria.TemporalField;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.function.AvgFunction;
import org.hibernate.dialect.function.SumReturnTypeResolver;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.metamodel.model.domain.internal.EntitySqmPathSource;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SortDirection;
import org.hibernate.query.common.FrameKind;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCastTarget;
import org.hibernate.query.criteria.JpaCoalesce;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaCriteriaSelect;
import org.hibernate.query.criteria.JpaCteCriteriaAttribute;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaFunction;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaParameterExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaSearchOrder;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.criteria.JpaWindow;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.query.criteria.spi.CriteriaBuilderExtension;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.spi.ImmutableEntityUpdateQueryHandlingMode;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryEngineOptions;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.cte.SqmSearchClauseSpecification;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddableDomainType;
import org.hibernate.query.sqm.tree.domain.SqmFkExpression;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedRoot;
import org.hibernate.query.sqm.tree.domain.SqmTreatedSingularJoin;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCoalesce;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmJsonExistsExpression;
import org.hibernate.query.sqm.tree.expression.SqmJsonNullBehavior;
import org.hibernate.query.sqm.tree.expression.SqmJsonObjectAggUniqueKeysBehavior;
import org.hibernate.query.sqm.tree.expression.SqmJsonQueryExpression;
import org.hibernate.query.sqm.tree.expression.SqmJsonTableFunction;
import org.hibernate.query.sqm.tree.expression.SqmJsonValueExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmModifiedSubQueryExpression;
import org.hibernate.query.sqm.tree.expression.SqmNamedExpression;
import org.hibernate.query.sqm.tree.expression.SqmOver;
import org.hibernate.query.sqm.tree.expression.SqmSetReturningFunction;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.expression.SqmWindow;
import org.hibernate.query.sqm.tree.expression.SqmWindowFrame;
import org.hibernate.query.sqm.tree.expression.SqmXmlElementExpression;
import org.hibernate.query.sqm.tree.expression.SqmXmlTableFunction;
import org.hibernate.query.sqm.tree.expression.ValueBindJpaCriteriaParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmJpaCompoundSelection;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindableType;
import org.hibernate.type.BindingContext;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmCriteriaNodeBuilder
implements NodeBuilder,
Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SqmCriteriaNodeBuilder.class);
    private final String uuid;
    private final String name;
    private final transient JpaCompliance jpaCompliance;
    private final transient QueryEngine queryEngine;
    private final transient ValueHandlingMode criteriaValueHandlingMode;
    private final transient ImmutableEntityUpdateQueryHandlingMode immutableEntityUpdateQueryHandlingMode;
    private final transient BindingContext bindingContext;
    private transient BasicType<Boolean> booleanType;
    private transient BasicType<Integer> integerType;
    private transient BasicType<Long> longType;
    private transient BasicType<Character> characterType;
    private transient BasicType<String> stringType;
    private transient FunctionReturnTypeResolver sumReturnTypeResolver;
    private transient FunctionReturnTypeResolver avgReturnTypeResolver;
    private final transient Map<Class<? extends HibernateCriteriaBuilder>, HibernateCriteriaBuilder> extensions;

    public SqmCriteriaNodeBuilder(String uuid, String name, QueryEngine queryEngine, QueryEngineOptions options, BindingContext bindingContext) {
        this.queryEngine = queryEngine;
        this.uuid = uuid;
        this.name = name;
        this.jpaCompliance = options.getJpaCompliance();
        this.criteriaValueHandlingMode = options.getCriteriaValueHandlingMode();
        this.immutableEntityUpdateQueryHandlingMode = options.getImmutableEntityUpdateQueryHandlingMode();
        this.bindingContext = bindingContext;
        this.extensions = this.loadExtensions();
    }

    private Map<Class<? extends HibernateCriteriaBuilder>, HibernateCriteriaBuilder> loadExtensions() {
        HashMap<Class<? extends HibernateCriteriaBuilder>, HibernateCriteriaBuilder> extensions = new HashMap<Class<? extends HibernateCriteriaBuilder>, HibernateCriteriaBuilder>();
        for (CriteriaBuilderExtension extension : ServiceLoader.load(CriteriaBuilderExtension.class)) {
            extensions.put(extension.getRegistrationKey(), extension.extend(this));
        }
        return extensions;
    }

    @Override
    public JpaMetamodel getDomainModel() {
        return this.bindingContext.getJpaMetamodel();
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.bindingContext.getTypeConfiguration();
    }

    @Override
    public boolean isJpaQueryComplianceEnabled() {
        return this.jpaCompliance.isJpaQueryComplianceEnabled();
    }

    @Override
    public JpaCompliance getJpaCompliance() {
        return this.jpaCompliance;
    }

    @Override
    @Deprecated
    public ImmutableEntityUpdateQueryHandlingMode getImmutableEntityUpdateQueryHandlingMode() {
        return this.immutableEntityUpdateQueryHandlingMode;
    }

    @Override
    public boolean allowImmutableEntityUpdate() {
        return this.immutableEntityUpdateQueryHandlingMode != ImmutableEntityUpdateQueryHandlingMode.EXCEPTION;
    }

    @Override
    public BasicType<Boolean> getBooleanType() {
        BasicType<Boolean> booleanType = this.booleanType;
        if (booleanType == null) {
            this.booleanType = this.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN);
            return this.booleanType;
        }
        return booleanType;
    }

    @Override
    public BasicType<Integer> getIntegerType() {
        BasicType<Integer> integerType = this.integerType;
        if (integerType == null) {
            this.integerType = this.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
            return this.integerType;
        }
        return integerType;
    }

    @Override
    public BasicType<Long> getLongType() {
        BasicType<Long> longType = this.longType;
        if (longType == null) {
            this.longType = this.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.LONG);
            return this.longType;
        }
        return longType;
    }

    @Override
    public BasicType<Character> getCharacterType() {
        BasicType<Character> characterType = this.characterType;
        if (characterType == null) {
            this.characterType = this.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.CHARACTER);
            return this.characterType;
        }
        return characterType;
    }

    public BasicType<String> getStringType() {
        BasicType<String> stringType = this.stringType;
        if (stringType == null) {
            this.stringType = this.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING);
            return this.stringType;
        }
        return stringType;
    }

    public FunctionReturnTypeResolver getSumReturnTypeResolver() {
        FunctionReturnTypeResolver resolver = this.sumReturnTypeResolver;
        if (resolver == null) {
            this.sumReturnTypeResolver = new SumReturnTypeResolver(this.getTypeConfiguration());
            return this.sumReturnTypeResolver;
        }
        return resolver;
    }

    public FunctionReturnTypeResolver getAvgReturnTypeResolver() {
        FunctionReturnTypeResolver resolver = this.avgReturnTypeResolver;
        if (resolver == null) {
            this.avgReturnTypeResolver = new AvgFunction.ReturnTypeResolver(this.getTypeConfiguration());
            return this.avgReturnTypeResolver;
        }
        return resolver;
    }

    @Override
    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public JpaMetamodel getJpaMetamodel() {
        return this.bindingContext.getJpaMetamodel();
    }

    @Override
    public SqmSelectStatement<Object> createQuery() {
        return new SqmSelectStatement<Object>(Object.class, (NodeBuilder)this);
    }

    @Override
    public <T> SqmSelectStatement<T> createQuery(Class<T> resultClass) {
        return new SqmSelectStatement<T>(resultClass, (NodeBuilder)this);
    }

    @Override
    public <T> SqmSelectStatement<T> createQuery(String hql, Class<T> resultClass) {
        SqmStatement<T> statement = this.queryEngine.getHqlTranslator().translate(hql, resultClass);
        if (statement instanceof SqmSelectStatement) {
            return new SqmSelectStatement((SqmSelectStatement)statement);
        }
        throw new IllegalArgumentException("Not a 'select' statement");
    }

    @Override
    public SqmSelectStatement<Tuple> createTupleQuery() {
        return new SqmSelectStatement<Tuple>(Tuple.class, (NodeBuilder)this);
    }

    @Override
    public <T> SqmUpdateStatement<T> createCriteriaUpdate(Class<T> targetEntity) {
        return new SqmUpdateStatement<T>(targetEntity, this);
    }

    @Override
    public <T> SqmDeleteStatement<T> createCriteriaDelete(Class<T> targetEntity) {
        return new SqmDeleteStatement<T>(targetEntity, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInsertValuesStatement<T> createCriteriaInsertValues(Class<T> targetEntity) {
        return new SqmInsertValuesStatement<T>(targetEntity, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInsertSelectStatement<T> createCriteriaInsertSelect(Class<T> targetEntity) {
        return new SqmInsertSelectStatement<T>(targetEntity, (NodeBuilder)this);
    }

    @Override
    public SqmValues values(Expression<?> ... expressions) {
        return this.values(Arrays.asList(expressions));
    }

    @Override
    public SqmValues values(List<? extends Expression<?>> expressions) {
        return new SqmValues(expressions);
    }

    @Override
    public <T> JpaCriteriaQuery<T> union(boolean all, CriteriaQuery<? extends T> query1, CriteriaQuery<?> ... queries) {
        return this.setOperation(all ? SetOperator.UNION_ALL : SetOperator.UNION, query1, queries);
    }

    @Override
    public <T> JpaCriteriaQuery<T> intersect(boolean all, CriteriaQuery<? extends T> query1, CriteriaQuery<?> ... queries) {
        return this.setOperation(all ? SetOperator.INTERSECT_ALL : SetOperator.INTERSECT, query1, queries);
    }

    @Override
    public <T> JpaCriteriaQuery<T> except(boolean all, CriteriaQuery<? extends T> query1, CriteriaQuery<?> ... queries) {
        return this.setOperation(all ? SetOperator.EXCEPT_ALL : SetOperator.EXCEPT, query1, queries);
    }

    public <T> JpaCriteriaSelect<T> union(CriteriaSelect<? extends T> left, CriteriaSelect<? extends T> right) {
        if (left instanceof Subquery) {
            assert (right instanceof Subquery);
            return this.setOperation(SetOperator.UNION, (Subquery)((Object)left), (Subquery)((Object)right));
        }
        return this.setOperation(SetOperator.UNION, (JpaCriteriaQuery)left, (JpaCriteriaQuery)right);
    }

    @Override
    public <T> JpaSubQuery<T> union(boolean all, Subquery<? extends T> query1, Subquery<?> ... queries) {
        return this.setOperation(all ? SetOperator.UNION_ALL : SetOperator.UNION, query1, queries);
    }

    @Override
    public <T> CriteriaSelect<T> unionAll(CriteriaSelect<? extends T> left, CriteriaSelect<? extends T> right) {
        if (left instanceof Subquery) {
            assert (right instanceof Subquery);
            return this.setOperation(SetOperator.UNION_ALL, (Subquery)((Object)left), (Subquery)((Object)right));
        }
        return this.setOperation(SetOperator.UNION_ALL, (JpaCriteriaQuery)left, (JpaCriteriaQuery)right);
    }

    @Override
    public <T> JpaSubQuery<T> intersect(boolean all, Subquery<? extends T> query1, Subquery<?> ... queries) {
        return this.setOperation(all ? SetOperator.INTERSECT_ALL : SetOperator.INTERSECT, query1, queries);
    }

    @Override
    public <T> CriteriaSelect<T> except(CriteriaSelect<T> left, CriteriaSelect<?> right) {
        if (left instanceof Subquery) {
            assert (right instanceof Subquery);
            return this.setOperation(SetOperator.EXCEPT, (Subquery)((Object)left), (Subquery)((Object)right));
        }
        return this.setOperation(SetOperator.EXCEPT, (JpaCriteriaQuery)left, (JpaCriteriaQuery)right);
    }

    @Override
    public <T> CriteriaSelect<T> exceptAll(CriteriaSelect<T> left, CriteriaSelect<?> right) {
        if (left instanceof Subquery) {
            assert (right instanceof Subquery);
            return this.setOperation(SetOperator.EXCEPT_ALL, (Subquery)((Object)left), (Subquery)((Object)right));
        }
        return this.setOperation(SetOperator.EXCEPT_ALL, (JpaCriteriaQuery)left, (JpaCriteriaQuery)right);
    }

    @Override
    public <T> JpaSubQuery<T> except(boolean all, Subquery<? extends T> query1, Subquery<?> ... queries) {
        return this.setOperation(all ? SetOperator.EXCEPT_ALL : SetOperator.EXCEPT, query1, queries);
    }

    private <T> JpaCriteriaQuery<T> setOperation(SetOperator operator, CriteriaQuery<? extends T> criteriaQuery, CriteriaQuery<?> ... queries) {
        Class resultType = criteriaQuery.getResultType();
        ArrayList<SqmQueryPart<T>> queryParts = new ArrayList<SqmQueryPart<T>>(queries.length + 1);
        LinkedHashMap cteStatements = new LinkedHashMap();
        SqmSelectStatement selectStatement = (SqmSelectStatement)criteriaQuery;
        this.collectQueryPartsAndCtes(selectStatement, queryParts, cteStatements);
        for (CriteriaQuery<?> query : queries) {
            if (query.getResultType() != resultType) {
                throw new IllegalArgumentException("Result type of all operands must match");
            }
            this.collectQueryPartsAndCtes((SqmSelectQuery)((Object)query), queryParts, cteStatements);
        }
        return new SqmSelectStatement<T>(new SqmQueryGroup<T>(this, operator, queryParts), resultType, cteStatements, selectStatement.getQuerySource(), this);
    }

    private <T> JpaSubQuery<T> setOperation(SetOperator operator, Subquery<? extends T> subquery, Subquery<?> ... queries) {
        Class resultType = subquery.getResultType();
        SqmQuery parent = (SqmQuery)((Object)subquery.getParent());
        ArrayList<SqmQueryPart<T>> queryParts = new ArrayList<SqmQueryPart<T>>(queries.length + 1);
        LinkedHashMap cteStatements = new LinkedHashMap();
        this.collectQueryPartsAndCtes((SqmSelectQuery)((Object)subquery), queryParts, cteStatements);
        for (Subquery<?> query : queries) {
            if (query.getResultType() != resultType) {
                throw new IllegalArgumentException("Result type of all operands must match");
            }
            if (query.getParent() != parent) {
                throw new IllegalArgumentException("Subquery parent of all operands must match");
            }
            this.collectQueryPartsAndCtes((SqmSelectQuery)((Object)query), queryParts, cteStatements);
        }
        return new SqmSubQuery<T>(parent, new SqmQueryGroup<T>(this, operator, queryParts), resultType, cteStatements, this);
    }

    private <T> void collectQueryPartsAndCtes(SqmSelectQuery<T> query, List<SqmQueryPart<T>> queryParts, Map<String, SqmCteStatement<?>> cteStatements) {
        queryParts.add((SqmQueryPart<T>)query.getQueryPart());
        for (SqmCteStatement<?> cteStatement : query.getCteStatements()) {
            String name = cteStatement.getCteTable().getCteName();
            SqmCteStatement<?> old = cteStatements.put(name, cteStatement);
            if (old == null || old == cteStatement) continue;
            throw new IllegalArgumentException(String.format("Different CTE with same name [%s] found in different set operands!", name));
        }
    }

    @Override
    public <X, T> SqmExpression<X> cast(JpaExpression<T> expression, Class<X> castTargetJavaType) {
        return this.cast((JpaExpression)expression, this.castTarget((Class)castTargetJavaType));
    }

    @Override
    public <X, T> SqmExpression<X> cast(JpaExpression<T> expression, JpaCastTarget<X> castTarget) {
        SqmCastTarget sqmCastTarget = (SqmCastTarget)castTarget;
        return this.getFunctionDescriptor("cast").generateSqmExpression((List<? extends SqmTypedNode<?>>)Arrays.asList((SqmTypedNode)((Object)expression), sqmCastTarget), sqmCastTarget.getType(), this.queryEngine);
    }

    @Override
    public <X> SqmCastTarget<X> castTarget(Class<X> castTargetJavaType) {
        return this.castTarget(castTargetJavaType, null, null, null);
    }

    @Override
    public <X> SqmCastTarget<X> castTarget(Class<X> castTargetJavaType, long length) {
        return this.castTarget(castTargetJavaType, length, null, null);
    }

    @Override
    public <X> SqmCastTarget<X> castTarget(Class<X> castTargetJavaType, int precision, int scale) {
        return this.castTarget(castTargetJavaType, null, precision, scale);
    }

    private <X> SqmCastTarget<X> castTarget(Class<X> castTargetJavaType, @Nullable Long length, @Nullable Integer precision, @Nullable Integer scale) {
        BasicType<X> type = this.getTypeConfiguration().standardBasicTypeForJavaType(castTargetJavaType);
        return new SqmCastTarget<X>(type, length, precision, scale, this);
    }

    @Override
    public SqmPredicate wrap(Expression<Boolean> expression) {
        SqmPredicate sqmPredicate;
        if (expression instanceof SqmPredicate) {
            SqmPredicate predicate = (SqmPredicate)expression;
            sqmPredicate = predicate;
        } else {
            sqmPredicate = new SqmBooleanExpressionPredicate((SqmExpression)expression, (NodeBuilder)this);
        }
        return sqmPredicate;
    }

    @Override
    @SafeVarargs
    public final SqmPredicate wrap(Expression<Boolean> ... expressions) {
        if (expressions.length == 1) {
            return this.wrap((Expression)expressions[0]);
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(expressions.length);
        for (Expression<Boolean> expression : expressions) {
            predicates.add((SqmPredicate)this.wrap((Expression)expression));
        }
        return new SqmJunctionPredicate(Predicate.BooleanOperator.AND, predicates, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate wrap(List<? extends Expression<Boolean>> restrictions) {
        if (restrictions.size() == 1) {
            return this.wrap((Expression)restrictions.get(0));
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(restrictions.size());
        for (Expression<Boolean> expression : restrictions) {
            predicates.add((SqmPredicate)this.wrap((Expression)expression));
        }
        return new SqmJunctionPredicate(Predicate.BooleanOperator.AND, predicates, (NodeBuilder)this);
    }

    @Override
    public <T extends HibernateCriteriaBuilder> T unwrap(Class<T> clazz) {
        return (T)this.extensions.get(clazz);
    }

    public SqmPath<?> fk(Path<?> path) {
        boolean validToOneRef;
        SqmPath sqmPath = (SqmPath)path;
        SqmPathSource<?> toOneReference = sqmPath.getReferencedPathSource();
        boolean bl = validToOneRef = toOneReference.getBindableType() == Bindable.BindableType.SINGULAR_ATTRIBUTE && toOneReference instanceof EntitySqmPathSource;
        if (!validToOneRef) {
            throw new FunctionArgumentException(String.format(Locale.ROOT, "Argument '%s' of 'fk()' function is not a single-valued association", sqmPath.getNavigablePath()));
        }
        return new SqmFkExpression(sqmPath);
    }

    @Override
    public <X, T extends X> SqmPath<T> treat(Path<X> path, Class<T> type) {
        return ((SqmPath)path).treatAs(type);
    }

    @Override
    public <X, T extends X> SqmRoot<T> treat(Root<X> root, Class<T> type) {
        return (SqmTreatedRoot)((SqmRoot)root).treatAs(type);
    }

    @Override
    public <T> JpaCriteriaQuery<T> union(CriteriaQuery<? extends T> left, CriteriaQuery<? extends T> right) {
        return SqmCriteriaNodeBuilder.createUnionSet(SetOperator.UNION, left, right);
    }

    @Override
    public <T> JpaCriteriaQuery<T> unionAll(CriteriaQuery<? extends T> left, CriteriaQuery<? extends T> right) {
        return SqmCriteriaNodeBuilder.createUnionSet(SetOperator.UNION_ALL, left, right);
    }

    @Override
    public <T> CriteriaSelect<T> intersect(CriteriaSelect<? super T> left, CriteriaSelect<? super T> right) {
        if (left instanceof Subquery) {
            assert (right instanceof Subquery);
            return this.setOperation(SetOperator.INTERSECT, (Subquery)((Object)left), (Subquery)((Object)right));
        }
        return this.setOperation(SetOperator.INTERSECT, (JpaCriteriaQuery)left, (JpaCriteriaQuery)right);
    }

    @Override
    public <T> CriteriaSelect<T> intersectAll(CriteriaSelect<? super T> left, CriteriaSelect<? super T> right) {
        if (left instanceof Subquery) {
            assert (right instanceof Subquery);
            return this.setOperation(SetOperator.INTERSECT_ALL, (Subquery)((Object)left), (Subquery)((Object)right));
        }
        return this.setOperation(SetOperator.INTERSECT_ALL, (JpaCriteriaQuery)left, (JpaCriteriaQuery)right);
    }

    private static <T> JpaCriteriaQuery<T> createUnionSet(SetOperator operator, CriteriaQuery<? extends T> left, CriteriaQuery<? extends T> right) {
        assert (operator == SetOperator.UNION || operator == SetOperator.UNION_ALL);
        SqmSelectStatement leftSqm = (SqmSelectStatement)left;
        SqmSelectStatement rightSqm = (SqmSelectStatement)right;
        SqmQueryGroup sqmQueryGroup = new SqmQueryGroup(leftSqm.nodeBuilder(), operator, List.of(leftSqm.getQueryPart(), rightSqm.getQueryPart()));
        SqmSelectStatement sqmSelectStatement = new SqmSelectStatement(leftSqm.getResultType(), SqmQuerySource.CRITERIA, leftSqm.nodeBuilder());
        sqmSelectStatement.setQueryPart(sqmQueryGroup);
        return sqmSelectStatement;
    }

    @Override
    public <T> JpaCriteriaQuery<T> intersect(CriteriaQuery<? super T> left, CriteriaQuery<? super T> right) {
        return SqmCriteriaNodeBuilder.createIntersectSet(SetOperator.INTERSECT, left, right);
    }

    @Override
    public <T> JpaCriteriaQuery<T> intersectAll(CriteriaQuery<? super T> left, CriteriaQuery<? super T> right) {
        return SqmCriteriaNodeBuilder.createIntersectSet(SetOperator.INTERSECT_ALL, left, right);
    }

    private static <T> JpaCriteriaQuery<T> createIntersectSet(SetOperator operator, CriteriaQuery<? super T> left, CriteriaQuery<? super T> right) {
        assert (operator == SetOperator.INTERSECT || operator == SetOperator.INTERSECT_ALL);
        SqmSelectStatement leftSqm = (SqmSelectStatement)left;
        SqmSelectStatement rightSqm = (SqmSelectStatement)right;
        SqmQueryGroup sqmQueryGroup = new SqmQueryGroup(leftSqm.nodeBuilder(), operator, List.of(leftSqm.getQueryPart(), rightSqm.getQueryPart()));
        SqmSelectStatement sqmSelectStatement = new SqmSelectStatement(leftSqm.getResultType(), SqmQuerySource.CRITERIA, leftSqm.nodeBuilder());
        sqmSelectStatement.setQueryPart(sqmQueryGroup);
        return sqmSelectStatement;
    }

    @Override
    public <T> JpaCriteriaQuery<T> except(CriteriaQuery<T> left, CriteriaQuery<?> right) {
        return SqmCriteriaNodeBuilder.createExceptSet(SetOperator.EXCEPT, left, right);
    }

    @Override
    public <T> JpaCriteriaQuery<T> exceptAll(CriteriaQuery<T> left, CriteriaQuery<?> right) {
        return SqmCriteriaNodeBuilder.createExceptSet(SetOperator.EXCEPT_ALL, left, right);
    }

    private static <T> JpaCriteriaQuery<T> createExceptSet(SetOperator operator, CriteriaQuery<T> left, CriteriaQuery<?> right) {
        assert (operator == SetOperator.EXCEPT || operator == SetOperator.EXCEPT_ALL);
        SqmSelectStatement leftSqm = (SqmSelectStatement)left;
        SqmSelectStatement rightSqm = (SqmSelectStatement)right;
        SqmQueryGroup sqmQueryGroup = new SqmQueryGroup(leftSqm.nodeBuilder(), operator, List.of(leftSqm.getQueryPart(), rightSqm.getQueryPart()));
        SqmSelectStatement sqmSelectStatement = new SqmSelectStatement(leftSqm.getResultType(), SqmQuerySource.CRITERIA, leftSqm.nodeBuilder());
        sqmSelectStatement.setQueryPart(sqmQueryGroup);
        return sqmSelectStatement;
    }

    @Override
    public <X, T, V extends T> SqmSingularJoin<X, V> treat(Join<X, T> join, Class<V> type) {
        return (SqmTreatedSingularJoin)((SqmSingularJoin)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> SqmBagJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        return ((SqmBagJoin)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> SqmSetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        return ((SqmSetJoin)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> SqmListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        return ((SqmListJoin)join).treatAs(type);
    }

    @Override
    public <X, K, T, V extends T> SqmMapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        return ((SqmMapJoin)join).treatAs(type);
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder, nullPrecedence);
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression, SortDirection sortOrder, Nulls nullPrecedence, boolean ignoreCase) {
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder, nullPrecedence, ignoreCase);
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression, SortDirection sortOrder) {
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder);
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression) {
        return new SqmSortSpecification((SqmExpression)sortExpression);
    }

    @Override
    public SqmSortSpecification asc(Expression<?> x) {
        return new SqmSortSpecification((SqmExpression)x, SortDirection.ASCENDING);
    }

    @Override
    public SqmSortSpecification desc(Expression<?> x) {
        return new SqmSortSpecification((SqmExpression)x, SortDirection.DESCENDING);
    }

    @Override
    public Order asc(Expression<?> expression, Nulls nullPrecedence) {
        return new SqmSortSpecification((SqmExpression)expression, SortDirection.ASCENDING, nullPrecedence);
    }

    @Override
    public Order desc(Expression<?> expression, Nulls nullPrecedence) {
        return new SqmSortSpecification((SqmExpression)expression, SortDirection.DESCENDING, nullPrecedence);
    }

    @Override
    public JpaOrder asc(Expression<?> x, boolean nullsFirst) {
        return new SqmSortSpecification((SqmExpression)x, SortDirection.ASCENDING, nullsFirst ? Nulls.FIRST : Nulls.LAST);
    }

    @Override
    public JpaOrder desc(Expression<?> x, boolean nullsFirst) {
        return new SqmSortSpecification((SqmExpression)x, SortDirection.DESCENDING, nullsFirst ? Nulls.FIRST : Nulls.LAST);
    }

    @Override
    public JpaSearchOrder search(JpaCteCriteriaAttribute sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)sortExpression, sortOrder, nullPrecedence);
    }

    @Override
    public JpaSearchOrder search(JpaCteCriteriaAttribute sortExpression, SortDirection sortOrder) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)sortExpression, sortOrder, Nulls.NONE);
    }

    @Override
    public JpaSearchOrder search(JpaCteCriteriaAttribute sortExpression) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)sortExpression, SortDirection.ASCENDING, Nulls.NONE);
    }

    @Override
    public JpaSearchOrder asc(JpaCteCriteriaAttribute x) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)x, SortDirection.ASCENDING, Nulls.NONE);
    }

    @Override
    public JpaSearchOrder desc(JpaCteCriteriaAttribute x) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)x, SortDirection.DESCENDING, Nulls.NONE);
    }

    @Override
    public JpaSearchOrder asc(JpaCteCriteriaAttribute x, boolean nullsFirst) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)x, SortDirection.ASCENDING, nullsFirst ? Nulls.FIRST : Nulls.LAST);
    }

    @Override
    public JpaSearchOrder desc(JpaCteCriteriaAttribute x, boolean nullsFirst) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)x, SortDirection.DESCENDING, nullsFirst ? Nulls.FIRST : Nulls.LAST);
    }

    @Override
    public JpaCompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return this.tuple((List)Arrays.asList(selections));
    }

    @Override
    public JpaCompoundSelection<Tuple> tuple(List<Selection<?>> selections) {
        this.checkMultiselect(selections);
        return new SqmJpaCompoundSelection<Tuple>(selections.stream().map(selection -> (SqmSelectableNode)selection).toList(), this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Tuple.class)), this);
    }

    @Override
    @Deprecated(since="7", forRemoval=true)
    public <R> SqmTuple<R> tuple(Class<R> tupleType, SqmExpression<?> ... expressions) {
        return this.tuple(tupleType, Arrays.asList(expressions));
    }

    @Override
    @Deprecated(since="7", forRemoval=true)
    public <R> SqmTuple<R> tuple(SqmExpressible<R> tupleType, SqmExpression<?> ... expressions) {
        return this.tuple(tupleType, Arrays.asList(expressions));
    }

    @Override
    @Deprecated(since="7", forRemoval=true)
    public <R> SqmTuple<R> tuple(Class<R> tupleType, List<? extends SqmExpression<?>> expressions) {
        SqmDomainType expressibleType = tupleType == null || tupleType == Object[].class ? (SqmDomainType)this.getTypeConfiguration().resolveTupleType(expressions) : (SqmEmbeddableDomainType)this.getDomainModel().embeddable(tupleType);
        return this.tuple(expressibleType, expressions);
    }

    @Override
    @Deprecated(since="7", forRemoval=true)
    public <R> SqmTuple<R> tuple(SqmExpressible<R> tupleType, List<? extends SqmExpression<?>> sqmExpressions) {
        if (tupleType == null) {
            tupleType = (SqmDomainType)this.getTypeConfiguration().resolveTupleType(sqmExpressions);
        }
        return new SqmTuple(new ArrayList(sqmExpressions), (SqmBindableType)tupleType, this);
    }

    @Override
    public JpaCompoundSelection<Object[]> array(Selection<?> ... selections) {
        return this.array(Object[].class, Arrays.stream(selections).map(selection -> (SqmSelectableNode)selection).toList());
    }

    @Override
    public JpaCompoundSelection<Object[]> array(List<Selection<?>> selections) {
        return this.arrayInternal(Object[].class, selections.stream().map(selection -> (SqmSelectableNode)selection).toList());
    }

    @Override
    public <Y> JpaCompoundSelection<Y> array(Class<Y> resultClass, Selection<?> ... selections) {
        return this.arrayInternal(resultClass, Arrays.stream(selections).map(selection -> (SqmSelectableNode)selection).toList());
    }

    @Override
    public <Y> JpaCompoundSelection<Y> array(Class<Y> resultClass, List<? extends Selection<?>> selections) {
        return this.arrayInternal(resultClass, selections.stream().map(selection -> (SqmSelectableNode)selection).toList());
    }

    public <Y> JpaCompoundSelection<Y> arrayInternal(Class<Y> resultClass, List<? extends SqmSelectableNode<?>> selections) {
        this.checkMultiselect(selections);
        JavaType javaType = this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(resultClass);
        return new SqmJpaCompoundSelection(selections, javaType, this);
    }

    @Override
    public <Y> JpaCompoundSelection<Y> construct(Class<Y> resultClass, Selection<?> ... arguments) {
        return this.constructInternal(resultClass, Arrays.stream(arguments).map(arg -> (SqmSelectableNode)arg).toList());
    }

    @Override
    public <Y> JpaCompoundSelection<Y> construct(Class<Y> resultClass, List<? extends Selection<?>> arguments) {
        return this.constructInternal(resultClass, arguments.stream().map(arg -> (SqmSelectableNode)arg).toList());
    }

    private <Y> JpaCompoundSelection<Y> constructInternal(Class<Y> resultClass, List<? extends SqmSelectableNode<?>> arguments) {
        this.checkMultiselect(arguments);
        if (List.class.equals(resultClass)) {
            return SqmDynamicInstantiation.listInstantiation(arguments, this);
        }
        if (Map.class.equals(resultClass)) {
            return SqmDynamicInstantiation.mapInstantiation(arguments, this);
        }
        return SqmDynamicInstantiation.classInstantiation(resultClass, arguments, this);
    }

    private void checkMultiselect(List<? extends Selection<?>> selections) {
        HashSet<String> aliases = new HashSet<String>(CollectionHelper.determineProperSizing(selections.size()));
        for (Selection<?> selection : selections) {
            String alias;
            if (selection.isCompoundSelection()) {
                Class javaType = selection.getJavaType();
                if (javaType.isArray()) {
                    throw new IllegalArgumentException("Selection item in a multi-select cannot contain compound array-valued elements");
                }
                if (Tuple.class.isAssignableFrom(javaType)) {
                    throw new IllegalArgumentException("Selection item in a multi-select cannot contain compound tuple-valued elements");
                }
            }
            if (!StringHelper.isNotEmpty(alias = selection.getAlias()) || aliases.add(alias)) continue;
            throw new IllegalArgumentException("Multi-select expressions have duplicate alias '" + alias + "'");
        }
    }

    @Override
    public <N extends Number> SqmExpression<Double> avg(Expression<N> argument) {
        return this.getFunctionDescriptor("avg").generateSqmExpression((SqmTypedNode)((Object)argument), null, this.queryEngine);
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(Expression<N> argument) {
        SqmTypedNode typedNode = (SqmTypedNode)((Object)argument);
        return this.getFunctionDescriptor("sum").generateSqmExpression(typedNode, (ReturnableType)((Object)typedNode.getExpressible().getSqmType()), this.queryEngine);
    }

    @Override
    public SqmExpression<Long> sumAsLong(Expression<Integer> argument) {
        return this.getFunctionDescriptor("sum").generateSqmExpression((SqmTypedNode)((Object)argument), null, this.queryEngine);
    }

    @Override
    public SqmExpression<Double> sumAsDouble(Expression<Float> argument) {
        return this.getFunctionDescriptor("sum").generateSqmExpression((SqmTypedNode)((Object)argument), null, this.queryEngine);
    }

    @Override
    public <N extends Number> SqmExpression<N> max(Expression<N> argument) {
        return this.getFunctionDescriptor("max").generateSqmExpression((SqmTypedNode)((Object)argument), null, this.queryEngine);
    }

    @Override
    public <N extends Number> SqmExpression<N> min(Expression<N> argument) {
        return this.getFunctionDescriptor("min").generateSqmExpression((SqmTypedNode)((Object)argument), null, this.queryEngine);
    }

    @Override
    public <X extends Comparable<? super X>> SqmExpression<X> greatest(Expression<X> argument) {
        return this.queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("max").generateSqmExpression((SqmTypedNode)((Object)argument), null, this.queryEngine);
    }

    @Override
    public <X extends Comparable<? super X>> SqmExpression<X> least(Expression<X> argument) {
        return this.queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("min").generateSqmExpression((SqmTypedNode)((Object)argument), null, this.queryEngine);
    }

    @Override
    public SqmExpression<Long> count(Expression<?> argument) {
        return this.getFunctionDescriptor("count").generateSqmExpression((SqmTypedNode)((Object)argument), null, this.queryEngine);
    }

    @Override
    public SqmExpression<Long> countDistinct(Expression<?> argument) {
        return this.getFunctionDescriptor("count").generateSqmExpression(new SqmDistinct((SqmExpression)argument, this), null, this.queryEngine);
    }

    @Override
    public SqmExpression<Long> count() {
        return this.getFunctionDescriptor("count").generateSqmExpression(new SqmStar(this), null, this.queryEngine);
    }

    @Override
    public JpaExpression<Integer> sign(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("sign").generateSqmExpression((SqmExpression)x, null, this.queryEngine);
    }

    @Override
    public <N extends Number> JpaExpression<N> ceiling(Expression<N> x) {
        return this.getFunctionDescriptor("ceiling").generateSqmExpression((SqmExpression)x, null, this.queryEngine);
    }

    @Override
    public <N extends Number> JpaExpression<N> floor(Expression<N> x) {
        return this.getFunctionDescriptor("floor").generateSqmExpression((SqmExpression)x, null, this.queryEngine);
    }

    @Override
    public JpaExpression<Double> exp(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("exp").generateSqmExpression((SqmExpression)x, null, this.queryEngine);
    }

    @Override
    public JpaExpression<Double> ln(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("ln").generateSqmExpression((SqmExpression)x, null, this.queryEngine);
    }

    @Override
    public JpaExpression<Double> power(Expression<? extends Number> x, Expression<? extends Number> y) {
        return this.getFunctionDescriptor("power").generateSqmExpression(Arrays.asList((SqmExpression)x, (SqmExpression)y), null, this.queryEngine);
    }

    @Override
    public JpaExpression<Double> power(Expression<? extends Number> x, Number y) {
        return this.getFunctionDescriptor("power").generateSqmExpression(Arrays.asList((SqmExpression)x, this.value(y)), null, this.queryEngine);
    }

    @Override
    public <T extends Number> JpaExpression<T> round(Expression<T> x, Integer n) {
        return this.getFunctionDescriptor("round").generateSqmExpression(Arrays.asList((SqmExpression)x, this.value(n)), null, this.queryEngine);
    }

    @Override
    public <T extends Number> JpaExpression<T> truncate(Expression<T> x, Integer n) {
        return this.getFunctionDescriptor("truncate").generateSqmExpression(Arrays.asList((SqmExpression)x, this.value(n)), null, this.queryEngine);
    }

    @Override
    public <N extends Number> SqmExpression<N> neg(Expression<N> x) {
        SqmExpression sqmExpression = (SqmExpression)x;
        return new SqmUnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, sqmExpression);
    }

    @Override
    public <N extends Number> SqmExpression<N> abs(Expression<N> x) {
        return this.getFunctionDescriptor("abs").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    @Override
    public JpaExpression<Duration> duration(long magnitude, TemporalUnit unit) {
        return new SqmToDuration<Duration>(this.literal((Object)magnitude), new SqmDurationUnit<Long>(unit, this.getLongType(), this), this.getTypeConfiguration().standardBasicTypeForJavaType(Duration.class), this);
    }

    @Override
    public JpaExpression<Long> durationByUnit(TemporalUnit unit, Expression<Duration> duration) {
        return new SqmByUnit(new SqmDurationUnit<Long>(unit, this.getLongType(), this), (SqmExpression)duration, this.getLongType(), this);
    }

    @Override
    public JpaExpression<Duration> durationSum(Expression<Duration> x, Expression<Duration> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public JpaExpression<Duration> durationSum(Expression<Duration> x, Duration y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)x, (SqmExpression<?>)this.value(y));
    }

    @Override
    public JpaExpression<Duration> durationDiff(Expression<Duration> x, Expression<Duration> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public JpaExpression<Duration> durationDiff(Expression<Duration> x, Duration y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, (SqmExpression<?>)this.value(y));
    }

    @Override
    public JpaExpression<Duration> durationScaled(Expression<? extends Number> number, Expression<Duration> duration) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MULTIPLY, (SqmExpression)number, (SqmExpression)duration);
    }

    @Override
    public JpaExpression<Duration> durationScaled(Number number, Expression<Duration> duration) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MULTIPLY, (SqmExpression<?>)this.value(number), (SqmExpression)duration);
    }

    @Override
    public JpaExpression<Duration> durationScaled(Expression<? extends Number> number, Duration duration) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MULTIPLY, (SqmExpression)number, (SqmExpression<?>)this.value(duration));
    }

    @Override
    public <T extends Temporal> JpaExpression<Duration> durationBetween(Expression<T> x, Expression<T> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public <T extends Temporal> JpaExpression<Duration> durationBetween(Expression<T> x, T y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, (SqmExpression<?>)this.value((Object)y));
    }

    @Override
    public <T extends Temporal> JpaExpression<T> addDuration(Expression<T> datetime, Expression<Duration> duration) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)datetime, (SqmExpression)duration);
    }

    @Override
    public <T extends Temporal> JpaExpression<T> addDuration(Expression<T> datetime, Duration duration) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)datetime, (SqmExpression<?>)this.value(duration));
    }

    @Override
    public <T extends Temporal> JpaExpression<T> addDuration(T datetime, Expression<Duration> duration) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression<?>)this.value((Object)datetime), (SqmExpression)duration);
    }

    @Override
    public <T extends Temporal> JpaExpression<T> subtractDuration(Expression<T> datetime, Expression<Duration> duration) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)datetime, (SqmExpression)duration);
    }

    @Override
    public <T extends Temporal> JpaExpression<T> subtractDuration(Expression<T> datetime, Duration duration) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)datetime, (SqmExpression<?>)this.value(duration));
    }

    @Override
    public <T extends Temporal> JpaExpression<T> subtractDuration(T datetime, Expression<Duration> duration) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression<?>)this.value((Object)datetime), (SqmExpression)duration);
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(Expression<? extends N> x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)x, (SqmExpression)y);
    }

    private <N> SqmExpression<N> createSqmArithmeticNode(BinaryArithmeticOperator operator, SqmExpression<?> leftHandExpression, SqmExpression<?> rightHandExpression) {
        SqmExpressible<?> arithmeticType = this.getTypeConfiguration().resolveArithmeticType(leftHandExpression.getNodeType(), rightHandExpression.getNodeType(), operator);
        SqmBindableType castType = (SqmBindableType)arithmeticType;
        return new SqmBinaryArithmetic(operator, leftHandExpression, rightHandExpression, castType, this);
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(Expression<? extends N> x, N y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)x, (SqmExpression<?>)this.value(y));
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(N x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression<?>)this.value(x), (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> prod(Expression<? extends N> x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MULTIPLY, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> prod(Expression<? extends N> x, N y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MULTIPLY, (SqmExpression)x, (SqmExpression<?>)this.value(y));
    }

    @Override
    public <N extends Number> SqmExpression<N> prod(N x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MULTIPLY, (SqmExpression<?>)this.value(x), (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> diff(Expression<? extends N> x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> diff(Expression<? extends N> x, N y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, (SqmExpression<?>)this.value(y));
    }

    @Override
    public <N extends Number> SqmExpression<N> diff(N x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression<?>)this.value(x), (SqmExpression)y);
    }

    @Override
    public SqmExpression<Number> quot(Expression<? extends Number> x, Expression<? extends Number> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.QUOT, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public SqmExpression<Number> quot(Expression<? extends Number> x, Number y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.QUOT, (SqmExpression)x, (SqmExpression<?>)this.value(y));
    }

    @Override
    public SqmExpression<Number> quot(Number x, Expression<? extends Number> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.QUOT, (SqmExpression<?>)this.value(x), (SqmExpression)y);
    }

    @Override
    public SqmExpression<Integer> mod(Expression<Integer> x, Expression<Integer> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MODULO, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public SqmExpression<Integer> mod(Expression<Integer> x, Integer y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MODULO, (SqmExpression)x, (SqmExpression<?>)this.value(y));
    }

    @Override
    public SqmExpression<Integer> mod(Integer x, Expression<Integer> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MODULO, (SqmExpression<?>)this.value(x), (SqmExpression)y);
    }

    @Override
    public SqmExpression<Double> sqrt(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("sqrt").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    @Override
    public SqmExpression<Long> toLong(Expression<? extends Number> number) {
        return ((SqmExpression)number).asLong();
    }

    @Override
    public SqmExpression<Integer> toInteger(Expression<? extends Number> number) {
        return ((SqmExpression)number).asInteger();
    }

    @Override
    public SqmExpression<Float> toFloat(Expression<? extends Number> number) {
        return ((SqmExpression)number).asFloat();
    }

    @Override
    public SqmExpression<Double> toDouble(Expression<? extends Number> number) {
        return ((SqmExpression)number).asDouble();
    }

    @Override
    public SqmExpression<BigDecimal> toBigDecimal(Expression<? extends Number> number) {
        return ((SqmExpression)number).asBigDecimal();
    }

    @Override
    public SqmExpression<BigInteger> toBigInteger(Expression<? extends Number> number) {
        return ((SqmExpression)number).asBigInteger();
    }

    @Override
    public SqmExpression<String> toString(Expression<Character> character) {
        return ((SqmExpression)character).asString();
    }

    public <T> SqmLiteral<T> literal(T value, SqmExpression<? extends T> typeInferenceSource) {
        return value == null ? new SqmLiteralNull(this) : this.createLiteral(value, this.resolveInferredType(value, typeInferenceSource));
    }

    private <T> SqmLiteral<T> createLiteral(T value, SqmBindableType<T> expressible) {
        if (expressible.getExpressibleJavaType().isInstance(value)) {
            return new SqmLiteral<T>(value, expressible, this);
        }
        Object coercedValue = expressible.getExpressibleJavaType().coerce(value, this::getTypeConfiguration);
        return expressible.getExpressibleJavaType().isInstance(coercedValue) ? new SqmLiteral(coercedValue, expressible, this) : this.literal((Object)value);
    }

    private <T> SqmBindableType<? extends T> resolveInferredType(T value, SqmExpression<? extends T> typeInferenceSource) {
        if (typeInferenceSource != null) {
            return typeInferenceSource.getNodeType();
        }
        if (value == null) {
            return null;
        }
        return this.resolveInferredType(value);
    }

    private <T> BasicType<T> resolveInferredType(T value) {
        Class<T> type;
        TypeConfiguration typeConfiguration = this.getTypeConfiguration();
        BasicType<T> result = typeConfiguration.getBasicTypeForJavaType(type = ReflectHelper.getClass(value));
        if (result == null && value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return SqmCriteriaNodeBuilder.resolveEnumType(typeConfiguration, enumValue);
        }
        return result;
    }

    private static <E extends Enum<E>> BasicType<E> resolveEnumType(TypeConfiguration configuration, Enum<E> enumValue) {
        EnumJavaType<E> javaType = new EnumJavaType<E>(ReflectHelper.getClass(enumValue));
        JdbcType jdbcType = javaType.getRecommendedJdbcType(configuration.getCurrentBaseSqlTypeIndicators());
        return configuration.getBasicTypeRegistry().resolve(javaType, jdbcType);
    }

    public <T> SqmLiteral<T> literal(T value) {
        if (value == null) {
            if (this.jpaCompliance.isJpaQueryComplianceEnabled()) {
                throw new IllegalArgumentException("literal value cannot be null");
            }
            return new SqmLiteralNull(this);
        }
        return new SqmLiteral<T>(value, this.resolveExpressible(this.getParameterBindType(value)), this);
    }

    @Override
    public MappingMetamodelImplementor getMappingMetamodel() {
        return (MappingMetamodelImplementor)this.bindingContext.getMappingMetamodel();
    }

    @Override
    public <T> List<? extends SqmExpression<T>> literals(T[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SqmExpression> literals = new ArrayList<SqmExpression>();
        for (T value : values) {
            literals.add(this.literal((Object)value));
        }
        return literals;
    }

    @Override
    public <T> List<? extends SqmExpression<T>> literals(List<T> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SqmExpression> literals = new ArrayList<SqmExpression>();
        for (T value : values) {
            literals.add(this.literal((Object)value));
        }
        return literals;
    }

    @Override
    public <T> SqmExpression<T> nullLiteral(Class<T> resultClass) {
        if (resultClass.isEnum()) {
            return new SqmLiteralNull(this);
        }
        BasicType<T> basicTypeForJavaType = this.getTypeConfiguration().getBasicTypeForJavaType(resultClass);
        BasicType<T> sqmExpressible = basicTypeForJavaType == null ? this.resolveExpressible(this.getDomainModel().managedType(resultClass)) : basicTypeForJavaType;
        return new SqmLiteralNull<T>(sqmExpressible, (NodeBuilder)this);
    }

    public <T> JpaCriteriaParameter<T> parameter(Class<T> paramClass) {
        return this.parameter((Class)paramClass, (String)null);
    }

    public <T> JpaCriteriaParameter<T> parameter(Class<T> paramClass, String name) {
        BasicType<T> basicType = this.getTypeConfiguration().getBasicTypeForJavaType(paramClass);
        boolean notBasic = basicType == null;
        BasicType<T> parameterType = notBasic && Collection.class.isAssignableFrom(paramClass) ? new MultiValueParameterType<Collection>(Collection.class) : basicType;
        return new JpaCriteriaParameter<T>(name, parameterType, notBasic, this);
    }

    @Override
    public <T> JpaParameterExpression<List<T>> listParameter(Class<T> paramClass) {
        return this.listParameter(paramClass, null);
    }

    @Override
    public <T> JpaParameterExpression<List<T>> listParameter(Class<T> paramClass, String name) {
        MultiValueParameterType<List> parameterType = new MultiValueParameterType<List>(List.class);
        return new JpaCriteriaParameter<List<T>>(name, parameterType, true, this);
    }

    public SqmExpression<String> concat(List<Expression<String>> expressions) {
        return this.getFunctionDescriptor("concat").generateSqmExpression(expressions, null, this.getQueryEngine());
    }

    @Override
    public SqmExpression<String> concat(Expression<String> x, Expression<String> y) {
        SqmExpression xSqmExpression = (SqmExpression)x;
        SqmExpression ySqmExpression = (SqmExpression)y;
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(xSqmExpression, ySqmExpression), null, this.getQueryEngine());
    }

    @Override
    public SqmExpression<String> concat(Expression<String> x, String y) {
        SqmExpression xSqmExpression = (SqmExpression)x;
        SqmExpression<String> ySqmExpression = this.value(y, xSqmExpression);
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(xSqmExpression, ySqmExpression), null, this.getQueryEngine());
    }

    @Override
    public SqmExpression<String> concat(String x, Expression<String> y) {
        SqmExpression ySqmExpression = (SqmExpression)y;
        SqmExpression<String> xSqmExpression = this.value(x, ySqmExpression);
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(xSqmExpression, ySqmExpression), null, this.getQueryEngine());
    }

    @Override
    public SqmExpression<String> concat(String x, String y) {
        JpaExpression xSqmExpression = this.value(x);
        SqmExpression<String> ySqmExpression = this.value((Object)y, (SqmExpression)xSqmExpression);
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(xSqmExpression, ySqmExpression), null, this.getQueryEngine());
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, Expression<Integer> from) {
        return this.createSubstringNode((SqmExpression)source, (SqmExpression)from, null);
    }

    private SqmFunction<String> createSubstringNode(SqmExpression<String> source, SqmExpression<Integer> from, SqmExpression<Integer> len) {
        return this.getFunctionDescriptor("substring").generateSqmExpression(len == null ? Arrays.asList(source, from) : Arrays.asList(source, from, len), null, this.getQueryEngine());
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, int from) {
        return this.createSubstringNode((SqmExpression)source, (SqmExpression<Integer>)this.value((Object)from), null);
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, Expression<Integer> from, Expression<Integer> len) {
        return this.createSubstringNode((SqmExpression)source, (SqmExpression)from, (SqmExpression)len);
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, int from, int len) {
        return this.createSubstringNode((SqmExpression)source, (SqmExpression<Integer>)this.value((Object)from), (SqmExpression<Integer>)this.value((Object)len));
    }

    @Override
    public SqmFunction<String> trim(Expression<String> source) {
        return this.createTrimNode(null, null, (SqmExpression)source);
    }

    private SqmFunction<String> createTrimNode(TrimSpec trimSpecification, SqmExpression<Character> trimCharacter, SqmExpression<String> source) {
        if (trimSpecification == null) {
            trimSpecification = TrimSpec.BOTH;
        }
        if (trimCharacter == null) {
            trimCharacter = new SqmLiteral<Character>(Character.valueOf(' '), this.getTypeConfiguration().standardBasicTypeForJavaType(Character.class), this);
        }
        ArrayList<SqmTypedNode<Object>> arguments = new ArrayList<SqmTypedNode<Object>>(3);
        arguments.add(new SqmTrimSpecification(trimSpecification, this));
        arguments.add(trimCharacter);
        arguments.add(source);
        return this.getFunctionDescriptor("trim").generateSqmExpression(arguments, null, this.getQueryEngine());
    }

    @Override
    public SqmFunction<String> trim(CriteriaBuilder.Trimspec ts, Expression<String> source) {
        return this.createTrimNode(TrimSpec.fromCriteriaTrimSpec(ts), null, (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(Expression<Character> trimChar, Expression<String> source) {
        return this.createTrimNode(null, (SqmExpression)trimChar, (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(CriteriaBuilder.Trimspec ts, Expression<Character> trimChar, Expression<String> source) {
        return this.createTrimNode(TrimSpec.fromCriteriaTrimSpec(ts), (SqmExpression)trimChar, (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(char trimChar, Expression<String> source) {
        return this.createTrimNode(null, this.literal(Character.valueOf(trimChar)), (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(CriteriaBuilder.Trimspec ts, char trimChar, Expression<String> source) {
        return this.createTrimNode(TrimSpec.fromCriteriaTrimSpec(ts), this.literal(Character.valueOf(trimChar)), (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> lower(Expression<String> x) {
        return this.getFunctionDescriptor("lower").generateSqmExpression((SqmExpression)x, null, this.getQueryEngine());
    }

    @Override
    public SqmFunction<String> upper(Expression<String> x) {
        return this.getFunctionDescriptor("upper").generateSqmExpression((SqmExpression)x, null, this.getQueryEngine());
    }

    @Override
    public SqmFunction<Integer> length(Expression<String> argument) {
        return this.getFunctionDescriptor("length").generateSqmExpression((SqmExpression)argument, null, this.getQueryEngine());
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, Expression<String> pattern) {
        return this.createLocateFunctionNode((SqmExpression)source, (SqmExpression)pattern, null);
    }

    private SqmFunction<Integer> createLocateFunctionNode(SqmExpression<String> source, SqmExpression<String> pattern, SqmExpression<Integer> startPosition) {
        List<SqmTypedNode> arguments = startPosition == null ? Arrays.asList(pattern, source) : Arrays.asList(pattern, source, startPosition);
        return this.getFunctionDescriptor("locate").generateSqmExpression(arguments, null, this.getQueryEngine());
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, String pattern) {
        return this.createLocateFunctionNode((SqmExpression)source, (SqmExpression<String>)this.value(pattern), null);
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, Expression<String> pattern, Expression<Integer> startPosition) {
        return this.createLocateFunctionNode((SqmExpression)source, (SqmExpression)pattern, (SqmExpression)startPosition);
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, String pattern, int startPosition) {
        return this.createLocateFunctionNode((SqmExpression)source, (SqmExpression<String>)this.value(pattern), (SqmExpression<Integer>)this.value((Object)startPosition));
    }

    @Override
    public SqmFunction<Date> currentDate() {
        return this.getFunctionDescriptor("current_date").generateSqmExpression(null, this.queryEngine);
    }

    @Override
    public SqmFunction<Timestamp> currentTimestamp() {
        return this.getFunctionDescriptor("current_timestamp").generateSqmExpression(null, this.queryEngine);
    }

    @Override
    public SqmFunction<Time> currentTime() {
        return this.getFunctionDescriptor("current_time").generateSqmExpression(null, this.queryEngine);
    }

    @Override
    public SqmFunction<Instant> currentInstant() {
        return this.getFunctionDescriptor("current_timestamp").generateSqmExpression(this.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INSTANT), this.queryEngine);
    }

    @Override
    public JpaExpression<LocalDate> localDate() {
        return this.getFunctionDescriptor("local_date").generateSqmExpression(null, this.queryEngine);
    }

    @Override
    public JpaExpression<LocalDateTime> localDateTime() {
        return this.getFunctionDescriptor("local_datetime").generateSqmExpression(null, this.queryEngine);
    }

    @Override
    public JpaExpression<LocalTime> localTime() {
        return this.getFunctionDescriptor("local_time").generateSqmExpression(null, this.queryEngine);
    }

    public SqmPath<?> id(Path<?> path) {
        return ((SqmPath)path).get("{id}");
    }

    public SqmPath<?> version(Path<?> path) {
        return ((SqmPath)path).get("{version}");
    }

    @Override
    public <T> SqmFunction<T> function(String name, Class<T> type, Expression<?>[] args) {
        BasicType<T> resultType = this.getTypeConfiguration().standardBasicTypeForJavaType(type);
        return this.getFunctionTemplate(name, resultType).generateSqmExpression(SqmCriteriaNodeBuilder.expressionList(args), resultType, this.getQueryEngine());
    }

    private <T> SqmFunctionDescriptor getFunctionTemplate(String name, BasicType<T> resultType) {
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(name);
        if (functionTemplate == null) {
            return new NamedSqmFunctionDescriptor(name, true, null, StandardFunctionReturnTypeResolvers.invariant(resultType), null);
        }
        return functionTemplate;
    }

    private static List<SqmExpression<?>> expressionList(Expression<?>[] jpaExpressions) {
        if (jpaExpressions == null || jpaExpressions.length == 0) {
            return Collections.emptyList();
        }
        ArrayList sqmExpressions = new ArrayList();
        for (Expression<?> jpaExpression : jpaExpressions) {
            sqmExpressions.add((SqmExpression)jpaExpression);
        }
        return sqmExpressions;
    }

    @Override
    public <Y> SqmModifiedSubQueryExpression<Y> all(Subquery<Y> subquery) {
        return new SqmModifiedSubQueryExpression((SqmSubQuery)subquery, SqmModifiedSubQueryExpression.Modifier.ALL, this);
    }

    @Override
    public <Y> SqmModifiedSubQueryExpression<Y> some(Subquery<Y> subquery) {
        return new SqmModifiedSubQueryExpression((SqmSubQuery)subquery, SqmModifiedSubQueryExpression.Modifier.SOME, this);
    }

    @Override
    public <Y> SqmModifiedSubQueryExpression<Y> any(Subquery<Y> subquery) {
        return new SqmModifiedSubQueryExpression((SqmSubQuery)subquery, SqmModifiedSubQueryExpression.Modifier.ANY, this);
    }

    @Override
    public <K, M extends Map<K, ?>> SqmExpression<Set<K>> keys(M map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, L extends List<?>> SqmExpression<Set<K>> indexes(L list) {
        throw new UnsupportedOperationException();
    }

    public <T> SqmExpression<T> value(T value, SqmExpression<? extends T> typeInferenceSource) {
        if (value instanceof SqmExpression) {
            return (SqmExpression)value;
        }
        return this.inlineValue(value) ? this.literal(value, typeInferenceSource) : this.valueParameter(value, typeInferenceSource);
    }

    private <E> SqmExpression<? extends Collection<?>> collectionValue(Collection<E> value, SqmExpression<E> typeInferenceSource) {
        return this.inlineValue(value) ? this.collectionLiteral(value.toArray()) : this.collectionValueParameter(value, typeInferenceSource);
    }

    public <T> SqmExpression<T> value(T value) {
        if (value instanceof Duration) {
            Duration duration = (Duration)value;
            JpaExpression<Duration> expression = duration.getNano() == 0 ? this.duration(duration.getSeconds(), TemporalUnit.SECOND) : this.duration((long)duration.getNano() + duration.getSeconds() * 1000000000L, TemporalUnit.NANOSECOND);
            return (SqmExpression)expression;
        }
        if (value instanceof SqmExpression) {
            return (SqmExpression)value;
        }
        return this.inlineValue(value) ? this.literal((Object)value) : this.valueParameter(value);
    }

    private <T> boolean isInstance(BindableType<? extends T> bindableType, T value) {
        if (bindableType instanceof SqmExpressible) {
            SqmExpressible expressible = (SqmExpressible)((Object)bindableType);
            return expressible.getExpressibleJavaType().isInstance(value);
        }
        return bindableType.getJavaType().isInstance(value) || this.resolveExpressible(bindableType).getExpressibleJavaType().isInstance(value);
    }

    private static <X, T extends X> BindableType<? extends X> resolveInferredParameterType(X value, SqmExpression<T> typeInferenceSource, TypeConfiguration typeConfiguration) {
        if (typeInferenceSource != null) {
            if (typeInferenceSource instanceof BindableType) {
                return (BindableType)((Object)typeInferenceSource);
            }
            SqmBindableType nodeType = typeInferenceSource.getExpressible();
            if (nodeType != null) {
                return nodeType;
            }
        }
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        return typeConfiguration.getBasicTypeForJavaType(valueClass);
    }

    private <T> ValueBindJpaCriteriaParameter<T> valueParameter(T value, SqmExpression<? extends T> typeInferenceSource) {
        BindableType<T> bindableType = SqmCriteriaNodeBuilder.resolveInferredParameterType(value, typeInferenceSource, this.getTypeConfiguration());
        if (bindableType == null || this.isInstance(bindableType, value)) {
            BindableType<T> widerType = bindableType;
            return new ValueBindJpaCriteriaParameter<T>(widerType, value, this);
        }
        Object coercedValue = this.resolveExpressible(bindableType).getExpressibleJavaType().coerce(value, this::getTypeConfiguration);
        if (this.isInstance(bindableType, coercedValue)) {
            BindableType<T> widerType = bindableType;
            return new ValueBindJpaCriteriaParameter<T>(widerType, coercedValue, this);
        }
        return new ValueBindJpaCriteriaParameter<T>(this.getParameterBindType(value), value, this);
    }

    private <E> ValueBindJpaCriteriaParameter<? extends Collection<E>> collectionValueParameter(Collection<E> value, SqmExpression<E> elementTypeInferenceSource) {
        SqmDomainType elementType;
        SqmBindableType<E> bindableType = null;
        if (elementTypeInferenceSource != null) {
            if (elementTypeInferenceSource instanceof BindableType) {
                bindableType = (SqmBindableType<E>)((Object)elementTypeInferenceSource);
            } else if (elementTypeInferenceSource.getNodeType() != null) {
                bindableType = elementTypeInferenceSource.getNodeType();
            }
        }
        if ((elementType = this.resolveExpressible(bindableType).getSqmType()) == null) {
            throw new UnsupportedOperationException("Can't infer collection type based on element expression: " + String.valueOf(elementTypeInferenceSource));
        }
        BasicType<?> collectionType = DdlTypeHelper.resolveListType(elementType, this.getTypeConfiguration());
        return new ValueBindJpaCriteriaParameter<Collection<E>>(collectionType, value, this);
    }

    private <T> ValueBindJpaCriteriaParameter<T> valueParameter(T value) {
        return new ValueBindJpaCriteriaParameter<T>(this.getParameterBindType(value), value, this);
    }

    private <T> BindableType<? super T> getParameterBindType(T value) {
        return this.getMappingMetamodel().resolveParameterBindType(value);
    }

    private <T> boolean inlineValue(T value) {
        return this.criteriaValueHandlingMode == ValueHandlingMode.INLINE;
    }

    @Override
    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        return this.value(map.values());
    }

    @Override
    public <C extends Collection<?>> SqmExpression<Integer> size(Expression<C> collection) {
        return new SqmCollectionSize((SqmPath)collection, (NodeBuilder)this);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<Integer> size(C collection) {
        return new SqmLiteral<Integer>(collection.size(), this.getIntegerType(), this);
    }

    @Override
    public <T> SqmCoalesce<T> coalesce() {
        return new SqmCoalesce(this);
    }

    @Override
    public <Y> JpaCoalesce<Y> coalesce(Expression<? extends Y> x, Expression<? extends Y> y) {
        SqmBindableType sqmExpressible = QueryHelper.highestPrecedenceType(((SqmExpression)x).getExpressible(), ((SqmExpression)y).getExpressible());
        return ((SqmCoalesce)new SqmCoalesce(sqmExpressible, 2, this).value(x)).value(y);
    }

    @Override
    public <Y> JpaCoalesce<Y> coalesce(Expression<? extends Y> x, Y y) {
        return this.coalesce((Expression)x, this.value(y, (SqmExpression)x));
    }

    @Override
    public <Y> SqmExpression<Y> nullif(Expression<Y> x, Expression<?> y) {
        return this.createNullifFunctionNode((SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public <Y> SqmExpression<Y> nullif(Expression<Y> x, Y y) {
        return this.createNullifFunctionNode((SqmExpression)x, this.value(y, (SqmExpression)x));
    }

    private <Y> SqmExpression<Y> createNullifFunctionNode(SqmExpression<Y> first, SqmExpression<Y> second) {
        SqmDomainType type = QueryHelper.highestPrecedenceType(first.getExpressible(), second.getExpressible()).getSqmType();
        ReturnableType resultType = (ReturnableType)((Object)type);
        return this.getFunctionDescriptor("nullif").generateSqmExpression(Arrays.asList(first, second), resultType, this.getQueryEngine());
    }

    private SqmFunctionDescriptor getFunctionDescriptor(String name) {
        return this.queryEngine.getSqmFunctionRegistry().findFunctionDescriptor(name);
    }

    private SqmSetReturningFunctionDescriptor getSetReturningFunctionDescriptor(String name) {
        return this.queryEngine.getSqmFunctionRegistry().findSetReturningFunctionDescriptor(name);
    }

    public <C, R> SqmCaseSimple<C, R> selectCase(Expression<? extends C> expression) {
        return new SqmCaseSimple((SqmExpression)expression, (NodeBuilder)this);
    }

    @Override
    public <R> SqmCaseSearched<R> selectCase() {
        return new SqmCaseSearched(this);
    }

    @Override
    public <M extends Map<?, ?>> SqmExpression<Integer> mapSize(JpaExpression<M> mapExpression) {
        return new SqmCollectionSize((SqmPath)mapExpression, (NodeBuilder)this);
    }

    @Override
    public <M extends Map<?, ?>> SqmExpression<Integer> mapSize(M map) {
        return new SqmLiteral<Integer>(map.size(), this.getIntegerType(), this);
    }

    @Override
    public SqmPredicate and(Expression<Boolean> x, Expression<Boolean> y) {
        return new SqmJunctionPredicate(Predicate.BooleanOperator.AND, (SqmPredicate)this.wrap((Expression)x), (SqmPredicate)this.wrap((Expression)y), this);
    }

    @Override
    public SqmPredicate and(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            return this.conjunction();
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(restrictions.length);
        for (Predicate expression : restrictions) {
            predicates.add((SqmPredicate)expression);
        }
        return new SqmJunctionPredicate(Predicate.BooleanOperator.AND, predicates, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate and(List<Predicate> restrictions) {
        if (restrictions == null || restrictions.isEmpty()) {
            return this.conjunction();
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(restrictions.size());
        for (Predicate expression : restrictions) {
            predicates.add((SqmPredicate)expression);
        }
        return new SqmJunctionPredicate(Predicate.BooleanOperator.AND, predicates, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate or(Expression<Boolean> x, Expression<Boolean> y) {
        return new SqmJunctionPredicate(Predicate.BooleanOperator.OR, (SqmPredicate)this.wrap((Expression)x), (SqmPredicate)this.wrap((Expression)y), this);
    }

    @Override
    public SqmPredicate or(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            return this.disjunction();
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(restrictions.length);
        for (Predicate expression : restrictions) {
            predicates.add((SqmPredicate)expression);
        }
        return new SqmJunctionPredicate(Predicate.BooleanOperator.OR, predicates, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate or(List<Predicate> restrictions) {
        if (restrictions == null || restrictions.isEmpty()) {
            return this.disjunction();
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(restrictions.size());
        for (Predicate expression : restrictions) {
            predicates.add((SqmPredicate)expression);
        }
        return new SqmJunctionPredicate(Predicate.BooleanOperator.OR, predicates, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate not(Expression<Boolean> restriction) {
        return this.wrap((Expression)restriction).not();
    }

    @Override
    public SqmPredicate conjunction() {
        return new SqmComparisonPredicate(new SqmLiteral<Integer>(1, this.getIntegerType(), this), ComparisonOperator.EQUAL, new SqmLiteral<Integer>(1, this.getIntegerType(), this), this);
    }

    @Override
    public SqmPredicate disjunction() {
        return new SqmComparisonPredicate(new SqmLiteral<Integer>(1, this.getIntegerType(), this), ComparisonOperator.NOT_EQUAL, new SqmLiteral<Integer>(1, this.getIntegerType(), this), this);
    }

    @Override
    public SqmPredicate isTrue(Expression<Boolean> x) {
        return this.wrap((Expression)x);
    }

    @Override
    public SqmPredicate isFalse(Expression<Boolean> x) {
        return this.wrap((Expression)x).not();
    }

    @Override
    public SqmPredicate isNull(Expression<?> x) {
        return new SqmNullnessPredicate((SqmExpression)x, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate isNotNull(Expression<?> x) {
        return new SqmNullnessPredicate((SqmExpression)x, (NodeBuilder)this).not();
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate between(Expression<? extends Y> value, Expression<? extends Y> lower, Expression<? extends Y> upper) {
        return new SqmBetweenPredicate((SqmExpression)value, (SqmExpression)lower, (SqmExpression)upper, false, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate between(Expression<? extends Y> value, Y lower, Y upper) {
        SqmExpression valueExpression = (SqmExpression)value;
        SqmExpression<Y> lowerExpr = this.value(lower, valueExpression);
        SqmExpression<Y> upperExpr = this.value(upper, valueExpression);
        return new SqmBetweenPredicate(valueExpression, lowerExpr, upperExpr, false, this);
    }

    @Override
    public SqmPredicate equal(Expression<?> x, Expression<?> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate equal(Expression<?> x, Object y) {
        SqmExpression<Object> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.EQUAL, yExpr, this);
    }

    @Override
    public SqmPredicate notEqual(Expression<?> x, Expression<?> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate notEqual(Expression<?> x, Object y) {
        SqmExpression<Object> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_EQUAL, yExpr, this);
    }

    @Override
    public SqmPredicate distinctFrom(Expression<?> x, Expression<?> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.DISTINCT_FROM, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate distinctFrom(Expression<?> x, Object y) {
        SqmExpression<Object> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.DISTINCT_FROM, yExpr, this);
    }

    @Override
    public SqmPredicate notDistinctFrom(Expression<?> x, Expression<?> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_DISTINCT_FROM, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate notDistinctFrom(Expression<?> x, Object y) {
        SqmExpression<Object> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_DISTINCT_FROM, yExpr, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThan(Expression<? extends Y> x, Y y) {
        SqmExpression<Y> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, yExpr, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        SqmExpression<Y> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, yExpr, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThan(Expression<? extends Y> x, Y y) {
        SqmExpression<Y> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, yExpr, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        SqmExpression<Y> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, yExpr, this);
    }

    @Override
    public SqmPredicate gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate gt(Expression<? extends Number> x, Number y) {
        SqmExpression<Number> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, yExpr, this);
    }

    @Override
    public SqmPredicate ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate ge(Expression<? extends Number> x, Number y) {
        SqmExpression<Number> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, yExpr, this);
    }

    @Override
    public SqmPredicate lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate lt(Expression<? extends Number> x, Number y) {
        SqmExpression<Number> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, yExpr, this);
    }

    @Override
    public SqmPredicate le(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate le(Expression<? extends Number> x, Number y) {
        SqmExpression<Number> yExpr = this.value(y, (SqmExpression)x);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, yExpr, this);
    }

    @Override
    public <C extends Collection<?>> SqmPredicate isEmpty(Expression<C> collection) {
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)collection, false, (NodeBuilder)this);
    }

    @Override
    public <C extends Collection<?>> SqmPredicate isNotEmpty(Expression<C> collection) {
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)collection, true, (NodeBuilder)this);
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isMember(Expression<E> elem, Expression<C> collection) {
        return this.createSqmMemberOfPredicate((SqmExpression)elem, (SqmPath)collection, false);
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isMember(E elem, Expression<C> collection) {
        return this.createSqmMemberOfPredicate((SqmExpression<?>)this.value(elem), (SqmPath)collection, false);
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isNotMember(Expression<E> elem, Expression<C> collection) {
        return this.createSqmMemberOfPredicate((SqmExpression)elem, (SqmPath)collection, true);
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isNotMember(E elem, Expression<C> collection) {
        return this.createSqmMemberOfPredicate((SqmExpression<?>)this.value(elem), (SqmPath)collection, true);
    }

    private SqmMemberOfPredicate createSqmMemberOfPredicate(SqmExpression<?> elem, SqmPath<?> collection, boolean negated) {
        if (collection instanceof SqmPluralValuedSimplePath) {
            SqmPluralValuedSimplePath pluralValuedSimplePath = (SqmPluralValuedSimplePath)collection;
            return new SqmMemberOfPredicate(elem, pluralValuedSimplePath, negated, this);
        }
        throw new SemanticException("Operand of 'member of' operator must be a plural path");
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, Expression<String> pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, String pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), (NodeBuilder)this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, Expression<String> pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, (SqmExpression)escapeChar, this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, Expression<String> pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, this.literal(Character.valueOf(escapeChar)), this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, String pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), (SqmExpression)escapeChar, this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, String pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), this.literal(Character.valueOf(escapeChar)), this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, Expression<String> pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, false, false, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, String pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), false, false, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, Expression<String> pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, (SqmExpression)escapeChar, false, false, this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, Expression<String> pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, this.literal(Character.valueOf(escapeChar)), false, false, this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, String pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), (SqmExpression)escapeChar, false, false, this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, String pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), this.literal(Character.valueOf(escapeChar)), false, false, this);
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, Expression<String> pattern) {
        return this.not((Expression)this.like((Expression)x, (Expression)pattern));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, String pattern) {
        return this.not((Expression)this.like((Expression)x, pattern));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return this.not((Expression)this.like((Expression)x, (Expression)pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return this.not((Expression)this.like((Expression)x, (Expression)pattern, escapeChar));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return this.not((Expression)this.like((Expression)x, pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, String pattern, char escapeChar) {
        return this.not((Expression)this.like((Expression)x, pattern, escapeChar));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, Expression<String> pattern) {
        return this.not((Expression)this.ilike((Expression)x, (Expression)pattern));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, String pattern) {
        return this.not((Expression)this.ilike((Expression)x, pattern));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return this.not((Expression)this.ilike((Expression)x, (Expression)pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return this.not((Expression)this.ilike((Expression)x, (Expression)pattern, escapeChar));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return this.not((Expression)this.ilike((Expression)x, pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, String pattern, char escapeChar) {
        return this.not((Expression)this.ilike((Expression)x, pattern, escapeChar));
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression) {
        return new SqmInListPredicate((SqmExpression)expression, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression, Expression<? extends T> ... values) {
        ArrayList<SqmExpression> listExpressions = new ArrayList<SqmExpression>(values.length);
        for (Expression<? extends T> value : values) {
            listExpressions.add((SqmExpression)value);
        }
        return new SqmInListPredicate((SqmExpression)expression, listExpressions, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression, T ... values) {
        SqmExpression sqmExpression = (SqmExpression)expression;
        ArrayList<SqmExpression<T>> listExpressions = new ArrayList<SqmExpression<T>>(values.length);
        for (T value : values) {
            listExpressions.add(this.value(value, sqmExpression));
        }
        return new SqmInListPredicate(sqmExpression, listExpressions, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression, Collection<T> values) {
        SqmExpression sqmExpression = (SqmExpression)expression;
        ArrayList<SqmExpression<T>> listExpressions = new ArrayList<SqmExpression<T>>(values.size());
        for (T value : values) {
            listExpressions.add(this.value(value, sqmExpression));
        }
        return new SqmInListPredicate(sqmExpression, listExpressions, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression, SqmSubQuery<T> subQuery) {
        return new SqmInSubQueryPredicate<T>((SqmExpression)expression, subQuery, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate exists(Subquery<?> subQuery) {
        return new SqmExistsPredicate((SqmExpression)((Object)subQuery), (NodeBuilder)this);
    }

    @Override
    public <M extends Map<?, ?>> SqmPredicate isMapEmpty(JpaExpression<M> mapExpression) {
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)mapExpression, false, (NodeBuilder)this);
    }

    @Override
    public <M extends Map<?, ?>> SqmPredicate isMapNotEmpty(JpaExpression<M> mapExpression) {
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)mapExpression, true, (NodeBuilder)this);
    }

    private Object readResolve() throws InvalidObjectException {
        LOG.trace("Resolving serialized SqmCriteriaNodeBuilder");
        return SqmCriteriaNodeBuilder.locateSessionFactoryOnDeserialization(this.uuid, this.name).getCriteriaBuilder();
    }

    private static SessionFactory locateSessionFactoryOnDeserialization(String uuid, String name) throws InvalidObjectException {
        SessionFactoryImplementor namedResult;
        SessionFactoryImplementor uuidResult = SessionFactoryRegistry.INSTANCE.getSessionFactory(uuid);
        if (uuidResult != null) {
            LOG.tracef("Resolved SessionFactory by UUID [%s]", (Object)uuid);
            return uuidResult;
        }
        if (name != null && (namedResult = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(name)) != null) {
            LOG.tracef("Resolved SessionFactory by name [%s]", (Object)name);
            return namedResult;
        }
        throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + uuid + ",name=" + name + "]");
    }

    public <T> SqmFunction<T> sql(String pattern, Class<T> type, Expression<?> ... arguments) {
        ArrayList sqmArguments = new ArrayList(SqmCriteriaNodeBuilder.expressionList(arguments));
        sqmArguments.add(0, this.literal(pattern));
        return this.getFunctionDescriptor("sql").generateSqmExpression(sqmArguments, this.getTypeConfiguration().standardBasicTypeForJavaType(type), this.queryEngine);
    }

    public SqmFunction<String> format(Expression<? extends TemporalAccessor> datetime, String pattern) {
        SqmFormat sqmFormat = new SqmFormat(pattern, null, (NodeBuilder)this);
        return this.getFunctionDescriptor("format").generateSqmExpression(Arrays.asList((SqmExpression)datetime, sqmFormat), null, this.getQueryEngine());
    }

    public <N, T extends Temporal> SqmExpression<N> extract(TemporalField<N, T> field, Expression<T> temporal) {
        TemporalUnit temporalUnit;
        Class resultType = Integer.class;
        switch (field.toString()) {
            case "year": {
                temporalUnit = TemporalUnit.YEAR;
                break;
            }
            case "quarter": {
                temporalUnit = TemporalUnit.QUARTER;
                break;
            }
            case "month": {
                temporalUnit = TemporalUnit.MONTH;
                break;
            }
            case "week": {
                temporalUnit = TemporalUnit.WEEK;
                break;
            }
            case "day": {
                temporalUnit = TemporalUnit.DAY;
                break;
            }
            case "hour": {
                temporalUnit = TemporalUnit.HOUR;
                break;
            }
            case "minute": {
                temporalUnit = TemporalUnit.MINUTE;
                break;
            }
            case "second": {
                temporalUnit = TemporalUnit.SECOND;
                resultType = Double.class;
                break;
            }
            case "date": {
                temporalUnit = TemporalUnit.DATE;
                resultType = LocalDate.class;
                break;
            }
            case "time": {
                temporalUnit = TemporalUnit.TIME;
                resultType = LocalTime.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid temporal field [" + String.valueOf(field) + "]");
            }
        }
        return this.extract(temporal, temporalUnit, resultType);
    }

    private <T> SqmFunction<T> extract(Expression<? extends TemporalAccessor> datetime, TemporalUnit temporalUnit, Class<T> type) {
        return this.getFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(new SqmExtractUnit<T>(temporalUnit, this.getTypeConfiguration().standardBasicTypeForJavaType(type), this), (SqmTypedNode)((Object)datetime)), null, this.queryEngine);
    }

    public SqmFunction<Integer> year(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.YEAR, Integer.class);
    }

    public SqmFunction<Integer> month(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.MONTH, Integer.class);
    }

    public SqmFunction<Integer> day(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.DAY, Integer.class);
    }

    public SqmFunction<Integer> hour(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.HOUR, Integer.class);
    }

    public SqmFunction<Integer> minute(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.MINUTE, Integer.class);
    }

    public SqmFunction<Float> second(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.SECOND, Float.class);
    }

    public <T extends TemporalAccessor> SqmFunction<T> truncate(Expression<T> datetime, TemporalUnit temporalUnit) {
        return this.getFunctionDescriptor("trunc").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)datetime), new SqmExtractUnit<Integer>(temporalUnit, this.getIntegerType(), this)), null, this.queryEngine);
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, int start) {
        return this.overlay((Expression)string, replacement, (Expression)this.value((Object)start), (Expression)null);
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, int start) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)this.value((Object)start), (Expression)null);
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, Expression<Integer> start) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)start, (Expression)null);
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, Expression<Integer> start) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)start, (Expression)null);
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, int start, int length) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)this.value((Object)start), (Expression)this.value((Object)length));
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, int start, int length) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)this.value((Object)start), (Expression)this.value((Object)length));
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, Expression<Integer> start, int length) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)start, (Expression)this.value((Object)length));
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, Expression<Integer> start, int length) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)start, (Expression)this.value((Object)length));
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, int start, Expression<Integer> length) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)this.value((Object)start), (Expression)length);
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, int start, Expression<Integer> length) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)this.value((Object)start), (Expression)length);
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, Expression<Integer> start, Expression<Integer> length) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)start, (Expression)length);
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, Expression<Integer> start, Expression<Integer> length) {
        SqmExpression sqmString = (SqmExpression)string;
        SqmExpression sqmReplacement = (SqmExpression)replacement;
        SqmExpression sqmStart = (SqmExpression)start;
        return this.getFunctionDescriptor("overlay").generateSqmExpression(length == null ? Arrays.asList(sqmString, sqmReplacement, sqmStart) : Arrays.asList(sqmString, sqmReplacement, sqmStart, (SqmExpression)length), null, this.getQueryEngine());
    }

    public SqmFunction<String> pad(Expression<String> x, int length) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)this.value((Object)length), (Expression)null);
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, int length) {
        return this.pad(ts, (Expression)x, (Expression)this.value((Object)length), (Expression)null);
    }

    public SqmFunction<String> pad(Expression<String> x, Expression<Integer> length) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)length, (Expression)null);
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, Expression<Integer> length) {
        return this.pad(ts, (Expression)x, (Expression)length, (Expression)null);
    }

    public SqmFunction<String> pad(Expression<String> x, int length, char padChar) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)this.value((Object)length), (Expression)this.value(Character.valueOf(padChar)));
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, int length, char padChar) {
        return this.pad(ts, (Expression)x, (Expression)this.value((Object)length), (Expression)this.value(Character.valueOf(padChar)));
    }

    public SqmFunction<String> pad(Expression<String> x, int length, Expression<Character> padChar) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)this.value((Object)length), (Expression)padChar);
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, int length, Expression<Character> padChar) {
        return this.pad(ts, (Expression)x, (Expression)this.value((Object)length), (Expression)padChar);
    }

    public SqmFunction<String> pad(Expression<String> x, Expression<Integer> length, char padChar) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)length, (Expression)this.value(Character.valueOf(padChar)));
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, Expression<Integer> length, char padChar) {
        return this.pad(ts, (Expression)x, (Expression)length, (Expression)this.value(Character.valueOf(padChar)));
    }

    public SqmFunction<String> pad(Expression<String> x, Expression<Integer> length, Expression<Character> padChar) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)length, (Expression)padChar);
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, Expression<Integer> length, Expression<Character> padChar) {
        SqmExpression source = (SqmExpression)x;
        SqmExpression sqmLength = (SqmExpression)length;
        SqmTrimSpecification padSpec = new SqmTrimSpecification(ts == null ? TrimSpec.TRAILING : TrimSpec.fromCriteriaTrimSpec(ts), this);
        return this.getFunctionDescriptor("pad").generateSqmExpression(padChar != null ? Arrays.asList(source, sqmLength, padSpec, (SqmExpression)padChar) : Arrays.asList(source, sqmLength, padSpec), null, this.getQueryEngine());
    }

    @Override
    public JpaFunction<String> repeat(Expression<String> x, Expression<Integer> times) {
        return this.getFunctionDescriptor("repeat").generateSqmExpression(Arrays.asList((SqmExpression)x, (SqmExpression)times), null, this.getQueryEngine());
    }

    @Override
    public JpaFunction<String> repeat(Expression<String> x, int times) {
        return this.repeat(x, (Expression<Integer>)this.value((Object)times));
    }

    @Override
    public JpaFunction<String> repeat(String x, Expression<Integer> times) {
        return this.repeat((Expression<String>)this.value(x), times);
    }

    public SqmFunction<String> left(Expression<String> x, int length) {
        return this.left((Expression)x, (Expression)this.value((Object)length));
    }

    public SqmFunction<String> left(Expression<String> x, Expression<Integer> length) {
        return this.getFunctionDescriptor("left").generateSqmExpression(Arrays.asList((SqmExpression)x, (SqmExpression)length), null, this.getQueryEngine());
    }

    public SqmFunction<String> right(Expression<String> x, int length) {
        return this.right((Expression)x, (Expression)this.value((Object)length));
    }

    public SqmFunction<String> right(Expression<String> x, Expression<Integer> length) {
        return this.getFunctionDescriptor("right").generateSqmExpression(Arrays.asList((SqmExpression)x, (SqmExpression)length), null, this.getQueryEngine());
    }

    public SqmFunction<String> replace(Expression<String> x, String pattern, String replacement) {
        JpaExpression sqmPattern = this.value(pattern);
        return this.replace((Expression)x, (Expression)sqmPattern, (Expression)this.value((Object)replacement, (SqmExpression)sqmPattern));
    }

    public SqmFunction<String> replace(Expression<String> x, String pattern, Expression<String> replacement) {
        return this.replace((Expression)x, (Expression)this.value(pattern), (Expression)replacement);
    }

    public SqmFunction<String> replace(Expression<String> x, Expression<String> pattern, String replacement) {
        return this.replace((Expression)x, (Expression)pattern, (Expression)this.value(replacement));
    }

    public SqmFunction<String> replace(Expression<String> x, Expression<String> pattern, Expression<String> replacement) {
        return this.getFunctionDescriptor("replace").generateSqmExpression(Arrays.asList((SqmExpression)x, (SqmExpression)pattern, (SqmExpression)replacement), null, this.getQueryEngine());
    }

    public SqmFunction<String> collate(Expression<String> x, String collation) {
        SqmCollation sqmCollation = new SqmCollation(collation, null, (NodeBuilder)this);
        return this.getFunctionDescriptor("collate").generateSqmExpression(Arrays.asList((SqmExpression)x, sqmCollation), null, this.getQueryEngine());
    }

    public SqmFunction<Double> log10(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("log10").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> log(Number b, Expression<? extends Number> x) {
        return this.log((Expression)this.value(b), (Expression)x);
    }

    public SqmFunction<Double> log(Expression<? extends Number> b, Expression<? extends Number> x) {
        return this.getFunctionDescriptor("log").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)b), (SqmTypedNode)((Object)x)), null, this.queryEngine);
    }

    public SqmFunction<Double> pi() {
        return this.getFunctionDescriptor("pi").generateSqmExpression(null, this.queryEngine);
    }

    public SqmFunction<Double> sin(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("sin").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> cos(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("cos").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> tan(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("tan").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> asin(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("asin").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> acos(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("acos").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> atan(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("atan").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> atan2(Number y, Expression<? extends Number> x) {
        return this.atan2((Expression)this.value(y), (Expression)x);
    }

    public SqmFunction<Double> atan2(Expression<? extends Number> y, Number x) {
        return this.atan2((Expression)y, (Expression)this.value(x));
    }

    public SqmFunction<Double> atan2(Expression<? extends Number> y, Expression<? extends Number> x) {
        return this.getFunctionDescriptor("atan2").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)y), (SqmTypedNode)((Object)x)), null, this.queryEngine);
    }

    public SqmFunction<Double> sinh(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("sinh").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> cosh(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("cosh").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> tanh(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("tanh").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> degrees(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("degrees").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    public SqmFunction<Double> radians(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("radians").generateSqmExpression((SqmTypedNode)((Object)x), null, this.queryEngine);
    }

    @Override
    public SqmWindow createWindow() {
        return new SqmWindow(this);
    }

    @Override
    public SqmWindowFrame frameUnboundedPreceding() {
        return new SqmWindowFrame(this, FrameKind.UNBOUNDED_PRECEDING);
    }

    @Override
    public SqmWindowFrame frameBetweenPreceding(int offset) {
        return new SqmWindowFrame(this, FrameKind.OFFSET_PRECEDING, this.literal((Object)offset));
    }

    @Override
    public SqmWindowFrame frameBetweenPreceding(Expression<?> offset) {
        return new SqmWindowFrame(this, FrameKind.OFFSET_PRECEDING, (SqmExpression)offset);
    }

    @Override
    public SqmWindowFrame frameCurrentRow() {
        return new SqmWindowFrame(this, FrameKind.CURRENT_ROW);
    }

    @Override
    public SqmWindowFrame frameBetweenFollowing(int offset) {
        return new SqmWindowFrame(this, FrameKind.OFFSET_FOLLOWING, this.literal((Object)offset));
    }

    @Override
    public SqmWindowFrame frameBetweenFollowing(Expression<?> offset) {
        return new SqmWindowFrame(this, FrameKind.OFFSET_FOLLOWING, (SqmExpression)offset);
    }

    @Override
    public SqmWindowFrame frameUnboundedFollowing() {
        return new SqmWindowFrame(this, FrameKind.UNBOUNDED_FOLLOWING);
    }

    public <T> SqmExpression<T> windowFunction(String name, Class<T> type, JpaWindow window, Expression<?> ... args) {
        SelfRenderingSqmFunction function = this.getFunctionDescriptor(name).generateSqmExpression(SqmCriteriaNodeBuilder.expressionList(args), null, this.queryEngine);
        return new SqmOver(function, (SqmWindow)window);
    }

    public SqmExpression<Long> rowNumber(JpaWindow window) {
        return this.windowFunction("row_number", Long.class, window, new Expression[0]);
    }

    public <T> SqmExpression<T> firstValue(Expression<T> argument, JpaWindow window) {
        return this.windowFunction("first_value", argument.getJavaType(), window, new Expression[]{argument});
    }

    public <T> SqmExpression<T> lastValue(Expression<T> argument, JpaWindow window) {
        return this.windowFunction("last_value", argument.getJavaType(), window, new Expression[]{argument});
    }

    public <T> SqmExpression<T> nthValue(Expression<T> argument, int n, JpaWindow window) {
        return this.nthValue((Expression)argument, (Expression)this.literal((Object)n), window);
    }

    public <T> SqmExpression<T> nthValue(Expression<T> argument, Expression<Integer> n, JpaWindow window) {
        return this.windowFunction("nth_value", argument.getJavaType(), window, new Expression[]{argument, n});
    }

    public SqmExpression<Long> rank(JpaWindow window) {
        return this.windowFunction("rank", Long.class, window, new Expression[0]);
    }

    public SqmExpression<Long> denseRank(JpaWindow window) {
        return this.windowFunction("dense_rank", Long.class, window, new Expression[0]);
    }

    public SqmExpression<Double> percentRank(JpaWindow window) {
        return this.windowFunction("percent_rank", Double.class, window, new Expression[0]);
    }

    public SqmExpression<Double> cumeDist(JpaWindow window) {
        return this.windowFunction("cume_dist", Double.class, window, new Expression[0]);
    }

    public <T> SqmExpression<T> functionAggregate(String name, Class<T> type, JpaPredicate filter, Expression<?> ... args) {
        return this.functionAggregate(name, (Class)type, filter, (JpaWindow)null, (Expression[])args);
    }

    public <T> SqmExpression<T> functionAggregate(String name, Class<T> type, JpaWindow window, Expression<?> ... args) {
        return this.functionAggregate(name, (Class)type, (JpaPredicate)null, window, (Expression[])args);
    }

    public <T> SqmExpression<T> functionAggregate(String name, Class<T> type, JpaPredicate filter, JpaWindow window, Expression<?> ... args) {
        SqmPredicate sqmFilter = filter != null ? (SqmPredicate)filter : null;
        SelfRenderingSqmFunction function = this.getFunctionDescriptor(name).generateAggregateSqmExpression(SqmCriteriaNodeBuilder.expressionList(args), sqmFilter, null, this.queryEngine);
        if (window == null) {
            return function;
        }
        return new SqmOver(function, (SqmWindow)window);
    }

    public <N extends Number> SqmExpression<Number> sum(Expression<N> argument, JpaPredicate filter) {
        return this.sum((Expression)argument, filter, (JpaWindow)null);
    }

    public <N extends Number> SqmExpression<Number> sum(Expression<N> argument, JpaWindow window) {
        return this.sum((Expression)argument, (JpaPredicate)null, window);
    }

    public <N extends Number> SqmExpression<Number> sum(Expression<N> argument, JpaPredicate filter, JpaWindow window) {
        return this.functionAggregate("sum", Number.class, filter, window, new Expression[]{argument});
    }

    public <N extends Number> SqmExpression<Double> avg(Expression<N> argument, JpaPredicate filter) {
        return this.avg((Expression)argument, filter, (JpaWindow)null);
    }

    public <N extends Number> SqmExpression<Double> avg(Expression<N> argument, JpaWindow window) {
        return this.avg((Expression)argument, (JpaPredicate)null, window);
    }

    public <N extends Number> SqmExpression<Double> avg(Expression<N> argument, JpaPredicate filter, JpaWindow window) {
        return this.functionAggregate("avg", Double.class, filter, window, new Expression[]{argument});
    }

    public SqmExpression<Long> count(Expression<?> argument, JpaPredicate filter) {
        return this.count((Expression)argument, filter, (JpaWindow)null);
    }

    public SqmExpression<Long> count(Expression<?> argument, JpaWindow window) {
        return this.count((Expression)argument, (JpaPredicate)null, window);
    }

    public SqmExpression<Long> count(Expression<?> argument, JpaPredicate filter, JpaWindow window) {
        return this.functionAggregate("count", Long.class, filter, window, new Expression[]{argument});
    }

    public <T> SqmExpression<T> functionWithinGroup(String name, Class<T> type, JpaOrder order, Expression<?> ... args) {
        return this.functionWithinGroup(name, (Class)type, order, (JpaPredicate)null, (JpaWindow)null, (Expression[])args);
    }

    public <T> SqmExpression<T> functionWithinGroup(String name, Class<T> type, JpaOrder order, JpaPredicate filter, Expression<?> ... args) {
        return this.functionWithinGroup(name, (Class)type, order, filter, (JpaWindow)null, (Expression[])args);
    }

    public <T> SqmExpression<T> functionWithinGroup(String name, Class<T> type, JpaOrder order, JpaWindow window, Expression<?> ... args) {
        return this.functionWithinGroup(name, (Class)type, order, (JpaPredicate)null, window, (Expression[])args);
    }

    public <T> SqmExpression<T> functionWithinGroup(String name, Class<T> type, JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<?> ... args) {
        SqmOrderByClause withinGroupClause = new SqmOrderByClause();
        if (order != null) {
            withinGroupClause.addSortSpecification((SqmSortSpecification)order);
        }
        SqmPredicate sqmFilter = filter != null ? (SqmPredicate)filter : null;
        SelfRenderingSqmFunction function = this.getFunctionDescriptor(name).generateOrderedSetAggregateSqmExpression(SqmCriteriaNodeBuilder.expressionList(args), sqmFilter, withinGroupClause, null, this.queryEngine);
        if (window == null) {
            return function;
        }
        return new SqmOver(function, (SqmWindow)window);
    }

    public SqmExpression<String> listagg(JpaOrder order, Expression<String> argument, String separator) {
        return this.listagg(order, (JpaPredicate)null, (JpaWindow)null, (Expression)argument, separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, Expression<String> argument, Expression<String> separator) {
        return this.listagg(order, (JpaPredicate)null, (JpaWindow)null, (Expression)argument, (Expression)separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaPredicate filter, Expression<String> argument, String separator) {
        return this.listagg(order, filter, (JpaWindow)null, (Expression)argument, separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaPredicate filter, Expression<String> argument, Expression<String> separator) {
        return this.listagg(order, filter, (JpaWindow)null, (Expression)argument, (Expression)separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaWindow window, Expression<String> argument, String separator) {
        return this.listagg(order, (JpaPredicate)null, window, (Expression)argument, separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaWindow window, Expression<String> argument, Expression<String> separator) {
        return this.listagg(order, (JpaPredicate)null, window, (Expression)argument, (Expression)separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<String> argument, String separator) {
        return this.listagg(order, filter, window, (Expression)argument, (Expression)this.literal(separator));
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<String> argument, Expression<String> separator) {
        return this.functionWithinGroup("listagg", String.class, order, filter, window, new Expression[]{argument, separator});
    }

    public <T> SqmExpression<T> mode(Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.mode((JpaPredicate)null, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> mode(JpaPredicate filter, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.mode(filter, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> mode(JpaWindow window, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.mode((JpaPredicate)null, window, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> mode(JpaPredicate filter, JpaWindow window, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.functionWithinGroup("mode", sortExpression.getJavaType(), this.sort((JpaExpression)((SqmExpression)sortExpression), sortOrder, nullPrecedence), filter, window, new Expression[0]);
    }

    public <T> SqmExpression<T> percentileCont(Expression<? extends Number> argument, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.percentileCont((Expression)argument, (JpaPredicate)null, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileCont(Expression<? extends Number> argument, JpaPredicate filter, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.percentileCont((Expression)argument, filter, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileCont(Expression<? extends Number> argument, JpaWindow window, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.percentileCont((Expression)argument, (JpaPredicate)null, window, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileCont(Expression<? extends Number> argument, JpaPredicate filter, JpaWindow window, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.functionWithinGroup("percentile_cont", sortExpression.getJavaType(), this.sort((JpaExpression)((SqmExpression)sortExpression), sortOrder, nullPrecedence), filter, window, new Expression[]{argument});
    }

    public <T> SqmExpression<T> percentileDisc(Expression<? extends Number> argument, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.percentileDisc((Expression)argument, (JpaPredicate)null, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileDisc(Expression<? extends Number> argument, JpaPredicate filter, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.percentileDisc((Expression)argument, filter, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileDisc(Expression<? extends Number> argument, JpaWindow window, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.percentileDisc((Expression)argument, (JpaPredicate)null, window, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileDisc(Expression<? extends Number> argument, JpaPredicate filter, JpaWindow window, Expression<T> sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        return this.functionWithinGroup("percentile_disc", sortExpression.getJavaType(), this.sort((JpaExpression)((SqmExpression)sortExpression), sortOrder, nullPrecedence), filter, window, new Expression[]{argument});
    }

    public SqmExpression<Long> rank(JpaOrder order, Expression<?> ... arguments) {
        return this.functionWithinGroup("rank", Long.class, order, (JpaPredicate)null, (JpaWindow)null, (Expression[])arguments);
    }

    public SqmExpression<Long> rank(JpaOrder order, JpaPredicate filter, Expression<?> ... arguments) {
        return this.functionWithinGroup("rank", Long.class, order, filter, (JpaWindow)null, (Expression[])arguments);
    }

    public SqmExpression<Long> rank(JpaOrder order, JpaWindow window, Expression<?> ... arguments) {
        return this.functionWithinGroup("rank", Long.class, order, (JpaPredicate)null, window, (Expression[])arguments);
    }

    public SqmExpression<Long> rank(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<?> ... arguments) {
        return this.functionWithinGroup("rank", Long.class, order, filter, window, (Expression[])arguments);
    }

    public SqmExpression<Double> percentRank(JpaOrder order, Expression<?> ... arguments) {
        return this.percentRank(order, (JpaPredicate)null, (JpaWindow)null, (Expression[])arguments);
    }

    public SqmExpression<Double> percentRank(JpaOrder order, JpaPredicate filter, Expression<?> ... arguments) {
        return this.percentRank(order, filter, (JpaWindow)null, (Expression[])arguments);
    }

    public SqmExpression<Double> percentRank(JpaOrder order, JpaWindow window, Expression<?> ... arguments) {
        return this.percentRank(order, (JpaPredicate)null, window, (Expression[])arguments);
    }

    public SqmExpression<Double> percentRank(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<?> ... arguments) {
        return this.functionWithinGroup("percent_rank", Double.class, order, filter, window, (Expression[])arguments);
    }

    @Override
    public <T> SqmExpression<T[]> arrayAgg(JpaOrder order, Expression<? extends T> argument) {
        return this.arrayAgg(order, (JpaPredicate)null, (JpaWindow)null, (Expression)argument);
    }

    @Override
    public <T> SqmExpression<T[]> arrayAgg(JpaOrder order, JpaPredicate filter, Expression<? extends T> argument) {
        return this.arrayAgg(order, filter, (JpaWindow)null, (Expression)argument);
    }

    @Override
    public <T> SqmExpression<T[]> arrayAgg(JpaOrder order, JpaWindow window, Expression<? extends T> argument) {
        return this.arrayAgg(order, (JpaPredicate)null, window, (Expression)argument);
    }

    @Override
    public <T> SqmExpression<T[]> arrayAgg(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<? extends T> argument) {
        return this.functionWithinGroup("array_agg", (Class)null, order, filter, window, new Expression[]{argument});
    }

    @Override
    public <T> SqmExpression<T[]> arrayLiteral(T ... elements) {
        return this.getFunctionDescriptor("array").generateSqmExpression(this.literals(elements), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<Integer> arrayPosition(Expression<T[]> arrayExpression, T element) {
        return this.getFunctionDescriptor("array_position").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value((Object)element)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<Integer> arrayPosition(Expression<T[]> arrayExpression, Expression<T> elementExpression) {
        return this.getFunctionDescriptor("array_position").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<int[]> arrayPositions(Expression<T[]> arrayExpression, Expression<T> elementExpression) {
        return this.getFunctionDescriptor("array_positions").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<int[]> arrayPositions(Expression<T[]> arrayExpression, T element) {
        return this.getFunctionDescriptor("array_positions").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value((Object)element)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<List<Integer>> arrayPositionsList(Expression<T[]> arrayExpression, Expression<T> elementExpression) {
        return this.getFunctionDescriptor("array_positions_list").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<List<Integer>> arrayPositionsList(Expression<T[]> arrayExpression, T element) {
        return this.getFunctionDescriptor("array_positions_list").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value((Object)element)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<Integer> arrayLength(Expression<T[]> arrayExpression) {
        return this.getFunctionDescriptor("array_length").generateSqmExpression(Collections.singletonList((SqmExpression)arrayExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayConcat(Expression<T[]> arrayExpression1, Expression<T[]> arrayExpression2) {
        return this.getFunctionDescriptor("array_concat").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression1, (SqmExpression)arrayExpression2), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayConcat(Expression<T[]> arrayExpression1, T[] array2) {
        return this.getFunctionDescriptor("array_concat").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression1, this.value(array2, (SqmExpression)arrayExpression1)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayConcat(T[] array1, Expression<T[]> arrayExpression2) {
        return this.getFunctionDescriptor("array_concat").generateSqmExpression(Arrays.asList(this.value(array1, (SqmExpression)arrayExpression2), (SqmExpression)arrayExpression2), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayAppend(Expression<T[]> arrayExpression, Expression<T> elementExpression) {
        return this.getFunctionDescriptor("array_append").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayAppend(Expression<T[]> arrayExpression, T element) {
        return this.getFunctionDescriptor("array_append").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value((Object)element)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayPrepend(Expression<T> elementExpression, Expression<T[]> arrayExpression) {
        return this.getFunctionDescriptor("array_prepend").generateSqmExpression(Arrays.asList((SqmExpression)elementExpression, (SqmExpression)arrayExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayPrepend(T element, Expression<T[]> arrayExpression) {
        return this.getFunctionDescriptor("array_prepend").generateSqmExpression(Arrays.asList(this.value((Object)element), (SqmExpression)arrayExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmPredicate arrayContains(Expression<T[]> arrayExpression, Expression<T> elementExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)elementExpression), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayContains(Expression<T[]> arrayExpression, T element) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value((Object)element)), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayContains(T[] array, Expression<T> elementExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains").generateSqmExpression(Arrays.asList(this.value(array), (SqmExpression)elementExpression), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayContainsNullable(Expression<T[]> arrayExpression, Expression<T> elementExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains_nullable").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)elementExpression), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayContainsNullable(Expression<T[]> arrayExpression, T element) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains_nullable").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value((Object)element)), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayContainsNullable(T[] array, Expression<T> elementExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains_nullable").generateSqmExpression(Arrays.asList(this.value(array), (SqmExpression)elementExpression), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIncludes(Expression<T[]> arrayExpression, Expression<T[]> subArrayExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)subArrayExpression), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIncludes(Expression<T[]> arrayExpression, T[] subArray) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(subArray, (SqmExpression)arrayExpression)), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIncludes(T[] array, Expression<T[]> subArrayExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes").generateSqmExpression(Arrays.asList(this.value(array, (SqmExpression)subArrayExpression), (SqmExpression)subArrayExpression), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIncludesNullable(Expression<T[]> arrayExpression, Expression<T[]> subArrayExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes_nullable").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)subArrayExpression), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIncludesNullable(Expression<T[]> arrayExpression, T[] subArray) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes_nullable").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(subArray, (SqmExpression)arrayExpression)), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIncludesNullable(T[] array, Expression<T[]> subArrayExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes_nullable").generateSqmExpression(Arrays.asList(this.value(array, (SqmExpression)subArrayExpression), (SqmExpression)subArrayExpression), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIntersects(Expression<T[]> arrayExpression1, Expression<T[]> arrayExpression2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression1, (SqmExpression)arrayExpression2), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIntersects(Expression<T[]> arrayExpression1, T[] array2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression1, this.value(array2, (SqmExpression)arrayExpression1)), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIntersects(T[] array1, Expression<T[]> arrayExpression2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects").generateSqmExpression(Arrays.asList(this.value(array1, (SqmExpression)arrayExpression2), (SqmExpression)arrayExpression2), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIntersectsNullable(Expression<T[]> arrayExpression1, Expression<T[]> arrayExpression2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects_nullable").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression1, (SqmExpression)arrayExpression2), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIntersectsNullable(Expression<T[]> arrayExpression1, T[] array2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects_nullable").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression1, this.value(array2, (SqmExpression)arrayExpression1)), null, this.queryEngine));
    }

    @Override
    public <T> SqmPredicate arrayIntersectsNullable(T[] array1, Expression<T[]> arrayExpression2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects_nullable").generateSqmExpression(Arrays.asList(this.value(array1, (SqmExpression)arrayExpression2), (SqmExpression)arrayExpression2), null, this.queryEngine));
    }

    @Override
    public <T> SqmExpression<T> arrayGet(Expression<T[]> arrayExpression, Expression<Integer> indexExpression) {
        return this.getFunctionDescriptor("array_get").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)indexExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T> arrayGet(Expression<T[]> arrayExpression, Integer index) {
        return this.getFunctionDescriptor("array_get").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(index)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arraySet(Expression<T[]> arrayExpression, Expression<Integer> indexExpression, Expression<T> elementExpression) {
        return this.getFunctionDescriptor("array_set").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)indexExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arraySet(Expression<T[]> arrayExpression, Expression<Integer> indexExpression, T element) {
        return this.getFunctionDescriptor("array_set").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)indexExpression, this.value((Object)element)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arraySet(Expression<T[]> arrayExpression, Integer index, Expression<T> elementExpression) {
        return this.getFunctionDescriptor("array_set").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(index), (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arraySet(Expression<T[]> arrayExpression, Integer index, T element) {
        return this.getFunctionDescriptor("array_set").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(index), this.value((Object)element)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayRemove(Expression<T[]> arrayExpression, Expression<T> elementExpression) {
        return this.getFunctionDescriptor("array_remove").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayRemove(Expression<T[]> arrayExpression, T element) {
        return this.getFunctionDescriptor("array_remove").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value((Object)element)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayRemoveIndex(Expression<T[]> arrayExpression, Expression<Integer> indexExpression) {
        return this.getFunctionDescriptor("array_remove_index").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)indexExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayRemoveIndex(Expression<T[]> arrayExpression, Integer index) {
        return this.getFunctionDescriptor("array_remove_index").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(index)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arraySlice(Expression<T[]> arrayExpression, Expression<Integer> lowerIndexExpression, Expression<Integer> upperIndexExpression) {
        return this.getFunctionDescriptor("array_slice").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)lowerIndexExpression, (SqmExpression)upperIndexExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arraySlice(Expression<T[]> arrayExpression, Expression<Integer> lowerIndexExpression, Integer upperIndex) {
        return this.getFunctionDescriptor("array_slice").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)lowerIndexExpression, this.value(upperIndex)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arraySlice(Expression<T[]> arrayExpression, Integer lowerIndex, Expression<Integer> upperIndexExpression) {
        return this.getFunctionDescriptor("array_slice").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(lowerIndex), (SqmExpression)upperIndexExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arraySlice(Expression<T[]> arrayExpression, Integer lowerIndex, Integer upperIndex) {
        return this.getFunctionDescriptor("array_slice").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(lowerIndex), this.value(upperIndex)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayReplace(Expression<T[]> arrayExpression, Expression<T> oldElementExpression, Expression<T> newElementExpression) {
        return this.getFunctionDescriptor("array_replace").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)oldElementExpression, (SqmExpression)newElementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayReplace(Expression<T[]> arrayExpression, Expression<T> oldElementExpression, T newElement) {
        return this.getFunctionDescriptor("array_replace").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)oldElementExpression, this.value((Object)newElement)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayReplace(Expression<T[]> arrayExpression, T oldElement, Expression<T> newElementExpression) {
        return this.getFunctionDescriptor("array_replace").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value((Object)oldElement), (SqmExpression)newElementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayReplace(Expression<T[]> arrayExpression, T oldElement, T newElement) {
        return this.getFunctionDescriptor("array_replace").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value((Object)oldElement), this.value((Object)newElement)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayTrim(Expression<T[]> arrayExpression, Expression<Integer> elementCountExpression) {
        return this.getFunctionDescriptor("array_trim").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)elementCountExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayTrim(Expression<T[]> arrayExpression, Integer elementCount) {
        return this.getFunctionDescriptor("array_trim").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(elementCount)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayFill(Expression<T> elementExpression, Expression<Integer> elementCountExpression) {
        return this.getFunctionDescriptor("array_fill").generateSqmExpression(Arrays.asList((SqmExpression)elementExpression, (SqmExpression)elementCountExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayFill(Expression<T> elementExpression, Integer elementCount) {
        return this.getFunctionDescriptor("array_fill").generateSqmExpression(Arrays.asList((SqmExpression)elementExpression, this.value(elementCount)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayFill(T element, Expression<Integer> elementCountExpression) {
        return this.getFunctionDescriptor("array_fill").generateSqmExpression(Arrays.asList(this.value((Object)element), (SqmExpression)elementCountExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T[]> arrayFill(T element, Integer elementCount) {
        return this.getFunctionDescriptor("array_fill").generateSqmExpression(Arrays.asList(this.value((Object)element), this.value(elementCount)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> arrayToString(Expression<? extends Object[]> arrayExpression, Expression<String> separatorExpression) {
        return this.getFunctionDescriptor("array_to_string").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)separatorExpression), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> arrayToString(Expression<? extends Object[]> arrayExpression, String separator) {
        return this.getFunctionDescriptor("array_to_string").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, this.value(separator)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> arrayToString(Expression<? extends Object[]> arrayExpression, Expression<String> separatorExpression, Expression<String> defaultExpression) {
        return this.getFunctionDescriptor("array_to_string").generateSqmExpression(Arrays.asList((SqmExpression)arrayExpression, (SqmExpression)separatorExpression, (SqmExpression)defaultExpression), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> arrayToString(Expression<? extends Object[]> arrayExpression, Expression<String> separatorExpression, String defaultValue) {
        return this.arrayToString((Expression)arrayExpression, (Expression)separatorExpression, (Expression)this.value(defaultValue));
    }

    @Override
    public SqmExpression<String> arrayToString(Expression<? extends Object[]> arrayExpression, String separator, Expression<String> defaultExpression) {
        return this.arrayToString((Expression)arrayExpression, (Expression)this.value(separator), (Expression)defaultExpression);
    }

    @Override
    public SqmExpression<String> arrayToString(Expression<? extends Object[]> arrayExpression, String separator, String defaultValue) {
        return this.arrayToString((Expression)arrayExpression, (Expression)this.value(separator), (Expression)this.value(defaultValue));
    }

    @Override
    public <E, C extends Collection<E>> SqmExpression<C> collectionLiteral(E ... elements) {
        return this.getFunctionDescriptor("array_list").generateSqmExpression(this.literals(elements), null, this.queryEngine);
    }

    @Override
    public <E> SqmExpression<Integer> collectionPosition(Expression<? extends Collection<? extends E>> collectionExpression, E element) {
        return this.getFunctionDescriptor("array_position").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(element)), null, this.queryEngine);
    }

    @Override
    public <E> SqmExpression<Integer> collectionPosition(Expression<? extends Collection<? extends E>> collectionExpression, Expression<E> elementExpression) {
        return this.getFunctionDescriptor("array_position").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<int[]> collectionPositions(Expression<? extends Collection<? super T>> collectionExpression, Expression<T> elementExpression) {
        return this.getFunctionDescriptor("array_positions").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<int[]> collectionPositions(Expression<? extends Collection<? super T>> collectionExpression, T element) {
        return this.getFunctionDescriptor("array_positions").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value((Object)element)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<List<Integer>> collectionPositionsList(Expression<? extends Collection<? super T>> collectionExpression, Expression<T> elementExpression) {
        return this.getFunctionDescriptor("array_positions_list").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<List<Integer>> collectionPositionsList(Expression<? extends Collection<? super T>> collectionExpression, T element) {
        return this.getFunctionDescriptor("array_positions_list").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value((Object)element)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<Integer> collectionLength(Expression<? extends Collection<?>> collectionExpression) {
        return this.getFunctionDescriptor("array_length").generateSqmExpression(Collections.singletonList((SqmExpression)collectionExpression), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionConcat(Expression<C> collectionExpression1, Expression<? extends Collection<? extends E>> collectionExpression2) {
        return this.getFunctionDescriptor("array_concat").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression1, (SqmExpression)collectionExpression2), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionConcat(Expression<C> collectionExpression1, Collection<? extends E> collection2) {
        return this.getFunctionDescriptor("array_concat").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression1, this.value(collection2, (SqmExpression)collectionExpression1)), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionConcat(C collection1, Expression<? extends Collection<? extends E>> collectionExpression2) {
        return this.getFunctionDescriptor("array_concat").generateSqmExpression(Arrays.asList(this.value(collection1, (SqmExpression)collectionExpression2), (SqmExpression)collectionExpression2), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionAppend(Expression<C> collectionExpression, Expression<? extends E> elementExpression) {
        return this.getFunctionDescriptor("array_append").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionAppend(Expression<C> collectionExpression, E element) {
        return this.getFunctionDescriptor("array_append").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(element)), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionPrepend(Expression<? extends E> elementExpression, Expression<C> collectionExpression) {
        return this.getFunctionDescriptor("array_prepend").generateSqmExpression(Arrays.asList((SqmExpression)elementExpression, (SqmExpression)collectionExpression), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionPrepend(E element, Expression<C> collectionExpression) {
        return this.getFunctionDescriptor("array_prepend").generateSqmExpression(Arrays.asList(this.value(element), (SqmExpression)collectionExpression), null, this.queryEngine);
    }

    @Override
    public <E> SqmPredicate collectionContains(Expression<? extends Collection<E>> collectionExpression, Expression<? extends E> elementExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)elementExpression), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionContains(Expression<? extends Collection<E>> collectionExpression, E element) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(element)), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionContains(Collection<E> collection, Expression<E> elementExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains").generateSqmExpression(Arrays.asList(this.collectionValue(collection, (SqmExpression)elementExpression), (SqmExpression)elementExpression), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionContainsNullable(Expression<? extends Collection<E>> collectionExpression, Expression<? extends E> elementExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains_nullable").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)elementExpression), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionContainsNullable(Expression<? extends Collection<E>> collectionExpression, E element) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains_nullable").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(element)), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionContainsNullable(Collection<E> collection, Expression<E> elementExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_contains_nullable").generateSqmExpression(Arrays.asList(this.collectionValue(collection, (SqmExpression)elementExpression), (SqmExpression)elementExpression), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIncludes(Expression<? extends Collection<E>> collectionExpression, Expression<? extends Collection<? extends E>> subCollectionExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)subCollectionExpression), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIncludes(Expression<? extends Collection<E>> collectionExpression, Collection<? extends E> subCollection) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(subCollection, (SqmExpression)collectionExpression)), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIncludes(Collection<E> collection, Expression<? extends Collection<? extends E>> subCollectionExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes").generateSqmExpression(Arrays.asList(this.value(collection, (SqmExpression)subCollectionExpression), (SqmExpression)subCollectionExpression), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIncludesNullable(Expression<? extends Collection<E>> collectionExpression, Expression<? extends Collection<? extends E>> subCollectionExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes_nullable").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)subCollectionExpression), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIncludesNullable(Expression<? extends Collection<E>> collectionExpression, Collection<? extends E> subCollection) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes_nullable").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(subCollection, (SqmExpression)collectionExpression)), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIncludesNullable(Collection<E> collection, Expression<? extends Collection<? extends E>> subCollectionExpression) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_includes_nullable").generateSqmExpression(Arrays.asList(this.value(collection, (SqmExpression)subCollectionExpression), (SqmExpression)subCollectionExpression), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIntersects(Expression<? extends Collection<E>> collectionExpression1, Expression<? extends Collection<? extends E>> collectionExpression2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression1, (SqmExpression)collectionExpression2), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIntersects(Expression<? extends Collection<E>> collectionExpression1, Collection<? extends E> collection2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression1, this.value(collection2, (SqmExpression)collectionExpression1)), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIntersects(Collection<E> collection1, Expression<? extends Collection<? extends E>> collectionExpression2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects").generateSqmExpression(Arrays.asList(this.value(collection1, (SqmExpression)collectionExpression2), (SqmExpression)collectionExpression2), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIntersectsNullable(Expression<? extends Collection<E>> collectionExpression1, Expression<? extends Collection<? extends E>> collectionExpression2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects_nullable").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression1, (SqmExpression)collectionExpression2), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIntersectsNullable(Expression<? extends Collection<E>> collectionExpression1, Collection<? extends E> collection2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects_nullable").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression1, this.value(collection2, (SqmExpression)collectionExpression1)), null, this.queryEngine));
    }

    @Override
    public <E> SqmPredicate collectionIntersectsNullable(Collection<E> collection1, Expression<? extends Collection<? extends E>> collectionExpression2) {
        return this.isTrue((Expression)this.getFunctionDescriptor("array_intersects_nullable").generateSqmExpression(Arrays.asList(this.value(collection1, (SqmExpression)collectionExpression2), (SqmExpression)collectionExpression2), null, this.queryEngine));
    }

    @Override
    public <E> SqmExpression<E> collectionGet(Expression<? extends Collection<E>> collectionExpression, Expression<Integer> indexExpression) {
        return this.getFunctionDescriptor("array_get").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)indexExpression), null, this.queryEngine);
    }

    @Override
    public <E> SqmExpression<E> collectionGet(Expression<? extends Collection<E>> collectionExpression, Integer index) {
        return this.getFunctionDescriptor("array_get").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(index)), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionSet(Expression<C> collectionExpression, Expression<Integer> indexExpression, Expression<? extends E> elementExpression) {
        return this.getFunctionDescriptor("array_set").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)indexExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionSet(Expression<C> collectionExpression, Expression<Integer> indexExpression, E element) {
        return this.getFunctionDescriptor("array_set").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)indexExpression, this.value(element)), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionSet(Expression<C> collectionExpression, Integer index, Expression<? extends E> elementExpression) {
        return this.getFunctionDescriptor("array_set").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(index), (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionSet(Expression<C> collectionExpression, Integer index, E element) {
        return this.getFunctionDescriptor("array_set").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(index), this.value(element)), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionRemove(Expression<C> collectionExpression, Expression<? extends E> elementExpression) {
        return this.getFunctionDescriptor("array_remove").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)elementExpression), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionRemove(Expression<C> collectionExpression, E element) {
        return this.getFunctionDescriptor("array_remove").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(element)), null, this.queryEngine);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<C> collectionRemoveIndex(Expression<C> collectionExpression, Expression<Integer> indexExpression) {
        return this.getFunctionDescriptor("array_remove_index").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)indexExpression), null, this.queryEngine);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<C> collectionRemoveIndex(Expression<C> collectionExpression, Integer index) {
        return this.getFunctionDescriptor("array_remove_index").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(index)), null, this.queryEngine);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<C> collectionSlice(Expression<C> collectionExpression, Expression<Integer> lowerIndexExpression, Expression<Integer> upperIndexExpression) {
        return this.getFunctionDescriptor("array_slice").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)lowerIndexExpression, (SqmExpression)upperIndexExpression), null, this.queryEngine);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<C> collectionSlice(Expression<C> collectionExpression, Expression<Integer> lowerIndexExpression, Integer upperIndex) {
        return this.getFunctionDescriptor("array_slice").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)lowerIndexExpression, this.value(upperIndex)), null, this.queryEngine);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<C> collectionSlice(Expression<C> collectionExpression, Integer lowerIndex, Expression<Integer> upperIndexExpression) {
        return this.getFunctionDescriptor("array_slice").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(lowerIndex), (SqmExpression)upperIndexExpression), null, this.queryEngine);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<C> collectionSlice(Expression<C> collectionExpression, Integer lowerIndex, Integer upperIndex) {
        return this.getFunctionDescriptor("array_slice").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(lowerIndex), this.value(upperIndex)), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionReplace(Expression<C> collectionExpression, Expression<? extends E> oldElementExpression, Expression<? extends E> newElementExpression) {
        return this.getFunctionDescriptor("array_replace").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)oldElementExpression, (SqmExpression)newElementExpression), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionReplace(Expression<C> collectionExpression, Expression<? extends E> oldElementExpression, E newElement) {
        return this.getFunctionDescriptor("array_replace").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)oldElementExpression, this.value(newElement)), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionReplace(Expression<C> collectionExpression, E oldElement, Expression<? extends E> newElementExpression) {
        return this.getFunctionDescriptor("array_replace").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(oldElement), (SqmExpression)newElementExpression), null, this.queryEngine);
    }

    @Override
    public <E, C extends Collection<? super E>> SqmExpression<C> collectionReplace(Expression<C> collectionExpression, E oldElement, E newElement) {
        return this.getFunctionDescriptor("array_replace").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(oldElement), this.value(newElement)), null, this.queryEngine);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<C> collectionTrim(Expression<C> collectionExpression, Expression<Integer> indexExpression) {
        return this.getFunctionDescriptor("array_trim").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)indexExpression), null, this.queryEngine);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<C> collectionTrim(Expression<C> collectionExpression, Integer index) {
        return this.getFunctionDescriptor("array_trim").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(index)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<Collection<T>> collectionFill(Expression<T> elementExpression, Expression<Integer> elementCountExpression) {
        return this.getFunctionDescriptor("array_fill_list").generateSqmExpression(Arrays.asList((SqmExpression)elementExpression, (SqmExpression)elementCountExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<Collection<T>> collectionFill(Expression<T> elementExpression, Integer elementCount) {
        return this.getFunctionDescriptor("array_fill_list").generateSqmExpression(Arrays.asList((SqmExpression)elementExpression, this.value(elementCount)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<Collection<T>> collectionFill(T element, Expression<Integer> elementCountExpression) {
        return this.getFunctionDescriptor("array_fill_list").generateSqmExpression(Arrays.asList(this.value((Object)element), (SqmExpression)elementCountExpression), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<Collection<T>> collectionFill(T element, Integer elementCount) {
        return this.getFunctionDescriptor("array_fill_list").generateSqmExpression(Arrays.asList(this.value((Object)element), this.value(elementCount)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> collectionToString(Expression<? extends Collection<?>> collectionExpression, Expression<String> separatorExpression) {
        return this.getFunctionDescriptor("array_to_string").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)separatorExpression), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> collectionToString(Expression<? extends Collection<?>> collectionExpression, String separator) {
        return this.getFunctionDescriptor("array_to_string").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, this.value(separator)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> collectionToString(Expression<? extends Collection<?>> collectionExpression, Expression<String> separatorExpression, Expression<String> defaultExpression) {
        return this.getFunctionDescriptor("array_to_string").generateSqmExpression(Arrays.asList((SqmExpression)collectionExpression, (SqmExpression)separatorExpression, (SqmExpression)defaultExpression), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> collectionToString(Expression<? extends Collection<?>> collectionExpression, Expression<String> separatorExpression, String defaultValue) {
        return this.collectionToString((Expression)collectionExpression, (Expression)separatorExpression, (Expression)this.value(defaultValue));
    }

    @Override
    public SqmExpression<String> collectionToString(Expression<? extends Collection<?>> collectionExpression, String separator, Expression<String> defaultExpression) {
        return this.collectionToString((Expression)collectionExpression, (Expression)this.value(separator), (Expression)defaultExpression);
    }

    @Override
    public SqmExpression<String> collectionToString(Expression<? extends Collection<?>> collectionExpression, String separator, String defaultValue) {
        return this.collectionToString((Expression)collectionExpression, (Expression)this.value(separator), (Expression)this.value(defaultValue));
    }

    @Override
    public SqmJsonValueExpression<String> jsonValue(Expression<?> jsonDocument, String jsonPath) {
        return this.jsonValue((Expression)jsonDocument, (Expression)this.value(jsonPath), (Class)null);
    }

    @Override
    public <T> SqmJsonValueExpression<T> jsonValue(Expression<?> jsonDocument, String jsonPath, Class<T> returningType) {
        return this.jsonValue((Expression)jsonDocument, (Expression)this.value(jsonPath), (Class)returningType);
    }

    @Override
    public SqmJsonValueExpression<String> jsonValue(Expression<?> jsonDocument, Expression<String> jsonPath) {
        return this.jsonValue((Expression)jsonDocument, (Expression)jsonPath, (Class)null);
    }

    @Override
    public <T> SqmJsonValueExpression<T> jsonValue(Expression<?> jsonDocument, Expression<String> jsonPath, Class<T> returningType) {
        if (returningType == null) {
            return (SqmJsonValueExpression)this.getFunctionDescriptor("json_value").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)jsonDocument), (SqmTypedNode)((Object)jsonPath)), null, this.queryEngine);
        }
        BasicType<T> type = this.getTypeConfiguration().standardBasicTypeForJavaType(returningType);
        return (SqmJsonValueExpression)this.getFunctionDescriptor("json_value").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)jsonDocument), (SqmTypedNode)((Object)jsonPath), new SqmCastTarget<T>(type, this)), type, this.queryEngine);
    }

    @Override
    public SqmJsonQueryExpression jsonQuery(Expression<?> jsonDocument, String jsonPath) {
        return this.jsonQuery((Expression)jsonDocument, (Expression)this.value(jsonPath));
    }

    @Override
    public SqmJsonQueryExpression jsonQuery(Expression<?> jsonDocument, Expression<String> jsonPath) {
        return (SqmJsonQueryExpression)this.getFunctionDescriptor("json_query").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)jsonDocument), (SqmTypedNode)((Object)jsonPath)), null, this.queryEngine);
    }

    @Override
    public SqmJsonExistsExpression jsonExists(Expression<?> jsonDocument, String jsonPath) {
        return this.jsonExists((Expression)jsonDocument, (Expression)this.value(jsonPath));
    }

    @Override
    public SqmJsonExistsExpression jsonExists(Expression<?> jsonDocument, Expression<String> jsonPath) {
        return (SqmJsonExistsExpression)this.getFunctionDescriptor("json_exists").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)jsonDocument), (SqmTypedNode)((Object)jsonPath)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> jsonArrayWithNulls(Expression<?> ... values) {
        ArrayList<SqmTypedNode> arguments = new ArrayList<SqmTypedNode>(values.length + 1);
        for (Expression<?> expression : values) {
            arguments.add((SqmTypedNode)((Object)expression));
        }
        arguments.add(SqmJsonNullBehavior.NULL);
        return this.getFunctionDescriptor("json_array").generateSqmExpression(arguments, null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> jsonArray(Expression<?> ... values) {
        return this.getFunctionDescriptor("json_array").generateSqmExpression(Arrays.asList(values), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> jsonArrayAgg(Expression<?> value) {
        return this.jsonArrayAgg((SqmExpression)value, (SqmJsonNullBehavior)null, (SqmPredicate)null, (SqmOrderByClause)null);
    }

    @Override
    public SqmExpression<String> jsonArrayAgg(Expression<?> value, Predicate filter, JpaOrder ... orderBy) {
        return this.jsonArrayAgg((SqmExpression)value, null, (SqmPredicate)filter, this.orderByClause(orderBy));
    }

    @Override
    public SqmExpression<String> jsonArrayAgg(Expression<?> value, Predicate filter) {
        return this.jsonArrayAgg((SqmExpression)value, null, (SqmPredicate)filter, null);
    }

    @Override
    public SqmExpression<String> jsonArrayAgg(Expression<?> value, JpaOrder ... orderBy) {
        return this.jsonArrayAgg((SqmExpression)value, null, null, this.orderByClause(orderBy));
    }

    @Override
    public SqmExpression<String> jsonArrayAggWithNulls(Expression<?> value) {
        return this.jsonArrayAgg((SqmExpression)value, SqmJsonNullBehavior.NULL, null, null);
    }

    @Override
    public SqmExpression<String> jsonArrayAggWithNulls(Expression<?> value, Predicate filter, JpaOrder ... orderBy) {
        return this.jsonArrayAgg((SqmExpression)value, SqmJsonNullBehavior.NULL, (SqmPredicate)filter, this.orderByClause(orderBy));
    }

    @Override
    public SqmExpression<String> jsonArrayAggWithNulls(Expression<?> value, Predicate filter) {
        return this.jsonArrayAgg((SqmExpression)value, SqmJsonNullBehavior.NULL, (SqmPredicate)filter, null);
    }

    @Override
    public SqmExpression<String> jsonArrayAggWithNulls(Expression<?> value, JpaOrder ... orderBy) {
        return this.jsonArrayAgg((SqmExpression)value, SqmJsonNullBehavior.NULL, null, this.orderByClause(orderBy));
    }

    @Override
    public SqmExpression<String> jsonObjectAggWithUniqueKeysAndNulls(Expression<?> key, Expression<?> value) {
        return this.jsonObjectAgg(key, value, SqmJsonNullBehavior.NULL, SqmJsonObjectAggUniqueKeysBehavior.WITH, null);
    }

    @Override
    public SqmExpression<String> jsonObjectAggWithUniqueKeys(Expression<?> key, Expression<?> value) {
        return this.jsonObjectAgg(key, value, null, SqmJsonObjectAggUniqueKeysBehavior.WITH, null);
    }

    @Override
    public SqmExpression<String> jsonObjectAggWithNulls(Expression<?> key, Expression<?> value) {
        return this.jsonObjectAgg(key, value, SqmJsonNullBehavior.NULL, null, null);
    }

    @Override
    public SqmExpression<String> jsonObjectAgg(Expression<?> key, Expression<?> value) {
        return this.jsonObjectAgg(key, value, null, null, null);
    }

    @Override
    public SqmExpression<String> jsonObjectAggWithUniqueKeysAndNulls(Expression<?> key, Expression<?> value, Predicate filter) {
        return this.jsonObjectAgg(key, value, SqmJsonNullBehavior.NULL, SqmJsonObjectAggUniqueKeysBehavior.WITH, filter);
    }

    @Override
    public SqmExpression<String> jsonObjectAggWithUniqueKeys(Expression<?> key, Expression<?> value, Predicate filter) {
        return this.jsonObjectAgg(key, value, null, SqmJsonObjectAggUniqueKeysBehavior.WITH, filter);
    }

    @Override
    public SqmExpression<String> jsonObjectAggWithNulls(Expression<?> key, Expression<?> value, Predicate filter) {
        return this.jsonObjectAgg(key, value, SqmJsonNullBehavior.NULL, null, filter);
    }

    @Override
    public SqmExpression<String> jsonObjectAgg(Expression<?> key, Expression<?> value, Predicate filter) {
        return this.jsonObjectAgg(key, value, null, null, filter);
    }

    private SqmExpression<String> jsonObjectAgg(Expression<?> key, Expression<?> value, @Nullable SqmJsonNullBehavior nullBehavior, @Nullable SqmJsonObjectAggUniqueKeysBehavior uniqueKeysBehavior, @Nullable Predicate filterPredicate) {
        ArrayList<SqmTypedNode> arguments = new ArrayList<SqmTypedNode>(4);
        arguments.add((SqmTypedNode)((Object)key));
        arguments.add((SqmTypedNode)((Object)value));
        if (nullBehavior != null) {
            arguments.add(nullBehavior);
        }
        if (uniqueKeysBehavior != null) {
            arguments.add(uniqueKeysBehavior);
        }
        return this.getFunctionDescriptor("json_objectagg").generateAggregateSqmExpression(arguments, (SqmPredicate)filterPredicate, null, this.queryEngine);
    }

    private @Nullable SqmOrderByClause orderByClause(JpaOrder[] orderBy) {
        if (orderBy.length == 0) {
            return null;
        }
        SqmOrderByClause sqmOrderByClause = new SqmOrderByClause(orderBy.length);
        for (JpaOrder jpaOrder : orderBy) {
            sqmOrderByClause.addSortSpecification((SqmSortSpecification)jpaOrder);
        }
        return sqmOrderByClause;
    }

    private SqmExpression<String> jsonArrayAgg(SqmExpression<?> value, @Nullable SqmJsonNullBehavior nullBehavior, @Nullable SqmPredicate filterPredicate, @Nullable SqmOrderByClause orderByClause) {
        return this.getFunctionDescriptor("json_arrayagg").generateOrderedSetAggregateSqmExpression(nullBehavior == null ? Collections.singletonList(value) : Arrays.asList(value, SqmJsonNullBehavior.NULL), filterPredicate, orderByClause, null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> jsonObjectWithNulls(Map<?, ? extends Expression<?>> keyValues) {
        ArrayList<SqmTypedNode<?>> arguments = this.keyValuesAsAlternatingList(keyValues);
        arguments.add(SqmJsonNullBehavior.NULL);
        return this.getFunctionDescriptor("json_object").generateSqmExpression(arguments, null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> jsonObject(Map<?, ? extends Expression<?>> keyValues) {
        return this.getFunctionDescriptor("json_object").generateSqmExpression(this.keyValuesAsAlternatingList(keyValues), null, this.queryEngine);
    }

    private ArrayList<SqmTypedNode<?>> keyValuesAsAlternatingList(Map<?, ? extends Expression<?>> keyValues) {
        ArrayList list = new ArrayList(keyValues.size());
        for (Map.Entry<?, Expression<?>> entry : keyValues.entrySet()) {
            list.add((SqmTypedNode<?>)((Object)this.value(entry.getKey())));
            list.add((SqmTypedNode)((Object)entry.getValue()));
        }
        return list;
    }

    @Override
    public SqmExpression<String> jsonSet(Expression<?> jsonDocument, Expression<String> jsonPath, Object value) {
        return this.jsonSet((Expression)jsonDocument, (Expression)jsonPath, (Expression)this.value(value));
    }

    @Override
    public SqmExpression<String> jsonSet(Expression<?> jsonDocument, String jsonPath, Object value) {
        return this.jsonSet((Expression)jsonDocument, (Expression)this.value(jsonPath), (Expression)this.value(value));
    }

    @Override
    public SqmExpression<String> jsonSet(Expression<?> jsonDocument, String jsonPath, Expression<?> value) {
        return this.jsonSet((Expression)jsonDocument, (Expression)this.value(jsonPath), (Expression)value);
    }

    @Override
    public SqmExpression<String> jsonSet(Expression<?> jsonDocument, Expression<String> jsonPath, Expression<?> value) {
        return this.getFunctionDescriptor("json_set").generateSqmExpression(Arrays.asList(jsonDocument, jsonPath, value), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> jsonRemove(Expression<?> jsonDocument, String jsonPath) {
        return this.jsonRemove((Expression)jsonDocument, (Expression)this.value(jsonPath));
    }

    @Override
    public SqmExpression<String> jsonRemove(Expression<?> jsonDocument, Expression<String> jsonPath) {
        return this.getFunctionDescriptor("json_remove").generateSqmExpression(Arrays.asList(jsonDocument, jsonPath), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> jsonInsert(Expression<?> jsonDocument, Expression<String> jsonPath, Object value) {
        return this.jsonInsert((Expression)jsonDocument, (Expression)jsonPath, (Expression)this.value(value));
    }

    @Override
    public SqmExpression<String> jsonInsert(Expression<?> jsonDocument, String jsonPath, Object value) {
        return this.jsonInsert((Expression)jsonDocument, (Expression)this.value(jsonPath), value);
    }

    @Override
    public SqmExpression<String> jsonInsert(Expression<?> jsonDocument, String jsonPath, Expression<?> value) {
        return this.jsonInsert((Expression)jsonDocument, (Expression)this.value(jsonPath), (Expression)value);
    }

    @Override
    public SqmExpression<String> jsonInsert(Expression<?> jsonDocument, Expression<String> jsonPath, Expression<?> value) {
        return this.getFunctionDescriptor("json_insert").generateSqmExpression(Arrays.asList(jsonDocument, jsonPath, value), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> jsonReplace(Expression<?> jsonDocument, Expression<String> jsonPath, Object value) {
        return this.jsonReplace((Expression)jsonDocument, (Expression)jsonPath, (Expression)this.value(value));
    }

    @Override
    public SqmExpression<String> jsonReplace(Expression<?> jsonDocument, String jsonPath, Object value) {
        return this.jsonReplace((Expression)jsonDocument, (Expression)this.value(jsonPath), value);
    }

    @Override
    public SqmExpression<String> jsonReplace(Expression<?> jsonDocument, String jsonPath, Expression<?> value) {
        return this.jsonReplace((Expression)jsonDocument, (Expression)this.value(jsonPath), (Expression)value);
    }

    @Override
    public SqmExpression<String> jsonReplace(Expression<?> jsonDocument, Expression<String> jsonPath, Expression<?> value) {
        return this.getFunctionDescriptor("json_replace").generateSqmExpression(Arrays.asList(jsonDocument, jsonPath, value), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> jsonMergepatch(String document, Expression<?> patch) {
        return this.jsonMergepatch((Expression)this.value(document), (Expression)patch);
    }

    @Override
    public SqmExpression<String> jsonMergepatch(Expression<?> document, String patch) {
        return this.jsonMergepatch((Expression)document, (Expression)this.value(patch));
    }

    @Override
    public SqmExpression<String> jsonMergepatch(Expression<?> document, Expression<?> patch) {
        return this.getFunctionDescriptor("json_mergepatch").generateSqmExpression(Arrays.asList(document, patch), null, this.queryEngine);
    }

    @Override
    public SqmXmlElementExpression xmlelement(String elementName) {
        ArrayList<SqmLiteral<String>> arguments = new ArrayList<SqmLiteral<String>>(3);
        arguments.add(new SqmLiteral<String>(elementName, this.getStringType(), this));
        return (SqmXmlElementExpression)this.getFunctionDescriptor("xmlelement").generateSqmExpression(arguments, null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> xmlcomment(String comment) {
        return this.getFunctionDescriptor("xmlcomment").generateSqmExpression(List.of(this.value(comment)), null, this.queryEngine);
    }

    @Override
    public <T> SqmExpression<T> named(Expression<T> expression, String name) {
        return new SqmNamedExpression((SqmExpression)expression, name);
    }

    @Override
    public SqmExpression<String> xmlforest(Expression<?> ... elements) {
        return this.xmlforest(Arrays.asList(elements));
    }

    @Override
    public SqmExpression<String> xmlforest(List<? extends Expression<?>> elements) {
        ArrayList arguments = new ArrayList(elements.size());
        for (Expression<?> expression : elements) {
            SqmPath path;
            Bindable bindable;
            if (expression instanceof SqmNamedExpression) {
                arguments.add((SqmNamedExpression)expression);
                continue;
            }
            if (!(expression instanceof SqmPath) || !((bindable = (path = (SqmPath)expression).getModel()) instanceof PersistentAttribute)) {
                throw new SemanticException("Can't use expression '" + String.valueOf(expression) + " without explicit name in xmlforest function, because XML element names can only be derived from path expressions.");
            }
            PersistentAttribute attribute = (PersistentAttribute)((Object)bindable);
            arguments.add(new SqmNamedExpression((SqmExpression)expression, attribute.getName()));
        }
        return this.getFunctionDescriptor("xmlforest").generateSqmExpression(arguments, null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> xmlconcat(Expression<?> ... elements) {
        return this.xmlconcat(Arrays.asList(elements));
    }

    @Override
    public SqmExpression<String> xmlconcat(List<? extends Expression<?>> elements) {
        return this.getFunctionDescriptor("xmlforest").generateSqmExpression(elements, null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> xmlpi(String elementName) {
        return this.getFunctionDescriptor("xmlpi").generateSqmExpression(Collections.singletonList(this.literal(elementName)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> xmlpi(String elementName, Expression<String> content) {
        return this.getFunctionDescriptor("xmlpi").generateSqmExpression(Arrays.asList(this.literal(elementName), (SqmTypedNode)((Object)content)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> xmlquery(String query, Expression<?> xmlDocument) {
        return this.xmlquery((Expression)this.value(query), (Expression)xmlDocument);
    }

    @Override
    public SqmExpression<String> xmlquery(Expression<String> query, Expression<?> xmlDocument) {
        return this.getFunctionDescriptor("xmlquery").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)query), (SqmTypedNode)((Object)xmlDocument)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<Boolean> xmlexists(String query, Expression<?> xmlDocument) {
        return this.xmlexists((Expression)this.value(query), (Expression)xmlDocument);
    }

    @Override
    public SqmExpression<Boolean> xmlexists(Expression<String> query, Expression<?> xmlDocument) {
        return this.getFunctionDescriptor("xmlexists").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)query), (SqmTypedNode)((Object)xmlDocument)), null, this.queryEngine);
    }

    @Override
    public SqmExpression<String> xmlagg(JpaOrder order, Expression<?> argument) {
        return this.xmlagg(order, (JpaPredicate)null, (JpaWindow)null, (Expression)argument);
    }

    @Override
    public SqmExpression<String> xmlagg(JpaOrder order, JpaPredicate filter, Expression<?> argument) {
        return this.xmlagg(order, filter, (JpaWindow)null, (Expression)argument);
    }

    @Override
    public SqmExpression<String> xmlagg(JpaOrder order, JpaWindow window, Expression<?> argument) {
        return this.xmlagg(order, (JpaPredicate)null, window, (Expression)argument);
    }

    @Override
    public SqmExpression<String> xmlagg(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<?> argument) {
        return this.functionWithinGroup("xmlagg", String.class, order, filter, window, new Expression[]{argument});
    }

    @Override
    public <E> SqmSetReturningFunction<E> setReturningFunction(String name, Expression<?> ... args) {
        return this.getSetReturningFunctionDescriptor(name).generateSqmExpression(SqmCriteriaNodeBuilder.expressionList(args), this.queryEngine);
    }

    @Override
    public <E> SqmSetReturningFunction<E> unnestArray(Expression<E[]> array) {
        return this.getSetReturningFunctionDescriptor("unnest").generateSqmExpression(Collections.singletonList((SqmTypedNode)((Object)array)), this.queryEngine);
    }

    @Override
    public <E> SqmSetReturningFunction<E> unnestCollection(Expression<? extends Collection<E>> collection) {
        return this.getSetReturningFunctionDescriptor("unnest").generateSqmExpression(Collections.singletonList((SqmTypedNode)((Object)collection)), this.queryEngine);
    }

    @Override
    public <E extends Temporal> SqmSetReturningFunction<E> generateTimeSeries(Expression<E> start, Expression<E> stop, Expression<? extends TemporalAmount> step) {
        return this.getSetReturningFunctionDescriptor("generate_series").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)start), (SqmTypedNode)((Object)stop), (SqmTypedNode)((Object)step)), this.queryEngine);
    }

    @Override
    public <E extends Temporal> SqmSetReturningFunction<E> generateTimeSeries(E start, E stop, TemporalAmount step) {
        return this.generateTimeSeries((Expression)this.value(start), (Expression)this.value(stop), (Expression)this.value(step));
    }

    @Override
    public <E extends Temporal> SqmSetReturningFunction<E> generateTimeSeries(E start, Expression<E> stop, TemporalAmount step) {
        return this.generateTimeSeries((Expression)this.value(start), (Expression)stop, (Expression)this.value(step));
    }

    @Override
    public <E extends Temporal> SqmSetReturningFunction<E> generateTimeSeries(Expression<E> start, E stop, TemporalAmount step) {
        return this.generateTimeSeries((Expression)start, (Expression)this.value(stop), (Expression)this.value(step));
    }

    @Override
    public <E extends Temporal> SqmSetReturningFunction<E> generateTimeSeries(Expression<E> start, Expression<E> stop, TemporalAmount step) {
        return this.generateTimeSeries((Expression)start, (Expression)stop, (Expression)this.value(step));
    }

    @Override
    public <E extends Temporal> SqmSetReturningFunction<E> generateTimeSeries(E start, E stop, Expression<? extends TemporalAmount> step) {
        return this.generateTimeSeries((Expression)this.value(start), (Expression)this.value(stop), (Expression)step);
    }

    @Override
    public <E extends Temporal> SqmSetReturningFunction<E> generateTimeSeries(Expression<E> start, E stop, Expression<? extends TemporalAmount> step) {
        return this.generateTimeSeries((Expression)start, (Expression)this.value(stop), (Expression)step);
    }

    @Override
    public <E extends Temporal> SqmSetReturningFunction<E> generateTimeSeries(E start, Expression<E> stop, Expression<? extends TemporalAmount> step) {
        return this.generateTimeSeries((Expression)this.value(start), (Expression)stop, (Expression)step);
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(Expression<E> start, Expression<E> stop, Expression<E> step) {
        return this.getSetReturningFunctionDescriptor("generate_series").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)start), (SqmTypedNode)((Object)stop), (SqmTypedNode)((Object)step)), this.queryEngine);
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(E start, E stop, E step) {
        return this.generateSeries((Expression)this.value(start), (Expression)this.value(stop), (Expression)this.value(step));
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(E start, E stop, Expression<E> step) {
        return this.generateSeries((Expression)this.value(start), (Expression)this.value(stop), (Expression)step);
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(Expression<E> start, E stop, E step) {
        return this.generateSeries((Expression)start, (Expression)this.value(stop), (Expression)this.value(step));
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(E start, Expression<E> stop, E step) {
        return this.generateSeries((Expression)this.value(start), (Expression)stop, (Expression)this.value(step));
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(Expression<E> start, Expression<E> stop, E step) {
        return this.generateSeries((Expression)start, (Expression)stop, (Expression)this.value(step));
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(Expression<E> start, E stop, Expression<E> step) {
        return this.generateSeries((Expression)start, (Expression)this.value(stop), (Expression)step);
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(E start, Expression<E> stop, Expression<E> step) {
        return this.generateSeries((Expression)this.value(start), (Expression)stop, (Expression)step);
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(Expression<E> start, Expression<E> stop) {
        return this.getSetReturningFunctionDescriptor("generate_series").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)start), (SqmTypedNode)((Object)stop)), this.queryEngine);
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(Expression<E> start, E stop) {
        return this.generateSeries((Expression)start, (Expression)this.value(stop));
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(E start, Expression<E> stop) {
        return this.generateSeries((Expression)this.value(start), (Expression)stop);
    }

    @Override
    public <E extends Number> SqmSetReturningFunction<E> generateSeries(E start, E stop) {
        return this.generateSeries((Expression)this.value(start), (Expression)this.value(stop));
    }

    @Override
    public SqmJsonTableFunction<?> jsonTable(Expression<?> jsonDocument) {
        return this.jsonTable((Expression)jsonDocument, (Expression)null);
    }

    @Override
    public SqmJsonTableFunction<?> jsonTable(Expression<?> jsonDocument, String jsonPath) {
        return this.jsonTable((Expression)jsonDocument, (Expression)this.value(jsonPath));
    }

    @Override
    public SqmJsonTableFunction<?> jsonTable(Expression<?> jsonDocument, @Nullable Expression<String> jsonPath) {
        return (SqmJsonTableFunction)this.getSetReturningFunctionDescriptor("json_table").generateSqmExpression(jsonPath == null ? Collections.singletonList((SqmTypedNode)((Object)jsonDocument)) : Arrays.asList((SqmTypedNode)((Object)jsonDocument), (SqmTypedNode)((Object)jsonPath)), this.queryEngine);
    }

    @Override
    public SqmXmlTableFunction<?> xmlTable(String xpath, Expression<?> xmlDocument) {
        return this.xmlTable((Expression)this.value(xpath), (Expression)xmlDocument);
    }

    @Override
    public SqmXmlTableFunction<?> xmlTable(Expression<String> xpath, Expression<?> xmlDocument) {
        return (SqmXmlTableFunction)this.getSetReturningFunctionDescriptor("xmltable").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)xpath), (SqmTypedNode)((Object)xmlDocument)), this.queryEngine);
    }

    class MultiValueParameterType<T>
    implements SqmBindableType<T> {
        private final JavaType<T> javaType;

        public MultiValueParameterType(Class<T> type) {
            this.javaType = SqmCriteriaNodeBuilder.this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(type);
        }

        @Override
        public Type.PersistenceType getPersistenceType() {
            return Type.PersistenceType.BASIC;
        }

        @Override
        public JavaType<T> getExpressibleJavaType() {
            return this.javaType;
        }

        @Override
        public Class<T> getJavaType() {
            return this.javaType.getJavaTypeClass();
        }

        @Override
        public SqmDomainType<T> getSqmType() {
            return null;
        }
    }
}

