/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.tree.expression.AsWrapperSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.jpa.AbstractJpaSelection;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractSqmExpression<T>
extends AbstractJpaSelection<T>
implements SqmExpression<T> {
    public AbstractSqmExpression(@Nullable SqmBindableType<? super T> type, NodeBuilder criteriaBuilder) {
        super(type, criteriaBuilder);
    }

    @Override
    public SqmCriteriaNodeBuilder nodeBuilder() {
        return (SqmCriteriaNodeBuilder)super.nodeBuilder();
    }

    @Override
    public void applyInferableType(@Nullable SqmBindableType<?> type) {
    }

    protected void internalApplyInferableType(@Nullable SqmBindableType<?> newType) {
        this.setExpressibleType(QueryHelper.highestPrecedenceType2(newType, this.getExpressible()));
    }

    private <B> SqmExpression<B> castToBasicType(Class<B> javaType) {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(javaType));
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.castToBasicType(Long.class);
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.castToBasicType(Integer.class);
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.castToBasicType(Float.class);
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.castToBasicType(Double.class);
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        return this.castToBasicType(BigDecimal.class);
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        return this.castToBasicType(BigInteger.class);
    }

    @Override
    public SqmExpression<String> asString() {
        return this.castToBasicType(String.class);
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        BasicType<X> basicTypeForJavaType = this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(type);
        if (basicTypeForJavaType == null) {
            throw new IllegalArgumentException("Can't cast expression to unknown type: " + type.getCanonicalName());
        }
        return new AsWrapperSqmExpression<X>(basicTypeForJavaType, this);
    }

    @Override
    public SqmPredicate isNull() {
        return this.nodeBuilder().isNull((Expression)this);
    }

    @Override
    public SqmPredicate isNotNull() {
        return this.nodeBuilder().isNotNull((Expression)this);
    }

    @Override
    public SqmPredicate equalTo(Expression<?> value) {
        return this.nodeBuilder().equal((Expression)this, (Expression)value);
    }

    @Override
    public SqmPredicate equalTo(Object value) {
        return this.nodeBuilder().equal((Expression)this, value);
    }

    @Override
    public SqmPredicate notEqualTo(Expression<?> value) {
        return this.nodeBuilder().notEqual((Expression)this, (Expression)value);
    }

    @Override
    public SqmPredicate notEqualTo(Object value) {
        return this.nodeBuilder().notEqual((Expression)this, value);
    }

    @Override
    public <X> SqmExpression<X> cast(Class<X> castTarget) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)castTarget);
    }

    @Override
    public SqmPredicate in(Object ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmPredicate in(Expression<?> ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmPredicate in(Collection<?> values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmPredicate in(Expression<Collection<?>> values) {
        return this.nodeBuilder().in((Expression)this, new Expression[]{values});
    }

    @Override
    public @Nullable JavaType<T> getJavaTypeDescriptor() {
        SqmBindableType nodeType = this.getNodeType();
        return nodeType == null ? null : nodeType.getExpressibleJavaType();
    }
}

