/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.type.BindableType;

public class JpaCriteriaParameter<T>
extends AbstractSqmExpression<T>
implements SqmParameter<T>,
QueryParameterImplementor<T> {
    private final String name;
    private boolean allowsMultiValuedBinding;

    public JpaCriteriaParameter(String name, BindableType<? super T> type, boolean allowsMultiValuedBinding, NodeBuilder nodeBuilder) {
        super(nodeBuilder.resolveExpressible(type), nodeBuilder);
        this.name = name;
        this.allowsMultiValuedBinding = allowsMultiValuedBinding;
    }

    protected JpaCriteriaParameter(JpaCriteriaParameter<T> original) {
        super(original.getNodeType(), original.nodeBuilder());
        this.name = original.name;
        this.allowsMultiValuedBinding = original.allowsMultiValuedBinding;
    }

    @Override
    public JpaCriteriaParameter<T> copy(SqmCopyContext context) {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public T getValue() {
        return null;
    }

    @Override
    public Integer getPosition() {
        return null;
    }

    @Override
    public Integer getTupleLength() {
        return null;
    }

    @Override
    public boolean allowsMultiValuedBinding() {
        return this.allowsMultiValuedBinding;
    }

    @Override
    public void disallowMultiValuedBinding() {
        this.allowsMultiValuedBinding = false;
    }

    @Override
    public boolean allowMultiValuedBinding() {
        return this.allowsMultiValuedBinding();
    }

    @Override
    public BindableType<T> getAnticipatedType() {
        return this.getHibernateType();
    }

    @Override
    public void applyAnticipatedType(BindableType type) {
        super.internalApplyInferableType(this.nodeBuilder().resolveExpressible(type));
    }

    @Override
    public SqmParameter<T> copy() {
        return new JpaCriteriaParameter<T>(this.getName(), this.getAnticipatedType(), this.allowMultiValuedBinding(), this.nodeBuilder());
    }

    @Override
    public BindableType<T> getHibernateType() {
        return this.getNodeType();
    }

    @Override
    public Class<T> getParameterType() {
        SqmBindableType nodeType = this.getNodeType();
        return nodeType == null ? null : nodeType.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    protected void internalApplyInferableType(SqmBindableType<?> newType) {
        super.internalApplyInferableType(newType);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitJpaCriteriaParameter(this);
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        throw new UnsupportedOperationException("ParameterMemento cannot be extracted from Criteria query parameter");
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append(':').append(this.name(context));
    }

    private String name(SqmRenderContext context) {
        return this.name == null ? context.resolveParameterName(this) : this.name;
    }

    @Override
    public int compareTo(SqmParameter<T> parameter) {
        return parameter instanceof JpaCriteriaParameter ? Integer.compare(this.hashCode(), parameter.hashCode()) : 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof JpaCriteriaParameter)) return false;
        JpaCriteriaParameter that = (JpaCriteriaParameter)object;
        if (this.name == null) return false;
        if (that.name == null) return false;
        if (!Objects.equals(this.name, that.name)) return false;
        return true;
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }
}

