/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.jboss.logging.Logger;

@SubSystemLogging(name="org.hibernate.orm.jdbc.bind", description="Logging of JDBC parameter value binding")
@Internal
public interface JdbcBindingLogging {
    public static final String NAME = "org.hibernate.orm.jdbc.bind";
    public static final Logger LOGGER = Logger.getLogger("org.hibernate.orm.jdbc.bind");

    public static void logBinding(int jdbcPosition, int typeCode, Object value) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("binding parameter (%s:%s) <- [%s]", jdbcPosition, (Object)JdbcTypeNameMapper.getTypeName(typeCode), value);
        }
    }

    public static void logNullBinding(int jdbcPosition, int typeCode) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("binding parameter (%s:%s) <- [null]", jdbcPosition, (Object)JdbcTypeNameMapper.getTypeName(typeCode));
        }
    }

    public static void logBinding(String callableParameterName, int typeCode, Object value) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("binding parameter (%s:%s) <- [%s]", (Object)callableParameterName, (Object)JdbcTypeNameMapper.getTypeName(typeCode), value);
        }
    }

    public static void logNullBinding(String callableParameterName, int typeCode) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("binding parameter (%s:%s) <- [null]", (Object)callableParameterName, (Object)JdbcTypeNameMapper.getTypeName(typeCode));
        }
    }
}

